/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for compromised-credentials actions and authentication-event sources with threat protection in full-function
 * <code>ENFORCED</code> mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompromisedCredentialsRiskConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<CompromisedCredentialsRiskConfigurationType.Builder, CompromisedCredentialsRiskConfigurationType> {
    private static final SdkField<List<String>> EVENT_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventFilter")
            .getter(getter(CompromisedCredentialsRiskConfigurationType::eventFilterAsStrings))
            .setter(setter(Builder::eventFilterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CompromisedCredentialsActionsType> ACTIONS_FIELD = SdkField
            .<CompromisedCredentialsActionsType> builder(MarshallingType.SDK_POJO).memberName("Actions")
            .getter(getter(CompromisedCredentialsRiskConfigurationType::actions)).setter(setter(Builder::actions))
            .constructor(CompromisedCredentialsActionsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FILTER_FIELD,
            ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> eventFilter;

    private final CompromisedCredentialsActionsType actions;

    private CompromisedCredentialsRiskConfigurationType(BuilderImpl builder) {
        this.eventFilter = builder.eventFilter;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * Settings for the sign-in activity where you want to configure compromised-credentials actions. Defaults to all
     * events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventFilter} method.
     * </p>
     * 
     * @return Settings for the sign-in activity where you want to configure compromised-credentials actions. Defaults
     *         to all events.
     */
    public final List<EventFilterType> eventFilter() {
        return EventFiltersTypeCopier.copyStringToEnum(eventFilter);
    }

    /**
     * For responses, this returns true if the service returned a value for the EventFilter property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventFilter() {
        return eventFilter != null && !(eventFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Settings for the sign-in activity where you want to configure compromised-credentials actions. Defaults to all
     * events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventFilter} method.
     * </p>
     * 
     * @return Settings for the sign-in activity where you want to configure compromised-credentials actions. Defaults
     *         to all events.
     */
    public final List<String> eventFilterAsStrings() {
        return eventFilter;
    }

    /**
     * <p>
     * Settings for the actions that you want your user pool to take when Amazon Cognito detects compromised
     * credentials.
     * </p>
     * 
     * @return Settings for the actions that you want your user pool to take when Amazon Cognito detects compromised
     *         credentials.
     */
    public final CompromisedCredentialsActionsType actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEventFilter() ? eventFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompromisedCredentialsRiskConfigurationType)) {
            return false;
        }
        CompromisedCredentialsRiskConfigurationType other = (CompromisedCredentialsRiskConfigurationType) obj;
        return hasEventFilter() == other.hasEventFilter() && Objects.equals(eventFilterAsStrings(), other.eventFilterAsStrings())
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompromisedCredentialsRiskConfigurationType")
                .add("EventFilter", hasEventFilter() ? eventFilterAsStrings() : null).add("Actions", actions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventFilter":
            return Optional.ofNullable(clazz.cast(eventFilterAsStrings()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventFilter", EVENT_FILTER_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompromisedCredentialsRiskConfigurationType, T> g) {
        return obj -> g.apply((CompromisedCredentialsRiskConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompromisedCredentialsRiskConfigurationType> {
        /**
         * <p>
         * Settings for the sign-in activity where you want to configure compromised-credentials actions. Defaults to
         * all events.
         * </p>
         * 
         * @param eventFilter
         *        Settings for the sign-in activity where you want to configure compromised-credentials actions.
         *        Defaults to all events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilterWithStrings(Collection<String> eventFilter);

        /**
         * <p>
         * Settings for the sign-in activity where you want to configure compromised-credentials actions. Defaults to
         * all events.
         * </p>
         * 
         * @param eventFilter
         *        Settings for the sign-in activity where you want to configure compromised-credentials actions.
         *        Defaults to all events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilterWithStrings(String... eventFilter);

        /**
         * <p>
         * Settings for the sign-in activity where you want to configure compromised-credentials actions. Defaults to
         * all events.
         * </p>
         * 
         * @param eventFilter
         *        Settings for the sign-in activity where you want to configure compromised-credentials actions.
         *        Defaults to all events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(Collection<EventFilterType> eventFilter);

        /**
         * <p>
         * Settings for the sign-in activity where you want to configure compromised-credentials actions. Defaults to
         * all events.
         * </p>
         * 
         * @param eventFilter
         *        Settings for the sign-in activity where you want to configure compromised-credentials actions.
         *        Defaults to all events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(EventFilterType... eventFilter);

        /**
         * <p>
         * Settings for the actions that you want your user pool to take when Amazon Cognito detects compromised
         * credentials.
         * </p>
         * 
         * @param actions
         *        Settings for the actions that you want your user pool to take when Amazon Cognito detects compromised
         *        credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(CompromisedCredentialsActionsType actions);

        /**
         * <p>
         * Settings for the actions that you want your user pool to take when Amazon Cognito detects compromised
         * credentials.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CompromisedCredentialsActionsType.Builder} avoiding the need to create one manually via
         * {@link CompromisedCredentialsActionsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompromisedCredentialsActionsType.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(CompromisedCredentialsActionsType)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link CompromisedCredentialsActionsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(CompromisedCredentialsActionsType)
         */
        default Builder actions(Consumer<CompromisedCredentialsActionsType.Builder> actions) {
            return actions(CompromisedCredentialsActionsType.builder().applyMutation(actions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> eventFilter = DefaultSdkAutoConstructList.getInstance();

        private CompromisedCredentialsActionsType actions;

        private BuilderImpl() {
        }

        private BuilderImpl(CompromisedCredentialsRiskConfigurationType model) {
            eventFilterWithStrings(model.eventFilter);
            actions(model.actions);
        }

        public final Collection<String> getEventFilter() {
            if (eventFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return eventFilter;
        }

        public final void setEventFilter(Collection<String> eventFilter) {
            this.eventFilter = EventFiltersTypeCopier.copy(eventFilter);
        }

        @Override
        public final Builder eventFilterWithStrings(Collection<String> eventFilter) {
            this.eventFilter = EventFiltersTypeCopier.copy(eventFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventFilterWithStrings(String... eventFilter) {
            eventFilterWithStrings(Arrays.asList(eventFilter));
            return this;
        }

        @Override
        public final Builder eventFilter(Collection<EventFilterType> eventFilter) {
            this.eventFilter = EventFiltersTypeCopier.copyEnumToString(eventFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventFilter(EventFilterType... eventFilter) {
            eventFilter(Arrays.asList(eventFilter));
            return this;
        }

        public final CompromisedCredentialsActionsType.Builder getActions() {
            return actions != null ? actions.toBuilder() : null;
        }

        public final void setActions(CompromisedCredentialsActionsType.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(CompromisedCredentialsActionsType actions) {
            this.actions = actions;
            return this;
        }

        @Override
        public CompromisedCredentialsRiskConfigurationType build() {
            return new CompromisedCredentialsRiskConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
