/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages of user pool
 * operations. Triggers can modify the outcome of the operations that invoked them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaConfigType implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaConfigType.Builder, LambdaConfigType> {
    private static final SdkField<String> PRE_SIGN_UP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreSignUp").getter(getter(LambdaConfigType::preSignUp)).setter(setter(Builder::preSignUp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignUp").build()).build();

    private static final SdkField<String> CUSTOM_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomMessage").getter(getter(LambdaConfigType::customMessage)).setter(setter(Builder::customMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomMessage").build()).build();

    private static final SdkField<String> POST_CONFIRMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostConfirmation").getter(getter(LambdaConfigType::postConfirmation))
            .setter(setter(Builder::postConfirmation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostConfirmation").build()).build();

    private static final SdkField<String> PRE_AUTHENTICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreAuthentication").getter(getter(LambdaConfigType::preAuthentication))
            .setter(setter(Builder::preAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreAuthentication").build()).build();

    private static final SdkField<String> POST_AUTHENTICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostAuthentication").getter(getter(LambdaConfigType::postAuthentication))
            .setter(setter(Builder::postAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAuthentication").build())
            .build();

    private static final SdkField<String> DEFINE_AUTH_CHALLENGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefineAuthChallenge").getter(getter(LambdaConfigType::defineAuthChallenge))
            .setter(setter(Builder::defineAuthChallenge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefineAuthChallenge").build())
            .build();

    private static final SdkField<String> CREATE_AUTH_CHALLENGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateAuthChallenge").getter(getter(LambdaConfigType::createAuthChallenge))
            .setter(setter(Builder::createAuthChallenge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAuthChallenge").build())
            .build();

    private static final SdkField<String> VERIFY_AUTH_CHALLENGE_RESPONSE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifyAuthChallengeResponse")
            .getter(getter(LambdaConfigType::verifyAuthChallengeResponse))
            .setter(setter(Builder::verifyAuthChallengeResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifyAuthChallengeResponse")
                    .build()).build();

    private static final SdkField<String> PRE_TOKEN_GENERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreTokenGeneration").getter(getter(LambdaConfigType::preTokenGeneration))
            .setter(setter(Builder::preTokenGeneration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreTokenGeneration").build())
            .build();

    private static final SdkField<String> USER_MIGRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserMigration").getter(getter(LambdaConfigType::userMigration)).setter(setter(Builder::userMigration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMigration").build()).build();

    private static final SdkField<PreTokenGenerationVersionConfigType> PRE_TOKEN_GENERATION_CONFIG_FIELD = SdkField
            .<PreTokenGenerationVersionConfigType> builder(MarshallingType.SDK_POJO).memberName("PreTokenGenerationConfig")
            .getter(getter(LambdaConfigType::preTokenGenerationConfig)).setter(setter(Builder::preTokenGenerationConfig))
            .constructor(PreTokenGenerationVersionConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreTokenGenerationConfig").build())
            .build();

    private static final SdkField<CustomSMSLambdaVersionConfigType> CUSTOM_SMS_SENDER_FIELD = SdkField
            .<CustomSMSLambdaVersionConfigType> builder(MarshallingType.SDK_POJO).memberName("CustomSMSSender")
            .getter(getter(LambdaConfigType::customSMSSender)).setter(setter(Builder::customSMSSender))
            .constructor(CustomSMSLambdaVersionConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSMSSender").build()).build();

    private static final SdkField<CustomEmailLambdaVersionConfigType> CUSTOM_EMAIL_SENDER_FIELD = SdkField
            .<CustomEmailLambdaVersionConfigType> builder(MarshallingType.SDK_POJO).memberName("CustomEmailSender")
            .getter(getter(LambdaConfigType::customEmailSender)).setter(setter(Builder::customEmailSender))
            .constructor(CustomEmailLambdaVersionConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEmailSender").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyID").getter(getter(LambdaConfigType::kmsKeyID)).setter(setter(Builder::kmsKeyID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRE_SIGN_UP_FIELD,
            CUSTOM_MESSAGE_FIELD, POST_CONFIRMATION_FIELD, PRE_AUTHENTICATION_FIELD, POST_AUTHENTICATION_FIELD,
            DEFINE_AUTH_CHALLENGE_FIELD, CREATE_AUTH_CHALLENGE_FIELD, VERIFY_AUTH_CHALLENGE_RESPONSE_FIELD,
            PRE_TOKEN_GENERATION_FIELD, USER_MIGRATION_FIELD, PRE_TOKEN_GENERATION_CONFIG_FIELD, CUSTOM_SMS_SENDER_FIELD,
            CUSTOM_EMAIL_SENDER_FIELD, KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String preSignUp;

    private final String customMessage;

    private final String postConfirmation;

    private final String preAuthentication;

    private final String postAuthentication;

    private final String defineAuthChallenge;

    private final String createAuthChallenge;

    private final String verifyAuthChallengeResponse;

    private final String preTokenGeneration;

    private final String userMigration;

    private final PreTokenGenerationVersionConfigType preTokenGenerationConfig;

    private final CustomSMSLambdaVersionConfigType customSMSSender;

    private final CustomEmailLambdaVersionConfigType customEmailSender;

    private final String kmsKeyID;

    private LambdaConfigType(BuilderImpl builder) {
        this.preSignUp = builder.preSignUp;
        this.customMessage = builder.customMessage;
        this.postConfirmation = builder.postConfirmation;
        this.preAuthentication = builder.preAuthentication;
        this.postAuthentication = builder.postAuthentication;
        this.defineAuthChallenge = builder.defineAuthChallenge;
        this.createAuthChallenge = builder.createAuthChallenge;
        this.verifyAuthChallengeResponse = builder.verifyAuthChallengeResponse;
        this.preTokenGeneration = builder.preTokenGeneration;
        this.userMigration = builder.userMigration;
        this.preTokenGenerationConfig = builder.preTokenGenerationConfig;
        this.customSMSSender = builder.customSMSSender;
        this.customEmailSender = builder.customEmailSender;
        this.kmsKeyID = builder.kmsKeyID;
    }

    /**
     * <p>
     * The configuration of a <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html">pre sign-up
     * Lambda trigger</a> in a user pool. This trigger evaluates new users and can bypass confirmation, <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
     * >link a federated user profile</a>, or block sign-up requests.
     * </p>
     * 
     * @return The configuration of a <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html">pre
     *         sign-up Lambda trigger</a> in a user pool. This trigger evaluates new users and can bypass confirmation,
     *         <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
     *         >link a federated user profile</a>, or block sign-up requests.
     */
    public final String preSignUp() {
        return preSignUp;
    }

    /**
     * <p>
     * A custom message Lambda trigger. This trigger is an opportunity to customize all SMS and email messages from your
     * user pool. When a custom message trigger is active, your user pool routes all messages to a Lambda function that
     * returns a runtime-customized message subject and body for your user pool to deliver to a user.
     * </p>
     * 
     * @return A custom message Lambda trigger. This trigger is an opportunity to customize all SMS and email messages
     *         from your user pool. When a custom message trigger is active, your user pool routes all messages to a
     *         Lambda function that returns a runtime-customized message subject and body for your user pool to deliver
     *         to a user.
     */
    public final String customMessage() {
        return customMessage;
    }

    /**
     * <p>
     * The configuration of a <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html">post
     * confirmation Lambda trigger</a> in a user pool. This trigger can take custom actions after a user confirms their
     * user account and their email address or phone number.
     * </p>
     * 
     * @return The configuration of a <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html"
     *         >post confirmation Lambda trigger</a> in a user pool. This trigger can take custom actions after a user
     *         confirms their user account and their email address or phone number.
     */
    public final String postConfirmation() {
        return postConfirmation;
    }

    /**
     * <p>
     * The configuration of a <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html">pre
     * authentication trigger</a> in a user pool. This trigger can evaluate and modify user sign-in events.
     * </p>
     * 
     * @return The configuration of a <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html"
     *         >pre authentication trigger</a> in a user pool. This trigger can evaluate and modify user sign-in events.
     */
    public final String preAuthentication() {
        return preAuthentication;
    }

    /**
     * <p>
     * The configuration of a <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html">post
     * authentication Lambda trigger</a> in a user pool. This trigger can take custom actions after a user signs in.
     * </p>
     * 
     * @return The configuration of a <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html"
     *         >post authentication Lambda trigger</a> in a user pool. This trigger can take custom actions after a user
     *         signs in.
     */
    public final String postAuthentication() {
        return postAuthentication;
    }

    /**
     * <p>
     * The configuration of a define auth challenge Lambda trigger, one of three triggers in the sequence of the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">custom
     * authentication challenge triggers</a>.
     * </p>
     * 
     * @return The configuration of a define auth challenge Lambda trigger, one of three triggers in the sequence of the
     *         <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">custom
     *         authentication challenge triggers</a>.
     */
    public final String defineAuthChallenge() {
        return defineAuthChallenge;
    }

    /**
     * <p>
     * The configuration of a create auth challenge Lambda trigger, one of three triggers in the sequence of the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">custom
     * authentication challenge triggers</a>.
     * </p>
     * 
     * @return The configuration of a create auth challenge Lambda trigger, one of three triggers in the sequence of the
     *         <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">custom
     *         authentication challenge triggers</a>.
     */
    public final String createAuthChallenge() {
        return createAuthChallenge;
    }

    /**
     * <p>
     * The configuration of a verify auth challenge Lambda trigger, one of three triggers in the sequence of the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">custom
     * authentication challenge triggers</a>.
     * </p>
     * 
     * @return The configuration of a verify auth challenge Lambda trigger, one of three triggers in the sequence of the
     *         <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">custom
     *         authentication challenge triggers</a>.
     */
    public final String verifyAuthChallengeResponse() {
        return verifyAuthChallengeResponse;
    }

    /**
     * <p>
     * The legacy configuration of a <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html">pre
     * token generation Lambda trigger</a> in a user pool.
     * </p>
     * <p>
     * Set this parameter for legacy purposes. If you also set an ARN in <code>PreTokenGenerationConfig</code>, its
     * value must be identical to <code>PreTokenGeneration</code>. For new instances of pre token generation triggers,
     * set the <code>LambdaArn</code> of <code>PreTokenGenerationConfig</code>.
     * </p>
     * 
     * @return The legacy configuration of a <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html"
     *         >pre token generation Lambda trigger</a> in a user pool.</p>
     *         <p>
     *         Set this parameter for legacy purposes. If you also set an ARN in <code>PreTokenGenerationConfig</code>,
     *         its value must be identical to <code>PreTokenGeneration</code>. For new instances of pre token generation
     *         triggers, set the <code>LambdaArn</code> of <code>PreTokenGenerationConfig</code>.
     */
    public final String preTokenGeneration() {
        return preTokenGeneration;
    }

    /**
     * <p>
     * The configuration of a <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html">migrate user
     * Lambda trigger</a> in a user pool. This trigger can create user profiles when users sign in or attempt to reset
     * their password with credentials that don't exist yet.
     * </p>
     * 
     * @return The configuration of a <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html"
     *         >migrate user Lambda trigger</a> in a user pool. This trigger can create user profiles when users sign in
     *         or attempt to reset their password with credentials that don't exist yet.
     */
    public final String userMigration() {
        return userMigration;
    }

    /**
     * <p>
     * The detailed configuration of a <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html">pre
     * token generation Lambda trigger</a> in a user pool. If you also set an ARN in <code>PreTokenGeneration</code>,
     * its value must be identical to <code>PreTokenGenerationConfig</code>.
     * </p>
     * 
     * @return The detailed configuration of a <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html"
     *         >pre token generation Lambda trigger</a> in a user pool. If you also set an ARN in
     *         <code>PreTokenGeneration</code>, its value must be identical to <code>PreTokenGenerationConfig</code>.
     */
    public final PreTokenGenerationVersionConfigType preTokenGenerationConfig() {
        return preTokenGenerationConfig;
    }

    /**
     * <p>
     * The configuration of a custom SMS sender Lambda trigger. This trigger routes all SMS notifications from a user
     * pool to a Lambda function that delivers the message using custom logic.
     * </p>
     * 
     * @return The configuration of a custom SMS sender Lambda trigger. This trigger routes all SMS notifications from a
     *         user pool to a Lambda function that delivers the message using custom logic.
     */
    public final CustomSMSLambdaVersionConfigType customSMSSender() {
        return customSMSSender;
    }

    /**
     * <p>
     * The configuration of a custom email sender Lambda trigger. This trigger routes all email notifications from a
     * user pool to a Lambda function that delivers the message using custom logic.
     * </p>
     * 
     * @return The configuration of a custom email sender Lambda trigger. This trigger routes all email notifications
     *         from a user pool to a Lambda function that delivers the message using custom logic.
     */
    public final CustomEmailLambdaVersionConfigType customEmailSender() {
        return customEmailSender;
    }

    /**
     * <p>
     * The ARN of an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">KMS
     * key</a>. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to custom sender Lambda
     * triggers.
     * </p>
     * 
     * @return The ARN of an <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">KMS key</a>.
     *         Amazon Cognito uses the key to encrypt codes and temporary passwords sent to custom sender Lambda
     *         triggers.
     */
    public final String kmsKeyID() {
        return kmsKeyID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(preSignUp());
        hashCode = 31 * hashCode + Objects.hashCode(customMessage());
        hashCode = 31 * hashCode + Objects.hashCode(postConfirmation());
        hashCode = 31 * hashCode + Objects.hashCode(preAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(postAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(defineAuthChallenge());
        hashCode = 31 * hashCode + Objects.hashCode(createAuthChallenge());
        hashCode = 31 * hashCode + Objects.hashCode(verifyAuthChallengeResponse());
        hashCode = 31 * hashCode + Objects.hashCode(preTokenGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(userMigration());
        hashCode = 31 * hashCode + Objects.hashCode(preTokenGenerationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(customSMSSender());
        hashCode = 31 * hashCode + Objects.hashCode(customEmailSender());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaConfigType)) {
            return false;
        }
        LambdaConfigType other = (LambdaConfigType) obj;
        return Objects.equals(preSignUp(), other.preSignUp()) && Objects.equals(customMessage(), other.customMessage())
                && Objects.equals(postConfirmation(), other.postConfirmation())
                && Objects.equals(preAuthentication(), other.preAuthentication())
                && Objects.equals(postAuthentication(), other.postAuthentication())
                && Objects.equals(defineAuthChallenge(), other.defineAuthChallenge())
                && Objects.equals(createAuthChallenge(), other.createAuthChallenge())
                && Objects.equals(verifyAuthChallengeResponse(), other.verifyAuthChallengeResponse())
                && Objects.equals(preTokenGeneration(), other.preTokenGeneration())
                && Objects.equals(userMigration(), other.userMigration())
                && Objects.equals(preTokenGenerationConfig(), other.preTokenGenerationConfig())
                && Objects.equals(customSMSSender(), other.customSMSSender())
                && Objects.equals(customEmailSender(), other.customEmailSender()) && Objects.equals(kmsKeyID(), other.kmsKeyID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaConfigType").add("PreSignUp", preSignUp()).add("CustomMessage", customMessage())
                .add("PostConfirmation", postConfirmation()).add("PreAuthentication", preAuthentication())
                .add("PostAuthentication", postAuthentication()).add("DefineAuthChallenge", defineAuthChallenge())
                .add("CreateAuthChallenge", createAuthChallenge())
                .add("VerifyAuthChallengeResponse", verifyAuthChallengeResponse())
                .add("PreTokenGeneration", preTokenGeneration()).add("UserMigration", userMigration())
                .add("PreTokenGenerationConfig", preTokenGenerationConfig()).add("CustomSMSSender", customSMSSender())
                .add("CustomEmailSender", customEmailSender()).add("KMSKeyID", kmsKeyID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreSignUp":
            return Optional.ofNullable(clazz.cast(preSignUp()));
        case "CustomMessage":
            return Optional.ofNullable(clazz.cast(customMessage()));
        case "PostConfirmation":
            return Optional.ofNullable(clazz.cast(postConfirmation()));
        case "PreAuthentication":
            return Optional.ofNullable(clazz.cast(preAuthentication()));
        case "PostAuthentication":
            return Optional.ofNullable(clazz.cast(postAuthentication()));
        case "DefineAuthChallenge":
            return Optional.ofNullable(clazz.cast(defineAuthChallenge()));
        case "CreateAuthChallenge":
            return Optional.ofNullable(clazz.cast(createAuthChallenge()));
        case "VerifyAuthChallengeResponse":
            return Optional.ofNullable(clazz.cast(verifyAuthChallengeResponse()));
        case "PreTokenGeneration":
            return Optional.ofNullable(clazz.cast(preTokenGeneration()));
        case "UserMigration":
            return Optional.ofNullable(clazz.cast(userMigration()));
        case "PreTokenGenerationConfig":
            return Optional.ofNullable(clazz.cast(preTokenGenerationConfig()));
        case "CustomSMSSender":
            return Optional.ofNullable(clazz.cast(customSMSSender()));
        case "CustomEmailSender":
            return Optional.ofNullable(clazz.cast(customEmailSender()));
        case "KMSKeyID":
            return Optional.ofNullable(clazz.cast(kmsKeyID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PreSignUp", PRE_SIGN_UP_FIELD);
        map.put("CustomMessage", CUSTOM_MESSAGE_FIELD);
        map.put("PostConfirmation", POST_CONFIRMATION_FIELD);
        map.put("PreAuthentication", PRE_AUTHENTICATION_FIELD);
        map.put("PostAuthentication", POST_AUTHENTICATION_FIELD);
        map.put("DefineAuthChallenge", DEFINE_AUTH_CHALLENGE_FIELD);
        map.put("CreateAuthChallenge", CREATE_AUTH_CHALLENGE_FIELD);
        map.put("VerifyAuthChallengeResponse", VERIFY_AUTH_CHALLENGE_RESPONSE_FIELD);
        map.put("PreTokenGeneration", PRE_TOKEN_GENERATION_FIELD);
        map.put("UserMigration", USER_MIGRATION_FIELD);
        map.put("PreTokenGenerationConfig", PRE_TOKEN_GENERATION_CONFIG_FIELD);
        map.put("CustomSMSSender", CUSTOM_SMS_SENDER_FIELD);
        map.put("CustomEmailSender", CUSTOM_EMAIL_SENDER_FIELD);
        map.put("KMSKeyID", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaConfigType, T> g) {
        return obj -> g.apply((LambdaConfigType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaConfigType> {
        /**
         * <p>
         * The configuration of a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html">pre
         * sign-up Lambda trigger</a> in a user pool. This trigger evaluates new users and can bypass confirmation, <a
         * href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
         * >link a federated user profile</a>, or block sign-up requests.
         * </p>
         * 
         * @param preSignUp
         *        The configuration of a <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html">pre
         *        sign-up Lambda trigger</a> in a user pool. This trigger evaluates new users and can bypass
         *        confirmation, <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
         *        >link a federated user profile</a>, or block sign-up requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignUp(String preSignUp);

        /**
         * <p>
         * A custom message Lambda trigger. This trigger is an opportunity to customize all SMS and email messages from
         * your user pool. When a custom message trigger is active, your user pool routes all messages to a Lambda
         * function that returns a runtime-customized message subject and body for your user pool to deliver to a user.
         * </p>
         * 
         * @param customMessage
         *        A custom message Lambda trigger. This trigger is an opportunity to customize all SMS and email
         *        messages from your user pool. When a custom message trigger is active, your user pool routes all
         *        messages to a Lambda function that returns a runtime-customized message subject and body for your user
         *        pool to deliver to a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMessage(String customMessage);

        /**
         * <p>
         * The configuration of a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html">post
         * confirmation Lambda trigger</a> in a user pool. This trigger can take custom actions after a user confirms
         * their user account and their email address or phone number.
         * </p>
         * 
         * @param postConfirmation
         *        The configuration of a <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html"
         *        >post confirmation Lambda trigger</a> in a user pool. This trigger can take custom actions after a
         *        user confirms their user account and their email address or phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postConfirmation(String postConfirmation);

        /**
         * <p>
         * The configuration of a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html">pre
         * authentication trigger</a> in a user pool. This trigger can evaluate and modify user sign-in events.
         * </p>
         * 
         * @param preAuthentication
         *        The configuration of a <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html"
         *        >pre authentication trigger</a> in a user pool. This trigger can evaluate and modify user sign-in
         *        events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preAuthentication(String preAuthentication);

        /**
         * <p>
         * The configuration of a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html"
         * >post authentication Lambda trigger</a> in a user pool. This trigger can take custom actions after a user
         * signs in.
         * </p>
         * 
         * @param postAuthentication
         *        The configuration of a <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html"
         *        >post authentication Lambda trigger</a> in a user pool. This trigger can take custom actions after a
         *        user signs in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postAuthentication(String postAuthentication);

        /**
         * <p>
         * The configuration of a define auth challenge Lambda trigger, one of three triggers in the sequence of the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">custom
         * authentication challenge triggers</a>.
         * </p>
         * 
         * @param defineAuthChallenge
         *        The configuration of a define auth challenge Lambda trigger, one of three triggers in the sequence of
         *        the <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html"
         *        >custom authentication challenge triggers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defineAuthChallenge(String defineAuthChallenge);

        /**
         * <p>
         * The configuration of a create auth challenge Lambda trigger, one of three triggers in the sequence of the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">custom
         * authentication challenge triggers</a>.
         * </p>
         * 
         * @param createAuthChallenge
         *        The configuration of a create auth challenge Lambda trigger, one of three triggers in the sequence of
         *        the <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html"
         *        >custom authentication challenge triggers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createAuthChallenge(String createAuthChallenge);

        /**
         * <p>
         * The configuration of a verify auth challenge Lambda trigger, one of three triggers in the sequence of the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">custom
         * authentication challenge triggers</a>.
         * </p>
         * 
         * @param verifyAuthChallengeResponse
         *        The configuration of a verify auth challenge Lambda trigger, one of three triggers in the sequence of
         *        the <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html"
         *        >custom authentication challenge triggers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifyAuthChallengeResponse(String verifyAuthChallengeResponse);

        /**
         * <p>
         * The legacy configuration of a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html"
         * >pre token generation Lambda trigger</a> in a user pool.
         * </p>
         * <p>
         * Set this parameter for legacy purposes. If you also set an ARN in <code>PreTokenGenerationConfig</code>, its
         * value must be identical to <code>PreTokenGeneration</code>. For new instances of pre token generation
         * triggers, set the <code>LambdaArn</code> of <code>PreTokenGenerationConfig</code>.
         * </p>
         * 
         * @param preTokenGeneration
         *        The legacy configuration of a <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html"
         *        >pre token generation Lambda trigger</a> in a user pool.</p>
         *        <p>
         *        Set this parameter for legacy purposes. If you also set an ARN in
         *        <code>PreTokenGenerationConfig</code>, its value must be identical to <code>PreTokenGeneration</code>.
         *        For new instances of pre token generation triggers, set the <code>LambdaArn</code> of
         *        <code>PreTokenGenerationConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preTokenGeneration(String preTokenGeneration);

        /**
         * <p>
         * The configuration of a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html">migrate
         * user Lambda trigger</a> in a user pool. This trigger can create user profiles when users sign in or attempt
         * to reset their password with credentials that don't exist yet.
         * </p>
         * 
         * @param userMigration
         *        The configuration of a <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html"
         *        >migrate user Lambda trigger</a> in a user pool. This trigger can create user profiles when users sign
         *        in or attempt to reset their password with credentials that don't exist yet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMigration(String userMigration);

        /**
         * <p>
         * The detailed configuration of a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html"
         * >pre token generation Lambda trigger</a> in a user pool. If you also set an ARN in
         * <code>PreTokenGeneration</code>, its value must be identical to <code>PreTokenGenerationConfig</code>.
         * </p>
         * 
         * @param preTokenGenerationConfig
         *        The detailed configuration of a <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html"
         *        >pre token generation Lambda trigger</a> in a user pool. If you also set an ARN in
         *        <code>PreTokenGeneration</code>, its value must be identical to <code>PreTokenGenerationConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preTokenGenerationConfig(PreTokenGenerationVersionConfigType preTokenGenerationConfig);

        /**
         * <p>
         * The detailed configuration of a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html"
         * >pre token generation Lambda trigger</a> in a user pool. If you also set an ARN in
         * <code>PreTokenGeneration</code>, its value must be identical to <code>PreTokenGenerationConfig</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PreTokenGenerationVersionConfigType.Builder} avoiding the need to create one manually via
         * {@link PreTokenGenerationVersionConfigType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PreTokenGenerationVersionConfigType.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #preTokenGenerationConfig(PreTokenGenerationVersionConfigType)}.
         * 
         * @param preTokenGenerationConfig
         *        a consumer that will call methods on {@link PreTokenGenerationVersionConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preTokenGenerationConfig(PreTokenGenerationVersionConfigType)
         */
        default Builder preTokenGenerationConfig(Consumer<PreTokenGenerationVersionConfigType.Builder> preTokenGenerationConfig) {
            return preTokenGenerationConfig(PreTokenGenerationVersionConfigType.builder().applyMutation(preTokenGenerationConfig)
                    .build());
        }

        /**
         * <p>
         * The configuration of a custom SMS sender Lambda trigger. This trigger routes all SMS notifications from a
         * user pool to a Lambda function that delivers the message using custom logic.
         * </p>
         * 
         * @param customSMSSender
         *        The configuration of a custom SMS sender Lambda trigger. This trigger routes all SMS notifications
         *        from a user pool to a Lambda function that delivers the message using custom logic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSMSSender(CustomSMSLambdaVersionConfigType customSMSSender);

        /**
         * <p>
         * The configuration of a custom SMS sender Lambda trigger. This trigger routes all SMS notifications from a
         * user pool to a Lambda function that delivers the message using custom logic.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomSMSLambdaVersionConfigType.Builder}
         * avoiding the need to create one manually via {@link CustomSMSLambdaVersionConfigType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomSMSLambdaVersionConfigType.Builder#build()} is called
         * immediately and its result is passed to {@link #customSMSSender(CustomSMSLambdaVersionConfigType)}.
         * 
         * @param customSMSSender
         *        a consumer that will call methods on {@link CustomSMSLambdaVersionConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customSMSSender(CustomSMSLambdaVersionConfigType)
         */
        default Builder customSMSSender(Consumer<CustomSMSLambdaVersionConfigType.Builder> customSMSSender) {
            return customSMSSender(CustomSMSLambdaVersionConfigType.builder().applyMutation(customSMSSender).build());
        }

        /**
         * <p>
         * The configuration of a custom email sender Lambda trigger. This trigger routes all email notifications from a
         * user pool to a Lambda function that delivers the message using custom logic.
         * </p>
         * 
         * @param customEmailSender
         *        The configuration of a custom email sender Lambda trigger. This trigger routes all email notifications
         *        from a user pool to a Lambda function that delivers the message using custom logic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEmailSender(CustomEmailLambdaVersionConfigType customEmailSender);

        /**
         * <p>
         * The configuration of a custom email sender Lambda trigger. This trigger routes all email notifications from a
         * user pool to a Lambda function that delivers the message using custom logic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomEmailLambdaVersionConfigType.Builder} avoiding the need to create one manually via
         * {@link CustomEmailLambdaVersionConfigType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomEmailLambdaVersionConfigType.Builder#build()} is called
         * immediately and its result is passed to {@link #customEmailSender(CustomEmailLambdaVersionConfigType)}.
         * 
         * @param customEmailSender
         *        a consumer that will call methods on {@link CustomEmailLambdaVersionConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customEmailSender(CustomEmailLambdaVersionConfigType)
         */
        default Builder customEmailSender(Consumer<CustomEmailLambdaVersionConfigType.Builder> customEmailSender) {
            return customEmailSender(CustomEmailLambdaVersionConfigType.builder().applyMutation(customEmailSender).build());
        }

        /**
         * <p>
         * The ARN of an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">KMS
         * key</a>. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to custom sender Lambda
         * triggers.
         * </p>
         * 
         * @param kmsKeyID
         *        The ARN of an <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">KMS key</a>.
         *        Amazon Cognito uses the key to encrypt codes and temporary passwords sent to custom sender Lambda
         *        triggers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyID(String kmsKeyID);
    }

    static final class BuilderImpl implements Builder {
        private String preSignUp;

        private String customMessage;

        private String postConfirmation;

        private String preAuthentication;

        private String postAuthentication;

        private String defineAuthChallenge;

        private String createAuthChallenge;

        private String verifyAuthChallengeResponse;

        private String preTokenGeneration;

        private String userMigration;

        private PreTokenGenerationVersionConfigType preTokenGenerationConfig;

        private CustomSMSLambdaVersionConfigType customSMSSender;

        private CustomEmailLambdaVersionConfigType customEmailSender;

        private String kmsKeyID;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaConfigType model) {
            preSignUp(model.preSignUp);
            customMessage(model.customMessage);
            postConfirmation(model.postConfirmation);
            preAuthentication(model.preAuthentication);
            postAuthentication(model.postAuthentication);
            defineAuthChallenge(model.defineAuthChallenge);
            createAuthChallenge(model.createAuthChallenge);
            verifyAuthChallengeResponse(model.verifyAuthChallengeResponse);
            preTokenGeneration(model.preTokenGeneration);
            userMigration(model.userMigration);
            preTokenGenerationConfig(model.preTokenGenerationConfig);
            customSMSSender(model.customSMSSender);
            customEmailSender(model.customEmailSender);
            kmsKeyID(model.kmsKeyID);
        }

        public final String getPreSignUp() {
            return preSignUp;
        }

        public final void setPreSignUp(String preSignUp) {
            this.preSignUp = preSignUp;
        }

        @Override
        public final Builder preSignUp(String preSignUp) {
            this.preSignUp = preSignUp;
            return this;
        }

        public final String getCustomMessage() {
            return customMessage;
        }

        public final void setCustomMessage(String customMessage) {
            this.customMessage = customMessage;
        }

        @Override
        public final Builder customMessage(String customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        public final String getPostConfirmation() {
            return postConfirmation;
        }

        public final void setPostConfirmation(String postConfirmation) {
            this.postConfirmation = postConfirmation;
        }

        @Override
        public final Builder postConfirmation(String postConfirmation) {
            this.postConfirmation = postConfirmation;
            return this;
        }

        public final String getPreAuthentication() {
            return preAuthentication;
        }

        public final void setPreAuthentication(String preAuthentication) {
            this.preAuthentication = preAuthentication;
        }

        @Override
        public final Builder preAuthentication(String preAuthentication) {
            this.preAuthentication = preAuthentication;
            return this;
        }

        public final String getPostAuthentication() {
            return postAuthentication;
        }

        public final void setPostAuthentication(String postAuthentication) {
            this.postAuthentication = postAuthentication;
        }

        @Override
        public final Builder postAuthentication(String postAuthentication) {
            this.postAuthentication = postAuthentication;
            return this;
        }

        public final String getDefineAuthChallenge() {
            return defineAuthChallenge;
        }

        public final void setDefineAuthChallenge(String defineAuthChallenge) {
            this.defineAuthChallenge = defineAuthChallenge;
        }

        @Override
        public final Builder defineAuthChallenge(String defineAuthChallenge) {
            this.defineAuthChallenge = defineAuthChallenge;
            return this;
        }

        public final String getCreateAuthChallenge() {
            return createAuthChallenge;
        }

        public final void setCreateAuthChallenge(String createAuthChallenge) {
            this.createAuthChallenge = createAuthChallenge;
        }

        @Override
        public final Builder createAuthChallenge(String createAuthChallenge) {
            this.createAuthChallenge = createAuthChallenge;
            return this;
        }

        public final String getVerifyAuthChallengeResponse() {
            return verifyAuthChallengeResponse;
        }

        public final void setVerifyAuthChallengeResponse(String verifyAuthChallengeResponse) {
            this.verifyAuthChallengeResponse = verifyAuthChallengeResponse;
        }

        @Override
        public final Builder verifyAuthChallengeResponse(String verifyAuthChallengeResponse) {
            this.verifyAuthChallengeResponse = verifyAuthChallengeResponse;
            return this;
        }

        public final String getPreTokenGeneration() {
            return preTokenGeneration;
        }

        public final void setPreTokenGeneration(String preTokenGeneration) {
            this.preTokenGeneration = preTokenGeneration;
        }

        @Override
        public final Builder preTokenGeneration(String preTokenGeneration) {
            this.preTokenGeneration = preTokenGeneration;
            return this;
        }

        public final String getUserMigration() {
            return userMigration;
        }

        public final void setUserMigration(String userMigration) {
            this.userMigration = userMigration;
        }

        @Override
        public final Builder userMigration(String userMigration) {
            this.userMigration = userMigration;
            return this;
        }

        public final PreTokenGenerationVersionConfigType.Builder getPreTokenGenerationConfig() {
            return preTokenGenerationConfig != null ? preTokenGenerationConfig.toBuilder() : null;
        }

        public final void setPreTokenGenerationConfig(PreTokenGenerationVersionConfigType.BuilderImpl preTokenGenerationConfig) {
            this.preTokenGenerationConfig = preTokenGenerationConfig != null ? preTokenGenerationConfig.build() : null;
        }

        @Override
        public final Builder preTokenGenerationConfig(PreTokenGenerationVersionConfigType preTokenGenerationConfig) {
            this.preTokenGenerationConfig = preTokenGenerationConfig;
            return this;
        }

        public final CustomSMSLambdaVersionConfigType.Builder getCustomSMSSender() {
            return customSMSSender != null ? customSMSSender.toBuilder() : null;
        }

        public final void setCustomSMSSender(CustomSMSLambdaVersionConfigType.BuilderImpl customSMSSender) {
            this.customSMSSender = customSMSSender != null ? customSMSSender.build() : null;
        }

        @Override
        public final Builder customSMSSender(CustomSMSLambdaVersionConfigType customSMSSender) {
            this.customSMSSender = customSMSSender;
            return this;
        }

        public final CustomEmailLambdaVersionConfigType.Builder getCustomEmailSender() {
            return customEmailSender != null ? customEmailSender.toBuilder() : null;
        }

        public final void setCustomEmailSender(CustomEmailLambdaVersionConfigType.BuilderImpl customEmailSender) {
            this.customEmailSender = customEmailSender != null ? customEmailSender.build() : null;
        }

        @Override
        public final Builder customEmailSender(CustomEmailLambdaVersionConfigType customEmailSender) {
            this.customEmailSender = customEmailSender;
            return this;
        }

        public final String getKmsKeyID() {
            return kmsKeyID;
        }

        public final void setKmsKeyID(String kmsKeyID) {
            this.kmsKeyID = kmsKeyID;
        }

        @Override
        public final Builder kmsKeyID(String kmsKeyID) {
            this.kmsKeyID = kmsKeyID;
            return this;
        }

        @Override
        public LambdaConfigType build() {
            return new LambdaConfigType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
