/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetRiskConfigurationRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<SetRiskConfigurationRequest.Builder, SetRiskConfigurationRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(SetRiskConfigurationRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(SetRiskConfigurationRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<CompromisedCredentialsRiskConfigurationType> COMPROMISED_CREDENTIALS_RISK_CONFIGURATION_FIELD = SdkField
            .<CompromisedCredentialsRiskConfigurationType> builder(MarshallingType.SDK_POJO)
            .memberName("CompromisedCredentialsRiskConfiguration")
            .getter(getter(SetRiskConfigurationRequest::compromisedCredentialsRiskConfiguration))
            .setter(setter(Builder::compromisedCredentialsRiskConfiguration))
            .constructor(CompromisedCredentialsRiskConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CompromisedCredentialsRiskConfiguration").build()).build();

    private static final SdkField<AccountTakeoverRiskConfigurationType> ACCOUNT_TAKEOVER_RISK_CONFIGURATION_FIELD = SdkField
            .<AccountTakeoverRiskConfigurationType> builder(MarshallingType.SDK_POJO)
            .memberName("AccountTakeoverRiskConfiguration")
            .getter(getter(SetRiskConfigurationRequest::accountTakeoverRiskConfiguration))
            .setter(setter(Builder::accountTakeoverRiskConfiguration))
            .constructor(AccountTakeoverRiskConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountTakeoverRiskConfiguration")
                    .build()).build();

    private static final SdkField<RiskExceptionConfigurationType> RISK_EXCEPTION_CONFIGURATION_FIELD = SdkField
            .<RiskExceptionConfigurationType> builder(MarshallingType.SDK_POJO)
            .memberName("RiskExceptionConfiguration")
            .getter(getter(SetRiskConfigurationRequest::riskExceptionConfiguration))
            .setter(setter(Builder::riskExceptionConfiguration))
            .constructor(RiskExceptionConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskExceptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CLIENT_ID_FIELD, COMPROMISED_CREDENTIALS_RISK_CONFIGURATION_FIELD, ACCOUNT_TAKEOVER_RISK_CONFIGURATION_FIELD,
            RISK_EXCEPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userPoolId;

    private final String clientId;

    private final CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration;

    private final AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration;

    private final RiskExceptionConfigurationType riskExceptionConfiguration;

    private SetRiskConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.compromisedCredentialsRiskConfiguration = builder.compromisedCredentialsRiskConfiguration;
        this.accountTakeoverRiskConfiguration = builder.accountTakeoverRiskConfiguration;
        this.riskExceptionConfiguration = builder.riskExceptionConfiguration;
    }

    /**
     * <p>
     * The ID of the user pool where you want to set a risk configuration. If you include <code>UserPoolId</code> in
     * your request, don't include <code>ClientId</code>. When the client ID is null, the same risk configuration is
     * applied to all the clients in the userPool. When you include both <code>ClientId</code> and
     * <code>UserPoolId</code>, Amazon Cognito maps the configuration to the app client only.
     * </p>
     * 
     * @return The ID of the user pool where you want to set a risk configuration. If you include
     *         <code>UserPoolId</code> in your request, don't include <code>ClientId</code>. When the client ID is null,
     *         the same risk configuration is applied to all the clients in the userPool. When you include both
     *         <code>ClientId</code> and <code>UserPoolId</code>, Amazon Cognito maps the configuration to the app
     *         client only.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The ID of the app client where you want to set a risk configuration. If <code>ClientId</code> is null, then the
     * risk configuration is mapped to <code>UserPoolId</code>. When the client ID is null, the same risk configuration
     * is applied to all the clients in the userPool.
     * </p>
     * <p>
     * When you include a <code>ClientId</code> parameter, Amazon Cognito maps the configuration to the app client. When
     * you include both <code>ClientId</code> and <code>UserPoolId</code>, Amazon Cognito maps the configuration to the
     * app client only.
     * </p>
     * 
     * @return The ID of the app client where you want to set a risk configuration. If <code>ClientId</code> is null,
     *         then the risk configuration is mapped to <code>UserPoolId</code>. When the client ID is null, the same
     *         risk configuration is applied to all the clients in the userPool.</p>
     *         <p>
     *         When you include a <code>ClientId</code> parameter, Amazon Cognito maps the configuration to the app
     *         client. When you include both <code>ClientId</code> and <code>UserPoolId</code>, Amazon Cognito maps the
     *         configuration to the app client only.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The configuration of automated reactions to detected compromised credentials. Includes settings for blocking
     * future sign-in requests and for the types of password-submission events you want to monitor.
     * </p>
     * 
     * @return The configuration of automated reactions to detected compromised credentials. Includes settings for
     *         blocking future sign-in requests and for the types of password-submission events you want to monitor.
     */
    public final CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration() {
        return compromisedCredentialsRiskConfiguration;
    }

    /**
     * <p>
     * The settings for automated responses and notification templates for adaptive authentication with threat
     * protection.
     * </p>
     * 
     * @return The settings for automated responses and notification templates for adaptive authentication with threat
     *         protection.
     */
    public final AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration() {
        return accountTakeoverRiskConfiguration;
    }

    /**
     * <p>
     * A set of IP-address overrides to threat protection. You can set up IP-address always-block and always-allow
     * lists.
     * </p>
     * 
     * @return A set of IP-address overrides to threat protection. You can set up IP-address always-block and
     *         always-allow lists.
     */
    public final RiskExceptionConfigurationType riskExceptionConfiguration() {
        return riskExceptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(compromisedCredentialsRiskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(accountTakeoverRiskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(riskExceptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetRiskConfigurationRequest)) {
            return false;
        }
        SetRiskConfigurationRequest other = (SetRiskConfigurationRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(compromisedCredentialsRiskConfiguration(), other.compromisedCredentialsRiskConfiguration())
                && Objects.equals(accountTakeoverRiskConfiguration(), other.accountTakeoverRiskConfiguration())
                && Objects.equals(riskExceptionConfiguration(), other.riskExceptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetRiskConfigurationRequest").add("UserPoolId", userPoolId())
                .add("ClientId", clientId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CompromisedCredentialsRiskConfiguration", compromisedCredentialsRiskConfiguration())
                .add("AccountTakeoverRiskConfiguration", accountTakeoverRiskConfiguration())
                .add("RiskExceptionConfiguration", riskExceptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "CompromisedCredentialsRiskConfiguration":
            return Optional.ofNullable(clazz.cast(compromisedCredentialsRiskConfiguration()));
        case "AccountTakeoverRiskConfiguration":
            return Optional.ofNullable(clazz.cast(accountTakeoverRiskConfiguration()));
        case "RiskExceptionConfiguration":
            return Optional.ofNullable(clazz.cast(riskExceptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("CompromisedCredentialsRiskConfiguration", COMPROMISED_CREDENTIALS_RISK_CONFIGURATION_FIELD);
        map.put("AccountTakeoverRiskConfiguration", ACCOUNT_TAKEOVER_RISK_CONFIGURATION_FIELD);
        map.put("RiskExceptionConfiguration", RISK_EXCEPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetRiskConfigurationRequest, T> g) {
        return obj -> g.apply((SetRiskConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetRiskConfigurationRequest> {
        /**
         * <p>
         * The ID of the user pool where you want to set a risk configuration. If you include <code>UserPoolId</code> in
         * your request, don't include <code>ClientId</code>. When the client ID is null, the same risk configuration is
         * applied to all the clients in the userPool. When you include both <code>ClientId</code> and
         * <code>UserPoolId</code>, Amazon Cognito maps the configuration to the app client only.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool where you want to set a risk configuration. If you include
         *        <code>UserPoolId</code> in your request, don't include <code>ClientId</code>. When the client ID is
         *        null, the same risk configuration is applied to all the clients in the userPool. When you include both
         *        <code>ClientId</code> and <code>UserPoolId</code>, Amazon Cognito maps the configuration to the app
         *        client only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The ID of the app client where you want to set a risk configuration. If <code>ClientId</code> is null, then
         * the risk configuration is mapped to <code>UserPoolId</code>. When the client ID is null, the same risk
         * configuration is applied to all the clients in the userPool.
         * </p>
         * <p>
         * When you include a <code>ClientId</code> parameter, Amazon Cognito maps the configuration to the app client.
         * When you include both <code>ClientId</code> and <code>UserPoolId</code>, Amazon Cognito maps the
         * configuration to the app client only.
         * </p>
         * 
         * @param clientId
         *        The ID of the app client where you want to set a risk configuration. If <code>ClientId</code> is null,
         *        then the risk configuration is mapped to <code>UserPoolId</code>. When the client ID is null, the same
         *        risk configuration is applied to all the clients in the userPool.</p>
         *        <p>
         *        When you include a <code>ClientId</code> parameter, Amazon Cognito maps the configuration to the app
         *        client. When you include both <code>ClientId</code> and <code>UserPoolId</code>, Amazon Cognito maps
         *        the configuration to the app client only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The configuration of automated reactions to detected compromised credentials. Includes settings for blocking
         * future sign-in requests and for the types of password-submission events you want to monitor.
         * </p>
         * 
         * @param compromisedCredentialsRiskConfiguration
         *        The configuration of automated reactions to detected compromised credentials. Includes settings for
         *        blocking future sign-in requests and for the types of password-submission events you want to monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compromisedCredentialsRiskConfiguration(
                CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration);

        /**
         * <p>
         * The configuration of automated reactions to detected compromised credentials. Includes settings for blocking
         * future sign-in requests and for the types of password-submission events you want to monitor.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CompromisedCredentialsRiskConfigurationType.Builder} avoiding the need to create one manually via
         * {@link CompromisedCredentialsRiskConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompromisedCredentialsRiskConfigurationType.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType)}.
         * 
         * @param compromisedCredentialsRiskConfiguration
         *        a consumer that will call methods on {@link CompromisedCredentialsRiskConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType)
         */
        default Builder compromisedCredentialsRiskConfiguration(
                Consumer<CompromisedCredentialsRiskConfigurationType.Builder> compromisedCredentialsRiskConfiguration) {
            return compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType.builder()
                    .applyMutation(compromisedCredentialsRiskConfiguration).build());
        }

        /**
         * <p>
         * The settings for automated responses and notification templates for adaptive authentication with threat
         * protection.
         * </p>
         * 
         * @param accountTakeoverRiskConfiguration
         *        The settings for automated responses and notification templates for adaptive authentication with
         *        threat protection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration);

        /**
         * <p>
         * The settings for automated responses and notification templates for adaptive authentication with threat
         * protection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AccountTakeoverRiskConfigurationType.Builder} avoiding the need to create one manually via
         * {@link AccountTakeoverRiskConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountTakeoverRiskConfigurationType.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType)}.
         * 
         * @param accountTakeoverRiskConfiguration
         *        a consumer that will call methods on {@link AccountTakeoverRiskConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType)
         */
        default Builder accountTakeoverRiskConfiguration(
                Consumer<AccountTakeoverRiskConfigurationType.Builder> accountTakeoverRiskConfiguration) {
            return accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType.builder()
                    .applyMutation(accountTakeoverRiskConfiguration).build());
        }

        /**
         * <p>
         * A set of IP-address overrides to threat protection. You can set up IP-address always-block and always-allow
         * lists.
         * </p>
         * 
         * @param riskExceptionConfiguration
         *        A set of IP-address overrides to threat protection. You can set up IP-address always-block and
         *        always-allow lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskExceptionConfiguration(RiskExceptionConfigurationType riskExceptionConfiguration);

        /**
         * <p>
         * A set of IP-address overrides to threat protection. You can set up IP-address always-block and always-allow
         * lists.
         * </p>
         * This is a convenience method that creates an instance of the {@link RiskExceptionConfigurationType.Builder}
         * avoiding the need to create one manually via {@link RiskExceptionConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RiskExceptionConfigurationType.Builder#build()} is called
         * immediately and its result is passed to {@link #riskExceptionConfiguration(RiskExceptionConfigurationType)}.
         * 
         * @param riskExceptionConfiguration
         *        a consumer that will call methods on {@link RiskExceptionConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #riskExceptionConfiguration(RiskExceptionConfigurationType)
         */
        default Builder riskExceptionConfiguration(Consumer<RiskExceptionConfigurationType.Builder> riskExceptionConfiguration) {
            return riskExceptionConfiguration(RiskExceptionConfigurationType.builder().applyMutation(riskExceptionConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String clientId;

        private CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration;

        private AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration;

        private RiskExceptionConfigurationType riskExceptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SetRiskConfigurationRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            clientId(model.clientId);
            compromisedCredentialsRiskConfiguration(model.compromisedCredentialsRiskConfiguration);
            accountTakeoverRiskConfiguration(model.accountTakeoverRiskConfiguration);
            riskExceptionConfiguration(model.riskExceptionConfiguration);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final CompromisedCredentialsRiskConfigurationType.Builder getCompromisedCredentialsRiskConfiguration() {
            return compromisedCredentialsRiskConfiguration != null ? compromisedCredentialsRiskConfiguration.toBuilder() : null;
        }

        public final void setCompromisedCredentialsRiskConfiguration(
                CompromisedCredentialsRiskConfigurationType.BuilderImpl compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration != null ? compromisedCredentialsRiskConfiguration
                    .build() : null;
        }

        @Override
        public final Builder compromisedCredentialsRiskConfiguration(
                CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration;
            return this;
        }

        public final AccountTakeoverRiskConfigurationType.Builder getAccountTakeoverRiskConfiguration() {
            return accountTakeoverRiskConfiguration != null ? accountTakeoverRiskConfiguration.toBuilder() : null;
        }

        public final void setAccountTakeoverRiskConfiguration(
                AccountTakeoverRiskConfigurationType.BuilderImpl accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration != null ? accountTakeoverRiskConfiguration
                    .build() : null;
        }

        @Override
        public final Builder accountTakeoverRiskConfiguration(
                AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration;
            return this;
        }

        public final RiskExceptionConfigurationType.Builder getRiskExceptionConfiguration() {
            return riskExceptionConfiguration != null ? riskExceptionConfiguration.toBuilder() : null;
        }

        public final void setRiskExceptionConfiguration(RiskExceptionConfigurationType.BuilderImpl riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration != null ? riskExceptionConfiguration.build() : null;
        }

        @Override
        public final Builder riskExceptionConfiguration(RiskExceptionConfigurationType riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetRiskConfigurationRequest build() {
            return new SetRiskConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
