/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TimeUnitsType {
    SECONDS("seconds"),
    MINUTES("minutes"),
    HOURS("hours"),
    DAYS("days"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TimeUnitsType> VALUE_MAP;
    private final String value;

    private TimeUnitsType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TimeUnitsType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TimeUnitsType> knownValues() {
        EnumSet<TimeUnitsType> knownValues = EnumSet.allOf(TimeUnitsType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TimeUnitsType.class, TimeUnitsType::toString);
    }
}

