/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChallengeNameType {
    SMS_MFA("SMS_MFA"),
    EMAIL_OTP("EMAIL_OTP"),
    SOFTWARE_TOKEN_MFA("SOFTWARE_TOKEN_MFA"),
    SELECT_MFA_TYPE("SELECT_MFA_TYPE"),
    MFA_SETUP("MFA_SETUP"),
    PASSWORD_VERIFIER("PASSWORD_VERIFIER"),
    CUSTOM_CHALLENGE("CUSTOM_CHALLENGE"),
    SELECT_CHALLENGE("SELECT_CHALLENGE"),
    DEVICE_SRP_AUTH("DEVICE_SRP_AUTH"),
    DEVICE_PASSWORD_VERIFIER("DEVICE_PASSWORD_VERIFIER"),
    ADMIN_NO_SRP_AUTH("ADMIN_NO_SRP_AUTH"),
    NEW_PASSWORD_REQUIRED("NEW_PASSWORD_REQUIRED"),
    SMS_OTP("SMS_OTP"),
    PASSWORD("PASSWORD"),
    WEB_AUTHN("WEB_AUTHN"),
    PASSWORD_SRP("PASSWORD_SRP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChallengeNameType> VALUE_MAP;
    private final String value;

    private ChallengeNameType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChallengeNameType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChallengeNameType> knownValues() {
        EnumSet<ChallengeNameType> knownValues = EnumSet.allOf(ChallengeNameType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChallengeNameType.class, ChallengeNameType::toString);
    }
}

