/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClient;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderServiceClientConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.CognitoIdentityProviderServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AliasExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryFailureException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CompleteWebAuthnRegistrationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CompleteWebAuthnRegistrationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateTermsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateTermsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteTermsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteTermsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteWebAuthnCredentialRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteWebAuthnCredentialResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingByClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingByClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeTermsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeTermsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceKeyExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DuplicateProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EnableSoftwareTokenMfaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExpiredCodeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.FeatureUnavailableInTierException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForbiddenException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetTokensFromRefreshTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetTokensFromRefreshTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAuthFactorsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAuthFactorsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GroupExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InternalErrorException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidEmailRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidLambdaResponseException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidOAuthFlowException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidPasswordException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleTrustRelationshipException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidUserPoolConfigurationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LimitExceededException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTermsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTermsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListWebAuthnCredentialsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListWebAuthnCredentialsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ManagedLoginBrandingExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MfaMethodNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordHistoryPolicyViolationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordResetRequiredException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PreconditionNotMetException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RefreshTokenReuseException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ScopeDoesNotExistException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartWebAuthnRegistrationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartWebAuthnRegistrationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TermsExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TierChangeNotAllowedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyFailedAttemptsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnauthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnexpectedLambdaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedTokenTypeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedUserStateException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateTermsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateTermsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportInProgressException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserLambdaValidationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotConfirmedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolAddOnNotEnabledException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolTaggingException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnChallengeNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnClientMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnConfigurationMissingException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnCredentialNotSupportedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnNotEnabledException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnOriginNotAllowedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnRelyingPartyMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AddCustomAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminAddUserToGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminCreateUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminEnableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminInitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminLinkProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListGroupsForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListUserAuthEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRemoveUserFromGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserMfaPreferenceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateAuthEventFeedbackRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUserGlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AssociateSoftwareTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ChangePasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CompleteWebAuthnRegistrationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateTermsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteTermsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteWebAuthnCredentialRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeManagedLoginBrandingByClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeRiskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeTermsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetCsvHeaderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetIdentityProviderByIdentifierRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetLogDeliveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetTokensFromRefreshTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserAttributeVerificationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserAuthFactorsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserPoolMfaConfigRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.InitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListResourceServersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListTermsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserImportJobsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolClientsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersInGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListWebAuthnCredentialsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ResendConfirmationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RevokeTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetLogDeliveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetRiskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserMfaPreferenceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserPoolMfaConfigRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StartUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StartWebAuthnRegistrationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StopUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateAuthEventFeedbackRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateTermsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifySoftwareTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifyUserAttributeRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCognitoIdentityProviderAsyncClient
implements CognitoIdentityProviderAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCognitoIdentityProviderAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoIdentityProviderAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Cognito_Identity_Provider#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AddCustomAttributesResponse> addCustomAttributes(AddCustomAttributesRequest addCustomAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addCustomAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, addCustomAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddCustomAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddCustomAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddCustomAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddCustomAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addCustomAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$addCustomAttributes$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$addCustomAttributes$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminAddUserToGroupResponse> adminAddUserToGroup(AdminAddUserToGroupRequest adminAddUserToGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminAddUserToGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminAddUserToGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminAddUserToGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminAddUserToGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminAddUserToGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminAddUserToGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminAddUserToGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminAddUserToGroup$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminAddUserToGroup$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminConfirmSignUpResponse> adminConfirmSignUp(AdminConfirmSignUpRequest adminConfirmSignUpRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminConfirmSignUpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminConfirmSignUpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminConfirmSignUp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminConfirmSignUpResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminConfirmSignUp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminConfirmSignUpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminConfirmSignUpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminConfirmSignUp$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminConfirmSignUp$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminCreateUserResponse> adminCreateUser(AdminCreateUserRequest adminCreateUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminCreateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminCreateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminCreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminCreateUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminCreateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminCreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminCreateUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminCreateUser$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminCreateUser$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminDeleteUserResponse> adminDeleteUser(AdminDeleteUserRequest adminDeleteUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminDeleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminDeleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminDeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminDeleteUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminDeleteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminDeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminDeleteUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminDeleteUser$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminDeleteUser$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminDeleteUserAttributesResponse> adminDeleteUserAttributes(AdminDeleteUserAttributesRequest adminDeleteUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminDeleteUserAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminDeleteUserAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminDeleteUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminDeleteUserAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminDeleteUserAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminDeleteUserAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminDeleteUserAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminDeleteUserAttributes$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminDeleteUserAttributes$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminDisableProviderForUserResponse> adminDisableProviderForUser(AdminDisableProviderForUserRequest adminDisableProviderForUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminDisableProviderForUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminDisableProviderForUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminDisableProviderForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminDisableProviderForUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminDisableProviderForUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminDisableProviderForUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminDisableProviderForUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminDisableProviderForUser$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminDisableProviderForUser$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminDisableUserResponse> adminDisableUser(AdminDisableUserRequest adminDisableUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminDisableUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminDisableUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminDisableUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminDisableUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminDisableUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminDisableUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminDisableUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminDisableUser$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminDisableUser$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminEnableUserResponse> adminEnableUser(AdminEnableUserRequest adminEnableUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminEnableUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminEnableUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminEnableUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminEnableUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminEnableUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminEnableUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminEnableUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminEnableUser$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminEnableUser$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminForgetDeviceResponse> adminForgetDevice(AdminForgetDeviceRequest adminForgetDeviceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminForgetDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminForgetDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminForgetDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminForgetDeviceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminForgetDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminForgetDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminForgetDeviceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminForgetDevice$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminForgetDevice$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminGetDeviceResponse> adminGetDevice(AdminGetDeviceRequest adminGetDeviceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminGetDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminGetDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminGetDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminGetDeviceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminGetDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminGetDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminGetDeviceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminGetDevice$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminGetDevice$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminGetUserResponse> adminGetUser(AdminGetUserRequest adminGetUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminGetUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminGetUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminGetUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminGetUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminGetUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminGetUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminGetUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminGetUser$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminGetUser$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminInitiateAuthResponse> adminInitiateAuth(AdminInitiateAuthRequest adminInitiateAuthRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminInitiateAuthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminInitiateAuthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminInitiateAuth");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminInitiateAuthResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminInitiateAuth").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminInitiateAuthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminInitiateAuthRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminInitiateAuth$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminInitiateAuth$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminLinkProviderForUserResponse> adminLinkProviderForUser(AdminLinkProviderForUserRequest adminLinkProviderForUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminLinkProviderForUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminLinkProviderForUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminLinkProviderForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminLinkProviderForUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminLinkProviderForUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminLinkProviderForUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminLinkProviderForUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminLinkProviderForUser$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminLinkProviderForUser$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminListDevicesResponse> adminListDevices(AdminListDevicesRequest adminListDevicesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminListDevicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminListDevicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminListDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminListDevicesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminListDevices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminListDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminListDevicesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminListDevices$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminListDevices$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminListGroupsForUserResponse> adminListGroupsForUser(AdminListGroupsForUserRequest adminListGroupsForUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminListGroupsForUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminListGroupsForUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminListGroupsForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminListGroupsForUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminListGroupsForUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminListGroupsForUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminListGroupsForUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminListGroupsForUser$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminListGroupsForUser$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminListUserAuthEventsResponse> adminListUserAuthEvents(AdminListUserAuthEventsRequest adminListUserAuthEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminListUserAuthEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminListUserAuthEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminListUserAuthEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminListUserAuthEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminListUserAuthEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminListUserAuthEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminListUserAuthEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminListUserAuthEvents$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminListUserAuthEvents$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminRemoveUserFromGroupResponse> adminRemoveUserFromGroup(AdminRemoveUserFromGroupRequest adminRemoveUserFromGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminRemoveUserFromGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminRemoveUserFromGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminRemoveUserFromGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminRemoveUserFromGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminRemoveUserFromGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminRemoveUserFromGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminRemoveUserFromGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminRemoveUserFromGroup$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminRemoveUserFromGroup$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminResetUserPasswordResponse> adminResetUserPassword(AdminResetUserPasswordRequest adminResetUserPasswordRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminResetUserPasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminResetUserPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminResetUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminResetUserPasswordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminResetUserPassword").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminResetUserPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminResetUserPasswordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminResetUserPassword$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminResetUserPassword$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminRespondToAuthChallengeResponse> adminRespondToAuthChallenge(AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminRespondToAuthChallengeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminRespondToAuthChallengeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminRespondToAuthChallenge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminRespondToAuthChallengeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminRespondToAuthChallenge").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminRespondToAuthChallengeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminRespondToAuthChallengeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminRespondToAuthChallenge$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminRespondToAuthChallenge$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminSetUserMfaPreferenceResponse> adminSetUserMFAPreference(AdminSetUserMfaPreferenceRequest adminSetUserMfaPreferenceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminSetUserMfaPreferenceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminSetUserMfaPreferenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminSetUserMFAPreference");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminSetUserMfaPreferenceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminSetUserMFAPreference").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminSetUserMfaPreferenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminSetUserMfaPreferenceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminSetUserMFAPreference$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminSetUserMFAPreference$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminSetUserPasswordResponse> adminSetUserPassword(AdminSetUserPasswordRequest adminSetUserPasswordRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminSetUserPasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminSetUserPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminSetUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminSetUserPasswordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminSetUserPassword").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminSetUserPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminSetUserPasswordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminSetUserPassword$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminSetUserPassword$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminSetUserSettingsResponse> adminSetUserSettings(AdminSetUserSettingsRequest adminSetUserSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminSetUserSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminSetUserSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminSetUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminSetUserSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminSetUserSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminSetUserSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminSetUserSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminSetUserSettings$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminSetUserSettings$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminUpdateAuthEventFeedbackResponse> adminUpdateAuthEventFeedback(AdminUpdateAuthEventFeedbackRequest adminUpdateAuthEventFeedbackRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminUpdateAuthEventFeedbackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminUpdateAuthEventFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminUpdateAuthEventFeedback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminUpdateAuthEventFeedbackResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminUpdateAuthEventFeedback").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminUpdateAuthEventFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminUpdateAuthEventFeedbackRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminUpdateAuthEventFeedback$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminUpdateAuthEventFeedback$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminUpdateDeviceStatusResponse> adminUpdateDeviceStatus(AdminUpdateDeviceStatusRequest adminUpdateDeviceStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminUpdateDeviceStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminUpdateDeviceStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminUpdateDeviceStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminUpdateDeviceStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminUpdateDeviceStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminUpdateDeviceStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminUpdateDeviceStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminUpdateDeviceStatus$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminUpdateDeviceStatus$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminUpdateUserAttributesResponse> adminUpdateUserAttributes(AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminUpdateUserAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminUpdateUserAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminUpdateUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminUpdateUserAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminUpdateUserAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminUpdateUserAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminUpdateUserAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminUpdateUserAttributes$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminUpdateUserAttributes$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdminUserGlobalSignOutResponse> adminUserGlobalSignOut(AdminUserGlobalSignOutRequest adminUserGlobalSignOutRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)adminUserGlobalSignOutRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, adminUserGlobalSignOutRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminUserGlobalSignOut");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminUserGlobalSignOutResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminUserGlobalSignOut").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdminUserGlobalSignOutRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)adminUserGlobalSignOutRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminUserGlobalSignOut$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$adminUserGlobalSignOut$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssociateSoftwareTokenResponse> associateSoftwareToken(AssociateSoftwareTokenRequest associateSoftwareTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateSoftwareTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, associateSoftwareTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateSoftwareToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateSoftwareTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateSoftwareToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateSoftwareTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateSoftwareTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$associateSoftwareToken$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$associateSoftwareToken$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ChangePasswordResponse> changePassword(ChangePasswordRequest changePasswordRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)changePasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, changePasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ChangePassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ChangePasswordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangePassword").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ChangePasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)changePasswordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$changePassword$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$changePassword$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CompleteWebAuthnRegistrationResponse> completeWebAuthnRegistration(CompleteWebAuthnRegistrationRequest completeWebAuthnRegistrationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)completeWebAuthnRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, completeWebAuthnRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CompleteWebAuthnRegistration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CompleteWebAuthnRegistrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteWebAuthnRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CompleteWebAuthnRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)completeWebAuthnRegistrationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$completeWebAuthnRegistration$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$completeWebAuthnRegistration$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ConfirmDeviceResponse> confirmDevice(ConfirmDeviceRequest confirmDeviceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)confirmDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, confirmDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmDeviceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ConfirmDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)confirmDeviceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$confirmDevice$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$confirmDevice$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ConfirmForgotPasswordResponse> confirmForgotPassword(ConfirmForgotPasswordRequest confirmForgotPasswordRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)confirmForgotPasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, confirmForgotPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmForgotPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmForgotPasswordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmForgotPassword").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ConfirmForgotPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)confirmForgotPasswordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$confirmForgotPassword$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$confirmForgotPassword$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ConfirmSignUpResponse> confirmSignUp(ConfirmSignUpRequest confirmSignUpRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)confirmSignUpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, confirmSignUpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmSignUp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmSignUpResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmSignUp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ConfirmSignUpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)confirmSignUpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$confirmSignUp$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$confirmSignUp$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, createGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$createGroup$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$createGroup$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(CreateIdentityProviderRequest createIdentityProviderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createIdentityProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, createIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIdentityProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIdentityProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createIdentityProviderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$createIdentityProvider$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$createIdentityProvider$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateManagedLoginBrandingResponse> createManagedLoginBranding(CreateManagedLoginBrandingRequest createManagedLoginBrandingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createManagedLoginBrandingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, createManagedLoginBrandingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateManagedLoginBranding");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateManagedLoginBrandingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateManagedLoginBranding").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateManagedLoginBrandingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createManagedLoginBrandingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$createManagedLoginBranding$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$createManagedLoginBranding$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateResourceServerResponse> createResourceServer(CreateResourceServerRequest createResourceServerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createResourceServerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, createResourceServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceServerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResourceServer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateResourceServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createResourceServerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$createResourceServer$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$createResourceServer$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTermsResponse> createTerms(CreateTermsRequest createTermsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTermsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, createTermsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTerms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTermsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTerms").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTermsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTermsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$createTerms$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$createTerms$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUserImportJobResponse> createUserImportJob(CreateUserImportJobRequest createUserImportJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUserImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, createUserImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUserImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUserImportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateUserImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUserImportJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$createUserImportJob$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$createUserImportJob$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUserPoolResponse> createUserPool(CreateUserPoolRequest createUserPoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUserPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, createUserPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUserPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserPoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUserPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateUserPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUserPoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$createUserPool$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$createUserPool$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUserPoolClientResponse> createUserPoolClient(CreateUserPoolClientRequest createUserPoolClientRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUserPoolClientRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, createUserPoolClientRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUserPoolClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserPoolClientResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUserPoolClient").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateUserPoolClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUserPoolClientRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$createUserPoolClient$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$createUserPoolClient$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUserPoolDomainResponse> createUserPoolDomain(CreateUserPoolDomainRequest createUserPoolDomainRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUserPoolDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, createUserPoolDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUserPoolDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserPoolDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUserPoolDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateUserPoolDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUserPoolDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$createUserPoolDomain$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$createUserPoolDomain$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, deleteGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteGroup$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteGroup$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(DeleteIdentityProviderRequest deleteIdentityProviderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteIdentityProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, deleteIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIdentityProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentityProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteIdentityProviderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteIdentityProvider$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteIdentityProvider$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteManagedLoginBrandingResponse> deleteManagedLoginBranding(DeleteManagedLoginBrandingRequest deleteManagedLoginBrandingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteManagedLoginBrandingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, deleteManagedLoginBrandingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteManagedLoginBranding");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteManagedLoginBrandingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteManagedLoginBranding").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteManagedLoginBrandingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteManagedLoginBrandingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteManagedLoginBranding$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteManagedLoginBranding$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourceServerResponse> deleteResourceServer(DeleteResourceServerRequest deleteResourceServerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourceServerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourceServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceServerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourceServer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourceServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourceServerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteResourceServer$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteResourceServer$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTermsResponse> deleteTerms(DeleteTermsRequest deleteTermsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTermsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTermsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTerms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTermsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTerms").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTermsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTermsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteTerms$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteTerms$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, deleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "UnsupportedIdentityProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "PasswordResetRequiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
                    }
                    case "DuplicateProviderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateProviderException::builder).build());
                    }
                    case "ManagedLoginBrandingExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
                    }
                    case "CodeDeliveryFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
                    }
                    case "WebAuthnRelyingPartyMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
                    }
                    case "FeatureUnavailableInTierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TierChangeNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
                    }
                    case "EnableSoftwareTokenMFAException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
                    }
                    case "WebAuthnConfigurationMissingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
                    }
                    case "InvalidUserPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "CodeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeMismatchException::builder).build());
                    }
                    case "WebAuthnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
                    }
                    case "RefreshTokenReuseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
                    }
                    case "InvalidSmsRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
                    }
                    case "UsernameExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UsernameExistsException::builder).build());
                    }
                    case "MFAMethodNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
                    }
                    case "UnsupportedTokenTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "WebAuthnOriginNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
                    }
                    case "AliasExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AliasExistsException::builder).build());
                    }
                    case "UnsupportedUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
                    }
                    case "TermsExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TermsExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TermsExistsException::builder).build());
                    }
                    case "UserNotConfirmedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
                    }
                    case "DeviceKeyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
                    }
                    case "UnexpectedLambdaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "UserLambdaValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
                    }
                    case "InvalidSmsRoleTrustRelationshipException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
                    }
                    case "TooManyFailedAttemptsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "WebAuthnClientMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
                    }
                    case "ScopeDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
                    }
                    case "InvalidEmailRoleAccessPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
                    }
                    case "PreconditionNotMetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                    }
                    case "WebAuthnCredentialNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
                    }
                    case "GroupExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GroupExistsException::builder).build());
                    }
                    case "UserPoolTaggingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
                    }
                    case "WebAuthnChallengeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
                    }
                    case "UserPoolAddOnNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteUser$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderAsyncClient.lambda$deleteUser$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteUserAttributesResponse> deleteUserAttributes(DeleteUserAttributesRequest deleteUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteUserAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderAsyncClient.resolveMetricPublishers(clientConfiguration, deleteUserAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidLambdaResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
                    }
                    case "PasswordHistoryPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
                    }
                    case "InvalidOAuthFlowException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
                    }
                    case "UserImportInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserImportInProgressException::builder).build());
                    }
                    case "SoftwareTokenMFANotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
                    }
                    case "ExpiredCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredCodeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "UserNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case