/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.CognitoIdentityProviderServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AliasExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryFailureException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CompleteWebAuthnRegistrationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CompleteWebAuthnRegistrationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteWebAuthnCredentialRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteWebAuthnCredentialResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingByClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingByClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceKeyExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DuplicateProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EnableSoftwareTokenMfaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExpiredCodeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.FeatureUnavailableInTierException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForbiddenException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetTokensFromRefreshTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetTokensFromRefreshTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAuthFactorsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAuthFactorsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GroupExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InternalErrorException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidEmailRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidLambdaResponseException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidOAuthFlowException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidPasswordException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleTrustRelationshipException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidUserPoolConfigurationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LimitExceededException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListWebAuthnCredentialsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListWebAuthnCredentialsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ManagedLoginBrandingExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MfaMethodNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordHistoryPolicyViolationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordResetRequiredException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PreconditionNotMetException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RefreshTokenReuseException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ScopeDoesNotExistException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartWebAuthnRegistrationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartWebAuthnRegistrationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TierChangeNotAllowedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyFailedAttemptsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnauthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnexpectedLambdaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedTokenTypeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedUserStateException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateManagedLoginBrandingRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateManagedLoginBrandingResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportInProgressException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserLambdaValidationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotConfirmedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolAddOnNotEnabledException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolTaggingException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnChallengeNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnClientMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnConfigurationMissingException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnCredentialNotSupportedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnNotEnabledException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnOriginNotAllowedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnRelyingPartyMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AddCustomAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminAddUserToGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminCreateUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminEnableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminInitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminLinkProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListGroupsForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListUserAuthEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRemoveUserFromGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserMfaPreferenceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateAuthEventFeedbackRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUserGlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AssociateSoftwareTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ChangePasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CompleteWebAuthnRegistrationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteWebAuthnCredentialRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeManagedLoginBrandingByClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeRiskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetCsvHeaderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetIdentityProviderByIdentifierRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetLogDeliveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetTokensFromRefreshTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserAttributeVerificationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserAuthFactorsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserPoolMfaConfigRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.InitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListResourceServersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserImportJobsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolClientsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersInGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListWebAuthnCredentialsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ResendConfirmationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RevokeTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetLogDeliveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetRiskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserMfaPreferenceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserPoolMfaConfigRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StartUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StartWebAuthnRegistrationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StopUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateAuthEventFeedbackRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateManagedLoginBrandingRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifySoftwareTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifyUserAttributeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link CognitoIdentityProviderClient}.
 *
 * @see CognitoIdentityProviderClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCognitoIdentityProviderClient implements CognitoIdentityProviderClient {
    private static final Logger log = Logger.loggerFor(DefaultCognitoIdentityProviderClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoIdentityProviderClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Cognito_Identity_Provider" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds additional user attributes to the user pool schema. Custom attributes can be mutable or immutable and have a
     * <code>custom:</code> or <code>dev:</code> prefix. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-custom-attributes"
     * >Custom attributes</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param addCustomAttributesRequest
     *        Represents the request to add custom attributes.
     * @return Result of the AddCustomAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserImportInProgressException
     *         This exception is thrown when you're trying to modify a user pool while a user import job is in progress
     *         for that pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AddCustomAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddCustomAttributesResponse addCustomAttributes(AddCustomAttributesRequest addCustomAttributesRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserImportInProgressException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddCustomAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddCustomAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addCustomAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addCustomAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddCustomAttributes");

            return clientHandler.execute(new ClientExecutionParams<AddCustomAttributesRequest, AddCustomAttributesResponse>()
                    .withOperationName("AddCustomAttributes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addCustomAttributesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddCustomAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a user to a group. A user who is in a group can present a preferred-role claim to an identity pool, and
     * populates a <code>cognito:groups</code> claim to their access and identity tokens.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminAddUserToGroupRequest
     * @return Result of the AdminAddUserToGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminAddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminAddUserToGroupResponse adminAddUserToGroup(AdminAddUserToGroupRequest adminAddUserToGroupRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminAddUserToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminAddUserToGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminAddUserToGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminAddUserToGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminAddUserToGroup");

            return clientHandler.execute(new ClientExecutionParams<AdminAddUserToGroupRequest, AdminAddUserToGroupResponse>()
                    .withOperationName("AdminAddUserToGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminAddUserToGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminAddUserToGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Confirms user sign-up as an administrator.
     * </p>
     * <p>
     * This request sets a user account active in a user pool that <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#signing-up-users-in-your-app-and-confirming-them-as-admin"
     * >requires confirmation of new user accounts</a> before they can sign in. You can configure your user pool to not
     * send confirmation codes to new users and instead confirm them with this API operation on the back end.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To configure your user pool to require administrative confirmation of users, set
     * <code>AllowAdminCreateUserOnly</code> to <code>true</code> in a <code>CreateUserPool</code> or
     * <code>UpdateUserPool</code> request.
     * </p>
     *
     * @param adminConfirmSignUpRequest
     *        Confirm a user's registration as a user pool administrator.
     * @return Result of the AdminConfirmSignUp operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws TooManyFailedAttemptsException
     *         This exception is thrown when the user has made too many failed attempts for a given action, such as
     *         sign-in.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when Amazon Cognito encounters an invalid Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminConfirmSignUpResponse adminConfirmSignUp(AdminConfirmSignUpRequest adminConfirmSignUpRequest)
            throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException,
            UserLambdaValidationException, NotAuthorizedException, TooManyFailedAttemptsException,
            InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminConfirmSignUpResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminConfirmSignUpResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminConfirmSignUpRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminConfirmSignUpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminConfirmSignUp");

            return clientHandler.execute(new ClientExecutionParams<AdminConfirmSignUpRequest, AdminConfirmSignUpResponse>()
                    .withOperationName("AdminConfirmSignUp").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminConfirmSignUpRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminConfirmSignUpRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new user in the specified user pool.
     * </p>
     * <p>
     * If <code>MessageAction</code> isn't set, the default is to send a welcome message via email or phone (SMS).
     * </p>
     * <p>
     * This message is based on a template that you configured in your call to create or update a user pool. This
     * template includes your custom sign-up instructions and placeholders for user name and temporary password.
     * </p>
     * <p>
     * Alternatively, you can call <code>AdminCreateUser</code> with <code>SUPPRESS</code> for the
     * <code>MessageAction</code> parameter, and Amazon Cognito won't send any email.
     * </p>
     * <p>
     * In either case, if the user has a password, they will be in the <code>FORCE_CHANGE_PASSWORD</code> state until
     * they sign in and set their password. Your invitation message template must have the <code>{####}</code> password
     * placeholder if your users have passwords. If your template doesn't have this placeholder, Amazon Cognito doesn't
     * deliver the invitation message. In this case, you must update your message template and resend the password with
     * a new <code>AdminCreateUser</code> request with a <code>MessageAction</code> value of <code>RESEND</code>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminCreateUserRequest
     *        Creates a new user in the specified user pool.
     * @return Result of the AdminCreateUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws UsernameExistsException
     *         This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.
     * @throws InvalidPasswordException
     *         This exception is thrown when Amazon Cognito encounters an invalid password.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when Amazon Cognito encounters an invalid Lambda response.
     * @throws PreconditionNotMetException
     *         This exception is thrown when a precondition is not met.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration doesn't have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is not valid for the role provided for SMS
     *         configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external
     *         ID provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UnsupportedUserStateException
     *         The request failed because the user is in an unsupported state.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminCreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AdminCreateUserResponse adminCreateUser(AdminCreateUserRequest adminCreateUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, UserNotFoundException, UsernameExistsException,
            InvalidPasswordException, CodeDeliveryFailureException, UnexpectedLambdaException, UserLambdaValidationException,
            InvalidLambdaResponseException, PreconditionNotMetException, InvalidSmsRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, TooManyRequestsException, NotAuthorizedException,
            UnsupportedUserStateException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminCreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AdminCreateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminCreateUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminCreateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminCreateUser");

            return clientHandler.execute(new ClientExecutionParams<AdminCreateUserRequest, AdminCreateUserResponse>()
                    .withOperationName("AdminCreateUser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminCreateUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminCreateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a user profile in your user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDeleteUserRequest
     *        Represents the request to delete a user as an administrator.
     * @return Result of the AdminDeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AdminDeleteUserResponse adminDeleteUser(AdminDeleteUserRequest adminDeleteUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminDeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AdminDeleteUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDeleteUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDeleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDeleteUser");

            return clientHandler.execute(new ClientExecutionParams<AdminDeleteUserRequest, AdminDeleteUserResponse>()
                    .withOperationName("AdminDeleteUser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminDeleteUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminDeleteUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes attribute values from a user. This operation doesn't affect tokens for existing user sessions. The next
     * ID token that the user receives will no longer have the deleted attributes.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDeleteUserAttributesRequest
     *        Represents the request to delete user attributes as an administrator.
     * @return Result of the AdminDeleteUserAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminDeleteUserAttributesResponse adminDeleteUserAttributes(
            AdminDeleteUserAttributesRequest adminDeleteUserAttributesRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminDeleteUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminDeleteUserAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDeleteUserAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDeleteUserAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDeleteUserAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminDeleteUserAttributesRequest, AdminDeleteUserAttributesResponse>()
                            .withOperationName("AdminDeleteUserAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminDeleteUserAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminDeleteUserAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the
     * user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use
     * their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user
     * and an existing user is removed. When the external user signs in again, and the user is no longer attached to the
     * previously linked <code>DestinationUser</code>, the user must create a new user account.
     * </p>
     * <p>
     * The value of <code>ProviderName</code> must match the name of a user pool IdP.
     * </p>
     * <p>
     * To deactivate a local user, set <code>ProviderName</code> to <code>Cognito</code> and the
     * <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. The <code>ProviderAttributeValue</code> must
     * be user's local username.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social IdPs. The
     * <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was originally
     * linked as a source user.
     * </p>
     * <p>
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in,
     * the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were
     * used for the <code>SourceUser</code> when the identities were originally linked using
     * <code> AdminLinkProviderForUser</code> call. This is also true if the linking was done with
     * <code>ProviderAttributeName</code> set to <code>Cognito_Subject</code>. If the user has already signed in, the
     * <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code>
     * must be the <code>NameID</code> from their SAML assertion.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDisableProviderForUserRequest
     * @return Result of the AdminDisableProviderForUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email address or phone number
     *         that has already been supplied as an alias for a different user profile. This exception indicates that an
     *         account with this email address or phone already exists in a user pool that you've configured to use
     *         email address or phone number as a sign-in alias.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDisableProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminDisableProviderForUserResponse adminDisableProviderForUser(
            AdminDisableProviderForUserRequest adminDisableProviderForUserRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            AliasExistsException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminDisableProviderForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminDisableProviderForUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDisableProviderForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDisableProviderForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDisableProviderForUser");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminDisableProviderForUserRequest, AdminDisableProviderForUserResponse>()
                            .withOperationName("AdminDisableProviderForUser").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminDisableProviderForUserRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminDisableProviderForUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates a user profile and revokes all access tokens for the user. A deactivated user can't sign in, but
     * still appears in the responses to <code>ListUsers</code> API requests.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDisableUserRequest
     *        Represents the request to disable the user as an administrator.
     * @return Result of the AdminDisableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AdminDisableUserResponse adminDisableUser(AdminDisableUserRequest adminDisableUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminDisableUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AdminDisableUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDisableUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDisableUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDisableUser");

            return clientHandler.execute(new ClientExecutionParams<AdminDisableUserRequest, AdminDisableUserResponse>()
                    .withOperationName("AdminDisableUser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminDisableUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminDisableUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Activates sign-in for a user profile that previously had sign-in access disabled.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminEnableUserRequest
     *        Represents the request that enables the user as an administrator.
     * @return Result of the AdminEnableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminEnableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AdminEnableUserResponse adminEnableUser(AdminEnableUserRequest adminEnableUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminEnableUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AdminEnableUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminEnableUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminEnableUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminEnableUser");

            return clientHandler.execute(new ClientExecutionParams<AdminEnableUserRequest, AdminEnableUserResponse>()
                    .withOperationName("AdminEnableUser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminEnableUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminEnableUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Forgets, or deletes, a remembered device from a user's profile. After you forget the device, the user can no
     * longer complete device authentication with that device and when applicable, must submit MFA codes again. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with devices</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminForgetDeviceRequest
     *        Sends the forgot device request, as an administrator.
     * @return Result of the AdminForgetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is not valid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AdminForgetDeviceResponse adminForgetDevice(AdminForgetDeviceRequest adminForgetDeviceRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidUserPoolConfigurationException,
            TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminForgetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AdminForgetDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminForgetDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminForgetDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminForgetDevice");

            return clientHandler.execute(new ClientExecutionParams<AdminForgetDeviceRequest, AdminForgetDeviceResponse>()
                    .withOperationName("AdminForgetDevice").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminForgetDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminForgetDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Given the device key, returns details for a user's device. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with devices</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminGetDeviceRequest
     *        Represents the request to get the device, as an administrator.
     * @return Result of the AdminGetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is not valid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminGetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AdminGetDeviceResponse adminGetDevice(AdminGetDeviceRequest adminGetDeviceRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidUserPoolConfigurationException, TooManyRequestsException, InternalErrorException,
            NotAuthorizedException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminGetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AdminGetDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminGetDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminGetDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminGetDevice");

            return clientHandler.execute(new ClientExecutionParams<AdminGetDeviceRequest, AdminGetDeviceResponse>()
                    .withOperationName("AdminGetDevice").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminGetDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminGetDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Given a username, returns details about a user profile in a user pool. You can specify alias attributes in the
     * <code>Username</code> request parameter.
     * </p>
     * <p>
     * This operation contributes to your monthly active user (MAU) count for the purpose of billing.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminGetUserRequest
     *        Represents the request to get the specified user as an administrator.
     * @return Result of the AdminGetUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminGetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AdminGetUserResponse adminGetUser(AdminGetUserRequest adminGetUserRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminGetUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AdminGetUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminGetUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminGetUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminGetUser");

            return clientHandler.execute(new ClientExecutionParams<AdminGetUserRequest, AdminGetUserResponse>()
                    .withOperationName("AdminGetUser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminGetUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminGetUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts sign-in for applications with a server-side component, for example a traditional web application. This
     * operation specifies the authentication flow that you'd like to begin. The authentication flow that you specify
     * must be supported in your app client configuration. For more information about authentication flows, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
     * >Authentication flows</a>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminInitiateAuthRequest
     *        Initiates the authorization request, as an administrator.
     * @return Result of the AdminInitiateAuth operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws UnsupportedOperationException
     *         Exception that is thrown when you attempt to perform an operation that isn't enabled for the user pool
     *         client.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is not valid.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when Amazon Cognito encounters an invalid Lambda response.
     * @throws MfaMethodNotFoundException
     *         This exception is thrown when Amazon Cognito can't find a multi-factor authentication (MFA) method.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration doesn't have permission to
     *         publish using Amazon SNS.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code:
     *         400.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is not valid for the role provided for SMS
     *         configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external
     *         ID provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user isn't confirmed successfully.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminInitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AdminInitiateAuthResponse adminInitiateAuth(AdminInitiateAuthRequest adminInitiateAuthRequest)
            throws ResourceNotFoundException, UnsupportedOperationException, InvalidParameterException, NotAuthorizedException,
            TooManyRequestsException, InternalErrorException, UnexpectedLambdaException, InvalidUserPoolConfigurationException,
            UserLambdaValidationException, InvalidLambdaResponseException, MfaMethodNotFoundException,
            InvalidSmsRoleAccessPolicyException, InvalidEmailRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminInitiateAuthResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AdminInitiateAuthResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminInitiateAuthRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminInitiateAuthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminInitiateAuth");

            return clientHandler.execute(new ClientExecutionParams<AdminInitiateAuthRequest, AdminInitiateAuthResponse>()
                    .withOperationName("AdminInitiateAuth").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminInitiateAuthRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminInitiateAuthRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Links an existing user account in a user pool, or <code>DestinationUser</code>, to an identity from an external
     * IdP, or <code>SourceUser</code>, based on a specified attribute name and value from the external IdP.
     * </p>
     * <p>
     * This operation connects a local user profile with a user identity who hasn't yet signed in from their third-party
     * IdP. When the user signs in with their IdP, they get access-control configuration from the local user profile.
     * Linked local users can also sign in with SDK-based API operations like <code>InitiateAuth</code> after they sign
     * in at least once through their IdP. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
     * >Linking federated users</a>.
     * </p>
     * <note>
     * <p>
     * The maximum number of federated identities linked to a user is five.
     * </p>
     * </note> <important>
     * <p>
     * Because this API allows a user with an external federated identity to sign in as a local user, it is critical
     * that it only be used with external IdPs and linked attributes that you trust.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminLinkProviderForUserRequest
     * @return Result of the AdminLinkProviderForUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email address or phone number
     *         that has already been supplied as an alias for a different user profile. This exception indicates that an
     *         account with this email address or phone already exists in a user pool that you've configured to use
     *         email address or phone number as a sign-in alias.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminLinkProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminLinkProviderForUserResponse adminLinkProviderForUser(
            AdminLinkProviderForUserRequest adminLinkProviderForUserRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            AliasExistsException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminLinkProviderForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminLinkProviderForUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminLinkProviderForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminLinkProviderForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminLinkProviderForUser");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminLinkProviderForUserRequest, AdminLinkProviderForUserResponse>()
                            .withOperationName("AdminLinkProviderForUser").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminLinkProviderForUserRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminLinkProviderForUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists a user's registered devices. Remembered devices are used in authentication services where you offer a
     * "Remember me" option for users who you want to permit to sign in without MFA from a trusted device. Users can
     * bypass MFA while your application performs device SRP authentication on the back end. For more information, see
     * <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with devices</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListDevicesRequest
     *        Represents the request to list devices, as an administrator.
     * @return Result of the AdminListDevices operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is not valid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AdminListDevicesResponse adminListDevices(AdminListDevicesRequest adminListDevicesRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidUserPoolConfigurationException,
            TooManyRequestsException, InternalErrorException, NotAuthorizedException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AdminListDevicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminListDevicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminListDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminListDevices");

            return clientHandler.execute(new ClientExecutionParams<AdminListDevicesRequest, AdminListDevicesResponse>()
                    .withOperationName("AdminListDevices").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminListDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminListDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the groups that a user belongs to. User pool groups are identifiers that you can reference from the
     * contents of ID and access tokens, and set preferred IAM roles for identity-pool authentication. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListGroupsForUserRequest
     * @return Result of the AdminListGroupsForUser operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminListGroupsForUserResponse adminListGroupsForUser(AdminListGroupsForUserRequest adminListGroupsForUserRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminListGroupsForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminListGroupsForUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminListGroupsForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminListGroupsForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminListGroupsForUser");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminListGroupsForUserRequest, AdminListGroupsForUserResponse>()
                            .withOperationName("AdminListGroupsForUser").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminListGroupsForUserRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminListGroupsForUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Requests a history of user activity and any risks detected as part of Amazon Cognito threat protection. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-event-user-history"
     * >Viewing user event history</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListUserAuthEventsRequest
     * @return Result of the AdminListUserAuthEvents operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons aren't enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminListUserAuthEventsResponse adminListUserAuthEvents(AdminListUserAuthEventsRequest adminListUserAuthEventsRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminListUserAuthEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminListUserAuthEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminListUserAuthEventsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminListUserAuthEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminListUserAuthEvents");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminListUserAuthEventsRequest, AdminListUserAuthEventsResponse>()
                            .withOperationName("AdminListUserAuthEvents").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminListUserAuthEventsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminListUserAuthEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Given a username and a group name, removes them from the group. User pool groups are identifiers that you can
     * reference from the contents of ID and access tokens, and set preferred IAM roles for identity-pool
     * authentication. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminRemoveUserFromGroupRequest
     * @return Result of the AdminRemoveUserFromGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminRemoveUserFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminRemoveUserFromGroupResponse adminRemoveUserFromGroup(
            AdminRemoveUserFromGroupRequest adminRemoveUserFromGroupRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminRemoveUserFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminRemoveUserFromGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminRemoveUserFromGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminRemoveUserFromGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminRemoveUserFromGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminRemoveUserFromGroupRequest, AdminRemoveUserFromGroupResponse>()
                            .withOperationName("AdminRemoveUserFromGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminRemoveUserFromGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminRemoveUserFromGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Resets the specified user's password in a user pool. This operation doesn't change the user's password, but sends
     * a password-reset code.
     * </p>
     * <p>
     * To use this API operation, your user pool must have self-service account recovery configured.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminResetUserPasswordRequest
     *        Represents the request to reset a user's password as an administrator.
     * @return Result of the AdminResetUserPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when Amazon Cognito encounters an invalid Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration doesn't have permission to
     *         publish using Amazon SNS.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code:
     *         400.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is not valid for the role provided for SMS
     *         configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external
     *         ID provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminResetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminResetUserPasswordResponse adminResetUserPassword(AdminResetUserPasswordRequest adminResetUserPasswordRequest)
            throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException,
            UserLambdaValidationException, NotAuthorizedException, InvalidLambdaResponseException, TooManyRequestsException,
            LimitExceededException, UserNotFoundException, InvalidSmsRoleAccessPolicyException,
            InvalidEmailRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminResetUserPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminResetUserPasswordResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminResetUserPasswordRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminResetUserPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminResetUserPassword");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminResetUserPasswordRequest, AdminResetUserPasswordResponse>()
                            .withOperationName("AdminResetUserPassword").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminResetUserPasswordRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminResetUserPasswordRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication
     * that bypasses MFA, or for a custom authentication challenge. An <code>AdminRespondToAuthChallenge</code> API
     * request provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a
     * response to an authentication challenge vary with the type of challenge.
     * </p>
     * <p>
     * For more information about custom authentication challenges, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminRespondToAuthChallengeRequest
     *        The request to respond to the authentication challenge, as an administrator.
     * @return Result of the AdminRespondToAuthChallenge operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code doesn't match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.
     * @throws InvalidPasswordException
     *         This exception is thrown when Amazon Cognito encounters an invalid password.
     * @throws PasswordHistoryPolicyViolationException
     *         The message returned when a user's new password matches a previous password and doesn't comply with the
     *         password-history policy.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when Amazon Cognito encounters an invalid Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is not valid.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws MfaMethodNotFoundException
     *         This exception is thrown when Amazon Cognito can't find a multi-factor authentication (MFA) method.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code:
     *         400.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration doesn't have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is not valid for the role provided for SMS
     *         configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external
     *         ID provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email address or phone number
     *         that has already been supplied as an alias for a different user profile. This exception indicates that an
     *         account with this email address or phone already exists in a user pool that you've configured to use
     *         email address or phone number as a sign-in alias.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user isn't confirmed successfully.
     * @throws SoftwareTokenMfaNotFoundException
     *         This exception is thrown when the software token time-based one-time password (TOTP) multi-factor
     *         authentication (MFA) isn't activated for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminRespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminRespondToAuthChallengeResponse adminRespondToAuthChallenge(
            AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, CodeMismatchException, ExpiredCodeException,
            UnexpectedLambdaException, InvalidPasswordException, PasswordHistoryPolicyViolationException,
            UserLambdaValidationException, InvalidLambdaResponseException, TooManyRequestsException,
            InvalidUserPoolConfigurationException, InternalErrorException, MfaMethodNotFoundException,
            InvalidEmailRoleAccessPolicyException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException,
            AliasExistsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException,
            SoftwareTokenMfaNotFoundException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminRespondToAuthChallengeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminRespondToAuthChallengeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminRespondToAuthChallengeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminRespondToAuthChallengeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminRespondToAuthChallenge");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminRespondToAuthChallengeRequest, AdminRespondToAuthChallengeResponse>()
                            .withOperationName("AdminRespondToAuthChallenge").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminRespondToAuthChallengeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminRespondToAuthChallengeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if
     * any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate
     * a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge
     * to choose an MFA option will be returned during sign-in.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserMfaPreferenceRequest
     * @return Result of the AdminSetUserMFAPreference operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user isn't confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminSetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminSetUserMfaPreferenceResponse adminSetUserMFAPreference(
            AdminSetUserMfaPreferenceRequest adminSetUserMfaPreferenceRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, PasswordResetRequiredException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminSetUserMfaPreferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminSetUserMfaPreferenceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminSetUserMfaPreferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminSetUserMfaPreferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminSetUserMFAPreference");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminSetUserMfaPreferenceRequest, AdminSetUserMfaPreferenceResponse>()
                            .withOperationName("AdminSetUserMFAPreference").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminSetUserMfaPreferenceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminSetUserMfaPreferenceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the specified user's password in a user pool. This operation administratively sets a temporary or permanent
     * password for a user. With this operation, you can bypass self-service password changes and permit immediate
     * sign-in with the password that you set. To do this, set <code>Permanent</code> to <code>true</code>.
     * </p>
     * <p>
     * You can also set a new temporary password in this request, send it to a user, and require them to choose a new
     * password on their next sign-in. To do this, set <code>Permanent</code> to <code>false</code>.
     * </p>
     * <p>
     * If the password is temporary, the user's <code>Status</code> becomes <code>FORCE_CHANGE_PASSWORD</code>. When the
     * user next tries to sign in, the <code>InitiateAuth</code> or <code>AdminInitiateAuth</code> response includes the
     * <code>NEW_PASSWORD_REQUIRED</code> challenge. If the user doesn't sign in before the temporary password expires,
     * they can no longer sign in and you must repeat this operation to set a temporary or permanent password for them.
     * </p>
     * <p>
     * After the user sets a new password, or if you set a permanent password, their status becomes
     * <code>Confirmed</code>.
     * </p>
     * <p>
     * <code>AdminSetUserPassword</code> can set a password for the user profile that Amazon Cognito creates for
     * third-party federated users. When you set a password, the federated user's status changes from
     * <code>EXTERNAL_PROVIDER</code> to <code>CONFIRMED</code>. A user in this state can sign in as a federated user,
     * and initiate authentication flows in the API like a linked native user. They can also modify their password and
     * attributes in token-authenticated API requests like <code>ChangePassword</code> and
     * <code>UpdateUserAttributes</code>. As a best security practice and to keep users in sync with your external IdP,
     * don't set passwords on federated user profiles. To set up a federated user for native sign-in with a linked
     * native user, refer to <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
     * >Linking federated users to an existing user profile</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserPasswordRequest
     * @return Result of the AdminSetUserPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidPasswordException
     *         This exception is thrown when Amazon Cognito encounters an invalid password.
     * @throws PasswordHistoryPolicyViolationException
     *         The message returned when a user's new password matches a previous password and doesn't comply with the
     *         password-history policy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminSetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminSetUserPasswordResponse adminSetUserPassword(AdminSetUserPasswordRequest adminSetUserPasswordRequest)
            throws ResourceNotFoundException, NotAuthorizedException, UserNotFoundException, InternalErrorException,
            TooManyRequestsException, InvalidParameterException, InvalidPasswordException,
            PasswordHistoryPolicyViolationException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminSetUserPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminSetUserPasswordResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminSetUserPasswordRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminSetUserPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminSetUserPassword");

            return clientHandler.execute(new ClientExecutionParams<AdminSetUserPasswordRequest, AdminSetUserPasswordResponse>()
                    .withOperationName("AdminSetUserPassword").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminSetUserPasswordRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminSetUserPasswordRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure time-based one-time password (TOTP) software token MFA.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserSettingsRequest
     *        You can use this parameter to set an MFA configuration that uses the SMS delivery medium.
     * @return Result of the AdminSetUserSettings operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminSetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminSetUserSettingsResponse adminSetUserSettings(AdminSetUserSettingsRequest adminSetUserSettingsRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminSetUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminSetUserSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminSetUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminSetUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminSetUserSettings");

            return clientHandler.execute(new ClientExecutionParams<AdminSetUserSettingsRequest, AdminSetUserSettingsResponse>()
                    .withOperationName("AdminSetUserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(adminSetUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdminSetUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides the feedback for an authentication event generated by threat protection features. Your response
     * indicates that you think that the event either was from a valid user or was an unwanted authentication attempt.
     * This feedback improves the risk evaluation decision for the user pool as part of Amazon Cognito threat
     * protection. To activate this setting, your user pool must be on the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html"> Plus tier</a>.
     * </p>
     * <p>
     * To train the threat-protection model to recognize trusted and untrusted sign-in characteristics, configure threat
     * protection in audit-only mode and provide a mechanism for users or administrators to submit feedback. Your
     * feedback can tell Amazon Cognito that a risk rating was assigned at a level you don't agree with.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUpdateAuthEventFeedbackRequest
     * @return Result of the AdminUpdateAuthEventFeedback operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons aren't enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminUpdateAuthEventFeedbackResponse adminUpdateAuthEventFeedback(
            AdminUpdateAuthEventFeedbackRequest adminUpdateAuthEventFeedbackRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminUpdateAuthEventFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminUpdateAuthEventFeedbackResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUpdateAuthEventFeedbackRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUpdateAuthEventFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUpdateAuthEventFeedback");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateAuthEventFeedbackRequest, AdminUpdateAuthEventFeedbackResponse>()
                            .withOperationName("AdminUpdateAuthEventFeedback").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminUpdateAuthEventFeedbackRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminUpdateAuthEventFeedbackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the status of a user's device so that it is marked as remembered or not remembered for the purpose of
     * device authentication. Device authentication is a "remember me" mechanism that silently completes sign-in from
     * trusted devices with a device key instead of a user-provided MFA code. This operation changes the status of a
     * device without deleting it, so you can enable it again later. For more information about device authentication,
     * see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with devices</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUpdateDeviceStatusRequest
     *        The request to update the device status, as an administrator.
     * @return Result of the AdminUpdateDeviceStatus operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is not valid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminUpdateDeviceStatusResponse adminUpdateDeviceStatus(AdminUpdateDeviceStatusRequest adminUpdateDeviceStatusRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidUserPoolConfigurationException,
            TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminUpdateDeviceStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminUpdateDeviceStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUpdateDeviceStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUpdateDeviceStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUpdateDeviceStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateDeviceStatusRequest, AdminUpdateDeviceStatusResponse>()
                            .withOperationName("AdminUpdateDeviceStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminUpdateDeviceStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminUpdateDeviceStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified user's attributes. To delete an attribute from your user, submit the attribute in your API
     * request with a blank value.
     * </p>
     * <p>
     * For custom attributes, you must add a <code>custom:</code> prefix to the attribute name, for example
     * <code>custom:department</code>.
     * </p>
     * <p>
     * This operation can set a user's email address or phone number as verified and permit immediate sign-in in user
     * pools that require verification of these attributes. To do this, set the <code>email_verified</code> or
     * <code>phone_number_verified</code> attribute to <code>true</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param adminUpdateUserAttributesRequest
     *        Represents the request to update the user's attributes as an administrator.
     * @return Result of the AdminUpdateUserAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when Amazon Cognito encounters an invalid Lambda response.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email address or phone number
     *         that has already been supplied as an alias for a different user profile. This exception indicates that an
     *         account with this email address or phone already exists in a user pool that you've configured to use
     *         email address or phone number as a sign-in alias.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration doesn't have permission to
     *         publish using Amazon SNS.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code:
     *         400.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is not valid for the role provided for SMS
     *         configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external
     *         ID provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminUpdateUserAttributesResponse adminUpdateUserAttributes(
            AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest) throws ResourceNotFoundException,
            InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, InvalidLambdaResponseException,
            AliasExistsException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, InvalidSmsRoleAccessPolicyException, InvalidEmailRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminUpdateUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminUpdateUserAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUpdateUserAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUpdateUserAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUpdateUserAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateUserAttributesRequest, AdminUpdateUserAttributesResponse>()
                            .withOperationName("AdminUpdateUserAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminUpdateUserAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminUpdateUserAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation
     * with your administrative credentials when your user signs out of your app. This results in the following
     * behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out
     * user's access tokens. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * <p>
     * Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a
     * user pools API request with a revoked access token that contains the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's ID token in a <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an
     * identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html"
     * >CognitoIdentityProvider</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's refresh tokens in refresh requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other requests might be valid until your user's token expires. This operation doesn't clear the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html">managed
     * login</a> session cookie. To clear the session for a user who signed in with managed login or the classic hosted
     * UI, direct their browser session to the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/logout-endpoint.html">logout endpoint</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUserGlobalSignOutRequest
     *        The request to sign out of all devices, as an administrator.
     * @return Result of the AdminUserGlobalSignOut operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUserGlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdminUserGlobalSignOutResponse adminUserGlobalSignOut(AdminUserGlobalSignOutRequest adminUserGlobalSignOutRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdminUserGlobalSignOutResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdminUserGlobalSignOutResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUserGlobalSignOutRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUserGlobalSignOutRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUserGlobalSignOut");

            return clientHandler
                    .execute(new ClientExecutionParams<AdminUserGlobalSignOutRequest, AdminUserGlobalSignOutResponse>()
                            .withOperationName("AdminUserGlobalSignOut").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(adminUserGlobalSignOutRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AdminUserGlobalSignOutRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a user, with a unique
     * private key that Amazon Cognito generates and returns in the API response. You can authorize an
     * <code>AssociateSoftwareToken</code> request with either the user's access token, or a session string from a
     * challenge response that you received from Amazon Cognito.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     *
     * @param associateSoftwareTokenRequest
     * @return Result of the AssociateSoftwareToken operation returned by the service.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SoftwareTokenMfaNotFoundException
     *         This exception is thrown when the software token time-based one-time password (TOTP) multi-factor
     *         authentication (MFA) isn't activated for the user pool.
     * @throws ForbiddenException
     *         This exception is thrown when WAF doesn't allow your request based on a web ACL that's associated with
     *         your user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AssociateSoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateSoftwareTokenResponse associateSoftwareToken(AssociateSoftwareTokenRequest associateSoftwareTokenRequest)
            throws ConcurrentModificationException, InvalidParameterException, NotAuthorizedException, ResourceNotFoundException,
            InternalErrorException, SoftwareTokenMfaNotFoundException, ForbiddenException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateSoftwareTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateSoftwareTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSoftwareTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSoftwareTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSoftwareToken");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateSoftwareTokenRequest, AssociateSoftwareTokenResponse>()
                            .withOperationName("AssociateSoftwareToken").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateSoftwareTokenRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateSoftwareTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the password for the currently signed-in user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param changePasswordRequest
     *        Represents the request to change a user password.
     * @return Result of the ChangePassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidPasswordException
     *         This exception is thrown when Amazon Cognito encounters an invalid password.
     * @throws PasswordHistoryPolicyViolationException
     *         The message returned when a user's new password matches a previous password and doesn't comply with the
     *         password-history policy.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user isn't confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws ForbiddenException
     *         This exception is thrown when WAF doesn't allow your request based on a web ACL that's associated with
     *         your user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ChangePasswordResponse changePassword(ChangePasswordRequest changePasswordRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidPasswordException, PasswordHistoryPolicyViolationException, NotAuthorizedException,
            TooManyRequestsException, LimitExceededException, PasswordResetRequiredException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ChangePasswordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ChangePasswordResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(changePasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, changePasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChangePassword");

            return clientHandler.execute(new ClientExecutionParams<ChangePasswordRequest, ChangePasswordResponse>()
                    .withOperationName("ChangePassword").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(changePasswordRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ChangePasswordRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Completes registration of a passkey authenticator for the currently signed-in user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     *
     * @param completeWebAuthnRegistrationRequest
     * @return Result of the CompleteWebAuthnRegistration operation returned by the service.
     * @throws ForbiddenException
     *         This exception is thrown when WAF doesn't allow your request based on a web ACL that's associated with
     *         your user pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws WebAuthnNotEnabledException
     *         This exception is thrown when the passkey feature isn't enabled for the user pool.
     * @throws WebAuthnChallengeNotFoundException
     *         This exception is thrown when the challenge from <code>StartWebAuthn</code> registration has expired.
     * @throws WebAuthnRelyingPartyMismatchException
     *         This exception is thrown when the given passkey credential is associated with a different relying party
     *         ID than the user pool relying party ID.
     * @throws WebAuthnClientMismatchException
     *         This exception is thrown when the access token is for a different client than the one in the original
     *         <code>StartWebAuthnRegistration</code> request.
     * @throws WebAuthnOriginNotAllowedException
     *         This exception is thrown when the passkey credential's registration origin does not align with the user
     *         pool relying party id.
     * @throws WebAuthnCredentialNotSupportedException
     *         This exception is thrown when a user presents passkey credentials from an unsupported device or provider.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CompleteWebAuthnRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CompleteWebAuthnRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompleteWebAuthnRegistrationResponse completeWebAuthnRegistration(
            CompleteWebAuthnRegistrationRequest completeWebAuthnRegistrationRequest) throws ForbiddenException,
            InternalErrorException, InvalidParameterException, LimitExceededException, NotAuthorizedException,
            TooManyRequestsException, WebAuthnNotEnabledException, WebAuthnChallengeNotFoundException,
            WebAuthnRelyingPartyMismatchException, WebAuthnClientMismatchException, WebAuthnOriginNotAllowedException,
            WebAuthnCredentialNotSupportedException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CompleteWebAuthnRegistrationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CompleteWebAuthnRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(completeWebAuthnRegistrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, completeWebAuthnRegistrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CompleteWebAuthnRegistration");

            return clientHandler
                    .execute(new ClientExecutionParams<CompleteWebAuthnRegistrationRequest, CompleteWebAuthnRegistrationResponse>()
                            .withOperationName("CompleteWebAuthnRegistration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(completeWebAuthnRegistrationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CompleteWebAuthnRegistrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Confirms a device that a user wants to remember. A remembered device is a "Remember me on this device" option for
     * user pools that perform authentication with the device key of a trusted device in the back end, instead of a
     * user-provided MFA code. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmDeviceRequest
     *        The confirm-device request.
     * @return Result of the ConfirmDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws InvalidPasswordException
     *         This exception is thrown when Amazon Cognito encounters an invalid password.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when Amazon Cognito encounters an invalid Lambda response.
     * @throws UsernameExistsException
     *         This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is not valid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user isn't confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws DeviceKeyExistsException
     *         This exception is thrown when a user attempts to confirm a device with a device key that already exists.
     * @throws ForbiddenException
     *         This exception is thrown when WAF doesn't allow your request based on a web ACL that's associated with
     *         your user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ConfirmDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ConfirmDeviceResponse confirmDevice(ConfirmDeviceRequest confirmDeviceRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, InvalidPasswordException, InvalidLambdaResponseException,
            UsernameExistsException, InvalidUserPoolConfigurationException, TooManyRequestsException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            DeviceKeyExistsException, ForbiddenException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConfirmDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ConfirmDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmDevice");

            return clientHandler.execute(new ClientExecutionParams<ConfirmDeviceRequest, ConfirmDeviceResponse>()
                    .withOperationName("ConfirmDevice").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(confirmDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ConfirmDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This public API operation accepts a confirmation code that Amazon Cognito sent to a user and accepts a new
     * password for that user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmForgotPasswordRequest
     *        The request representing the confirmation for a password reset.
     * @return Result of the ConfirmForgotPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         Lambda service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidPasswordException
     *         This exception is thrown when Amazon Cognito encounters an invalid password.
     * @throws PasswordHistoryPolicyViolationException
     *         The message returned when a user's new password matches a previous password and doesn't comply with the
     *         password-history policy.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code doesn't match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws TooManyFailedAttemptsException
     *         This exception is thrown when the user has made too many failed attempts for a given action, such as
     *         sign-in.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when Amazon Cognito encounters an invalid Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user isn't confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws ForbiddenException
     *         This exception is thrown when WAF doesn't allow your request based on a web ACL that's associated with
     *         your user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ConfirmForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ConfirmForgotPasswordResponse confirmForgotPassword(ConfirmForgotPasswordRequest confirmForgotPasswordRequest)
            throws ResourceNotFoundException, UnexpectedLambdaException, UserLambdaValidationException,
            InvalidParameterException, InvalidPasswordException, PasswordHistoryPolicyViolationException, NotAuthorizedException,
            CodeMismatchException, ExpiredCodeException, TooManyFailedAttemptsException, InvalidLambdaResponseException,
            TooManyRequestsException, LimitExceededException, UserNotFoundException, UserNotConfirmedException,
            InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConfirmForgotPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ConfirmForgotPasswordResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmForgotPasswordRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmForgotPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmForgotPassword");

            return clientHandler.execute(new ClientExecutionParams<ConfirmForgotPasswordRequest, ConfirmForgotPasswordResponse>()
                    .withOperationName("ConfirmForgotPassword").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(confirmForgotPasswordRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ConfirmForgotPasswordRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Confirms the account of a new user. This public API operation submits a code that Amazon Cognito sent to your
     * user when they signed up in your user pool. After your user enters their code, they confirm ownership of the
     * email address or phone number that they provided, and their user account becomes active. Depending on your user
     * pool configuration, your users will receive their confirmation code in an email or SMS message.
     * </p>
     * <p>
     * Local users who signed up in your user pool are the only type of user who can confirm sign-up with a code. Users
     * who federate through an external identity provider (IdP) have already been confirmed by their IdP.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmSignUpRequest
     *        Represents the request to confirm registration of a user.
     * @return Result of the ConfirmSignUp operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws TooManyFailedAttemptsException
     *         This exception is thrown when the user has made too many failed attempts for a given action, such as
     *         sign-in.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code doesn't match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when Amazon Cognito encounters an invalid Lambda response.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email address or phone number
     *         that has already been supplied as an alias for a different user profile. This exception indicates that an
     *         account with this email address or phone already exists in a user pool that you've configured to use
     *         email address or phone number as a sign-in alias.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user isn't found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws ForbiddenException
     *         This exception is thrown when WAF doesn't allow your request based on a web ACL that's associated with
     *         your user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ConfirmSignUpResponse confirmSignUp(ConfirmSignUpRequest confirmSignUpRequest) throws ResourceNotFoundException,
            InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException,
            TooManyFailedAttemptsException, CodeMismatchException, ExpiredCodeException, InvalidLambdaResponseException,
            AliasExistsException, TooManyRequestsException, LimitExceededException, UserNotFoundException,
            InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConfirmSignUpResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ConfirmSignUpResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmSignUpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmSignUpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmSignUp");

            return clientHandler.execute(new ClientExecutionParams<ConfirmSignUpRequest, ConfirmSignUpResponse>()
                    .withOperationName("ConfirmSignUp").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(confirmSignUpRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ConfirmSignUpRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new group in the specified user pool. For more information about user pool groups, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createGroupRequest
     * @return Result of the CreateGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws GroupExistsException
     *         This exception is thrown when Amazon Cognito encounters a group that already exists in the user pool.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws InvalidParameterException,
            GroupExistsException, ResourceNotFoundException, TooManyRequestsException, LimitExceededException,
            NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                    .withOperationName("CreateGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a configuration and trust relationship between a third-party identity provider (IdP) and a user pool. Amazon
     * Cognito accepts sign-in with third-party identity providers through managed login and OIDC relying-party
     * libraries. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html"
     * >Third-party IdP sign-in</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createIdentityProviderRequest
     * @return Result of the CreateIdentityProvider operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws DuplicateProviderException
     *         This exception is thrown when the provider is already supported by the user pool.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIdentityProviderResponse createIdentityProvider(CreateIdentityProviderRequest createIdentityProviderRequest)
            throws InvalidParameterException, DuplicateProviderException, ResourceNotFoundException, NotAuthorizedException,
            TooManyRequestsException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIdentityProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdentityProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIdentityProviderRequest, CreateIdentityProviderResponse>()
                            .withOperationName("CreateIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createIdentityProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIdentityProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new set of branding settings for a user pool style and associates it with an app client. This operation
     * is the programmatic option for the creation of a new style in the branding designer.
     * </p>
     * <p>
     * Provides values for UI customization in a <code>Settings</code> JSON object and image files in an
     * <code>Assets</code> array. To send the JSON object <code>Document</code> type parameter in <code>Settings</code>,
     * you might need to update to the most recent version of your Amazon Web Services SDK. To create a new style with
     * default settings, set <code>UseCognitoProvidedValues</code> to <code>true</code> and don't provide values for any
     * other options.
     * </p>
     * <p>
     * This operation has a 2-megabyte request-size limit and include the CSS settings and image assets for your app
     * client. Your branding settings might exceed 2MB in size. Amazon Cognito doesn't require that you pass all
     * parameters in one request and preserves existing style settings that you don't specify. If your request is larger
     * than 2MB, separate it into multiple requests, each with a size smaller than the limit.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createManagedLoginBrandingRequest
     * @return Result of the CreateManagedLoginBranding operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws ManagedLoginBrandingExistsException
     *         This exception is thrown when you attempt to apply a managed login branding style to an app client that
     *         already has an assigned style.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateManagedLoginBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateManagedLoginBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateManagedLoginBrandingResponse createManagedLoginBranding(
            CreateManagedLoginBrandingRequest createManagedLoginBrandingRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, ManagedLoginBrandingExistsException, InvalidParameterException,
            TooManyRequestsException, NotAuthorizedException, LimitExceededException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateManagedLoginBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateManagedLoginBrandingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createManagedLoginBrandingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createManagedLoginBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateManagedLoginBranding");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateManagedLoginBrandingRequest, CreateManagedLoginBrandingResponse>()
                            .withOperationName("CreateManagedLoginBranding").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createManagedLoginBrandingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateManagedLoginBrandingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new OAuth2.0 resource server and defines custom scopes within it. Resource servers are associated with
     * custom scopes and machine-to-machine (M2M) authorization. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-define-resource-servers.html"
     * >Access control with resource servers</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createResourceServerRequest
     * @return Result of the CreateResourceServer operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResourceServerResponse createResourceServer(CreateResourceServerRequest createResourceServerRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourceServerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceServer");

            return clientHandler.execute(new ClientExecutionParams<CreateResourceServerRequest, CreateResourceServerResponse>()
                    .withOperationName("CreateResourceServer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createResourceServerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateResourceServerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a user import job. You can import users into user pools from a comma-separated values (CSV) file without
     * adding Amazon Cognito MAU costs to your Amazon Web Services bill.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserImportJobRequest
     *        Represents the request to create the user import job.
     * @return Result of the CreateUserImportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PreconditionNotMetException
     *         This exception is thrown when a precondition is not met.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUserImportJobResponse createUserImportJob(CreateUserImportJobRequest createUserImportJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, PreconditionNotMetException,
            NotAuthorizedException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUserImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserImportJob");

            return clientHandler.execute(new ClientExecutionParams<CreateUserImportJobRequest, CreateUserImportJobResponse>()
                    .withOperationName("CreateUserImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createUserImportJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Amazon Cognito user pool. This operation sets basic and advanced configuration options.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Services service, Amazon
     * Simple Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolRequest
     *        Represents the request to create a user pool.
     * @return Result of the CreateUserPool operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration doesn't have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is not valid for the role provided for SMS
     *         configuration. This can happen if you don't trust <code>cognito-idp.amazonaws.com</code> or the external
     *         ID provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito isn't allowed to use your email identity. HTTP status code:
     *         400.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws UserPoolTaggingException
     *         This exception is thrown when a user pool tag can't be set or updated.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws TierChangeNotAllowedException
     *         This exception is thrown when you've attempted to change your feature plan but the operation isn't
     *         permitted.
     * @throws FeatureUnavailableInTierException
     *         This exception is thrown when a feature you attempted to configure isn't available in your current
     *         feature plan.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateUserPoolResponse createUserPool(CreateUserPoolRequest createUserPoolRequest) throws InvalidParameterException,
            TooManyRequestsException, LimitExceededException, InvalidSmsRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException, NotAuthorizedException,
            UserPoolTaggingException, InternalErrorException, TierChangeNotAllowedException, FeatureUnavailableInTierException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUserPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserPool");

            return clientHandler.execute(new ClientExecutionParams<CreateUserPoolRequest, CreateUserPoolResponse>()
                    .withOperationName("CreateUserPool").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createUserPoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an app client in a user pool. This operation sets basic and advanced configuration options.
     * </p>
     * <p>
     * Unlike app clients created in the console, Amazon Cognito doesn't automatically assign a branding style to app
     * clients that you configure with this API operation. Managed login and classic hosted UI pages aren't available
     * for your client until after you apply a branding style.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolClientRequest
     *        Represents the request to create a user pool client.
     * @return Result of the CreateUserPoolClient operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws ScopeDoesNotExistException
     *         This exception is thrown when the specified scope doesn't exist.
     * @throws InvalidOAuthFlowException
     *         This exception is thrown when the specified OAuth flow is not valid.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws FeatureUnavailableInTierException
     *         This exception is thrown when a feature you attempted to configure isn't available in your current
     *         feature plan.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUserPoolClientResponse createUserPoolClient(CreateUserPoolClientRequest createUserPoolClientRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, LimitExceededException,
            NotAuthorizedException, ScopeDoesNotExistException, InvalidOAuthFlowException, InternalErrorException,
            FeatureUnavailableInTierException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUserPoolClientResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserPoolClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserPoolClientRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserPoolClient");

            return clientHandler.execute(new ClientExecutionParams<CreateUserPoolClientRequest, CreateUserPoolClientResponse>()
                    .withOperationName("CreateUserPoolClient").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createUserPoolClientRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserPoolClientRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A user pool domain hosts managed login, an authorization server and web server for authentication in your
     * application. This operation creates a new user pool prefix domain or custom domain and sets the managed login
     * branding version. Set the branding version to <code>1</code> for hosted UI (classic) or <code>2</code> for
     * managed login. When you choose a custom domain, you must provide an SSL certificate in the US East (N. Virginia)
     * Amazon Web Services Region in your request.
     * </p>
     * <p>
     * Your prefix domain might take up to one minute to take effect. Your custom domain is online within five minutes,
     * but it can take up to one hour to distribute your SSL certificate.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html"
     * >Configuring a user pool domain</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolDomainRequest
     * @return Result of the CreateUserPoolDomain operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws FeatureUnavailableInTierException
     *         This exception is thrown when a feature you attempted to configure isn't available in your current
     *         feature plan.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUserPoolDomainResponse createUserPoolDomain(CreateUserPoolDomainRequest createUserPoolDomainRequest)
            throws InvalidParameterException, NotAuthorizedException, ConcurrentModificationException, ResourceNotFoundException,
            LimitExceededException, InternalErrorException, FeatureUnavailableInTierException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUserPoolDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserPoolDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserPoolDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserPoolDomain");

            return clientHandler.execute(new ClientExecutionParams<CreateUserPoolDomainRequest, CreateUserPoolDomainResponse>()
                    .withOperationName("CreateUserPoolDomain").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createUserPoolDomainRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserPoolDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a group from the specified user pool. When you delete a group, that group no longer contributes to users'
     * <code>cognito:preferred_group</code> or <code>cognito:groups</code> claims, and no longer influence
     * access-control decision that are based on group membership. For more information about user pool groups, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-user-groups.html">Adding
     * groups to a user pool</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                    .withOperationName("DeleteGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a user pool identity provider (IdP). After you delete an IdP, users can no longer sign in to your user
     * pool through that IdP. For more information about user pool IdPs, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html"
     * >Third-party IdP sign-in</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteIdentityProviderRequest
     * @return Result of the DeleteIdentityProvider operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnsupportedIdentityProviderException
     *         This exception is thrown when the specified identifier isn't supported.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIdentityProviderResponse deleteIdentityProvider(DeleteIdentityProviderRequest deleteIdentityProviderRequest)
            throws InvalidParameterException, UnsupportedIdentityProviderException, ConcurrentModificationException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteIdentityProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdentityProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>()
                            .withOperationName("DeleteIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteIdentityProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIdentityProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a managed login branding style. When you delete a style, you delete the branding association for an app
     * client. When an app client doesn't have a style assigned, your managed login pages for that app client are
     * nonfunctional until you create a new style or switch the domain branding version.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteManagedLoginBrandingRequest
     * @return Result of the DeleteManagedLoginBranding operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteManagedLoginBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteManagedLoginBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteManagedLoginBrandingResponse deleteManagedLoginBranding(
            DeleteManagedLoginBrandingRequest deleteManagedLoginBrandingRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteManagedLoginBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteManagedLoginBrandingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "UserLambdaValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserLambdaValidationException::builder).build());
            case "InvalidSmsRoleTrustRelationshipException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).build());
            case "TooManyFailedAttemptsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "WebAuthnClientMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnClientMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnClientMismatchException::builder).build());
            case "ScopeDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).build());
            case "InvalidEmailRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "WebAuthnCredentialNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnCredentialNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnCredentialNotSupportedException::builder).build());
            case "GroupExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GroupExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GroupExistsException::builder).build());
            case "UserPoolTaggingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolTaggingException::builder).build());
            case "WebAuthnChallengeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnChallengeNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnChallengeNotFoundException::builder).build());
            case "UserPoolAddOnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteManagedLoginBrandingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteManagedLoginBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteManagedLoginBranding");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteManagedLoginBrandingRequest, DeleteManagedLoginBrandingResponse>()
                            .withOperationName("DeleteManagedLoginBranding").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteManagedLoginBrandingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteManagedLoginBrandingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a resource server. After you delete a resource server, users can no longer generate access tokens with
     * scopes that are associate with that resource server.
     * </p>
     * <p>
     * Resource servers are associated with custom scopes and machine-to-machine (M2M) authorization. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-define-resource-servers.html"
     * >Access control with resource servers</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteResourceServerRequest
     * @return Result of the DeleteResourceServer operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service can't find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user isn't authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourceServerResponse deleteResourceServer(DeleteResourceServerRequest deleteResourceServerRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourceServerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "InvalidLambdaResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).build());
            case "PasswordHistoryPolicyViolationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).build());
            case "InvalidOAuthFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).build());
            case "UserImportInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserImportInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserImportInProgressException::builder).build());
            case "SoftwareTokenMFANotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).build());
            case "ExpiredCodeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredCodeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ExpiredCodeException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "NotAuthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NotAuthorizedException::builder).build());
            case "UnsupportedIdentityProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "PasswordResetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PasswordResetRequiredException::builder).build());
            case "DuplicateProviderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateProviderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateProviderException::builder).build());
            case "ManagedLoginBrandingExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManagedLoginBrandingExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ManagedLoginBrandingExistsException::builder).build());
            case "CodeDeliveryFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).build());
            case "WebAuthnRelyingPartyMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnRelyingPartyMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnRelyingPartyMismatchException::builder).build());
            case "FeatureUnavailableInTierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureUnavailableInTierException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureUnavailableInTierException::builder).build());
            case "InternalErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalErrorException::builder).build());
            case "TierChangeNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TierChangeNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TierChangeNotAllowedException::builder).build());
            case "EnableSoftwareTokenMFAException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).build());
            case "WebAuthnConfigurationMissingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnConfigurationMissingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WebAuthnConfigurationMissingException::builder).build());
            case "InvalidUserPoolConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "CodeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CodeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CodeMismatchException::builder).build());
            case "WebAuthnNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnNotEnabledException::builder).build());
            case "RefreshTokenReuseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RefreshTokenReuseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RefreshTokenReuseException::builder).build());
            case "InvalidSmsRoleAccessPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).build());
            case "UsernameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UsernameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UsernameExistsException::builder).build());
            case "MFAMethodNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).build());
            case "UnsupportedTokenTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "WebAuthnOriginNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WebAuthnOriginNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(WebAuthnOriginNotAllowedException::builder).build());
            case "AliasExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AliasExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AliasExistsException::builder).build());
            case "UnsupportedUserStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedUserStateException::builder).build());
            case "UserNotConfirmedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserNotConfirmedException::builder).build());
            case "DeviceKeyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeviceKeyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeviceKeyExistsException::builder).build());
            case "UnexpectedLambdaException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnexpectedLambdaExceptio