/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.FeatureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshTokenRotationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RefreshTokenRotationType> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Feature").getter(RefreshTokenRotationType.getter(RefreshTokenRotationType::featureAsString)).setter(RefreshTokenRotationType.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()}).build();
    private static final SdkField<Integer> RETRY_GRACE_PERIOD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetryGracePeriodSeconds").getter(RefreshTokenRotationType.getter(RefreshTokenRotationType::retryGracePeriodSeconds)).setter(RefreshTokenRotationType.setter(Builder::retryGracePeriodSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryGracePeriodSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD, RETRY_GRACE_PERIOD_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RefreshTokenRotationType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String feature;
    private final Integer retryGracePeriodSeconds;

    private RefreshTokenRotationType(BuilderImpl builder) {
        this.feature = builder.feature;
        this.retryGracePeriodSeconds = builder.retryGracePeriodSeconds;
    }

    public final FeatureType feature() {
        return FeatureType.fromValue(this.feature);
    }

    public final String featureAsString() {
        return this.feature;
    }

    public final Integer retryGracePeriodSeconds() {
        return this.retryGracePeriodSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryGracePeriodSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshTokenRotationType)) {
            return false;
        }
        RefreshTokenRotationType other = (RefreshTokenRotationType)obj;
        return Objects.equals(this.featureAsString(), other.featureAsString()) && Objects.equals(this.retryGracePeriodSeconds(), other.retryGracePeriodSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"RefreshTokenRotationType").add("Feature", (Object)this.featureAsString()).add("RetryGracePeriodSeconds", (Object)this.retryGracePeriodSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Feature": {
                return Optional.ofNullable(clazz.cast(this.featureAsString()));
            }
            case "RetryGracePeriodSeconds": {
                return Optional.ofNullable(clazz.cast(this.retryGracePeriodSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Feature", FEATURE_FIELD);
        map.put("RetryGracePeriodSeconds", RETRY_GRACE_PERIOD_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshTokenRotationType, T> g) {
        return obj -> g.apply((RefreshTokenRotationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String feature;
        private Integer retryGracePeriodSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshTokenRotationType model) {
            this.feature(model.feature);
            this.retryGracePeriodSeconds(model.retryGracePeriodSeconds);
        }

        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(FeatureType feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final Integer getRetryGracePeriodSeconds() {
            return this.retryGracePeriodSeconds;
        }

        public final void setRetryGracePeriodSeconds(Integer retryGracePeriodSeconds) {
            this.retryGracePeriodSeconds = retryGracePeriodSeconds;
        }

        @Override
        public final Builder retryGracePeriodSeconds(Integer retryGracePeriodSeconds) {
            this.retryGracePeriodSeconds = retryGracePeriodSeconds;
            return this;
        }

        public RefreshTokenRotationType build() {
            return new RefreshTokenRotationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RefreshTokenRotationType> {
        public Builder feature(String var1);

        public Builder feature(FeatureType var1);

        public Builder retryGracePeriodSeconds(Integer var1);
    }
}

