/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum AssetCategoryType {
    FAVICON_ICO("FAVICON_ICO"),

    FAVICON_SVG("FAVICON_SVG"),

    EMAIL_GRAPHIC("EMAIL_GRAPHIC"),

    SMS_GRAPHIC("SMS_GRAPHIC"),

    AUTH_APP_GRAPHIC("AUTH_APP_GRAPHIC"),

    PASSWORD_GRAPHIC("PASSWORD_GRAPHIC"),

    PASSKEY_GRAPHIC("PASSKEY_GRAPHIC"),

    PAGE_HEADER_LOGO("PAGE_HEADER_LOGO"),

    PAGE_HEADER_BACKGROUND("PAGE_HEADER_BACKGROUND"),

    PAGE_FOOTER_LOGO("PAGE_FOOTER_LOGO"),

    PAGE_FOOTER_BACKGROUND("PAGE_FOOTER_BACKGROUND"),

    PAGE_BACKGROUND("PAGE_BACKGROUND"),

    FORM_BACKGROUND("FORM_BACKGROUND"),

    FORM_LOGO("FORM_LOGO"),

    IDP_BUTTON_ICON("IDP_BUTTON_ICON"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssetCategoryType> VALUE_MAP = EnumUtils.uniqueIndex(AssetCategoryType.class,
            AssetCategoryType::toString);

    private final String value;

    private AssetCategoryType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AssetCategoryType corresponding to the value
     */
    public static AssetCategoryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AssetCategoryType}s
     */
    public static Set<AssetCategoryType> knownValues() {
        Set<AssetCategoryType> knownValues = EnumSet.allOf(AssetCategoryType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
