/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a set of terms documents. For more information, see <a href=
 * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html#managed-login-terms-documents"
 * >Terms documents</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TermsType implements SdkPojo, Serializable, ToCopyableBuilder<TermsType.Builder, TermsType> {
    private static final SdkField<String> TERMS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TermsId").getter(getter(TermsType::termsId)).setter(setter(Builder::termsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsId").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(TermsType::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(TermsType::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> TERMS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TermsName").getter(getter(TermsType::termsName)).setter(setter(Builder::termsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsName").build()).build();

    private static final SdkField<String> TERMS_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TermsSource").getter(getter(TermsType::termsSourceAsString)).setter(setter(Builder::termsSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsSource").build()).build();

    private static final SdkField<String> ENFORCEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Enforcement").getter(getter(TermsType::enforcementAsString)).setter(setter(Builder::enforcement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enforcement").build()).build();

    private static final SdkField<Map<String, String>> LINKS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Links")
            .getter(getter(TermsType::links))
            .setter(setter(Builder::links))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Links").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(TermsType::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(TermsType::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMS_ID_FIELD,
            USER_POOL_ID_FIELD, CLIENT_ID_FIELD, TERMS_NAME_FIELD, TERMS_SOURCE_FIELD, ENFORCEMENT_FIELD, LINKS_FIELD,
            CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String termsId;

    private final String userPoolId;

    private final String clientId;

    private final String termsName;

    private final String termsSource;

    private final String enforcement;

    private final Map<String, String> links;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private TermsType(BuilderImpl builder) {
        this.termsId = builder.termsId;
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.termsName = builder.termsName;
        this.termsSource = builder.termsSource;
        this.enforcement = builder.enforcement;
        this.links = builder.links;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The ID of the terms documents.
     * </p>
     * 
     * @return The ID of the terms documents.
     */
    public final String termsId() {
        return termsId;
    }

    /**
     * <p>
     * The ID of the user pool that contains the terms documents.
     * </p>
     * 
     * @return The ID of the user pool that contains the terms documents.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The ID of the app client that the terms documents are assigned to.
     * </p>
     * 
     * @return The ID of the app client that the terms documents are assigned to.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The type and friendly name of the terms documents.
     * </p>
     * 
     * @return The type and friendly name of the terms documents.
     */
    public final String termsName() {
        return termsName;
    }

    /**
     * <p>
     * This parameter is reserved for future use and currently accepts one value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termsSource} will
     * return {@link TermsSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termsSourceAsString}.
     * </p>
     * 
     * @return This parameter is reserved for future use and currently accepts one value.
     * @see TermsSourceType
     */
    public final TermsSourceType termsSource() {
        return TermsSourceType.fromValue(termsSource);
    }

    /**
     * <p>
     * This parameter is reserved for future use and currently accepts one value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termsSource} will
     * return {@link TermsSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termsSourceAsString}.
     * </p>
     * 
     * @return This parameter is reserved for future use and currently accepts one value.
     * @see TermsSourceType
     */
    public final String termsSourceAsString() {
        return termsSource;
    }

    /**
     * <p>
     * This parameter is reserved for future use and currently accepts one value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enforcement} will
     * return {@link TermsEnforcementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enforcementAsString}.
     * </p>
     * 
     * @return This parameter is reserved for future use and currently accepts one value.
     * @see TermsEnforcementType
     */
    public final TermsEnforcementType enforcement() {
        return TermsEnforcementType.fromValue(enforcement);
    }

    /**
     * <p>
     * This parameter is reserved for future use and currently accepts one value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enforcement} will
     * return {@link TermsEnforcementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enforcementAsString}.
     * </p>
     * 
     * @return This parameter is reserved for future use and currently accepts one value.
     * @see TermsEnforcementType
     */
    public final String enforcementAsString() {
        return enforcement;
    }

    /**
     * For responses, this returns true if the service returned a value for the Links property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLinks() {
        return links != null && !(links instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of URLs to languages. For each localized language that will view the requested <code>TermsName</code>,
     * assign a URL. A selection of <code>cognito:default</code> displays for all languages that don't have a
     * language-specific URL.
     * </p>
     * <p>
     * For example,
     * <code>"cognito:default": "https://terms.example.com", "cognito:spanish": "https://terms.example.com/es"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinks} method.
     * </p>
     * 
     * @return A map of URLs to languages. For each localized language that will view the requested
     *         <code>TermsName</code>, assign a URL. A selection of <code>cognito:default</code> displays for all
     *         languages that don't have a language-specific URL.</p>
     *         <p>
     *         For example,
     *         <code>"cognito:default": "https://terms.example.com", "cognito:spanish": "https://terms.example.com/es"</code>.
     */
    public final Map<String, String> links() {
        return links;
    }

    /**
     * <p>
     * The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format.
     * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
     * </p>
     * 
     * @return The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time
     *         format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
     *         <code>Date</code> object.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format.
     * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
     * </p>
     * 
     * @return The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time
     *         format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
     *         <code>Date</code> object.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(termsId());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(termsName());
        hashCode = 31 * hashCode + Objects.hashCode(termsSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enforcementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLinks() ? links() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermsType)) {
            return false;
        }
        TermsType other = (TermsType) obj;
        return Objects.equals(termsId(), other.termsId()) && Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(clientId(), other.clientId()) && Objects.equals(termsName(), other.termsName())
                && Objects.equals(termsSourceAsString(), other.termsSourceAsString())
                && Objects.equals(enforcementAsString(), other.enforcementAsString()) && hasLinks() == other.hasLinks()
                && Objects.equals(links(), other.links()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TermsType").add("TermsId", termsId()).add("UserPoolId", userPoolId())
                .add("ClientId", clientId() == null ? null : "*** Sensitive Data Redacted ***").add("TermsName", termsName())
                .add("TermsSource", termsSourceAsString()).add("Enforcement", enforcementAsString())
                .add("Links", hasLinks() ? links() : null).add("CreationDate", creationDate())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TermsId":
            return Optional.ofNullable(clazz.cast(termsId()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "TermsName":
            return Optional.ofNullable(clazz.cast(termsName()));
        case "TermsSource":
            return Optional.ofNullable(clazz.cast(termsSourceAsString()));
        case "Enforcement":
            return Optional.ofNullable(clazz.cast(enforcementAsString()));
        case "Links":
            return Optional.ofNullable(clazz.cast(links()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TermsId", TERMS_ID_FIELD);
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("TermsName", TERMS_NAME_FIELD);
        map.put("TermsSource", TERMS_SOURCE_FIELD);
        map.put("Enforcement", ENFORCEMENT_FIELD);
        map.put("Links", LINKS_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TermsType, T> g) {
        return obj -> g.apply((TermsType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TermsType> {
        /**
         * <p>
         * The ID of the terms documents.
         * </p>
         * 
         * @param termsId
         *        The ID of the terms documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termsId(String termsId);

        /**
         * <p>
         * The ID of the user pool that contains the terms documents.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool that contains the terms documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The ID of the app client that the terms documents are assigned to.
         * </p>
         * 
         * @param clientId
         *        The ID of the app client that the terms documents are assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The type and friendly name of the terms documents.
         * </p>
         * 
         * @param termsName
         *        The type and friendly name of the terms documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termsName(String termsName);

        /**
         * <p>
         * This parameter is reserved for future use and currently accepts one value.
         * </p>
         * 
         * @param termsSource
         *        This parameter is reserved for future use and currently accepts one value.
         * @see TermsSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermsSourceType
         */
        Builder termsSource(String termsSource);

        /**
         * <p>
         * This parameter is reserved for future use and currently accepts one value.
         * </p>
         * 
         * @param termsSource
         *        This parameter is reserved for future use and currently accepts one value.
         * @see TermsSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermsSourceType
         */
        Builder termsSource(TermsSourceType termsSource);

        /**
         * <p>
         * This parameter is reserved for future use and currently accepts one value.
         * </p>
         * 
         * @param enforcement
         *        This parameter is reserved for future use and currently accepts one value.
         * @see TermsEnforcementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermsEnforcementType
         */
        Builder enforcement(String enforcement);

        /**
         * <p>
         * This parameter is reserved for future use and currently accepts one value.
         * </p>
         * 
         * @param enforcement
         *        This parameter is reserved for future use and currently accepts one value.
         * @see TermsEnforcementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermsEnforcementType
         */
        Builder enforcement(TermsEnforcementType enforcement);

        /**
         * <p>
         * A map of URLs to languages. For each localized language that will view the requested <code>TermsName</code>,
         * assign a URL. A selection of <code>cognito:default</code> displays for all languages that don't have a
         * language-specific URL.
         * </p>
         * <p>
         * For example,
         * <code>"cognito:default": "https://terms.example.com", "cognito:spanish": "https://terms.example.com/es"</code>
         * .
         * </p>
         * 
         * @param links
         *        A map of URLs to languages. For each localized language that will view the requested
         *        <code>TermsName</code>, assign a URL. A selection of <code>cognito:default</code> displays for all
         *        languages that don't have a language-specific URL.</p>
         *        <p>
         *        For example,
         *        <code>"cognito:default": "https://terms.example.com", "cognito:spanish": "https://terms.example.com/es"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(Map<String, String> links);

        /**
         * <p>
         * The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format.
         * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time
         *        format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
         *        <code>Date</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time
         * format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code>
         * object.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time
         *        format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
         *        <code>Date</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String termsId;

        private String userPoolId;

        private String clientId;

        private String termsName;

        private String termsSource;

        private String enforcement;

        private Map<String, String> links = DefaultSdkAutoConstructMap.getInstance();

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TermsType model) {
            termsId(model.termsId);
            userPoolId(model.userPoolId);
            clientId(model.clientId);
            termsName(model.termsName);
            termsSource(model.termsSource);
            enforcement(model.enforcement);
            links(model.links);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getTermsId() {
            return termsId;
        }

        public final void setTermsId(String termsId) {
            this.termsId = termsId;
        }

        @Override
        public final Builder termsId(String termsId) {
            this.termsId = termsId;
            return this;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getTermsName() {
            return termsName;
        }

        public final void setTermsName(String termsName) {
            this.termsName = termsName;
        }

        @Override
        public final Builder termsName(String termsName) {
            this.termsName = termsName;
            return this;
        }

        public final String getTermsSource() {
            return termsSource;
        }

        public final void setTermsSource(String termsSource) {
            this.termsSource = termsSource;
        }

        @Override
        public final Builder termsSource(String termsSource) {
            this.termsSource = termsSource;
            return this;
        }

        @Override
        public final Builder termsSource(TermsSourceType termsSource) {
            this.termsSource(termsSource == null ? null : termsSource.toString());
            return this;
        }

        public final String getEnforcement() {
            return enforcement;
        }

        public final void setEnforcement(String enforcement) {
            this.enforcement = enforcement;
        }

        @Override
        public final Builder enforcement(String enforcement) {
            this.enforcement = enforcement;
            return this;
        }

        @Override
        public final Builder enforcement(TermsEnforcementType enforcement) {
            this.enforcement(enforcement == null ? null : enforcement.toString());
            return this;
        }

        public final Map<String, String> getLinks() {
            if (links instanceof SdkAutoConstructMap) {
                return null;
            }
            return links;
        }

        public final void setLinks(Map<String, String> links) {
            this.links = LinksTypeCopier.copy(links);
        }

        @Override
        public final Builder links(Map<String, String> links) {
            this.links = LinksTypeCopier.copy(links);
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public TermsType build() {
            return new TermsType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
