/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTermsResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<DescribeTermsResponse.Builder, DescribeTermsResponse> {
    private static final SdkField<TermsType> TERMS_FIELD = SdkField.<TermsType> builder(MarshallingType.SDK_POJO)
            .memberName("Terms").getter(getter(DescribeTermsResponse::terms)).setter(setter(Builder::terms))
            .constructor(TermsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Terms").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TermsType terms;

    private DescribeTermsResponse(BuilderImpl builder) {
        super(builder);
        this.terms = builder.terms;
    }

    /**
     * <p>
     * A summary of the requested terms documents. Includes a unique identifier for later changes to the terms
     * documents.
     * </p>
     * 
     * @return A summary of the requested terms documents. Includes a unique identifier for later changes to the terms
     *         documents.
     */
    public final TermsType terms() {
        return terms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(terms());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTermsResponse)) {
            return false;
        }
        DescribeTermsResponse other = (DescribeTermsResponse) obj;
        return Objects.equals(terms(), other.terms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTermsResponse").add("Terms", terms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Terms":
            return Optional.ofNullable(clazz.cast(terms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Terms", TERMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTermsResponse, T> g) {
        return obj -> g.apply((DescribeTermsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTermsResponse> {
        /**
         * <p>
         * A summary of the requested terms documents. Includes a unique identifier for later changes to the terms
         * documents.
         * </p>
         * 
         * @param terms
         *        A summary of the requested terms documents. Includes a unique identifier for later changes to the
         *        terms documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terms(TermsType terms);

        /**
         * <p>
         * A summary of the requested terms documents. Includes a unique identifier for later changes to the terms
         * documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link TermsType.Builder} avoiding the need to
         * create one manually via {@link TermsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TermsType.Builder#build()} is called immediately and its result
         * is passed to {@link #terms(TermsType)}.
         * 
         * @param terms
         *        a consumer that will call methods on {@link TermsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terms(TermsType)
         */
        default Builder terms(Consumer<TermsType.Builder> terms) {
            return terms(TermsType.builder().applyMutation(terms).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private TermsType terms;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTermsResponse model) {
            super(model);
            terms(model.terms);
        }

        public final TermsType.Builder getTerms() {
            return terms != null ? terms.toBuilder() : null;
        }

        public final void setTerms(TermsType.BuilderImpl terms) {
            this.terms = terms != null ? terms.build() : null;
        }

        @Override
        public final Builder terms(TermsType terms) {
            this.terms = terms;
            return this;
        }

        @Override
        public DescribeTermsResponse build() {
            return new DescribeTermsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
