/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LinksTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TermsEnforcementType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TermsSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TermsType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TermsType> {
    private static final SdkField<String> TERMS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermsId").getter(TermsType.getter(TermsType::termsId)).setter(TermsType.setter(Builder::termsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsId").build()}).build();
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(TermsType.getter(TermsType::userPoolId)).setter(TermsType.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(TermsType.getter(TermsType::clientId)).setter(TermsType.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> TERMS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermsName").getter(TermsType.getter(TermsType::termsName)).setter(TermsType.setter(Builder::termsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsName").build()}).build();
    private static final SdkField<String> TERMS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermsSource").getter(TermsType.getter(TermsType::termsSourceAsString)).setter(TermsType.setter(Builder::termsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsSource").build()}).build();
    private static final SdkField<String> ENFORCEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Enforcement").getter(TermsType.getter(TermsType::enforcementAsString)).setter(TermsType.setter(Builder::enforcement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enforcement").build()}).build();
    private static final SdkField<Map<String, String>> LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Links").getter(TermsType.getter(TermsType::links)).setter(TermsType.setter(Builder::links)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Links").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(TermsType.getter(TermsType::creationDate)).setter(TermsType.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(TermsType.getter(TermsType::lastModifiedDate)).setter(TermsType.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMS_ID_FIELD, USER_POOL_ID_FIELD, CLIENT_ID_FIELD, TERMS_NAME_FIELD, TERMS_SOURCE_FIELD, ENFORCEMENT_FIELD, LINKS_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TermsType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String termsId;
    private final String userPoolId;
    private final String clientId;
    private final String termsName;
    private final String termsSource;
    private final String enforcement;
    private final Map<String, String> links;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private TermsType(BuilderImpl builder) {
        this.termsId = builder.termsId;
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.termsName = builder.termsName;
        this.termsSource = builder.termsSource;
        this.enforcement = builder.enforcement;
        this.links = builder.links;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String termsId() {
        return this.termsId;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String termsName() {
        return this.termsName;
    }

    public final TermsSourceType termsSource() {
        return TermsSourceType.fromValue(this.termsSource);
    }

    public final String termsSourceAsString() {
        return this.termsSource;
    }

    public final TermsEnforcementType enforcement() {
        return TermsEnforcementType.fromValue(this.enforcement);
    }

    public final String enforcementAsString() {
        return this.enforcement;
    }

    public final boolean hasLinks() {
        return this.links != null && !(this.links instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> links() {
        return this.links;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.termsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.termsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.termsSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforcementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinks() ? this.links() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermsType)) {
            return false;
        }
        TermsType other = (TermsType)obj;
        return Objects.equals(this.termsId(), other.termsId()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.termsName(), other.termsName()) && Objects.equals(this.termsSourceAsString(), other.termsSourceAsString()) && Objects.equals(this.enforcementAsString(), other.enforcementAsString()) && this.hasLinks() == other.hasLinks() && Objects.equals(this.links(), other.links()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"TermsType").add("TermsId", (Object)this.termsId()).add("UserPoolId", (Object)this.userPoolId()).add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("TermsName", (Object)this.termsName()).add("TermsSource", (Object)this.termsSourceAsString()).add("Enforcement", (Object)this.enforcementAsString()).add("Links", this.hasLinks() ? this.links() : null).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TermsId": {
                return Optional.ofNullable(clazz.cast(this.termsId()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "TermsName": {
                return Optional.ofNullable(clazz.cast(this.termsName()));
            }
            case "TermsSource": {
                return Optional.ofNullable(clazz.cast(this.termsSourceAsString()));
            }
            case "Enforcement": {
                return Optional.ofNullable(clazz.cast(this.enforcementAsString()));
            }
            case "Links": {
                return Optional.ofNullable(clazz.cast(this.links()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TermsId", TERMS_ID_FIELD);
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("TermsName", TERMS_NAME_FIELD);
        map.put("TermsSource", TERMS_SOURCE_FIELD);
        map.put("Enforcement", ENFORCEMENT_FIELD);
        map.put("Links", LINKS_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TermsType, T> g) {
        return obj -> g.apply((TermsType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String termsId;
        private String userPoolId;
        private String clientId;
        private String termsName;
        private String termsSource;
        private String enforcement;
        private Map<String, String> links = DefaultSdkAutoConstructMap.getInstance();
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TermsType model) {
            this.termsId(model.termsId);
            this.userPoolId(model.userPoolId);
            this.clientId(model.clientId);
            this.termsName(model.termsName);
            this.termsSource(model.termsSource);
            this.enforcement(model.enforcement);
            this.links(model.links);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getTermsId() {
            return this.termsId;
        }

        public final void setTermsId(String termsId) {
            this.termsId = termsId;
        }

        @Override
        public final Builder termsId(String termsId) {
            this.termsId = termsId;
            return this;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getTermsName() {
            return this.termsName;
        }

        public final void setTermsName(String termsName) {
            this.termsName = termsName;
        }

        @Override
        public final Builder termsName(String termsName) {
            this.termsName = termsName;
            return this;
        }

        public final String getTermsSource() {
            return this.termsSource;
        }

        public final void setTermsSource(String termsSource) {
            this.termsSource = termsSource;
        }

        @Override
        public final Builder termsSource(String termsSource) {
            this.termsSource = termsSource;
            return this;
        }

        @Override
        public final Builder termsSource(TermsSourceType termsSource) {
            this.termsSource(termsSource == null ? null : termsSource.toString());
            return this;
        }

        public final String getEnforcement() {
            return this.enforcement;
        }

        public final void setEnforcement(String enforcement) {
            this.enforcement = enforcement;
        }

        @Override
        public final Builder enforcement(String enforcement) {
            this.enforcement = enforcement;
            return this;
        }

        @Override
        public final Builder enforcement(TermsEnforcementType enforcement) {
            this.enforcement(enforcement == null ? null : enforcement.toString());
            return this;
        }

        public final Map<String, String> getLinks() {
            if (this.links instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.links;
        }

        public final void setLinks(Map<String, String> links) {
            this.links = LinksTypeCopier.copy(links);
        }

        @Override
        public final Builder links(Map<String, String> links) {
            this.links = LinksTypeCopier.copy(links);
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public TermsType build() {
            return new TermsType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TermsType> {
        public Builder termsId(String var1);

        public Builder userPoolId(String var1);

        public Builder clientId(String var1);

        public Builder termsName(String var1);

        public Builder termsSource(String var1);

        public Builder termsSource(TermsSourceType var1);

        public Builder enforcement(String var1);

        public Builder enforcement(TermsEnforcementType var1);

        public Builder links(Map<String, String> var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

