/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.UserAgentUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType;

public class AdminListGroupsForUserIterable
implements SdkIterable<AdminListGroupsForUserResponse> {
    private final CognitoIdentityProviderClient client;
    private final AdminListGroupsForUserRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public AdminListGroupsForUserIterable(CognitoIdentityProviderClient client, AdminListGroupsForUserRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new AdminListGroupsForUserResponseFetcher();
    }

    public Iterator<AdminListGroupsForUserResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupType> groups() {
        Function<AdminListGroupsForUserResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class AdminListGroupsForUserResponseFetcher
    implements SyncPageFetcher<AdminListGroupsForUserResponse> {
        private AdminListGroupsForUserResponseFetcher() {
        }

        public boolean hasNextPage(AdminListGroupsForUserResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public AdminListGroupsForUserResponse nextPage(AdminListGroupsForUserResponse previousPage) {
            if (previousPage == null) {
                return AdminListGroupsForUserIterable.this.client.adminListGroupsForUser(AdminListGroupsForUserIterable.this.firstRequest);
            }
            return AdminListGroupsForUserIterable.this.client.adminListGroupsForUser((AdminListGroupsForUserRequest)((Object)AdminListGroupsForUserIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

