/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetLogDeliveryConfigurationResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<SetLogDeliveryConfigurationResponse.Builder, SetLogDeliveryConfigurationResponse> {
    private static final SdkField<LogDeliveryConfigurationType> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<LogDeliveryConfigurationType> builder(MarshallingType.SDK_POJO).memberName("LogDeliveryConfiguration")
            .getter(getter(SetLogDeliveryConfigurationResponse::logDeliveryConfiguration))
            .setter(setter(Builder::logDeliveryConfiguration)).constructor(LogDeliveryConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOG_DELIVERY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LogDeliveryConfigurationType logDeliveryConfiguration;

    private SetLogDeliveryConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
    }

    /**
     * <p>
     * The logging configuration that you applied to the requested user pool.
     * </p>
     * 
     * @return The logging configuration that you applied to the requested user pool.
     */
    public final LogDeliveryConfigurationType logDeliveryConfiguration() {
        return logDeliveryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logDeliveryConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLogDeliveryConfigurationResponse)) {
            return false;
        }
        SetLogDeliveryConfigurationResponse other = (SetLogDeliveryConfigurationResponse) obj;
        return Objects.equals(logDeliveryConfiguration(), other.logDeliveryConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetLogDeliveryConfigurationResponse")
                .add("LogDeliveryConfiguration", logDeliveryConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(logDeliveryConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogDeliveryConfiguration", LOG_DELIVERY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetLogDeliveryConfigurationResponse, T> g) {
        return obj -> g.apply((SetLogDeliveryConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SetLogDeliveryConfigurationResponse> {
        /**
         * <p>
         * The logging configuration that you applied to the requested user pool.
         * </p>
         * 
         * @param logDeliveryConfiguration
         *        The logging configuration that you applied to the requested user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfiguration(LogDeliveryConfigurationType logDeliveryConfiguration);

        /**
         * <p>
         * The logging configuration that you applied to the requested user pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogDeliveryConfigurationType.Builder}
         * avoiding the need to create one manually via {@link LogDeliveryConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogDeliveryConfigurationType.Builder#build()} is called
         * immediately and its result is passed to {@link #logDeliveryConfiguration(LogDeliveryConfigurationType)}.
         * 
         * @param logDeliveryConfiguration
         *        a consumer that will call methods on {@link LogDeliveryConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfiguration(LogDeliveryConfigurationType)
         */
        default Builder logDeliveryConfiguration(Consumer<LogDeliveryConfigurationType.Builder> logDeliveryConfiguration) {
            return logDeliveryConfiguration(LogDeliveryConfigurationType.builder().applyMutation(logDeliveryConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private LogDeliveryConfigurationType logDeliveryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLogDeliveryConfigurationResponse model) {
            super(model);
            logDeliveryConfiguration(model.logDeliveryConfiguration);
        }

        public final LogDeliveryConfigurationType.Builder getLogDeliveryConfiguration() {
            return logDeliveryConfiguration != null ? logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfigurationType.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfigurationType logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        @Override
        public SetLogDeliveryConfigurationResponse build() {
            return new SetLogDeliveryConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
