/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The code delivery details being returned from the server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeDeliveryDetailsType implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeDeliveryDetailsType.Builder, CodeDeliveryDetailsType> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CodeDeliveryDetailsType::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> DELIVERY_MEDIUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CodeDeliveryDetailsType::deliveryMediumAsString)).setter(setter(Builder::deliveryMedium))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryMedium").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CodeDeliveryDetailsType::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            DELIVERY_MEDIUM_FIELD, ATTRIBUTE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destination;

    private final String deliveryMedium;

    private final String attributeName;

    private CodeDeliveryDetailsType(BuilderImpl builder) {
        this.destination = builder.destination;
        this.deliveryMedium = builder.deliveryMedium;
        this.attributeName = builder.attributeName;
    }

    /**
     * <p>
     * The destination for the code delivery details.
     * </p>
     * 
     * @return The destination for the code delivery details.
     */
    public String destination() {
        return destination;
    }

    /**
     * <p>
     * The delivery medium (email message or phone number).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryMedium}
     * will return {@link DeliveryMediumType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deliveryMediumAsString}.
     * </p>
     * 
     * @return The delivery medium (email message or phone number).
     * @see DeliveryMediumType
     */
    public DeliveryMediumType deliveryMedium() {
        return DeliveryMediumType.fromValue(deliveryMedium);
    }

    /**
     * <p>
     * The delivery medium (email message or phone number).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryMedium}
     * will return {@link DeliveryMediumType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deliveryMediumAsString}.
     * </p>
     * 
     * @return The delivery medium (email message or phone number).
     * @see DeliveryMediumType
     */
    public String deliveryMediumAsString() {
        return deliveryMedium;
    }

    /**
     * <p>
     * The attribute name.
     * </p>
     * 
     * @return The attribute name.
     */
    public String attributeName() {
        return attributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryMediumAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeDeliveryDetailsType)) {
            return false;
        }
        CodeDeliveryDetailsType other = (CodeDeliveryDetailsType) obj;
        return Objects.equals(destination(), other.destination())
                && Objects.equals(deliveryMediumAsString(), other.deliveryMediumAsString())
                && Objects.equals(attributeName(), other.attributeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CodeDeliveryDetailsType").add("Destination", destination())
                .add("DeliveryMedium", deliveryMediumAsString()).add("AttributeName", attributeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DeliveryMedium":
            return Optional.ofNullable(clazz.cast(deliveryMediumAsString()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeDeliveryDetailsType, T> g) {
        return obj -> g.apply((CodeDeliveryDetailsType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeDeliveryDetailsType> {
        /**
         * <p>
         * The destination for the code delivery details.
         * </p>
         * 
         * @param destination
         *        The destination for the code delivery details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The delivery medium (email message or phone number).
         * </p>
         * 
         * @param deliveryMedium
         *        The delivery medium (email message or phone number).
         * @see DeliveryMediumType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryMediumType
         */
        Builder deliveryMedium(String deliveryMedium);

        /**
         * <p>
         * The delivery medium (email message or phone number).
         * </p>
         * 
         * @param deliveryMedium
         *        The delivery medium (email message or phone number).
         * @see DeliveryMediumType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryMediumType
         */
        Builder deliveryMedium(DeliveryMediumType deliveryMedium);

        /**
         * <p>
         * The attribute name.
         * </p>
         * 
         * @param attributeName
         *        The attribute name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);
    }

    static final class BuilderImpl implements Builder {
        private String destination;

        private String deliveryMedium;

        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeDeliveryDetailsType model) {
            destination(model.destination);
            deliveryMedium(model.deliveryMedium);
            attributeName(model.attributeName);
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDeliveryMediumAsString() {
            return deliveryMedium;
        }

        @Override
        public final Builder deliveryMedium(String deliveryMedium) {
            this.deliveryMedium = deliveryMedium;
            return this;
        }

        @Override
        public final Builder deliveryMedium(DeliveryMediumType deliveryMedium) {
            this.deliveryMedium(deliveryMedium.toString());
            return this;
        }

        public final void setDeliveryMedium(String deliveryMedium) {
            this.deliveryMedium = deliveryMedium;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public CodeDeliveryDetailsType build() {
            return new CodeDeliveryDetailsType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
