/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailConfigurationType> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EmailConfigurationType.getter(EmailConfigurationType::sourceArn)).setter(EmailConfigurationType.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> REPLY_TO_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EmailConfigurationType.getter(EmailConfigurationType::replyToEmailAddress)).setter(EmailConfigurationType.setter(Builder::replyToEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToEmailAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, REPLY_TO_EMAIL_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceArn;
    private final String replyToEmailAddress;

    private EmailConfigurationType(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.replyToEmailAddress = builder.replyToEmailAddress;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String replyToEmailAddress() {
        return this.replyToEmailAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replyToEmailAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailConfigurationType)) {
            return false;
        }
        EmailConfigurationType other = (EmailConfigurationType)obj;
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.replyToEmailAddress(), other.replyToEmailAddress());
    }

    public String toString() {
        return ToString.builder((String)"EmailConfigurationType").add("SourceArn", (Object)this.sourceArn()).add("ReplyToEmailAddress", (Object)this.replyToEmailAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "ReplyToEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.replyToEmailAddress()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailConfigurationType, T> g) {
        return obj -> g.apply((EmailConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceArn;
        private String replyToEmailAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailConfigurationType model) {
            this.sourceArn(model.sourceArn);
            this.replyToEmailAddress(model.replyToEmailAddress);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getReplyToEmailAddress() {
            return this.replyToEmailAddress;
        }

        @Override
        public final Builder replyToEmailAddress(String replyToEmailAddress) {
            this.replyToEmailAddress = replyToEmailAddress;
            return this;
        }

        public final void setReplyToEmailAddress(String replyToEmailAddress) {
            this.replyToEmailAddress = replyToEmailAddress;
        }

        public EmailConfigurationType build() {
            return new EmailConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailConfigurationType> {
        public Builder sourceArn(String var1);

        public Builder replyToEmailAddress(String var1);
    }
}

