/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response to list devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDevicesResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ListDevicesResponse.Builder, ListDevicesResponse> {
    private static final SdkField<List<DeviceType>> DEVICES_FIELD = SdkField
            .<List<DeviceType>> builder(MarshallingType.LIST)
            .getter(getter(ListDevicesResponse::devices))
            .setter(setter(Builder::devices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Devices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceType> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDevicesResponse::paginationToken)).setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICES_FIELD,
            PAGINATION_TOKEN_FIELD));

    private final List<DeviceType> devices;

    private final String paginationToken;

    private ListDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.devices = builder.devices;
        this.paginationToken = builder.paginationToken;
    }

    /**
     * <p>
     * The devices returned in the list devices response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The devices returned in the list devices response.
     */
    public List<DeviceType> devices() {
        return devices;
    }

    /**
     * <p>
     * The pagination token for the list device response.
     * </p>
     * 
     * @return The pagination token for the list device response.
     */
    public String paginationToken() {
        return paginationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devices());
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesResponse)) {
            return false;
        }
        ListDevicesResponse other = (ListDevicesResponse) obj;
        return Objects.equals(devices(), other.devices()) && Objects.equals(paginationToken(), other.paginationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDevicesResponse").add("Devices", devices()).add("PaginationToken", paginationToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Devices":
            return Optional.ofNullable(clazz.cast(devices()));
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesResponse, T> g) {
        return obj -> g.apply((ListDevicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDevicesResponse> {
        /**
         * <p>
         * The devices returned in the list devices response.
         * </p>
         * 
         * @param devices
         *        The devices returned in the list devices response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<DeviceType> devices);

        /**
         * <p>
         * The devices returned in the list devices response.
         * </p>
         * 
         * @param devices
         *        The devices returned in the list devices response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(DeviceType... devices);

        /**
         * <p>
         * The devices returned in the list devices response.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceType>.Builder} avoiding the need to
         * create one manually via {@link List<DeviceType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceType>.Builder#build()} is called immediately and its
         * result is passed to {@link #devices(List<DeviceType>)}.
         * 
         * @param devices
         *        a consumer that will call methods on {@link List<DeviceType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devices(List<DeviceType>)
         */
        Builder devices(Consumer<DeviceType.Builder>... devices);

        /**
         * <p>
         * The pagination token for the list device response.
         * </p>
         * 
         * @param paginationToken
         *        The pagination token for the list device response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<DeviceType> devices = DefaultSdkAutoConstructList.getInstance();

        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesResponse model) {
            super(model);
            devices(model.devices);
            paginationToken(model.paginationToken);
        }

        public final Collection<DeviceType.Builder> getDevices() {
            return devices != null ? devices.stream().map(DeviceType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<DeviceType> devices) {
            this.devices = DeviceListTypeCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(DeviceType... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<DeviceType.Builder>... devices) {
            devices(Stream.of(devices).map(c -> DeviceType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevices(Collection<DeviceType.BuilderImpl> devices) {
            this.devices = DeviceListTypeCopier.copyFromBuilder(devices);
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public ListDevicesResponse build() {
            return new ListDevicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
