/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeResponse;

/**
 * Service client for accessing Amazon Cognito Identity Provider asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Using the Amazon Cognito User Pools API, you can create a user pool to manage directories and users. You can
 * authenticate a user to obtain tokens related to user identity and access policies.
 * </p>
 * <p>
 * This API reference provides information about user pools in Amazon Cognito User Pools.
 * </p>
 * <p>
 * For more information, see the Amazon Cognito Documentation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CognitoIdentityProviderAsyncClient extends SdkClient {
    String SERVICE_NAME = "cognito-idp";

    /**
     * Create a {@link CognitoIdentityProviderAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CognitoIdentityProviderAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CognitoIdentityProviderAsyncClient}.
     */
    static CognitoIdentityProviderAsyncClientBuilder builder() {
        return new DefaultCognitoIdentityProviderAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds additional user attributes to the user pool schema.
     * </p>
     *
     * @param addCustomAttributesRequest
     *        Represents the request to add custom attributes.
     * @return A Java Future containing the result of the AddCustomAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you are trying to modify a user pool
     *         while a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AddCustomAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddCustomAttributesResponse> addCustomAttributes(
            AddCustomAttributesRequest addCustomAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds additional user attributes to the user pool schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddCustomAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link AddCustomAttributesRequest#builder()}
     * </p>
     *
     * @param addCustomAttributesRequest
     *        A {@link Consumer} that will call methods on {@link AddCustomAttributesRequest.Builder} to create a
     *        request. Represents the request to add custom attributes.
     * @return A Java Future containing the result of the AddCustomAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you are trying to modify a user pool
     *         while a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AddCustomAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddCustomAttributesResponse> addCustomAttributes(
            Consumer<AddCustomAttributesRequest.Builder> addCustomAttributesRequest) {
        return addCustomAttributes(AddCustomAttributesRequest.builder().applyMutation(addCustomAttributesRequest).build());
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminAddUserToGroupRequest
     * @return A Java Future containing the result of the AdminAddUserToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminAddUserToGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminAddUserToGroupResponse> adminAddUserToGroup(
            AdminAddUserToGroupRequest adminAddUserToGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminAddUserToGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AdminAddUserToGroupRequest#builder()}
     * </p>
     *
     * @param adminAddUserToGroupRequest
     *        A {@link Consumer} that will call methods on {@link AdminAddUserToGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AdminAddUserToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminAddUserToGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminAddUserToGroupResponse> adminAddUserToGroup(
            Consumer<AdminAddUserToGroupRequest.Builder> adminAddUserToGroupRequest) {
        return adminAddUserToGroup(AdminAddUserToGroupRequest.builder().applyMutation(adminAddUserToGroupRequest).build());
    }

    /**
     * <p>
     * Confirms user registration as an admin without using a confirmation code. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminConfirmSignUpRequest
     *        Represents the request to confirm user registration.
     * @return A Java Future containing the result of the AdminConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action (e.g., sign in).</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminConfirmSignUp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminConfirmSignUpResponse> adminConfirmSignUp(AdminConfirmSignUpRequest adminConfirmSignUpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms user registration as an admin without using a confirmation code. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminConfirmSignUpRequest.Builder} avoiding the
     * need to create one manually via {@link AdminConfirmSignUpRequest#builder()}
     * </p>
     *
     * @param adminConfirmSignUpRequest
     *        A {@link Consumer} that will call methods on {@link AdminConfirmSignUpRequest.Builder} to create a
     *        request. Represents the request to confirm user registration.
     * @return A Java Future containing the result of the AdminConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action (e.g., sign in).</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminConfirmSignUp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminConfirmSignUpResponse> adminConfirmSignUp(
            Consumer<AdminConfirmSignUpRequest.Builder> adminConfirmSignUpRequest) {
        return adminConfirmSignUp(AdminConfirmSignUpRequest.builder().applyMutation(adminConfirmSignUpRequest).build());
    }

    /**
     * <p>
     * Creates a new user in the specified user pool.
     * </p>
     * <p>
     * If <code>MessageAction</code> is not set, the default is to send a welcome message via email or phone (SMS).
     * </p>
     * <note>
     * <p>
     * This message is based on a template that you configured in your call to or . This template includes your custom
     * sign-up instructions and placeholders for user name and temporary password.
     * </p>
     * </note>
     * <p>
     * Alternatively, you can call AdminCreateUser with “SUPPRESS” for the <code>MessageAction</code> parameter, and
     * Amazon Cognito will not send any email.
     * </p>
     * <p>
     * In either case, the user will be in the <code>FORCE_CHANGE_PASSWORD</code> state until they sign in and change
     * their password.
     * </p>
     * <p>
     * AdminCreateUser requires developer credentials.
     * </p>
     *
     * @param adminCreateUserRequest
     *        Represents the request to create a user in the specified user pool.
     * @return A Java Future containing the result of the AdminCreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UnsupportedUserStateException The request failed because the user is in an unsupported state.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminCreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminCreateUserResponse> adminCreateUser(AdminCreateUserRequest adminCreateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new user in the specified user pool.
     * </p>
     * <p>
     * If <code>MessageAction</code> is not set, the default is to send a welcome message via email or phone (SMS).
     * </p>
     * <note>
     * <p>
     * This message is based on a template that you configured in your call to or . This template includes your custom
     * sign-up instructions and placeholders for user name and temporary password.
     * </p>
     * </note>
     * <p>
     * Alternatively, you can call AdminCreateUser with “SUPPRESS” for the <code>MessageAction</code> parameter, and
     * Amazon Cognito will not send any email.
     * </p>
     * <p>
     * In either case, the user will be in the <code>FORCE_CHANGE_PASSWORD</code> state until they sign in and change
     * their password.
     * </p>
     * <p>
     * AdminCreateUser requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminCreateUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminCreateUserRequest#builder()}
     * </p>
     *
     * @param adminCreateUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminCreateUserRequest.Builder} to create a request.
     *        Represents the request to create a user in the specified user pool.
     * @return A Java Future containing the result of the AdminCreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UnsupportedUserStateException The request failed because the user is in an unsupported state.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminCreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminCreateUserResponse> adminCreateUser(
            Consumer<AdminCreateUserRequest.Builder> adminCreateUserRequest) {
        return adminCreateUser(AdminCreateUserRequest.builder().applyMutation(adminCreateUserRequest).build());
    }

    /**
     * <p>
     * Deletes a user as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminDeleteUserRequest
     *        Represents the request to delete a user as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminDeleteUserResponse> adminDeleteUser(AdminDeleteUserRequest adminDeleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDeleteUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminDeleteUserRequest#builder()}
     * </p>
     *
     * @param adminDeleteUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminDeleteUserRequest.Builder} to create a request.
     *        Represents the request to delete a user as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminDeleteUserResponse> adminDeleteUser(
            Consumer<AdminDeleteUserRequest.Builder> adminDeleteUserRequest) {
        return adminDeleteUser(AdminDeleteUserRequest.builder().applyMutation(adminDeleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminDeleteUserAttributesRequest
     *        Represents the request to delete user attributes as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminDeleteUserAttributesResponse> adminDeleteUserAttributes(
            AdminDeleteUserAttributesRequest adminDeleteUserAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDeleteUserAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link AdminDeleteUserAttributesRequest#builder()}
     * </p>
     *
     * @param adminDeleteUserAttributesRequest
     *        A {@link Consumer} that will call methods on {@link AdminDeleteUserAttributesRequest.Builder} to create a
     *        request. Represents the request to delete user attributes as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminDeleteUserAttributesResponse> adminDeleteUserAttributes(
            Consumer<AdminDeleteUserAttributesRequest.Builder> adminDeleteUserAttributesRequest) {
        return adminDeleteUserAttributes(AdminDeleteUserAttributesRequest.builder()
                .applyMutation(adminDeleteUserAttributesRequest).build());
    }

    /**
     * <p>
     * Disables the user from signing in with the specified external (SAML or social) identity provider. If the user to
     * disable is a Cognito User Pools native username + password user, they are not permitted to use their password to
     * sign-in. If the user to disable is a linked external IdP user, any link between that user and an existing user is
     * removed. The next time the external user (no longer attached to the previously linked
     * <code>DestinationUser</code>) signs in, they must create a new user account. See .
     * </p>
     * <p>
     * This action is enabled only for admin access and requires developer credentials.
     * </p>
     * <p>
     * The <code>ProviderName</code> must match the value specified when creating an IdP for the pool.
     * </p>
     * <p>
     * To disable a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code>
     * and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>, with the
     * <code>ProviderAttributeValue</code> being the name that is used in the user pool for the user.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social identity providers.
     * The <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was
     * originally linked as a source user.
     * </p>
     * <p>
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign-in,
     * the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were
     * used for the <code>SourceUser</code> when the identities were originally linked in the call. (If the linking was
     * done with <code>ProviderAttributeName</code> set to <code>Cognito_Subject</code>, the same applies here).
     * However, if the user has already signed in, the <code>ProviderAttributeName</code> must be
     * <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code> must be the subject of the SAML assertion.
     * </p>
     *
     * @param adminDisableProviderForUserRequest
     * @return A Java Future containing the result of the AdminDisableProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableProviderForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminDisableProviderForUserResponse> adminDisableProviderForUser(
            AdminDisableProviderForUserRequest adminDisableProviderForUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the user from signing in with the specified external (SAML or social) identity provider. If the user to
     * disable is a Cognito User Pools native username + password user, they are not permitted to use their password to
     * sign-in. If the user to disable is a linked external IdP user, any link between that user and an existing user is
     * removed. The next time the external user (no longer attached to the previously linked
     * <code>DestinationUser</code>) signs in, they must create a new user account. See .
     * </p>
     * <p>
     * This action is enabled only for admin access and requires developer credentials.
     * </p>
     * <p>
     * The <code>ProviderName</code> must match the value specified when creating an IdP for the pool.
     * </p>
     * <p>
     * To disable a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code>
     * and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>, with the
     * <code>ProviderAttributeValue</code> being the name that is used in the user pool for the user.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social identity providers.
     * The <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was
     * originally linked as a source user.
     * </p>
     * <p>
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign-in,
     * the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were
     * used for the <code>SourceUser</code> when the identities were originally linked in the call. (If the linking was
     * done with <code>ProviderAttributeName</code> set to <code>Cognito_Subject</code>, the same applies here).
     * However, if the user has already signed in, the <code>ProviderAttributeName</code> must be
     * <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code> must be the subject of the SAML assertion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDisableProviderForUserRequest.Builder}
     * avoiding the need to create one manually via {@link AdminDisableProviderForUserRequest#builder()}
     * </p>
     *
     * @param adminDisableProviderForUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminDisableProviderForUserRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AdminDisableProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableProviderForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminDisableProviderForUserResponse> adminDisableProviderForUser(
            Consumer<AdminDisableProviderForUserRequest.Builder> adminDisableProviderForUserRequest) {
        return adminDisableProviderForUser(AdminDisableProviderForUserRequest.builder()
                .applyMutation(adminDisableProviderForUserRequest).build());
    }

    /**
     * <p>
     * Disables the specified user as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminDisableUserRequest
     *        Represents the request to disable any user as an administrator.
     * @return A Java Future containing the result of the AdminDisableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminDisableUserResponse> adminDisableUser(AdminDisableUserRequest adminDisableUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the specified user as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDisableUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminDisableUserRequest#builder()}
     * </p>
     *
     * @param adminDisableUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminDisableUserRequest.Builder} to create a request.
     *        Represents the request to disable any user as an administrator.
     * @return A Java Future containing the result of the AdminDisableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminDisableUserResponse> adminDisableUser(
            Consumer<AdminDisableUserRequest.Builder> adminDisableUserRequest) {
        return adminDisableUser(AdminDisableUserRequest.builder().applyMutation(adminDisableUserRequest).build());
    }

    /**
     * <p>
     * Enables the specified user as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminEnableUserRequest
     *        Represents the request that enables the user as an administrator.
     * @return A Java Future containing the result of the AdminEnableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminEnableUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminEnableUserResponse> adminEnableUser(AdminEnableUserRequest adminEnableUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the specified user as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminEnableUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminEnableUserRequest#builder()}
     * </p>
     *
     * @param adminEnableUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminEnableUserRequest.Builder} to create a request.
     *        Represents the request that enables the user as an administrator.
     * @return A Java Future containing the result of the AdminEnableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminEnableUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminEnableUserResponse> adminEnableUser(
            Consumer<AdminEnableUserRequest.Builder> adminEnableUserRequest) {
        return adminEnableUser(AdminEnableUserRequest.builder().applyMutation(adminEnableUserRequest).build());
    }

    /**
     * <p>
     * Forgets the device, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminForgetDeviceRequest
     *        Sends the forgot device request, as an administrator.
     * @return A Java Future containing the result of the AdminForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminForgetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminForgetDeviceResponse> adminForgetDevice(AdminForgetDeviceRequest adminForgetDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forgets the device, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminForgetDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link AdminForgetDeviceRequest#builder()}
     * </p>
     *
     * @param adminForgetDeviceRequest
     *        A {@link Consumer} that will call methods on {@link AdminForgetDeviceRequest.Builder} to create a request.
     *        Sends the forgot device request, as an administrator.
     * @return A Java Future containing the result of the AdminForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminForgetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminForgetDeviceResponse> adminForgetDevice(
            Consumer<AdminForgetDeviceRequest.Builder> adminForgetDeviceRequest) {
        return adminForgetDevice(AdminForgetDeviceRequest.builder().applyMutation(adminForgetDeviceRequest).build());
    }

    /**
     * <p>
     * Gets the device, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminGetDeviceRequest
     *        Represents the request to get the device, as an administrator.
     * @return A Java Future containing the result of the AdminGetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AdminGetDeviceResponse> adminGetDevice(AdminGetDeviceRequest adminGetDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the device, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminGetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link AdminGetDeviceRequest#builder()}
     * </p>
     *
     * @param adminGetDeviceRequest
     *        A {@link Consumer} that will call methods on {@link AdminGetDeviceRequest.Builder} to create a request.
     *        Represents the request to get the device, as an administrator.
     * @return A Java Future containing the result of the AdminGetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AdminGetDeviceResponse> adminGetDevice(Consumer<AdminGetDeviceRequest.Builder> adminGetDeviceRequest) {
        return adminGetDevice(AdminGetDeviceRequest.builder().applyMutation(adminGetDeviceRequest).build());
    }

    /**
     * <p>
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminGetUserRequest
     *        Represents the request to get the specified user as an administrator.
     * @return A Java Future containing the result of the AdminGetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AdminGetUserResponse> adminGetUser(AdminGetUserRequest adminGetUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminGetUserRequest.Builder} avoiding the need to
     * create one manually via {@link AdminGetUserRequest#builder()}
     * </p>
     *
     * @param adminGetUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminGetUserRequest.Builder} to create a request.
     *        Represents the request to get the specified user as an administrator.
     * @return A Java Future containing the result of the AdminGetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AdminGetUserResponse> adminGetUser(Consumer<AdminGetUserRequest.Builder> adminGetUserRequest) {
        return adminGetUser(AdminGetUserRequest.builder().applyMutation(adminGetUserRequest).build());
    }

    /**
     * <p>
     * Initiates the authentication flow, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminInitiateAuthRequest
     *        Initiates the authorization request, as an administrator.
     * @return A Java Future containing the result of the AdminInitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito cannot find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminInitiateAuth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminInitiateAuthResponse> adminInitiateAuth(AdminInitiateAuthRequest adminInitiateAuthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the authentication flow, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminInitiateAuthRequest.Builder} avoiding the need
     * to create one manually via {@link AdminInitiateAuthRequest#builder()}
     * </p>
     *
     * @param adminInitiateAuthRequest
     *        A {@link Consumer} that will call methods on {@link AdminInitiateAuthRequest.Builder} to create a request.
     *        Initiates the authorization request, as an administrator.
     * @return A Java Future containing the result of the AdminInitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito cannot find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminInitiateAuth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminInitiateAuthResponse> adminInitiateAuth(
            Consumer<AdminInitiateAuthRequest.Builder> adminInitiateAuthRequest) {
        return adminInitiateAuth(AdminInitiateAuthRequest.builder().applyMutation(adminInitiateAuthRequest).build());
    }

    /**
     * <p>
     * Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external
     * identity provider (<code>SourceUser</code>) based on a specified attribute name and value from the external
     * identity provider. This allows you to create a link from the existing user account to an external federated user
     * identity that has not yet been used to sign in, so that the federated user identity can be used to sign in as the
     * existing user account.
     * </p>
     * <p>
     * For example, if there is an existing user with a username and password, this API links that user to a federated
     * user identity, so that when the federated user identity is used, the user signs in as the existing user account.
     * </p>
     * <important>
     * <p>
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user
     * pool, it is critical that it only be used with external identity providers and provider attributes that have been
     * trusted by the application owner.
     * </p>
     * </important>
     * <p>
     * See also .
     * </p>
     * <p>
     * This action is enabled only for admin access and requires developer credentials.
     * </p>
     *
     * @param adminLinkProviderForUserRequest
     * @return A Java Future containing the result of the AdminLinkProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminLinkProviderForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminLinkProviderForUserResponse> adminLinkProviderForUser(
            AdminLinkProviderForUserRequest adminLinkProviderForUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external
     * identity provider (<code>SourceUser</code>) based on a specified attribute name and value from the external
     * identity provider. This allows you to create a link from the existing user account to an external federated user
     * identity that has not yet been used to sign in, so that the federated user identity can be used to sign in as the
     * existing user account.
     * </p>
     * <p>
     * For example, if there is an existing user with a username and password, this API links that user to a federated
     * user identity, so that when the federated user identity is used, the user signs in as the existing user account.
     * </p>
     * <important>
     * <p>
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user
     * pool, it is critical that it only be used with external identity providers and provider attributes that have been
     * trusted by the application owner.
     * </p>
     * </important>
     * <p>
     * See also .
     * </p>
     * <p>
     * This action is enabled only for admin access and requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminLinkProviderForUserRequest.Builder} avoiding
     * the need to create one manually via {@link AdminLinkProviderForUserRequest#builder()}
     * </p>
     *
     * @param adminLinkProviderForUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminLinkProviderForUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AdminLinkProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminLinkProviderForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminLinkProviderForUserResponse> adminLinkProviderForUser(
            Consumer<AdminLinkProviderForUserRequest.Builder> adminLinkProviderForUserRequest) {
        return adminLinkProviderForUser(AdminLinkProviderForUserRequest.builder().applyMutation(adminLinkProviderForUserRequest)
                .build());
    }

    /**
     * <p>
     * Lists devices, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminListDevicesRequest
     *        Represents the request to list devices, as an administrator.
     * @return A Java Future containing the result of the AdminListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminListDevicesResponse> adminListDevices(AdminListDevicesRequest adminListDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists devices, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link AdminListDevicesRequest#builder()}
     * </p>
     *
     * @param adminListDevicesRequest
     *        A {@link Consumer} that will call methods on {@link AdminListDevicesRequest.Builder} to create a request.
     *        Represents the request to list devices, as an administrator.
     * @return A Java Future containing the result of the AdminListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminListDevicesResponse> adminListDevices(
            Consumer<AdminListDevicesRequest.Builder> adminListDevicesRequest) {
        return adminListDevices(AdminListDevicesRequest.builder().applyMutation(adminListDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the groups that the user belongs to.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminListGroupsForUserRequest
     * @return A Java Future containing the result of the AdminListGroupsForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListGroupsForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminListGroupsForUserResponse> adminListGroupsForUser(
            AdminListGroupsForUserRequest adminListGroupsForUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the groups that the user belongs to.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListGroupsForUserRequest.Builder} avoiding the
     * need to create one manually via {@link AdminListGroupsForUserRequest#builder()}
     * </p>
     *
     * @param adminListGroupsForUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminListGroupsForUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AdminListGroupsForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListGroupsForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminListGroupsForUserResponse> adminListGroupsForUser(
            Consumer<AdminListGroupsForUserRequest.Builder> adminListGroupsForUserRequest) {
        return adminListGroupsForUser(AdminListGroupsForUserRequest.builder().applyMutation(adminListGroupsForUserRequest)
                .build());
    }

    /**
     * <p>
     * Lists a history of user activity and any risks detected as part of Amazon Cognito advanced security.
     * </p>
     *
     * @param adminListUserAuthEventsRequest
     * @return A Java Future containing the result of the AdminListUserAuthEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons are not enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListUserAuthEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminListUserAuthEventsResponse> adminListUserAuthEvents(
            AdminListUserAuthEventsRequest adminListUserAuthEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists a history of user activity and any risks detected as part of Amazon Cognito advanced security.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListUserAuthEventsRequest.Builder} avoiding
     * the need to create one manually via {@link AdminListUserAuthEventsRequest#builder()}
     * </p>
     *
     * @param adminListUserAuthEventsRequest
     *        A {@link Consumer} that will call methods on {@link AdminListUserAuthEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AdminListUserAuthEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons are not enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListUserAuthEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminListUserAuthEventsResponse> adminListUserAuthEvents(
            Consumer<AdminListUserAuthEventsRequest.Builder> adminListUserAuthEventsRequest) {
        return adminListUserAuthEvents(AdminListUserAuthEventsRequest.builder().applyMutation(adminListUserAuthEventsRequest)
                .build());
    }

    /**
     * <p>
     * Removes the specified user from the specified group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminRemoveUserFromGroupRequest
     * @return A Java Future containing the result of the AdminRemoveUserFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRemoveUserFromGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminRemoveUserFromGroupResponse> adminRemoveUserFromGroup(
            AdminRemoveUserFromGroupRequest adminRemoveUserFromGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified user from the specified group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminRemoveUserFromGroupRequest.Builder} avoiding
     * the need to create one manually via {@link AdminRemoveUserFromGroupRequest#builder()}
     * </p>
     *
     * @param adminRemoveUserFromGroupRequest
     *        A {@link Consumer} that will call methods on {@link AdminRemoveUserFromGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AdminRemoveUserFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRemoveUserFromGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminRemoveUserFromGroupResponse> adminRemoveUserFromGroup(
            Consumer<AdminRemoveUserFromGroupRequest.Builder> adminRemoveUserFromGroupRequest) {
        return adminRemoveUserFromGroup(AdminRemoveUserFromGroupRequest.builder().applyMutation(adminRemoveUserFromGroupRequest)
                .build());
    }

    /**
     * <p>
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to
     * sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should
     * direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition,
     * if the user pool has phone verification selected and a verified phone number exists for the user, or if email
     * verification is selected and a verified email exists for the user, calling this API will also result in sending a
     * message to the end user with the code to change their password.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminResetUserPasswordRequest
     *        Represents the request to reset a user's password as an administrator.
     * @return A Java Future containing the result of the AdminResetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminResetUserPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminResetUserPasswordResponse> adminResetUserPassword(
            AdminResetUserPasswordRequest adminResetUserPasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to
     * sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should
     * direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition,
     * if the user pool has phone verification selected and a verified phone number exists for the user, or if email
     * verification is selected and a verified email exists for the user, calling this API will also result in sending a
     * message to the end user with the code to change their password.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminResetUserPasswordRequest.Builder} avoiding the
     * need to create one manually via {@link AdminResetUserPasswordRequest#builder()}
     * </p>
     *
     * @param adminResetUserPasswordRequest
     *        A {@link Consumer} that will call methods on {@link AdminResetUserPasswordRequest.Builder} to create a
     *        request. Represents the request to reset a user's password as an administrator.
     * @return A Java Future containing the result of the AdminResetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminResetUserPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminResetUserPasswordResponse> adminResetUserPassword(
            Consumer<AdminResetUserPasswordRequest.Builder> adminResetUserPasswordRequest) {
        return adminResetUserPassword(AdminResetUserPasswordRequest.builder().applyMutation(adminResetUserPasswordRequest)
                .build());
    }

    /**
     * <p>
     * Responds to an authentication challenge, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminRespondToAuthChallengeRequest
     *        The request to respond to the authentication challenge, as an administrator.
     * @return A Java Future containing the result of the AdminRespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito cannot find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token TOTP multi-factor
     *         authentication (MFA) is not enabled for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRespondToAuthChallenge
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminRespondToAuthChallengeResponse> adminRespondToAuthChallenge(
            AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Responds to an authentication challenge, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminRespondToAuthChallengeRequest.Builder}
     * avoiding the need to create one manually via {@link AdminRespondToAuthChallengeRequest#builder()}
     * </p>
     *
     * @param adminRespondToAuthChallengeRequest
     *        A {@link Consumer} that will call methods on {@link AdminRespondToAuthChallengeRequest.Builder} to create
     *        a request. The request to respond to the authentication challenge, as an administrator.
     * @return A Java Future containing the result of the AdminRespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito cannot find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token TOTP multi-factor
     *         authentication (MFA) is not enabled for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRespondToAuthChallenge
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminRespondToAuthChallengeResponse> adminRespondToAuthChallenge(
            Consumer<AdminRespondToAuthChallengeRequest.Builder> adminRespondToAuthChallengeRequest) {
        return adminRespondToAuthChallenge(AdminRespondToAuthChallengeRequest.builder()
                .applyMutation(adminRespondToAuthChallengeRequest).build());
    }

    /**
     * <p>
     * Sets the user's multi-factor authentication (MFA) preference.
     * </p>
     *
     * @param adminSetUserMfaPreferenceRequest
     * @return A Java Future containing the result of the AdminSetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserMFAPreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminSetUserMfaPreferenceResponse> adminSetUserMFAPreference(
            AdminSetUserMfaPreferenceRequest adminSetUserMfaPreferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the user's multi-factor authentication (MFA) preference.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminSetUserMfaPreferenceRequest.Builder} avoiding
     * the need to create one manually via {@link AdminSetUserMfaPreferenceRequest#builder()}
     * </p>
     *
     * @param adminSetUserMfaPreferenceRequest
     *        A {@link Consumer} that will call methods on {@link AdminSetUserMFAPreferenceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AdminSetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserMFAPreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminSetUserMfaPreferenceResponse> adminSetUserMFAPreference(
            Consumer<AdminSetUserMfaPreferenceRequest.Builder> adminSetUserMfaPreferenceRequest) {
        return adminSetUserMFAPreference(AdminSetUserMfaPreferenceRequest.builder()
                .applyMutation(adminSetUserMfaPreferenceRequest).build());
    }

    /**
     * <p>
     * Sets all the user settings for a specified user name. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminSetUserSettingsRequest
     *        Represents the request to set user settings as an administrator.
     * @return A Java Future containing the result of the AdminSetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminSetUserSettingsResponse> adminSetUserSettings(
            AdminSetUserSettingsRequest adminSetUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets all the user settings for a specified user name. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminSetUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link AdminSetUserSettingsRequest#builder()}
     * </p>
     *
     * @param adminSetUserSettingsRequest
     *        A {@link Consumer} that will call methods on {@link AdminSetUserSettingsRequest.Builder} to create a
     *        request. Represents the request to set user settings as an administrator.
     * @return A Java Future containing the result of the AdminSetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminSetUserSettingsResponse> adminSetUserSettings(
            Consumer<AdminSetUserSettingsRequest.Builder> adminSetUserSettingsRequest) {
        return adminSetUserSettings(AdminSetUserSettingsRequest.builder().applyMutation(adminSetUserSettingsRequest).build());
    }

    /**
     * <p>
     * Provides feedback for an authentication event as to whether it was from a valid user. This feedback is used for
     * improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     *
     * @param adminUpdateAuthEventFeedbackRequest
     * @return A Java Future containing the result of the AdminUpdateAuthEventFeedback operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons are not enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateAuthEventFeedback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateAuthEventFeedbackResponse> adminUpdateAuthEventFeedback(
            AdminUpdateAuthEventFeedbackRequest adminUpdateAuthEventFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides feedback for an authentication event as to whether it was from a valid user. This feedback is used for
     * improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUpdateAuthEventFeedbackRequest.Builder}
     * avoiding the need to create one manually via {@link AdminUpdateAuthEventFeedbackRequest#builder()}
     * </p>
     *
     * @param adminUpdateAuthEventFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link AdminUpdateAuthEventFeedbackRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AdminUpdateAuthEventFeedback operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons are not enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateAuthEventFeedback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateAuthEventFeedbackResponse> adminUpdateAuthEventFeedback(
            Consumer<AdminUpdateAuthEventFeedbackRequest.Builder> adminUpdateAuthEventFeedbackRequest) {
        return adminUpdateAuthEventFeedback(AdminUpdateAuthEventFeedbackRequest.builder()
                .applyMutation(adminUpdateAuthEventFeedbackRequest).build());
    }

    /**
     * <p>
     * Updates the device status as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminUpdateDeviceStatusRequest
     *        The request to update the device status, as an administrator.
     * @return A Java Future containing the result of the AdminUpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateDeviceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateDeviceStatusResponse> adminUpdateDeviceStatus(
            AdminUpdateDeviceStatusRequest adminUpdateDeviceStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device status as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUpdateDeviceStatusRequest.Builder} avoiding
     * the need to create one manually via {@link AdminUpdateDeviceStatusRequest#builder()}
     * </p>
     *
     * @param adminUpdateDeviceStatusRequest
     *        A {@link Consumer} that will call methods on {@link AdminUpdateDeviceStatusRequest.Builder} to create a
     *        request. The request to update the device status, as an administrator.
     * @return A Java Future containing the result of the AdminUpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateDeviceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateDeviceStatusResponse> adminUpdateDeviceStatus(
            Consumer<AdminUpdateDeviceStatusRequest.Builder> adminUpdateDeviceStatusRequest) {
        return adminUpdateDeviceStatus(AdminUpdateDeviceStatusRequest.builder().applyMutation(adminUpdateDeviceStatusRequest)
                .build());
    }

    /**
     * <p>
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     * </p>
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * </p>
     * <p>
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminUpdateUserAttributesRequest
     *        Represents the request to update the user's attributes as an administrator.
     * @return A Java Future containing the result of the AdminUpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateUserAttributesResponse> adminUpdateUserAttributes(
            AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     * </p>
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * </p>
     * <p>
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUpdateUserAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link AdminUpdateUserAttributesRequest#builder()}
     * </p>
     *
     * @param adminUpdateUserAttributesRequest
     *        A {@link Consumer} that will call methods on {@link AdminUpdateUserAttributesRequest.Builder} to create a
     *        request. Represents the request to update the user's attributes as an administrator.
     * @return A Java Future containing the result of the AdminUpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateUserAttributesResponse> adminUpdateUserAttributes(
            Consumer<AdminUpdateUserAttributesRequest.Builder> adminUpdateUserAttributesRequest) {
        return adminUpdateUserAttributes(AdminUpdateUserAttributesRequest.builder()
                .applyMutation(adminUpdateUserAttributesRequest).build());
    }

    /**
     * <p>
     * Signs out users from all devices, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminUserGlobalSignOutRequest
     *        The request to sign out of all devices, as an administrator.
     * @return A Java Future containing the result of the AdminUserGlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUserGlobalSignOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUserGlobalSignOutResponse> adminUserGlobalSignOut(
            AdminUserGlobalSignOutRequest adminUserGlobalSignOutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Signs out users from all devices, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUserGlobalSignOutRequest.Builder} avoiding the
     * need to create one manually via {@link AdminUserGlobalSignOutRequest#builder()}
     * </p>
     *
     * @param adminUserGlobalSignOutRequest
     *        A {@link Consumer} that will call methods on {@link AdminUserGlobalSignOutRequest.Builder} to create a
     *        request. The request to sign out of all devices, as an administrator.
     * @return A Java Future containing the result of the AdminUserGlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUserGlobalSignOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUserGlobalSignOutResponse> adminUserGlobalSignOut(
            Consumer<AdminUserGlobalSignOutRequest.Builder> adminUserGlobalSignOutRequest) {
        return adminUserGlobalSignOut(AdminUserGlobalSignOutRequest.builder().applyMutation(adminUserGlobalSignOutRequest)
                .build());
    }

    /**
     * <p>
     * Returns a unique generated shared secret key code for the user account. The request takes an access token or a
     * session string, but not both.
     * </p>
     *
     * @param associateSoftwareTokenRequest
     * @return A Java Future containing the result of the AssociateSoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token TOTP multi-factor
     *         authentication (MFA) is not enabled for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AssociateSoftwareToken
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSoftwareTokenResponse> associateSoftwareToken(
            AssociateSoftwareTokenRequest associateSoftwareTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a unique generated shared secret key code for the user account. The request takes an access token or a
     * session string, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSoftwareTokenRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateSoftwareTokenRequest#builder()}
     * </p>
     *
     * @param associateSoftwareTokenRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSoftwareTokenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateSoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token TOTP multi-factor
     *         authentication (MFA) is not enabled for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AssociateSoftwareToken
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSoftwareTokenResponse> associateSoftwareToken(
            Consumer<AssociateSoftwareTokenRequest.Builder> associateSoftwareTokenRequest) {
        return associateSoftwareToken(AssociateSoftwareTokenRequest.builder().applyMutation(associateSoftwareTokenRequest)
                .build());
    }

    /**
     * <p>
     * Changes the password for a specified user in a user pool.
     * </p>
     *
     * @param changePasswordRequest
     *        Represents the request to change a user password.
     * @return A Java Future containing the result of the ChangePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ChangePassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ChangePasswordResponse> changePassword(ChangePasswordRequest changePasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the password for a specified user in a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangePasswordRequest.Builder} avoiding the need to
     * create one manually via {@link ChangePasswordRequest#builder()}
     * </p>
     *
     * @param changePasswordRequest
     *        A {@link Consumer} that will call methods on {@link ChangePasswordRequest.Builder} to create a request.
     *        Represents the request to change a user password.
     * @return A Java Future containing the result of the ChangePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ChangePassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ChangePasswordResponse> changePassword(Consumer<ChangePasswordRequest.Builder> changePasswordRequest) {
        return changePassword(ChangePasswordRequest.builder().applyMutation(changePasswordRequest).build());
    }

    /**
     * <p>
     * Confirms tracking of the device. This API call is the call that begins device tracking.
     * </p>
     *
     * @param confirmDeviceRequest
     *        Confirms the device request.
     * @return A Java Future containing the result of the ConfirmDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConfirmDeviceResponse> confirmDevice(ConfirmDeviceRequest confirmDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms tracking of the device. This API call is the call that begins device tracking.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link ConfirmDeviceRequest#builder()}
     * </p>
     *
     * @param confirmDeviceRequest
     *        A {@link Consumer} that will call methods on {@link ConfirmDeviceRequest.Builder} to create a request.
     *        Confirms the device request.
     * @return A Java Future containing the result of the ConfirmDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConfirmDeviceResponse> confirmDevice(Consumer<ConfirmDeviceRequest.Builder> confirmDeviceRequest) {
        return confirmDevice(ConfirmDeviceRequest.builder().applyMutation(confirmDeviceRequest).build());
    }

    /**
     * <p>
     * Allows a user to enter a confirmation code to reset a forgotten password.
     * </p>
     *
     * @param confirmForgotPasswordRequest
     *        The request representing the confirmation for a password reset.
     * @return A Java Future containing the result of the ConfirmForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action (e.g., sign in).</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmForgotPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConfirmForgotPasswordResponse> confirmForgotPassword(
            ConfirmForgotPasswordRequest confirmForgotPasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a user to enter a confirmation code to reset a forgotten password.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmForgotPasswordRequest.Builder} avoiding the
     * need to create one manually via {@link ConfirmForgotPasswordRequest#builder()}
     * </p>
     *
     * @param confirmForgotPasswordRequest
     *        A {@link Consumer} that will call methods on {@link ConfirmForgotPasswordRequest.Builder} to create a
     *        request. The request representing the confirmation for a password reset.
     * @return A Java Future containing the result of the ConfirmForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action (e.g., sign in).</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmForgotPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConfirmForgotPasswordResponse> confirmForgotPassword(
            Consumer<ConfirmForgotPasswordRequest.Builder> confirmForgotPasswordRequest) {
        return confirmForgotPassword(ConfirmForgotPasswordRequest.builder().applyMutation(confirmForgotPasswordRequest).build());
    }

    /**
     * <p>
     * Confirms registration of a user and handles the existing alias from a previous user.
     * </p>
     *
     * @param confirmSignUpRequest
     *        Represents the request to confirm registration of a user.
     * @return A Java Future containing the result of the ConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action (e.g., sign in).</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmSignUp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConfirmSignUpResponse> confirmSignUp(ConfirmSignUpRequest confirmSignUpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms registration of a user and handles the existing alias from a previous user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmSignUpRequest.Builder} avoiding the need to
     * create one manually via {@link ConfirmSignUpRequest#builder()}
     * </p>
     *
     * @param confirmSignUpRequest
     *        A {@link Consumer} that will call methods on {@link ConfirmSignUpRequest.Builder} to create a request.
     *        Represents the request to confirm registration of a user.
     * @return A Java Future containing the result of the ConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action (e.g., sign in).</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmSignUp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConfirmSignUpResponse> confirmSignUp(Consumer<ConfirmSignUpRequest.Builder> confirmSignUpRequest) {
        return confirmSignUp(ConfirmSignUpRequest.builder().applyMutation(confirmSignUpRequest).build());
    }

    /**
     * <p>
     * Creates a new group in the specified user pool.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>GroupExistsException This exception is thrown when Amazon Cognito encounters a group that already
     *         exists in the user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new group in the specified user pool.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>GroupExistsException This exception is thrown when Amazon Cognito encounters a group that already
     *         exists in the user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Creates an identity provider for a user pool.
     * </p>
     *
     * @param createIdentityProviderRequest
     * @return A Java Future containing the result of the CreateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>DuplicateProviderException This exception is thrown when the provider is already supported by the
     *         user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(
            CreateIdentityProviderRequest createIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an identity provider for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIdentityProviderRequest#builder()}
     * </p>
     *
     * @param createIdentityProviderRequest
     *        A {@link Consumer} that will call methods on {@link CreateIdentityProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>DuplicateProviderException This exception is thrown when the provider is already supported by the
     *         user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(
            Consumer<CreateIdentityProviderRequest.Builder> createIdentityProviderRequest) {
        return createIdentityProvider(CreateIdentityProviderRequest.builder().applyMutation(createIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new OAuth2.0 resource server and defines custom scopes in it.
     * </p>
     *
     * @param createResourceServerRequest
     * @return A Java Future containing the result of the CreateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceServerResponse> createResourceServer(
            CreateResourceServerRequest createResourceServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new OAuth2.0 resource server and defines custom scopes in it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceServerRequest#builder()}
     * </p>
     *
     * @param createResourceServerRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceServerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceServerResponse> createResourceServer(
            Consumer<CreateResourceServerRequest.Builder> createResourceServerRequest) {
        return createResourceServer(CreateResourceServerRequest.builder().applyMutation(createResourceServerRequest).build());
    }

    /**
     * <p>
     * Creates the user import job.
     * </p>
     *
     * @param createUserImportJobRequest
     *        Represents the request to create the user import job.
     * @return A Java Future containing the result of the CreateUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserImportJobResponse> createUserImportJob(
            CreateUserImportJobRequest createUserImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserImportJobRequest#builder()}
     * </p>
     *
     * @param createUserImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserImportJobRequest.Builder} to create a
     *        request. Represents the request to create the user import job.
     * @return A Java Future containing the result of the CreateUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserImportJobResponse> createUserImportJob(
            Consumer<CreateUserImportJobRequest.Builder> createUserImportJobRequest) {
        return createUserImportJob(CreateUserImportJobRequest.builder().applyMutation(createUserImportJobRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     * </p>
     *
     * @param createUserPoolRequest
     *        Represents the request to create a user pool.
     * @return A Java Future containing the result of the CreateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag cannot be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserPoolResponse> createUserPool(CreateUserPoolRequest createUserPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserPoolRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserPoolRequest#builder()}
     * </p>
     *
     * @param createUserPoolRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserPoolRequest.Builder} to create a request.
     *        Represents the request to create a user pool.
     * @return A Java Future containing the result of the CreateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag cannot be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserPoolResponse> createUserPool(Consumer<CreateUserPoolRequest.Builder> createUserPoolRequest) {
        return createUserPool(CreateUserPoolRequest.builder().applyMutation(createUserPoolRequest).build());
    }

    /**
     * <p>
     * Creates the user pool client.
     * </p>
     *
     * @param createUserPoolClientRequest
     *        Represents the request to create a user pool client.
     * @return A Java Future containing the result of the CreateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope does not exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is invalid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserPoolClientResponse> createUserPoolClient(
            CreateUserPoolClientRequest createUserPoolClientRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the user pool client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserPoolClientRequest#builder()}
     * </p>
     *
     * @param createUserPoolClientRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserPoolClientRequest.Builder} to create a
     *        request. Represents the request to create a user pool client.
     * @return A Java Future containing the result of the CreateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope does not exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is invalid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserPoolClientResponse> createUserPoolClient(
            Consumer<CreateUserPoolClientRequest.Builder> createUserPoolClientRequest) {
        return createUserPoolClient(CreateUserPoolClientRequest.builder().applyMutation(createUserPoolClientRequest).build());
    }

    /**
     * <p>
     * Creates a new domain for a user pool.
     * </p>
     *
     * @param createUserPoolDomainRequest
     * @return A Java Future containing the result of the CreateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserPoolDomainResponse> createUserPoolDomain(
            CreateUserPoolDomainRequest createUserPoolDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new domain for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param createUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserPoolDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserPoolDomainResponse> createUserPoolDomain(
            Consumer<CreateUserPoolDomainRequest.Builder> createUserPoolDomainRequest) {
        return createUserPoolDomain(CreateUserPoolDomainRequest.builder().applyMutation(createUserPoolDomainRequest).build());
    }

    /**
     * <p>
     * Deletes a group. Currently only groups with no members can be deleted.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group. Currently only groups with no members can be deleted.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an identity provider for a user pool.
     * </p>
     *
     * @param deleteIdentityProviderRequest
     * @return A Java Future containing the result of the DeleteIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier is not
     *         supported.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(
            DeleteIdentityProviderRequest deleteIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an identity provider for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIdentityProviderRequest#builder()}
     * </p>
     *
     * @param deleteIdentityProviderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIdentityProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier is not
     *         supported.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(
            Consumer<DeleteIdentityProviderRequest.Builder> deleteIdentityProviderRequest) {
        return deleteIdentityProvider(DeleteIdentityProviderRequest.builder().applyMutation(deleteIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a resource server.
     * </p>
     *
     * @param deleteResourceServerRequest
     * @return A Java Future containing the result of the DeleteResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceServerResponse> deleteResourceServer(
            DeleteResourceServerRequest deleteResourceServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceServerRequest#builder()}
     * </p>
     *
     * @param deleteResourceServerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceServerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceServerResponse> deleteResourceServer(
            Consumer<DeleteResourceServerRequest.Builder> deleteResourceServerRequest) {
        return deleteResourceServer(DeleteResourceServerRequest.builder().applyMutation(deleteResourceServerRequest).build());
    }

    /**
     * <p>
     * Allows a user to delete himself or herself.
     * </p>
     *
     * @param deleteUserRequest
     *        Represents the request to delete a user.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a user to delete himself or herself.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     *        Represents the request to delete a user.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes the attributes for a user.
     * </p>
     *
     * @param deleteUserAttributesRequest
     *        Represents the request to delete user attributes.
     * @return A Java Future containing the result of the DeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserAttributesResponse> deleteUserAttributes(
            DeleteUserAttributesRequest deleteUserAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the attributes for a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserAttributesRequest#builder()}
     * </p>
     *
     * @param deleteUserAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserAttributesRequest.Builder} to create a
     *        request. Represents the request to delete user attributes.
     * @return A Java Future containing the result of the DeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserAttributesResponse> deleteUserAttributes(
            Consumer<DeleteUserAttributesRequest.Builder> deleteUserAttributesRequest) {
        return deleteUserAttributes(DeleteUserAttributesRequest.builder().applyMutation(deleteUserAttributesRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon Cognito user pool.
     * </p>
     *
     * @param deleteUserPoolRequest
     *        Represents the request to delete a user pool.
     * @return A Java Future containing the result of the DeleteUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you are trying to modify a user pool
     *         while a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolResponse> deleteUserPool(DeleteUserPoolRequest deleteUserPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon Cognito user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserPoolRequest#builder()}
     * </p>
     *
     * @param deleteUserPoolRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserPoolRequest.Builder} to create a request.
     *        Represents the request to delete a user pool.
     * @return A Java Future containing the result of the DeleteUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you are trying to modify a user pool
     *         while a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolResponse> deleteUserPool(Consumer<DeleteUserPoolRequest.Builder> deleteUserPoolRequest) {
        return deleteUserPool(DeleteUserPoolRequest.builder().applyMutation(deleteUserPoolRequest).build());
    }

    /**
     * <p>
     * Allows the developer to delete the user pool client.
     * </p>
     *
     * @param deleteUserPoolClientRequest
     *        Represents the request to delete a user pool client.
     * @return A Java Future containing the result of the DeleteUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolClientResponse> deleteUserPoolClient(
            DeleteUserPoolClientRequest deleteUserPoolClientRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the developer to delete the user pool client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserPoolClientRequest#builder()}
     * </p>
     *
     * @param deleteUserPoolClientRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserPoolClientRequest.Builder} to create a
     *        request. Represents the request to delete a user pool client.
     * @return A Java Future containing the result of the DeleteUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolClientResponse> deleteUserPoolClient(
            Consumer<DeleteUserPoolClientRequest.Builder> deleteUserPoolClientRequest) {
        return deleteUserPoolClient(DeleteUserPoolClientRequest.builder().applyMutation(deleteUserPoolClientRequest).build());
    }

    /**
     * <p>
     * Deletes a domain for a user pool.
     * </p>
     *
     * @param deleteUserPoolDomainRequest
     * @return A Java Future containing the result of the DeleteUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolDomainResponse> deleteUserPoolDomain(
            DeleteUserPoolDomainRequest deleteUserPoolDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a domain for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param deleteUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserPoolDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolDomainResponse> deleteUserPoolDomain(
            Consumer<DeleteUserPoolDomainRequest.Builder> deleteUserPoolDomainRequest) {
        return deleteUserPoolDomain(DeleteUserPoolDomainRequest.builder().applyMutation(deleteUserPoolDomainRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific identity provider.
     * </p>
     *
     * @param describeIdentityProviderRequest
     * @return A Java Future containing the result of the DescribeIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityProviderResponse> describeIdentityProvider(
            DescribeIdentityProviderRequest describeIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIdentityProviderRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeIdentityProviderRequest#builder()}
     * </p>
     *
     * @param describeIdentityProviderRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIdentityProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityProviderResponse> describeIdentityProvider(
            Consumer<DescribeIdentityProviderRequest.Builder> describeIdentityProviderRequest) {
        return describeIdentityProvider(DescribeIdentityProviderRequest.builder().applyMutation(describeIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Describes a resource server.
     * </p>
     *
     * @param describeResourceServerRequest
     * @return A Java Future containing the result of the DescribeResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourceServerResponse> describeResourceServer(
            DescribeResourceServerRequest describeResourceServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a resource server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourceServerRequest#builder()}
     * </p>
     *
     * @param describeResourceServerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResourceServerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourceServerResponse> describeResourceServer(
            Consumer<DescribeResourceServerRequest.Builder> describeResourceServerRequest) {
        return describeResourceServer(DescribeResourceServerRequest.builder().applyMutation(describeResourceServerRequest)
                .build());
    }

    /**
     * <p>
     * Describes the risk configuration.
     * </p>
     *
     * @param describeRiskConfigurationRequest
     * @return A Java Future containing the result of the DescribeRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons are not enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeRiskConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRiskConfigurationResponse> describeRiskConfiguration(
            DescribeRiskConfigurationRequest describeRiskConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the risk configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRiskConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRiskConfigurationRequest#builder()}
     * </p>
     *
     * @param describeRiskConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRiskConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons are not enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeRiskConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRiskConfigurationResponse> describeRiskConfiguration(
            Consumer<DescribeRiskConfigurationRequest.Builder> describeRiskConfigurationRequest) {
        return describeRiskConfiguration(DescribeRiskConfigurationRequest.builder()
                .applyMutation(describeRiskConfigurationRequest).build());
    }

    /**
     * <p>
     * Describes the user import job.
     * </p>
     *
     * @param describeUserImportJobRequest
     *        Represents the request to describe the user import job.
     * @return A Java Future containing the result of the DescribeUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserImportJobResponse> describeUserImportJob(
            DescribeUserImportJobRequest describeUserImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserImportJobRequest#builder()}
     * </p>
     *
     * @param describeUserImportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserImportJobRequest.Builder} to create a
     *        request. Represents the request to describe the user import job.
     * @return A Java Future containing the result of the DescribeUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserImportJobResponse> describeUserImportJob(
            Consumer<DescribeUserImportJobRequest.Builder> describeUserImportJobRequest) {
        return describeUserImportJob(DescribeUserImportJobRequest.builder().applyMutation(describeUserImportJobRequest).build());
    }

    /**
     * <p>
     * Returns the configuration information and metadata of the specified user pool.
     * </p>
     *
     * @param describeUserPoolRequest
     *        Represents the request to describe the user pool.
     * @return A Java Future containing the result of the DescribeUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag cannot be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolResponse> describeUserPool(DescribeUserPoolRequest describeUserPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration information and metadata of the specified user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserPoolRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeUserPoolRequest#builder()}
     * </p>
     *
     * @param describeUserPoolRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserPoolRequest.Builder} to create a request.
     *        Represents the request to describe the user pool.
     * @return A Java Future containing the result of the DescribeUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag cannot be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolResponse> describeUserPool(
            Consumer<DescribeUserPoolRequest.Builder> describeUserPoolRequest) {
        return describeUserPool(DescribeUserPoolRequest.builder().applyMutation(describeUserPoolRequest).build());
    }

    /**
     * <p>
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     * </p>
     *
     * @param describeUserPoolClientRequest
     *        Represents the request to describe a user pool client.
     * @return A Java Future containing the result of the DescribeUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolClientResponse> describeUserPoolClient(
            DescribeUserPoolClientRequest describeUserPoolClientRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserPoolClientRequest#builder()}
     * </p>
     *
     * @param describeUserPoolClientRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserPoolClientRequest.Builder} to create a
     *        request. Represents the request to describe a user pool client.
     * @return A Java Future containing the result of the DescribeUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolClientResponse> describeUserPoolClient(
            Consumer<DescribeUserPoolClientRequest.Builder> describeUserPoolClientRequest) {
        return describeUserPoolClient(DescribeUserPoolClientRequest.builder().applyMutation(describeUserPoolClientRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a domain.
     * </p>
     *
     * @param describeUserPoolDomainRequest
     * @return A Java Future containing the result of the DescribeUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolDomainResponse> describeUserPoolDomain(
            DescribeUserPoolDomainRequest describeUserPoolDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param describeUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserPoolDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolDomainResponse> describeUserPoolDomain(
            Consumer<DescribeUserPoolDomainRequest.Builder> describeUserPoolDomainRequest) {
        return describeUserPoolDomain(DescribeUserPoolDomainRequest.builder().applyMutation(describeUserPoolDomainRequest)
                .build());
    }

    /**
     * <p>
     * Forgets the specified device.
     * </p>
     *
     * @param forgetDeviceRequest
     *        Represents the request to forget the device.
     * @return A Java Future containing the result of the ForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ForgetDeviceResponse> forgetDevice(ForgetDeviceRequest forgetDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forgets the specified device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ForgetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link ForgetDeviceRequest#builder()}
     * </p>
     *
     * @param forgetDeviceRequest
     *        A {@link Consumer} that will call methods on {@link ForgetDeviceRequest.Builder} to create a request.
     *        Represents the request to forget the device.
     * @return A Java Future containing the result of the ForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ForgetDeviceResponse> forgetDevice(Consumer<ForgetDeviceRequest.Builder> forgetDeviceRequest) {
        return forgetDevice(ForgetDeviceRequest.builder().applyMutation(forgetDeviceRequest).build());
    }

    /**
     * <p>
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change
     * the user's password. For the <code>Username</code> parameter, you can use the username or user alias. If a
     * verified phone number exists for the user, the confirmation code is sent to the phone number. Otherwise, if a
     * verified email exists, the confirmation code is sent to the email. If neither a verified phone number nor a
     * verified email exists, <code>InvalidParameterException</code> is thrown. To use the confirmation code for
     * resetting the password, call .
     * </p>
     *
     * @param forgotPasswordRequest
     *        Represents the request to reset a user's password.
     * @return A Java Future containing the result of the ForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgotPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ForgotPasswordResponse> forgotPassword(ForgotPasswordRequest forgotPasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change
     * the user's password. For the <code>Username</code> parameter, you can use the username or user alias. If a
     * verified phone number exists for the user, the confirmation code is sent to the phone number. Otherwise, if a
     * verified email exists, the confirmation code is sent to the email. If neither a verified phone number nor a
     * verified email exists, <code>InvalidParameterException</code> is thrown. To use the confirmation code for
     * resetting the password, call .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ForgotPasswordRequest.Builder} avoiding the need to
     * create one manually via {@link ForgotPasswordRequest#builder()}
     * </p>
     *
     * @param forgotPasswordRequest
     *        A {@link Consumer} that will call methods on {@link ForgotPasswordRequest.Builder} to create a request.
     *        Represents the request to reset a user's password.
     * @return A Java Future containing the result of the ForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgotPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ForgotPasswordResponse> forgotPassword(Consumer<ForgotPasswordRequest.Builder> forgotPasswordRequest) {
        return forgotPassword(ForgotPasswordRequest.builder().applyMutation(forgotPasswordRequest).build());
    }

    /**
     * <p>
     * Gets the header information for the .csv file to be used as input for the user import job.
     * </p>
     *
     * @param getCsvHeaderRequest
     *        Represents the request to get the header information for the .csv file for the user import job.
     * @return A Java Future containing the result of the GetCSVHeader operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetCSVHeader
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCsvHeaderResponse> getCSVHeader(GetCsvHeaderRequest getCsvHeaderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the header information for the .csv file to be used as input for the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCsvHeaderRequest.Builder} avoiding the need to
     * create one manually via {@link GetCsvHeaderRequest#builder()}
     * </p>
     *
     * @param getCsvHeaderRequest
     *        A {@link Consumer} that will call methods on {@link GetCSVHeaderRequest.Builder} to create a request.
     *        Represents the request to get the header information for the .csv file for the user import job.
     * @return A Java Future containing the result of the GetCSVHeader operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetCSVHeader
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCsvHeaderResponse> getCSVHeader(Consumer<GetCsvHeaderRequest.Builder> getCsvHeaderRequest) {
        return getCSVHeader(GetCsvHeaderRequest.builder().applyMutation(getCsvHeaderRequest).build());
    }

    /**
     * <p>
     * Gets the device.
     * </p>
     *
     * @param getDeviceRequest
     *        Represents the request to get the device.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeviceResponse> getDevice(GetDeviceRequest getDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeviceRequest#builder()}
     * </p>
     *
     * @param getDeviceRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceRequest.Builder} to create a request.
     *        Represents the request to get the device.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeviceResponse> getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) {
        return getDevice(GetDeviceRequest.builder().applyMutation(getDeviceRequest).build());
    }

    /**
     * <p>
     * Gets a group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * Gets the specified identity provider.
     * </p>
     *
     * @param getIdentityProviderByIdentifierRequest
     * @return A Java Future containing the result of the GetIdentityProviderByIdentifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetIdentityProviderByIdentifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityProviderByIdentifierResponse> getIdentityProviderByIdentifier(
            GetIdentityProviderByIdentifierRequest getIdentityProviderByIdentifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityProviderByIdentifierRequest.Builder}
     * avoiding the need to create one manually via {@link GetIdentityProviderByIdentifierRequest#builder()}
     * </p>
     *
     * @param getIdentityProviderByIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityProviderByIdentifierRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetIdentityProviderByIdentifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetIdentityProviderByIdentifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityProviderByIdentifierResponse> getIdentityProviderByIdentifier(
            Consumer<GetIdentityProviderByIdentifierRequest.Builder> getIdentityProviderByIdentifierRequest) {
        return getIdentityProviderByIdentifier(GetIdentityProviderByIdentifierRequest.builder()
                .applyMutation(getIdentityProviderByIdentifierRequest).build());
    }

    /**
     * <p>
     * This method takes a user pool ID, and returns the signing certificate.
     * </p>
     *
     * @param getSigningCertificateRequest
     *        Request to get a signing certificate from Cognito.
     * @return A Java Future containing the result of the GetSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetSigningCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSigningCertificateResponse> getSigningCertificate(
            GetSigningCertificateRequest getSigningCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method takes a user pool ID, and returns the signing certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSigningCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link GetSigningCertificateRequest#builder()}
     * </p>
     *
     * @param getSigningCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GetSigningCertificateRequest.Builder} to create a
     *        request. Request to get a signing certificate from Cognito.
     * @return A Java Future containing the result of the GetSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetSigningCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSigningCertificateResponse> getSigningCertificate(
            Consumer<GetSigningCertificateRequest.Builder> getSigningCertificateRequest) {
        return getSigningCertificate(GetSigningCertificateRequest.builder().applyMutation(getSigningCertificateRequest).build());
    }

    /**
     * <p>
     * Gets the UI Customization information for a particular app client's app UI, if there is something set. If nothing
     * is set for the particular client, but there is an existing pool level customization (app <code>clientId</code>
     * will be <code>ALL</code>), then that is returned. If nothing is present, then an empty shape is returned.
     * </p>
     *
     * @param getUiCustomizationRequest
     * @return A Java Future containing the result of the GetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUICustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetUiCustomizationResponse> getUICustomization(GetUiCustomizationRequest getUiCustomizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the UI Customization information for a particular app client's app UI, if there is something set. If nothing
     * is set for the particular client, but there is an existing pool level customization (app <code>clientId</code>
     * will be <code>ALL</code>), then that is returned. If nothing is present, then an empty shape is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUiCustomizationRequest.Builder} avoiding the
     * need to create one manually via {@link GetUiCustomizationRequest#builder()}
     * </p>
     *
     * @param getUiCustomizationRequest
     *        A {@link Consumer} that will call methods on {@link GetUICustomizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUICustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetUiCustomizationResponse> getUICustomization(
            Consumer<GetUiCustomizationRequest.Builder> getUiCustomizationRequest) {
        return getUICustomization(GetUiCustomizationRequest.builder().applyMutation(getUiCustomizationRequest).build());
    }

    /**
     * <p>
     * Gets the user attributes and metadata for a user.
     * </p>
     *
     * @param getUserRequest
     *        Represents the request to get information about the user.
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the user attributes and metadata for a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserRequest.Builder} avoiding the need to create
     * one manually via {@link GetUserRequest#builder()}
     * </p>
     *
     * @param getUserRequest
     *        A {@link Consumer} that will call methods on {@link GetUserRequest.Builder} to create a request.
     *        Represents the request to get information about the user.
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser(Consumer<GetUserRequest.Builder> getUserRequest) {
        return getUser(GetUserRequest.builder().applyMutation(getUserRequest).build());
    }

    /**
     * <p>
     * Gets the user attribute verification code for the specified attribute name.
     * </p>
     *
     * @param getUserAttributeVerificationCodeRequest
     *        Represents the request to get user attribute verification.
     * @return A Java Future containing the result of the GetUserAttributeVerificationCode operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserAttributeVerificationCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserAttributeVerificationCodeResponse> getUserAttributeVerificationCode(
            GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the user attribute verification code for the specified attribute name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserAttributeVerificationCodeRequest.Builder}
     * avoiding the need to create one manually via {@link GetUserAttributeVerificationCodeRequest#builder()}
     * </p>
     *
     * @param getUserAttributeVerificationCodeRequest
     *        A {@link Consumer} that will call methods on {@link GetUserAttributeVerificationCodeRequest.Builder} to
     *        create a request. Represents the request to get user attribute verification.
     * @return A Java Future containing the result of the GetUserAttributeVerificationCode operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserAttributeVerificationCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserAttributeVerificationCodeResponse> getUserAttributeVerificationCode(
            Consumer<GetUserAttributeVerificationCodeRequest.Builder> getUserAttributeVerificationCodeRequest) {
        return getUserAttributeVerificationCode(GetUserAttributeVerificationCodeRequest.builder()
                .applyMutation(getUserAttributeVerificationCodeRequest).build());
    }

    /**
     * <p>
     * Gets the user pool multi-factor authentication (MFA) configuration.
     * </p>
     *
     * @param getUserPoolMfaConfigRequest
     * @return A Java Future containing the result of the GetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserPoolMfaConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserPoolMfaConfigResponse> getUserPoolMfaConfig(
            GetUserPoolMfaConfigRequest getUserPoolMfaConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the user pool multi-factor authentication (MFA) configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserPoolMfaConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetUserPoolMfaConfigRequest#builder()}
     * </p>
     *
     * @param getUserPoolMfaConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetUserPoolMfaConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserPoolMfaConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserPoolMfaConfigResponse> getUserPoolMfaConfig(
            Consumer<GetUserPoolMfaConfigRequest.Builder> getUserPoolMfaConfigRequest) {
        return getUserPoolMfaConfig(GetUserPoolMfaConfigRequest.builder().applyMutation(getUserPoolMfaConfigRequest).build());
    }

    /**
     * <p>
     * Signs out users from all devices.
     * </p>
     *
     * @param globalSignOutRequest
     *        Represents the request to sign out all devices.
     * @return A Java Future containing the result of the GlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GlobalSignOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GlobalSignOutResponse> globalSignOut(GlobalSignOutRequest globalSignOutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Signs out users from all devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GlobalSignOutRequest.Builder} avoiding the need to
     * create one manually via {@link GlobalSignOutRequest#builder()}
     * </p>
     *
     * @param globalSignOutRequest
     *        A {@link Consumer} that will call methods on {@link GlobalSignOutRequest.Builder} to create a request.
     *        Represents the request to sign out all devices.
     * @return A Java Future containing the result of the GlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GlobalSignOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GlobalSignOutResponse> globalSignOut(Consumer<GlobalSignOutRequest.Builder> globalSignOutRequest) {
        return globalSignOut(GlobalSignOutRequest.builder().applyMutation(globalSignOutRequest).build());
    }

    /**
     * <p>
     * Initiates the authentication flow.
     * </p>
     *
     * @param initiateAuthRequest
     *        Initiates the authentication request.
     * @return A Java Future containing the result of the InitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.InitiateAuth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitiateAuthResponse> initiateAuth(InitiateAuthRequest initiateAuthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the authentication flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateAuthRequest.Builder} avoiding the need to
     * create one manually via {@link InitiateAuthRequest#builder()}
     * </p>
     *
     * @param initiateAuthRequest
     *        A {@link Consumer} that will call methods on {@link InitiateAuthRequest.Builder} to create a request.
     *        Initiates the authentication request.
     * @return A Java Future containing the result of the InitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.InitiateAuth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitiateAuthResponse> initiateAuth(Consumer<InitiateAuthRequest.Builder> initiateAuthRequest) {
        return initiateAuth(InitiateAuthRequest.builder().applyMutation(initiateAuthRequest).build());
    }

    /**
     * <p>
     * Lists the devices.
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the request to list the devices.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesRequest.Builder} to create a request.
     *        Represents the request to list the devices.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the groups associated with a user pool.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the groups associated with a user pool.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists information about all identity providers for a user pool.
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListIdentityProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about all identity providers for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentityProvidersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListIdentityProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) {
        return listIdentityProviders(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest).build());
    }

    /**
     * <p>
     * Lists the resource servers for a user pool.
     * </p>
     *
     * @param listResourceServersRequest
     * @return A Java Future containing the result of the ListResourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListResourceServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceServersResponse> listResourceServers(
            ListResourceServersRequest listResourceServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource servers for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceServersRequest#builder()}
     * </p>
     *
     * @param listResourceServersRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceServersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListResourceServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceServersResponse> listResourceServers(
            Consumer<ListResourceServersRequest.Builder> listResourceServersRequest) {
        return listResourceServers(ListResourceServersRequest.builder().applyMutation(listResourceServersRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     * </p>
     * <p>
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * You can use this action up to 10 times per second, per account.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     * </p>
     * <p>
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * You can use this action up to 10 times per second, per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the user import jobs.
     * </p>
     *
     * @param listUserImportJobsRequest
     *        Represents the request to list the user import jobs.
     * @return A Java Future containing the result of the ListUserImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListUserImportJobsResponse> listUserImportJobs(ListUserImportJobsRequest listUserImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the user import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserImportJobsRequest#builder()}
     * </p>
     *
     * @param listUserImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserImportJobsRequest.Builder} to create a
     *        request. Represents the request to list the user import jobs.
     * @return A Java Future containing the result of the ListUserImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListUserImportJobsResponse> listUserImportJobs(
            Consumer<ListUserImportJobsRequest.Builder> listUserImportJobsRequest) {
        return listUserImportJobs(ListUserImportJobsRequest.builder().applyMutation(listUserImportJobsRequest).build());
    }

    /**
     * <p>
     * Lists the clients that have been created for the specified user pool.
     * </p>
     *
     * @param listUserPoolClientsRequest
     *        Represents the request to list the user pool clients.
     * @return A Java Future containing the result of the ListUserPoolClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPoolClients
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserPoolClientsResponse> listUserPoolClients(
            ListUserPoolClientsRequest listUserPoolClientsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the clients that have been created for the specified user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoolClientsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserPoolClientsRequest#builder()}
     * </p>
     *
     * @param listUserPoolClientsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserPoolClientsRequest.Builder} to create a
     *        request. Represents the request to list the user pool clients.
     * @return A Java Future containing the result of the ListUserPoolClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPoolClients
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserPoolClientsResponse> listUserPoolClients(
            Consumer<ListUserPoolClientsRequest.Builder> listUserPoolClientsRequest) {
        return listUserPoolClients(ListUserPoolClientsRequest.builder().applyMutation(listUserPoolClientsRequest).build());
    }

    /**
     * <p>
     * Lists the user pools associated with an AWS account.
     * </p>
     *
     * @param listUserPoolsRequest
     *        Represents the request to list user pools.
     * @return A Java Future containing the result of the ListUserPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUserPoolsResponse> listUserPools(ListUserPoolsRequest listUserPoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the user pools associated with an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoolsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserPoolsRequest#builder()}
     * </p>
     *
     * @param listUserPoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserPoolsRequest.Builder} to create a request.
     *        Represents the request to list user pools.
     * @return A Java Future containing the result of the ListUserPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUserPoolsResponse> listUserPools(Consumer<ListUserPoolsRequest.Builder> listUserPoolsRequest) {
        return listUserPools(ListUserPoolsRequest.builder().applyMutation(listUserPoolsRequest).build());
    }

    /**
     * <p>
     * Lists the users in the Amazon Cognito user pool.
     * </p>
     *
     * @param listUsersRequest
     *        Represents the request to list users.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users in the Amazon Cognito user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     *        Represents the request to list users.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists the users in the specified group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param listUsersInGroupRequest
     * @return A Java Future containing the result of the ListUsersInGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsersInGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListUsersInGroupResponse> listUsersInGroup(ListUsersInGroupRequest listUsersInGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users in the specified group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersInGroupRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsersInGroupRequest#builder()}
     * </p>
     *
     * @param listUsersInGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersInGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUsersInGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsersInGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListUsersInGroupResponse> listUsersInGroup(
            Consumer<ListUsersInGroupRequest.Builder> listUsersInGroupRequest) {
        return listUsersInGroup(ListUsersInGroupRequest.builder().applyMutation(listUsersInGroupRequest).build());
    }

    /**
     * <p>
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     * </p>
     *
     * @param resendConfirmationCodeRequest
     *        Represents the request to resend the confirmation code.
     * @return A Java Future containing the result of the ResendConfirmationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ResendConfirmationCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResendConfirmationCodeResponse> resendConfirmationCode(
            ResendConfirmationCodeRequest resendConfirmationCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResendConfirmationCodeRequest.Builder} avoiding the
     * need to create one manually via {@link ResendConfirmationCodeRequest#builder()}
     * </p>
     *
     * @param resendConfirmationCodeRequest
     *        A {@link Consumer} that will call methods on {@link ResendConfirmationCodeRequest.Builder} to create a
     *        request. Represents the request to resend the confirmation code.
     * @return A Java Future containing the result of the ResendConfirmationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ResendConfirmationCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResendConfirmationCodeResponse> resendConfirmationCode(
            Consumer<ResendConfirmationCodeRequest.Builder> resendConfirmationCodeRequest) {
        return resendConfirmationCode(ResendConfirmationCodeRequest.builder().applyMutation(resendConfirmationCodeRequest)
                .build());
    }

    /**
     * <p>
     * Responds to the authentication challenge.
     * </p>
     *
     * @param respondToAuthChallengeRequest
     *        The request to respond to an authentication challenge.
     * @return A Java Future containing the result of the RespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito cannot find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token TOTP multi-factor
     *         authentication (MFA) is not enabled for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RespondToAuthChallenge
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RespondToAuthChallengeResponse> respondToAuthChallenge(
            RespondToAuthChallengeRequest respondToAuthChallengeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Responds to the authentication challenge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RespondToAuthChallengeRequest.Builder} avoiding the
     * need to create one manually via {@link RespondToAuthChallengeRequest#builder()}
     * </p>
     *
     * @param respondToAuthChallengeRequest
     *        A {@link Consumer} that will call methods on {@link RespondToAuthChallengeRequest.Builder} to create a
     *        request. The request to respond to an authentication challenge.
     * @return A Java Future containing the result of the RespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito cannot find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token TOTP multi-factor
     *         authentication (MFA) is not enabled for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RespondToAuthChallenge
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RespondToAuthChallengeResponse> respondToAuthChallenge(
            Consumer<RespondToAuthChallengeRequest.Builder> respondToAuthChallengeRequest) {
        return respondToAuthChallenge(RespondToAuthChallengeRequest.builder().applyMutation(respondToAuthChallengeRequest)
                .build());
    }

    /**
     * <p>
     * Configures actions on detected risks. To delete the risk configuration for <code>UserPoolId</code> or
     * <code>ClientId</code>, pass null values for all four configuration types.
     * </p>
     * <p>
     * To enable Amazon Cognito advanced security features, update the user pool to include the
     * <code>UserPoolAddOns</code> key<code>AdvancedSecurityMode</code>.
     * </p>
     * <p>
     * See .
     * </p>
     *
     * @param setRiskConfigurationRequest
     * @return A Java Future containing the result of the SetRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons are not enabled.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetRiskConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetRiskConfigurationResponse> setRiskConfiguration(
            SetRiskConfigurationRequest setRiskConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures actions on detected risks. To delete the risk configuration for <code>UserPoolId</code> or
     * <code>ClientId</code>, pass null values for all four configuration types.
     * </p>
     * <p>
     * To enable Amazon Cognito advanced security features, update the user pool to include the
     * <code>UserPoolAddOns</code> key<code>AdvancedSecurityMode</code>.
     * </p>
     * <p>
     * See .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetRiskConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link SetRiskConfigurationRequest#builder()}
     * </p>
     *
     * @param setRiskConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link SetRiskConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons are not enabled.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetRiskConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetRiskConfigurationResponse> setRiskConfiguration(
            Consumer<SetRiskConfigurationRequest.Builder> setRiskConfigurationRequest) {
        return setRiskConfiguration(SetRiskConfigurationRequest.builder().applyMutation(setRiskConfigurationRequest).build());
    }

    /**
     * <p>
     * Sets the UI customization information for a user pool's built-in app UI.
     * </p>
     * <p>
     * You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for
     * all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the
     * default configuration will be used for every client that has no UI customization set previously. If you specify
     * UI customization settings for a particular client, it will no longer fall back to the <code>ALL</code>
     * configuration.
     * </p>
     * <note>
     * <p>
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the
     * app's pages, and the service will throw an error.
     * </p>
     * </note>
     *
     * @param setUiCustomizationRequest
     * @return A Java Future containing the result of the SetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUICustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetUiCustomizationResponse> setUICustomization(SetUiCustomizationRequest setUiCustomizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the UI customization information for a user pool's built-in app UI.
     * </p>
     * <p>
     * You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for
     * all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the
     * default configuration will be used for every client that has no UI customization set previously. If you specify
     * UI customization settings for a particular client, it will no longer fall back to the <code>ALL</code>
     * configuration.
     * </p>
     * <note>
     * <p>
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the
     * app's pages, and the service will throw an error.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUiCustomizationRequest.Builder} avoiding the
     * need to create one manually via {@link SetUiCustomizationRequest#builder()}
     * </p>
     *
     * @param setUiCustomizationRequest
     *        A {@link Consumer} that will call methods on {@link SetUICustomizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUICustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetUiCustomizationResponse> setUICustomization(
            Consumer<SetUiCustomizationRequest.Builder> setUiCustomizationRequest) {
        return setUICustomization(SetUiCustomizationRequest.builder().applyMutation(setUiCustomizationRequest).build());
    }

    /**
     * <p>
     * Set the user's multi-factor authentication (MFA) method preference.
     * </p>
     *
     * @param setUserMfaPreferenceRequest
     * @return A Java Future containing the result of the SetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserMFAPreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetUserMfaPreferenceResponse> setUserMFAPreference(
            SetUserMfaPreferenceRequest setUserMfaPreferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the user's multi-factor authentication (MFA) method preference.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUserMfaPreferenceRequest.Builder} avoiding the
     * need to create one manually via {@link SetUserMfaPreferenceRequest#builder()}
     * </p>
     *
     * @param setUserMfaPreferenceRequest
     *        A {@link Consumer} that will call methods on {@link SetUserMFAPreferenceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserMFAPreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetUserMfaPreferenceResponse> setUserMFAPreference(
            Consumer<SetUserMfaPreferenceRequest.Builder> setUserMfaPreferenceRequest) {
        return setUserMFAPreference(SetUserMfaPreferenceRequest.builder().applyMutation(setUserMfaPreferenceRequest).build());
    }

    /**
     * <p>
     * Set the user pool MFA configuration.
     * </p>
     *
     * @param setUserPoolMfaConfigRequest
     * @return A Java Future containing the result of the SetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserPoolMfaConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetUserPoolMfaConfigResponse> setUserPoolMfaConfig(
            SetUserPoolMfaConfigRequest setUserPoolMfaConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the user pool MFA configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUserPoolMfaConfigRequest.Builder} avoiding the
     * need to create one manually via {@link SetUserPoolMfaConfigRequest#builder()}
     * </p>
     *
     * @param setUserPoolMfaConfigRequest
     *        A {@link Consumer} that will call methods on {@link SetUserPoolMfaConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserPoolMfaConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetUserPoolMfaConfigResponse> setUserPoolMfaConfig(
            Consumer<SetUserPoolMfaConfigRequest.Builder> setUserPoolMfaConfigRequest) {
        return setUserPoolMfaConfig(SetUserPoolMfaConfigRequest.builder().applyMutation(setUserPoolMfaConfigRequest).build());
    }

    /**
     * <p>
     * Sets the user settings like multi-factor authentication (MFA). If MFA is to be removed for a particular attribute
     * pass the attribute with code delivery as null. If null list is passed, all MFA options are removed.
     * </p>
     *
     * @param setUserSettingsRequest
     *        Represents the request to set user settings.
     * @return A Java Future containing the result of the SetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetUserSettingsResponse> setUserSettings(SetUserSettingsRequest setUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the user settings like multi-factor authentication (MFA). If MFA is to be removed for a particular attribute
     * pass the attribute with code delivery as null. If null list is passed, all MFA options are removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUserSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link SetUserSettingsRequest#builder()}
     * </p>
     *
     * @param setUserSettingsRequest
     *        A {@link Consumer} that will call methods on {@link SetUserSettingsRequest.Builder} to create a request.
     *        Represents the request to set user settings.
     * @return A Java Future containing the result of the SetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetUserSettingsResponse> setUserSettings(
            Consumer<SetUserSettingsRequest.Builder> setUserSettingsRequest) {
        return setUserSettings(SetUserSettingsRequest.builder().applyMutation(setUserSettingsRequest).build());
    }

    /**
     * <p>
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     * </p>
     *
     * @param signUpRequest
     *        Represents the request to register a user.
     * @return A Java Future containing the result of the SignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SignUp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SignUpResponse> signUp(SignUpRequest signUpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SignUpRequest.Builder} avoiding the need to create
     * one manually via {@link SignUpRequest#builder()}
     * </p>
     *
     * @param signUpRequest
     *        A {@link Consumer} that will call methods on {@link SignUpRequest.Builder} to create a request. Represents
     *        the request to register a user.
     * @return A Java Future containing the result of the SignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SignUp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SignUpResponse> signUp(Consumer<SignUpRequest.Builder> signUpRequest) {
        return signUp(SignUpRequest.builder().applyMutation(signUpRequest).build());
    }

    /**
     * <p>
     * Starts the user import.
     * </p>
     *
     * @param startUserImportJobRequest
     *        Represents the request to start the user import job.
     * @return A Java Future containing the result of the StartUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StartUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartUserImportJobResponse> startUserImportJob(StartUserImportJobRequest startUserImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the user import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartUserImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartUserImportJobRequest#builder()}
     * </p>
     *
     * @param startUserImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartUserImportJobRequest.Builder} to create a
     *        request. Represents the request to start the user import job.
     * @return A Java Future containing the result of the StartUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StartUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartUserImportJobResponse> startUserImportJob(
            Consumer<StartUserImportJobRequest.Builder> startUserImportJobRequest) {
        return startUserImportJob(StartUserImportJobRequest.builder().applyMutation(startUserImportJobRequest).build());
    }

    /**
     * <p>
     * Stops the user import job.
     * </p>
     *
     * @param stopUserImportJobRequest
     *        Represents the request to stop the user import job.
     * @return A Java Future containing the result of the StopUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StopUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopUserImportJobResponse> stopUserImportJob(StopUserImportJobRequest stopUserImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopUserImportJobRequest.Builder} avoiding the need
     * to create one manually via {@link StopUserImportJobRequest#builder()}
     * </p>
     *
     * @param stopUserImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StopUserImportJobRequest.Builder} to create a request.
     *        Represents the request to stop the user import job.
     * @return A Java Future containing the result of the StopUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StopUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopUserImportJobResponse> stopUserImportJob(
            Consumer<StopUserImportJobRequest.Builder> stopUserImportJobRequest) {
        return stopUserImportJob(StopUserImportJobRequest.builder().applyMutation(stopUserImportJobRequest).build());
    }

    /**
     * <p>
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific
     * values. For example, if you have two versions of a user pool, one for testing and another for production, you
     * might assign an <code>Environment</code> tag key to both user pools. The value of this key might be
     * <code>Test</code> for one user pool and <code>Production</code> for the other.
     * </p>
     * <p>
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the
     * Billing and Cost Management console, where you can track the costs associated with your user pools. In an IAM
     * policy, you can constrain permissions for user pools based on specific tags or tag values.
     * </p>
     * <p>
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific
     * values. For example, if you have two versions of a user pool, one for testing and another for production, you
     * might assign an <code>Environment</code> tag key to both user pools. The value of this key might be
     * <code>Test</code> for one user pool and <code>Production</code> for the other.
     * </p>
     * <p>
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the
     * Billing and Cost Management console, where you can track the costs associated with your user pools. In an IAM
     * policy, you can constrain permissions for user pools based on specific tags or tag values.
     * </p>
     * <p>
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second,
     * per account
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second,
     * per account
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Provides the feedback for an authentication event whether it was from a valid user or not. This feedback is used
     * for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     *
     * @param updateAuthEventFeedbackRequest
     * @return A Java Future containing the result of the UpdateAuthEventFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons are not enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateAuthEventFeedback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAuthEventFeedbackResponse> updateAuthEventFeedback(
            UpdateAuthEventFeedbackRequest updateAuthEventFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the feedback for an authentication event whether it was from a valid user or not. This feedback is used
     * for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAuthEventFeedbackRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAuthEventFeedbackRequest#builder()}
     * </p>
     *
     * @param updateAuthEventFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAuthEventFeedbackRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAuthEventFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons are not enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateAuthEventFeedback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAuthEventFeedbackResponse> updateAuthEventFeedback(
            Consumer<UpdateAuthEventFeedbackRequest.Builder> updateAuthEventFeedbackRequest) {
        return updateAuthEventFeedback(UpdateAuthEventFeedbackRequest.builder().applyMutation(updateAuthEventFeedbackRequest)
                .build());
    }

    /**
     * <p>
     * Updates the device status.
     * </p>
     *
     * @param updateDeviceStatusRequest
     *        Represents the request to update the device status.
     * @return A Java Future containing the result of the UpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateDeviceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceStatusResponse> updateDeviceStatus(UpdateDeviceStatusRequest updateDeviceStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceStatusRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeviceStatusRequest#builder()}
     * </p>
     *
     * @param updateDeviceStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeviceStatusRequest.Builder} to create a
     *        request. Represents the request to update the device status.
     * @return A Java Future containing the result of the UpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateDeviceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceStatusResponse> updateDeviceStatus(
            Consumer<UpdateDeviceStatusRequest.Builder> updateDeviceStatusRequest) {
        return updateDeviceStatus(UpdateDeviceStatusRequest.builder().applyMutation(updateDeviceStatusRequest).build());
    }

    /**
     * <p>
     * Updates the specified group with the specified attributes.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified group with the specified attributes.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest) {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Updates identity provider information for a user pool.
     * </p>
     *
     * @param updateIdentityProviderRequest
     * @return A Java Future containing the result of the UpdateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier is not
     *         supported.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdentityProviderResponse> updateIdentityProvider(
            UpdateIdentityProviderRequest updateIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates identity provider information for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIdentityProviderRequest#builder()}
     * </p>
     *
     * @param updateIdentityProviderRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIdentityProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier is not
     *         supported.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdentityProviderResponse> updateIdentityProvider(
            Consumer<UpdateIdentityProviderRequest.Builder> updateIdentityProviderRequest) {
        return updateIdentityProvider(UpdateIdentityProviderRequest.builder().applyMutation(updateIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Updates the name and scopes of resource server. All other fields are read-only.
     * </p>
     *
     * @param updateResourceServerRequest
     * @return A Java Future containing the result of the UpdateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceServerResponse> updateResourceServer(
            UpdateResourceServerRequest updateResourceServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name and scopes of resource server. All other fields are read-only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourceServerRequest#builder()}
     * </p>
     *
     * @param updateResourceServerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceServerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceServerResponse> updateResourceServer(
            Consumer<UpdateResourceServerRequest.Builder> updateResourceServerRequest) {
        return updateResourceServer(UpdateResourceServerRequest.builder().applyMutation(updateResourceServerRequest).build());
    }

    /**
     * <p>
     * Allows a user to update a specific attribute (one at a time).
     * </p>
     *
     * @param updateUserAttributesRequest
     *        Represents the request to update user attributes.
     * @return A Java Future containing the result of the UpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserAttributesResponse> updateUserAttributes(
            UpdateUserAttributesRequest updateUserAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a user to update a specific attribute (one at a time).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserAttributesRequest#builder()}
     * </p>
     *
     * @param updateUserAttributesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserAttributesRequest.Builder} to create a
     *        request. Represents the request to update user attributes.
     * @return A Java Future containing the result of the UpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserAttributesResponse> updateUserAttributes(
            Consumer<UpdateUserAttributesRequest.Builder> updateUserAttributesRequest) {
        return updateUserAttributes(UpdateUserAttributesRequest.builder().applyMutation(updateUserAttributesRequest).build());
    }

    /**
     * <p>
     * Updates the specified user pool with the specified attributes. If you don't provide a value for an attribute, it
     * will be set to the default value. You can get a list of the current user pool settings with .
     * </p>
     *
     * @param updateUserPoolRequest
     *        Represents the request to update the user pool.
     * @return A Java Future containing the result of the UpdateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you are trying to modify a user pool
     *         while a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag cannot be set or updated.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolResponse> updateUserPool(UpdateUserPoolRequest updateUserPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified user pool with the specified attributes. If you don't provide a value for an attribute, it
     * will be set to the default value. You can get a list of the current user pool settings with .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserPoolRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserPoolRequest#builder()}
     * </p>
     *
     * @param updateUserPoolRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserPoolRequest.Builder} to create a request.
     *        Represents the request to update the user pool.
     * @return A Java Future containing the result of the UpdateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you are trying to modify a user pool
     *         while a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag cannot be set or updated.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolResponse> updateUserPool(Consumer<UpdateUserPoolRequest.Builder> updateUserPoolRequest) {
        return updateUserPool(UpdateUserPoolRequest.builder().applyMutation(updateUserPoolRequest).build());
    }

    /**
     * <p>
     * Updates the specified user pool app client with the specified attributes. If you don't provide a value for an
     * attribute, it will be set to the default value. You can get a list of the current user pool app client settings
     * with .
     * </p>
     *
     * @param updateUserPoolClientRequest
     *        Represents the request to update the user pool client.
     * @return A Java Future containing the result of the UpdateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope does not exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is invalid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolClientResponse> updateUserPoolClient(
            UpdateUserPoolClientRequest updateUserPoolClientRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified user pool app client with the specified attributes. If you don't provide a value for an
     * attribute, it will be set to the default value. You can get a list of the current user pool app client settings
     * with .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserPoolClientRequest#builder()}
     * </p>
     *
     * @param updateUserPoolClientRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserPoolClientRequest.Builder} to create a
     *        request. Represents the request to update the user pool client.
     * @return A Java Future containing the result of the UpdateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope does not exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is invalid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolClientResponse> updateUserPoolClient(
            Consumer<UpdateUserPoolClientRequest.Builder> updateUserPoolClientRequest) {
        return updateUserPoolClient(UpdateUserPoolClientRequest.builder().applyMutation(updateUserPoolClientRequest).build());
    }

    /**
     * <p>
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     * </p>
     * <p>
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You
     * cannot use it to change the domain for a user pool.
     * </p>
     * <p>
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your
     * application. When you set up a custom domain, you provide a certificate that you manage with AWS Certificate
     * Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your
     * custom domain.
     * </p>
     * <p>
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing
     * certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new
     * certificate automatically.
     * </p>
     * <p>
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To
     * apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     * </p>
     * <p>
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the AWS Region.
     * </p>
     * <p>
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your
     * custom domain.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using
     * Your Own Domain for the Hosted UI</a>.
     * </p>
     *
     * @param updateUserPoolDomainRequest
     *        The UpdateUserPoolDomain request input.
     * @return A Java Future containing the result of the UpdateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolDomainResponse> updateUserPoolDomain(
            UpdateUserPoolDomainRequest updateUserPoolDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     * </p>
     * <p>
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You
     * cannot use it to change the domain for a user pool.
     * </p>
     * <p>
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your
     * application. When you set up a custom domain, you provide a certificate that you manage with AWS Certificate
     * Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your
     * custom domain.
     * </p>
     * <p>
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing
     * certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new
     * certificate automatically.
     * </p>
     * <p>
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To
     * apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     * </p>
     * <p>
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the AWS Region.
     * </p>
     * <p>
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your
     * custom domain.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using
     * Your Own Domain for the Hosted UI</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param updateUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserPoolDomainRequest.Builder} to create a
     *        request. The UpdateUserPoolDomain request input.
     * @return A Java Future containing the result of the UpdateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolDomainResponse> updateUserPoolDomain(
            Consumer<UpdateUserPoolDomainRequest.Builder> updateUserPoolDomainRequest) {
        return updateUserPoolDomain(UpdateUserPoolDomainRequest.builder().applyMutation(updateUserPoolDomainRequest).build());
    }

    /**
     * <p>
     * Use this API to register a user's entered TOTP code and mark the user's software token MFA status as "verified"
     * if successful. The request takes an access token or a session string, but not both.
     * </p>
     *
     * @param verifySoftwareTokenRequest
     * @return A Java Future containing the result of the VerifySoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>EnableSoftwareTokenMfaException This exception is thrown when there is a code mismatch and the
     *         service fails to configure the software token TOTP multi-factor authentication (MFA).</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token TOTP multi-factor
     *         authentication (MFA) is not enabled for the user pool.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifySoftwareToken
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifySoftwareTokenResponse> verifySoftwareToken(
            VerifySoftwareTokenRequest verifySoftwareTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API to register a user's entered TOTP code and mark the user's software token MFA status as "verified"
     * if successful. The request takes an access token or a session string, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifySoftwareTokenRequest.Builder} avoiding the
     * need to create one manually via {@link VerifySoftwareTokenRequest#builder()}
     * </p>
     *
     * @param verifySoftwareTokenRequest
     *        A {@link Consumer} that will call methods on {@link VerifySoftwareTokenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the VerifySoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>EnableSoftwareTokenMfaException This exception is thrown when there is a code mismatch and the
     *         service fails to configure the software token TOTP multi-factor authentication (MFA).</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token TOTP multi-factor
     *         authentication (MFA) is not enabled for the user pool.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifySoftwareToken
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifySoftwareTokenResponse> verifySoftwareToken(
            Consumer<VerifySoftwareTokenRequest.Builder> verifySoftwareTokenRequest) {
        return verifySoftwareToken(VerifySoftwareTokenRequest.builder().applyMutation(verifySoftwareTokenRequest).build());
    }

    /**
     * <p>
     * Verifies the specified user attributes in the user pool.
     * </p>
     *
     * @param verifyUserAttributeRequest
     *        Represents the request to verify user attributes.
     * @return A Java Future containing the result of the VerifyUserAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifyUserAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifyUserAttributeResponse> verifyUserAttribute(
            VerifyUserAttributeRequest verifyUserAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Verifies the specified user attributes in the user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyUserAttributeRequest.Builder} avoiding the
     * need to create one manually via {@link VerifyUserAttributeRequest#builder()}
     * </p>
     *
     * @param verifyUserAttributeRequest
     *        A {@link Consumer} that will call methods on {@link VerifyUserAttributeRequest.Builder} to create a
     *        request. Represents the request to verify user attributes.
     * @return A Java Future containing the result of the VerifyUserAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifyUserAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifyUserAttributeResponse> verifyUserAttribute(
            Consumer<VerifyUserAttributeRequest.Builder> verifyUserAttributeRequest) {
        return verifyUserAttribute(VerifyUserAttributeRequest.builder().applyMutation(verifyUserAttributeRequest).build());
    }
}
