/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminUpdateAuthEventFeedbackRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AdminUpdateAuthEventFeedbackRequest.Builder, AdminUpdateAuthEventFeedbackRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminUpdateAuthEventFeedbackRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminUpdateAuthEventFeedbackRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminUpdateAuthEventFeedbackRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()).build();

    private static final SdkField<String> FEEDBACK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdminUpdateAuthEventFeedbackRequest::feedbackValueAsString)).setter(setter(Builder::feedbackValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            USERNAME_FIELD, EVENT_ID_FIELD, FEEDBACK_VALUE_FIELD));

    private final String userPoolId;

    private final String username;

    private final String eventId;

    private final String feedbackValue;

    private AdminUpdateAuthEventFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.eventId = builder.eventId;
        this.feedbackValue = builder.feedbackValue;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The user pool username.
     * </p>
     * 
     * @return The user pool username.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The authentication event ID.
     * </p>
     * 
     * @return The authentication event ID.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The authentication event feedback value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedbackValue}
     * will return {@link FeedbackValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackValueAsString}.
     * </p>
     * 
     * @return The authentication event feedback value.
     * @see FeedbackValueType
     */
    public FeedbackValueType feedbackValue() {
        return FeedbackValueType.fromValue(feedbackValue);
    }

    /**
     * <p>
     * The authentication event feedback value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedbackValue}
     * will return {@link FeedbackValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackValueAsString}.
     * </p>
     * 
     * @return The authentication event feedback value.
     * @see FeedbackValueType
     */
    public String feedbackValueAsString() {
        return feedbackValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackValueAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminUpdateAuthEventFeedbackRequest)) {
            return false;
        }
        AdminUpdateAuthEventFeedbackRequest other = (AdminUpdateAuthEventFeedbackRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(username(), other.username())
                && Objects.equals(eventId(), other.eventId())
                && Objects.equals(feedbackValueAsString(), other.feedbackValueAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AdminUpdateAuthEventFeedbackRequest").add("UserPoolId", userPoolId())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***").add("EventId", eventId())
                .add("FeedbackValue", feedbackValueAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "FeedbackValue":
            return Optional.ofNullable(clazz.cast(feedbackValueAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminUpdateAuthEventFeedbackRequest, T> g) {
        return obj -> g.apply((AdminUpdateAuthEventFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminUpdateAuthEventFeedbackRequest> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The user pool username.
         * </p>
         * 
         * @param username
         *        The user pool username.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The authentication event ID.
         * </p>
         * 
         * @param eventId
         *        The authentication event ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The authentication event feedback value.
         * </p>
         * 
         * @param feedbackValue
         *        The authentication event feedback value.
         * @see FeedbackValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeedbackValueType
         */
        Builder feedbackValue(String feedbackValue);

        /**
         * <p>
         * The authentication event feedback value.
         * </p>
         * 
         * @param feedbackValue
         *        The authentication event feedback value.
         * @see FeedbackValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeedbackValueType
         */
        Builder feedbackValue(FeedbackValueType feedbackValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String username;

        private String eventId;

        private String feedbackValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminUpdateAuthEventFeedbackRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            username(model.username);
            eventId(model.eventId);
            feedbackValue(model.feedbackValue);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getFeedbackValueAsString() {
            return feedbackValue;
        }

        @Override
        public final Builder feedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
            return this;
        }

        @Override
        public final Builder feedbackValue(FeedbackValueType feedbackValue) {
            this.feedbackValue(feedbackValue.toString());
            return this;
        }

        public final void setFeedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminUpdateAuthEventFeedbackRequest build() {
            return new AdminUpdateAuthEventFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
