/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the user pool's device tracking.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceConfigurationType.Builder, DeviceConfigurationType> {
    private static final SdkField<Boolean> CHALLENGE_REQUIRED_ON_NEW_DEVICE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeviceConfigurationType::challengeRequiredOnNewDevice))
            .setter(setter(Builder::challengeRequiredOnNewDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeRequiredOnNewDevice")
                    .build()).build();

    private static final SdkField<Boolean> DEVICE_ONLY_REMEMBERED_ON_USER_PROMPT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeviceConfigurationType::deviceOnlyRememberedOnUserPrompt))
            .setter(setter(Builder::deviceOnlyRememberedOnUserPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOnlyRememberedOnUserPrompt")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHALLENGE_REQUIRED_ON_NEW_DEVICE_FIELD, DEVICE_ONLY_REMEMBERED_ON_USER_PROMPT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean challengeRequiredOnNewDevice;

    private final Boolean deviceOnlyRememberedOnUserPrompt;

    private DeviceConfigurationType(BuilderImpl builder) {
        this.challengeRequiredOnNewDevice = builder.challengeRequiredOnNewDevice;
        this.deviceOnlyRememberedOnUserPrompt = builder.deviceOnlyRememberedOnUserPrompt;
    }

    /**
     * <p>
     * Indicates whether a challenge is required on a new device. Only applicable to a new device.
     * </p>
     * 
     * @return Indicates whether a challenge is required on a new device. Only applicable to a new device.
     */
    public Boolean challengeRequiredOnNewDevice() {
        return challengeRequiredOnNewDevice;
    }

    /**
     * <p>
     * If true, a device is only remembered on user prompt.
     * </p>
     * 
     * @return If true, a device is only remembered on user prompt.
     */
    public Boolean deviceOnlyRememberedOnUserPrompt() {
        return deviceOnlyRememberedOnUserPrompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(challengeRequiredOnNewDevice());
        hashCode = 31 * hashCode + Objects.hashCode(deviceOnlyRememberedOnUserPrompt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceConfigurationType)) {
            return false;
        }
        DeviceConfigurationType other = (DeviceConfigurationType) obj;
        return Objects.equals(challengeRequiredOnNewDevice(), other.challengeRequiredOnNewDevice())
                && Objects.equals(deviceOnlyRememberedOnUserPrompt(), other.deviceOnlyRememberedOnUserPrompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeviceConfigurationType").add("ChallengeRequiredOnNewDevice", challengeRequiredOnNewDevice())
                .add("DeviceOnlyRememberedOnUserPrompt", deviceOnlyRememberedOnUserPrompt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChallengeRequiredOnNewDevice":
            return Optional.ofNullable(clazz.cast(challengeRequiredOnNewDevice()));
        case "DeviceOnlyRememberedOnUserPrompt":
            return Optional.ofNullable(clazz.cast(deviceOnlyRememberedOnUserPrompt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceConfigurationType, T> g) {
        return obj -> g.apply((DeviceConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceConfigurationType> {
        /**
         * <p>
         * Indicates whether a challenge is required on a new device. Only applicable to a new device.
         * </p>
         * 
         * @param challengeRequiredOnNewDevice
         *        Indicates whether a challenge is required on a new device. Only applicable to a new device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice);

        /**
         * <p>
         * If true, a device is only remembered on user prompt.
         * </p>
         * 
         * @param deviceOnlyRememberedOnUserPrompt
         *        If true, a device is only remembered on user prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt);
    }

    static final class BuilderImpl implements Builder {
        private Boolean challengeRequiredOnNewDevice;

        private Boolean deviceOnlyRememberedOnUserPrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceConfigurationType model) {
            challengeRequiredOnNewDevice(model.challengeRequiredOnNewDevice);
            deviceOnlyRememberedOnUserPrompt(model.deviceOnlyRememberedOnUserPrompt);
        }

        public final Boolean getChallengeRequiredOnNewDevice() {
            return challengeRequiredOnNewDevice;
        }

        @Override
        public final Builder challengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice) {
            this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
            return this;
        }

        public final void setChallengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice) {
            this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
        }

        public final Boolean getDeviceOnlyRememberedOnUserPrompt() {
            return deviceOnlyRememberedOnUserPrompt;
        }

        @Override
        public final Builder deviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt) {
            this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
            return this;
        }

        public final void setDeviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt) {
            this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
        }

        @Override
        public DeviceConfigurationType build() {
            return new DeviceConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
