/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The email configuration type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailConfigurationType.Builder, EmailConfigurationType> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailConfigurationType::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> REPLY_TO_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailConfigurationType::replyToEmailAddress)).setter(setter(Builder::replyToEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToEmailAddress").build())
            .build();

    private static final SdkField<String> EMAIL_SENDING_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailConfigurationType::emailSendingAccountAsString)).setter(setter(Builder::emailSendingAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailSendingAccount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD,
            REPLY_TO_EMAIL_ADDRESS_FIELD, EMAIL_SENDING_ACCOUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceArn;

    private final String replyToEmailAddress;

    private final String emailSendingAccount;

    private EmailConfigurationType(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.replyToEmailAddress = builder.replyToEmailAddress;
        this.emailSendingAccount = builder.emailSendingAccount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a verified email address in Amazon SES. This email address is used in one of
     * the following ways, depending on the value that you specify for the <code>EmailSendingAccount</code> parameter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify <code>COGNITO_DEFAULT</code>, Amazon Cognito uses this address as the custom FROM address when it
     * emails your users by using its built-in email account.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify <code>DEVELOPER</code>, Amazon Cognito emails your users with this address by calling Amazon SES
     * on your behalf.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of a verified email address in Amazon SES. This email address is used in
     *         one of the following ways, depending on the value that you specify for the
     *         <code>EmailSendingAccount</code> parameter:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify <code>COGNITO_DEFAULT</code>, Amazon Cognito uses this address as the custom FROM address
     *         when it emails your users by using its built-in email account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify <code>DEVELOPER</code>, Amazon Cognito emails your users with this address by calling
     *         Amazon SES on your behalf.
     *         </p>
     *         </li>
     */
    public String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The destination to which the receiver of the email should reply to.
     * </p>
     * 
     * @return The destination to which the receiver of the email should reply to.
     */
    public String replyToEmailAddress() {
        return replyToEmailAddress;
    }

    /**
     * <p>
     * Specifies whether Amazon Cognito emails your users by using its built-in email functionality or your Amazon SES
     * email configuration. Specify one of the following values:
     * </p>
     * <dl>
     * <dt>COGNITO_DEFAULT</dt>
     * <dd>
     * <p>
     * When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option,
     * Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production
     * environments, the default email limit is below the required delivery volume. To achieve a higher delivery volume,
     * specify DEVELOPER to use your Amazon SES email configuration.
     * </p>
     * <p>
     * To look up the email delivery limit for the default option, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in Amazon Cognito</a> in the
     * <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * <p>
     * The default FROM address is no-reply@verificationemail.com. To customize the FROM address, provide the ARN of an
     * Amazon SES verified email address for the <code>SourceArn</code> parameter.
     * </p>
     * </dd>
     * <dt>DEVELOPER</dt>
     * <dd>
     * <p>
     * When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on
     * your behalf to send email from your verified email address. When you use this option, the email delivery limits
     * are the same limits that apply to your Amazon SES verified email address in your AWS account.
     * </p>
     * <p>
     * If you use this option, you must provide the ARN of an Amazon SES verified email address for the
     * <code>SourceArn</code> parameter.
     * </p>
     * <p>
     * Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf.
     * When you update your user pool with this option, Amazon Cognito creates a <i>service-linked role</i>, which is a
     * type of IAM role, in your AWS account. This role contains the permissions that allow Amazon Cognito to access
     * Amazon SES and send email messages with your address. For more information about the service-linked role that
     * Amazon Cognito creates, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using
     * Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #emailSendingAccount} will return {@link EmailSendingAccountType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #emailSendingAccountAsString}.
     * </p>
     * 
     * @return Specifies whether Amazon Cognito emails your users by using its built-in email functionality or your
     *         Amazon SES email configuration. Specify one of the following values:</p>
     *         <dl>
     *         <dt>COGNITO_DEFAULT</dt>
     *         <dd>
     *         <p>
     *         When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default
     *         option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical
     *         production environments, the default email limit is below the required delivery volume. To achieve a
     *         higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.
     *         </p>
     *         <p>
     *         To look up the email delivery limit for the default option, see <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in Amazon Cognito</a>
     *         in the <i>Amazon Cognito Developer Guide</i>.
     *         </p>
     *         <p>
     *         The default FROM address is no-reply@verificationemail.com. To customize the FROM address, provide the
     *         ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.
     *         </p>
     *         </dd>
     *         <dt>DEVELOPER</dt>
     *         <dd>
     *         <p>
     *         When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon
     *         SES on your behalf to send email from your verified email address. When you use this option, the email
     *         delivery limits are the same limits that apply to your Amazon SES verified email address in your AWS
     *         account.
     *         </p>
     *         <p>
     *         If you use this option, you must provide the ARN of an Amazon SES verified email address for the
     *         <code>SourceArn</code> parameter.
     *         </p>
     *         <p>
     *         Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your
     *         behalf. When you update your user pool with this option, Amazon Cognito creates a <i>service-linked
     *         role</i>, which is a type of IAM role, in your AWS account. This role contains the permissions that allow
     *         Amazon Cognito to access Amazon SES and send email messages with your address. For more information about
     *         the service-linked role that Amazon Cognito creates, see <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using
     *         Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.
     *         </p>
     *         </dd>
     * @see EmailSendingAccountType
     */
    public EmailSendingAccountType emailSendingAccount() {
        return EmailSendingAccountType.fromValue(emailSendingAccount);
    }

    /**
     * <p>
     * Specifies whether Amazon Cognito emails your users by using its built-in email functionality or your Amazon SES
     * email configuration. Specify one of the following values:
     * </p>
     * <dl>
     * <dt>COGNITO_DEFAULT</dt>
     * <dd>
     * <p>
     * When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option,
     * Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production
     * environments, the default email limit is below the required delivery volume. To achieve a higher delivery volume,
     * specify DEVELOPER to use your Amazon SES email configuration.
     * </p>
     * <p>
     * To look up the email delivery limit for the default option, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in Amazon Cognito</a> in the
     * <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * <p>
     * The default FROM address is no-reply@verificationemail.com. To customize the FROM address, provide the ARN of an
     * Amazon SES verified email address for the <code>SourceArn</code> parameter.
     * </p>
     * </dd>
     * <dt>DEVELOPER</dt>
     * <dd>
     * <p>
     * When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on
     * your behalf to send email from your verified email address. When you use this option, the email delivery limits
     * are the same limits that apply to your Amazon SES verified email address in your AWS account.
     * </p>
     * <p>
     * If you use this option, you must provide the ARN of an Amazon SES verified email address for the
     * <code>SourceArn</code> parameter.
     * </p>
     * <p>
     * Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf.
     * When you update your user pool with this option, Amazon Cognito creates a <i>service-linked role</i>, which is a
     * type of IAM role, in your AWS account. This role contains the permissions that allow Amazon Cognito to access
     * Amazon SES and send email messages with your address. For more information about the service-linked role that
     * Amazon Cognito creates, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using
     * Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #emailSendingAccount} will return {@link EmailSendingAccountType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #emailSendingAccountAsString}.
     * </p>
     * 
     * @return Specifies whether Amazon Cognito emails your users by using its built-in email functionality or your
     *         Amazon SES email configuration. Specify one of the following values:</p>
     *         <dl>
     *         <dt>COGNITO_DEFAULT</dt>
     *         <dd>
     *         <p>
     *         When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default
     *         option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical
     *         production environments, the default email limit is below the required delivery volume. To achieve a
     *         higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.
     *         </p>
     *         <p>
     *         To look up the email delivery limit for the default option, see <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in Amazon Cognito</a>
     *         in the <i>Amazon Cognito Developer Guide</i>.
     *         </p>
     *         <p>
     *         The default FROM address is no-reply@verificationemail.com. To customize the FROM address, provide the
     *         ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.
     *         </p>
     *         </dd>
     *         <dt>DEVELOPER</dt>
     *         <dd>
     *         <p>
     *         When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon
     *         SES on your behalf to send email from your verified email address. When you use this option, the email
     *         delivery limits are the same limits that apply to your Amazon SES verified email address in your AWS
     *         account.
     *         </p>
     *         <p>
     *         If you use this option, you must provide the ARN of an Amazon SES verified email address for the
     *         <code>SourceArn</code> parameter.
     *         </p>
     *         <p>
     *         Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your
     *         behalf. When you update your user pool with this option, Amazon Cognito creates a <i>service-linked
     *         role</i>, which is a type of IAM role, in your AWS account. This role contains the permissions that allow
     *         Amazon Cognito to access Amazon SES and send email messages with your address. For more information about
     *         the service-linked role that Amazon Cognito creates, see <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using
     *         Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.
     *         </p>
     *         </dd>
     * @see EmailSendingAccountType
     */
    public String emailSendingAccountAsString() {
        return emailSendingAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(replyToEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(emailSendingAccountAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailConfigurationType)) {
            return false;
        }
        EmailConfigurationType other = (EmailConfigurationType) obj;
        return Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(replyToEmailAddress(), other.replyToEmailAddress())
                && Objects.equals(emailSendingAccountAsString(), other.emailSendingAccountAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EmailConfigurationType").add("SourceArn", sourceArn())
                .add("ReplyToEmailAddress", replyToEmailAddress()).add("EmailSendingAccount", emailSendingAccountAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "ReplyToEmailAddress":
            return Optional.ofNullable(clazz.cast(replyToEmailAddress()));
        case "EmailSendingAccount":
            return Optional.ofNullable(clazz.cast(emailSendingAccountAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailConfigurationType, T> g) {
        return obj -> g.apply((EmailConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailConfigurationType> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a verified email address in Amazon SES. This email address is used in one
         * of the following ways, depending on the value that you specify for the <code>EmailSendingAccount</code>
         * parameter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>COGNITO_DEFAULT</code>, Amazon Cognito uses this address as the custom FROM address when
         * it emails your users by using its built-in email account.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>DEVELOPER</code>, Amazon Cognito emails your users with this address by calling Amazon
         * SES on your behalf.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of a verified email address in Amazon SES. This email address is used
         *        in one of the following ways, depending on the value that you specify for the
         *        <code>EmailSendingAccount</code> parameter:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify <code>COGNITO_DEFAULT</code>, Amazon Cognito uses this address as the custom FROM
         *        address when it emails your users by using its built-in email account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>DEVELOPER</code>, Amazon Cognito emails your users with this address by calling
         *        Amazon SES on your behalf.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The destination to which the receiver of the email should reply to.
         * </p>
         * 
         * @param replyToEmailAddress
         *        The destination to which the receiver of the email should reply to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replyToEmailAddress(String replyToEmailAddress);

        /**
         * <p>
         * Specifies whether Amazon Cognito emails your users by using its built-in email functionality or your Amazon
         * SES email configuration. Specify one of the following values:
         * </p>
         * <dl>
         * <dt>COGNITO_DEFAULT</dt>
         * <dd>
         * <p>
         * When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default
         * option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical
         * production environments, the default email limit is below the required delivery volume. To achieve a higher
         * delivery volume, specify DEVELOPER to use your Amazon SES email configuration.
         * </p>
         * <p>
         * To look up the email delivery limit for the default option, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in Amazon Cognito</a> in
         * the <i>Amazon Cognito Developer Guide</i>.
         * </p>
         * <p>
         * The default FROM address is no-reply@verificationemail.com. To customize the FROM address, provide the ARN of
         * an Amazon SES verified email address for the <code>SourceArn</code> parameter.
         * </p>
         * </dd>
         * <dt>DEVELOPER</dt>
         * <dd>
         * <p>
         * When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES
         * on your behalf to send email from your verified email address. When you use this option, the email delivery
         * limits are the same limits that apply to your Amazon SES verified email address in your AWS account.
         * </p>
         * <p>
         * If you use this option, you must provide the ARN of an Amazon SES verified email address for the
         * <code>SourceArn</code> parameter.
         * </p>
         * <p>
         * Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your
         * behalf. When you update your user pool with this option, Amazon Cognito creates a <i>service-linked role</i>,
         * which is a type of IAM role, in your AWS account. This role contains the permissions that allow Amazon
         * Cognito to access Amazon SES and send email messages with your address. For more information about the
         * service-linked role that Amazon Cognito creates, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using
         * Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param emailSendingAccount
         *        Specifies whether Amazon Cognito emails your users by using its built-in email functionality or your
         *        Amazon SES email configuration. Specify one of the following values:</p>
         *        <dl>
         *        <dt>COGNITO_DEFAULT</dt>
         *        <dd>
         *        <p>
         *        When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the
         *        default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For
         *        typical production environments, the default email limit is below the required delivery volume. To
         *        achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.
         *        </p>
         *        <p>
         *        To look up the email delivery limit for the default option, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in Amazon
         *        Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.
         *        </p>
         *        <p>
         *        The default FROM address is no-reply@verificationemail.com. To customize the FROM address, provide the
         *        ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.
         *        </p>
         *        </dd>
         *        <dt>DEVELOPER</dt>
         *        <dd>
         *        <p>
         *        When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls
         *        Amazon SES on your behalf to send email from your verified email address. When you use this option,
         *        the email delivery limits are the same limits that apply to your Amazon SES verified email address in
         *        your AWS account.
         *        </p>
         *        <p>
         *        If you use this option, you must provide the ARN of an Amazon SES verified email address for the
         *        <code>SourceArn</code> parameter.
         *        </p>
         *        <p>
         *        Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on
         *        your behalf. When you update your user pool with this option, Amazon Cognito creates a
         *        <i>service-linked role</i>, which is a type of IAM role, in your AWS account. This role contains the
         *        permissions that allow Amazon Cognito to access Amazon SES and send email messages with your address.
         *        For more information about the service-linked role that Amazon Cognito creates, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using
         *        Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.
         *        </p>
         *        </dd>
         * @see EmailSendingAccountType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmailSendingAccountType
         */
        Builder emailSendingAccount(String emailSendingAccount);

        /**
         * <p>
         * Specifies whether Amazon Cognito emails your users by using its built-in email functionality or your Amazon
         * SES email configuration. Specify one of the following values:
         * </p>
         * <dl>
         * <dt>COGNITO_DEFAULT</dt>
         * <dd>
         * <p>
         * When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default
         * option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical
         * production environments, the default email limit is below the required delivery volume. To achieve a higher
         * delivery volume, specify DEVELOPER to use your Amazon SES email configuration.
         * </p>
         * <p>
         * To look up the email delivery limit for the default option, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in Amazon Cognito</a> in
         * the <i>Amazon Cognito Developer Guide</i>.
         * </p>
         * <p>
         * The default FROM address is no-reply@verificationemail.com. To customize the FROM address, provide the ARN of
         * an Amazon SES verified email address for the <code>SourceArn</code> parameter.
         * </p>
         * </dd>
         * <dt>DEVELOPER</dt>
         * <dd>
         * <p>
         * When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES
         * on your behalf to send email from your verified email address. When you use this option, the email delivery
         * limits are the same limits that apply to your Amazon SES verified email address in your AWS account.
         * </p>
         * <p>
         * If you use this option, you must provide the ARN of an Amazon SES verified email address for the
         * <code>SourceArn</code> parameter.
         * </p>
         * <p>
         * Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your
         * behalf. When you update your user pool with this option, Amazon Cognito creates a <i>service-linked role</i>,
         * which is a type of IAM role, in your AWS account. This role contains the permissions that allow Amazon
         * Cognito to access Amazon SES and send email messages with your address. For more information about the
         * service-linked role that Amazon Cognito creates, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using
         * Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param emailSendingAccount
         *        Specifies whether Amazon Cognito emails your users by using its built-in email functionality or your
         *        Amazon SES email configuration. Specify one of the following values:</p>
         *        <dl>
         *        <dt>COGNITO_DEFAULT</dt>
         *        <dd>
         *        <p>
         *        When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the
         *        default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For
         *        typical production environments, the default email limit is below the required delivery volume. To
         *        achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.
         *        </p>
         *        <p>
         *        To look up the email delivery limit for the default option, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in Amazon
         *        Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.
         *        </p>
         *        <p>
         *        The default FROM address is no-reply@verificationemail.com. To customize the FROM address, provide the
         *        ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.
         *        </p>
         *        </dd>
         *        <dt>DEVELOPER</dt>
         *        <dd>
         *        <p>
         *        When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls
         *        Amazon SES on your behalf to send email from your verified email address. When you use this option,
         *        the email delivery limits are the same limits that apply to your Amazon SES verified email address in
         *        your AWS account.
         *        </p>
         *        <p>
         *        If you use this option, you must provide the ARN of an Amazon SES verified email address for the
         *        <code>SourceArn</code> parameter.
         *        </p>
         *        <p>
         *        Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on
         *        your behalf. When you update your user pool with this option, Amazon Cognito creates a
         *        <i>service-linked role</i>, which is a type of IAM role, in your AWS account. This role contains the
         *        permissions that allow Amazon Cognito to access Amazon SES and send email messages with your address.
         *        For more information about the service-linked role that Amazon Cognito creates, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using
         *        Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.
         *        </p>
         *        </dd>
         * @see EmailSendingAccountType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmailSendingAccountType
         */
        Builder emailSendingAccount(EmailSendingAccountType emailSendingAccount);
    }

    static final class BuilderImpl implements Builder {
        private String sourceArn;

        private String replyToEmailAddress;

        private String emailSendingAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailConfigurationType model) {
            sourceArn(model.sourceArn);
            replyToEmailAddress(model.replyToEmailAddress);
            emailSendingAccount(model.emailSendingAccount);
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getReplyToEmailAddress() {
            return replyToEmailAddress;
        }

        @Override
        public final Builder replyToEmailAddress(String replyToEmailAddress) {
            this.replyToEmailAddress = replyToEmailAddress;
            return this;
        }

        public final void setReplyToEmailAddress(String replyToEmailAddress) {
            this.replyToEmailAddress = replyToEmailAddress;
        }

        public final String getEmailSendingAccountAsString() {
            return emailSendingAccount;
        }

        @Override
        public final Builder emailSendingAccount(String emailSendingAccount) {
            this.emailSendingAccount = emailSendingAccount;
            return this;
        }

        @Override
        public final Builder emailSendingAccount(EmailSendingAccountType emailSendingAccount) {
            this.emailSendingAccount(emailSendingAccount.toString());
            return this;
        }

        public final void setEmailSendingAccount(String emailSendingAccount) {
            this.emailSendingAccount = emailSendingAccount;
        }

        @Override
        public EmailConfigurationType build() {
            return new EmailConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
