/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server that lists user pool clients.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserPoolClientsResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ListUserPoolClientsResponse.Builder, ListUserPoolClientsResponse> {
    private static final SdkField<List<UserPoolClientDescription>> USER_POOL_CLIENTS_FIELD = SdkField
            .<List<UserPoolClientDescription>> builder(MarshallingType.LIST)
            .getter(getter(ListUserPoolClientsResponse::userPoolClients))
            .setter(setter(Builder::userPoolClients))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolClients").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserPoolClientDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserPoolClientDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUserPoolClientsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_CLIENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<UserPoolClientDescription> userPoolClients;

    private final String nextToken;

    private ListUserPoolClientsResponse(BuilderImpl builder) {
        super(builder);
        this.userPoolClients = builder.userPoolClients;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The user pool clients in the response that lists user pool clients.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The user pool clients in the response that lists user pool clients.
     */
    public List<UserPoolClientDescription> userPoolClients() {
        return userPoolClients;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolClients());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserPoolClientsResponse)) {
            return false;
        }
        ListUserPoolClientsResponse other = (ListUserPoolClientsResponse) obj;
        return Objects.equals(userPoolClients(), other.userPoolClients()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListUserPoolClientsResponse").add("UserPoolClients", userPoolClients())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolClients":
            return Optional.ofNullable(clazz.cast(userPoolClients()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserPoolClientsResponse, T> g) {
        return obj -> g.apply((ListUserPoolClientsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUserPoolClientsResponse> {
        /**
         * <p>
         * The user pool clients in the response that lists user pool clients.
         * </p>
         * 
         * @param userPoolClients
         *        The user pool clients in the response that lists user pool clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolClients(Collection<UserPoolClientDescription> userPoolClients);

        /**
         * <p>
         * The user pool clients in the response that lists user pool clients.
         * </p>
         * 
         * @param userPoolClients
         *        The user pool clients in the response that lists user pool clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolClients(UserPoolClientDescription... userPoolClients);

        /**
         * <p>
         * The user pool clients in the response that lists user pool clients.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserPoolClientDescription>.Builder}
         * avoiding the need to create one manually via {@link List<UserPoolClientDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserPoolClientDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #userPoolClients(List<UserPoolClientDescription>)}.
         * 
         * @param userPoolClients
         *        a consumer that will call methods on {@link List<UserPoolClientDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolClients(List<UserPoolClientDescription>)
         */
        Builder userPoolClients(Consumer<UserPoolClientDescription.Builder>... userPoolClients);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<UserPoolClientDescription> userPoolClients = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserPoolClientsResponse model) {
            super(model);
            userPoolClients(model.userPoolClients);
            nextToken(model.nextToken);
        }

        public final Collection<UserPoolClientDescription.Builder> getUserPoolClients() {
            return userPoolClients != null ? userPoolClients.stream().map(UserPoolClientDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userPoolClients(Collection<UserPoolClientDescription> userPoolClients) {
            this.userPoolClients = UserPoolClientListTypeCopier.copy(userPoolClients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPoolClients(UserPoolClientDescription... userPoolClients) {
            userPoolClients(Arrays.asList(userPoolClients));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPoolClients(Consumer<UserPoolClientDescription.Builder>... userPoolClients) {
            userPoolClients(Stream.of(userPoolClients).map(c -> UserPoolClientDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserPoolClients(Collection<UserPoolClientDescription.BuilderImpl> userPoolClients) {
            this.userPoolClients = UserPoolClientListTypeCopier.copyFromBuilder(userPoolClients);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUserPoolClientsResponse build() {
            return new ListUserPoolClientsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
