/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to list the devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDevicesRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<ListDevicesRequest.Builder, ListDevicesRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDevicesRequest::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListDevicesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDevicesRequest::paginationToken)).setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            LIMIT_FIELD, PAGINATION_TOKEN_FIELD));

    private final String accessToken;

    private final Integer limit;

    private final String paginationToken;

    private ListDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.limit = builder.limit;
        this.paginationToken = builder.paginationToken;
    }

    /**
     * <p>
     * The access tokens for the request to list devices.
     * </p>
     * 
     * @return The access tokens for the request to list devices.
     */
    public String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The limit of the device request.
     * </p>
     * 
     * @return The limit of the device request.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The pagination token for the list request.
     * </p>
     * 
     * @return The pagination token for the list request.
     */
    public String paginationToken() {
        return paginationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesRequest)) {
            return false;
        }
        ListDevicesRequest other = (ListDevicesRequest) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(limit(), other.limit())
                && Objects.equals(paginationToken(), other.paginationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDevicesRequest")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***").add("Limit", limit())
                .add("PaginationToken", paginationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesRequest, T> g) {
        return obj -> g.apply((ListDevicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDevicesRequest> {
        /**
         * <p>
         * The access tokens for the request to list devices.
         * </p>
         * 
         * @param accessToken
         *        The access tokens for the request to list devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The limit of the device request.
         * </p>
         * 
         * @param limit
         *        The limit of the device request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The pagination token for the list request.
         * </p>
         * 
         * @param paginationToken
         *        The pagination token for the list request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String accessToken;

        private Integer limit;

        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesRequest model) {
            super(model);
            accessToken(model.accessToken);
            limit(model.limit);
            paginationToken(model.paginationToken);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDevicesRequest build() {
            return new ListDevicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
