/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to get user attribute verification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUserAttributeVerificationCodeRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<GetUserAttributeVerificationCodeRequest.Builder, GetUserAttributeVerificationCodeRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetUserAttributeVerificationCodeRequest::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetUserAttributeVerificationCodeRequest::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            ATTRIBUTE_NAME_FIELD));

    private final String accessToken;

    private final String attributeName;

    private GetUserAttributeVerificationCodeRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.attributeName = builder.attributeName;
    }

    /**
     * <p>
     * The access token returned by the server response to get the user attribute verification code.
     * </p>
     * 
     * @return The access token returned by the server response to get the user attribute verification code.
     */
    public String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The attribute name returned by the server response to get the user attribute verification code.
     * </p>
     * 
     * @return The attribute name returned by the server response to get the user attribute verification code.
     */
    public String attributeName() {
        return attributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserAttributeVerificationCodeRequest)) {
            return false;
        }
        GetUserAttributeVerificationCodeRequest other = (GetUserAttributeVerificationCodeRequest) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(attributeName(), other.attributeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetUserAttributeVerificationCodeRequest")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AttributeName", attributeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUserAttributeVerificationCodeRequest, T> g) {
        return obj -> g.apply((GetUserAttributeVerificationCodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetUserAttributeVerificationCodeRequest> {
        /**
         * <p>
         * The access token returned by the server response to get the user attribute verification code.
         * </p>
         * 
         * @param accessToken
         *        The access token returned by the server response to get the user attribute verification code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The attribute name returned by the server response to get the user attribute verification code.
         * </p>
         * 
         * @param attributeName
         *        The attribute name returned by the server response to get the user attribute verification code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String accessToken;

        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserAttributeVerificationCodeRequest model) {
            super(model);
            accessToken(model.accessToken);
            attributeName(model.attributeName);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUserAttributeVerificationCodeRequest build() {
            return new GetUserAttributeVerificationCodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
