/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResendConfirmationCodeRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ResendConfirmationCodeRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResendConfirmationCodeRequest.getter(ResendConfirmationCodeRequest::clientId)).setter(ResendConfirmationCodeRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> SECRET_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResendConfirmationCodeRequest.getter(ResendConfirmationCodeRequest::secretHash)).setter(ResendConfirmationCodeRequest.setter(Builder::secretHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretHash").build()}).build();
    private static final SdkField<UserContextDataType> USER_CONTEXT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResendConfirmationCodeRequest.getter(ResendConfirmationCodeRequest::userContextData)).setter(ResendConfirmationCodeRequest.setter(Builder::userContextData)).constructor(UserContextDataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContextData").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResendConfirmationCodeRequest.getter(ResendConfirmationCodeRequest::username)).setter(ResendConfirmationCodeRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<AnalyticsMetadataType> ANALYTICS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResendConfirmationCodeRequest.getter(ResendConfirmationCodeRequest::analyticsMetadata)).setter(ResendConfirmationCodeRequest.setter(Builder::analyticsMetadata)).constructor(AnalyticsMetadataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, SECRET_HASH_FIELD, USER_CONTEXT_DATA_FIELD, USERNAME_FIELD, ANALYTICS_METADATA_FIELD));
    private final String clientId;
    private final String secretHash;
    private final UserContextDataType userContextData;
    private final String username;
    private final AnalyticsMetadataType analyticsMetadata;

    private ResendConfirmationCodeRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.secretHash = builder.secretHash;
        this.userContextData = builder.userContextData;
        this.username = builder.username;
        this.analyticsMetadata = builder.analyticsMetadata;
    }

    public String clientId() {
        return this.clientId;
    }

    public String secretHash() {
        return this.secretHash;
    }

    public UserContextDataType userContextData() {
        return this.userContextData;
    }

    public String username() {
        return this.username;
    }

    public AnalyticsMetadataType analyticsMetadata() {
        return this.analyticsMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.userContextData());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResendConfirmationCodeRequest)) {
            return false;
        }
        ResendConfirmationCodeRequest other = (ResendConfirmationCodeRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.secretHash(), other.secretHash()) && Objects.equals(this.userContextData(), other.userContextData()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.analyticsMetadata(), other.analyticsMetadata());
    }

    public String toString() {
        return ToString.builder((String)"ResendConfirmationCodeRequest").add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("SecretHash", (Object)(this.secretHash() == null ? null : "*** Sensitive Data Redacted ***")).add("UserContextData", (Object)this.userContextData()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("AnalyticsMetadata", (Object)this.analyticsMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "SecretHash": {
                return Optional.ofNullable(clazz.cast(this.secretHash()));
            }
            case "UserContextData": {
                return Optional.ofNullable(clazz.cast(this.userContextData()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "AnalyticsMetadata": {
                return Optional.ofNullable(clazz.cast(this.analyticsMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResendConfirmationCodeRequest, T> g) {
        return obj -> g.apply((ResendConfirmationCodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String secretHash;
        private UserContextDataType userContextData;
        private String username;
        private AnalyticsMetadataType analyticsMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ResendConfirmationCodeRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.secretHash(model.secretHash);
            this.userContextData(model.userContextData);
            this.username(model.username);
            this.analyticsMetadata(model.analyticsMetadata);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getSecretHash() {
            return this.secretHash;
        }

        @Override
        public final Builder secretHash(String secretHash) {
            this.secretHash = secretHash;
            return this;
        }

        public final void setSecretHash(String secretHash) {
            this.secretHash = secretHash;
        }

        public final UserContextDataType.Builder getUserContextData() {
            return this.userContextData != null ? this.userContextData.toBuilder() : null;
        }

        @Override
        public final Builder userContextData(UserContextDataType userContextData) {
            this.userContextData = userContextData;
            return this;
        }

        public final void setUserContextData(UserContextDataType.BuilderImpl userContextData) {
            this.userContextData = userContextData != null ? userContextData.build() : null;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final AnalyticsMetadataType.Builder getAnalyticsMetadata() {
            return this.analyticsMetadata != null ? this.analyticsMetadata.toBuilder() : null;
        }

        @Override
        public final Builder analyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata;
            return this;
        }

        public final void setAnalyticsMetadata(AnalyticsMetadataType.BuilderImpl analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata != null ? analyticsMetadata.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResendConfirmationCodeRequest build() {
            return new ResendConfirmationCodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResendConfirmationCodeRequest> {
        public Builder clientId(String var1);

        public Builder secretHash(String var1);

        public Builder userContextData(UserContextDataType var1);

        default public Builder userContextData(Consumer<UserContextDataType.Builder> userContextData) {
            return this.userContextData((UserContextDataType)((UserContextDataType.Builder)UserContextDataType.builder().applyMutation(userContextData)).build());
        }

        public Builder username(String var1);

        public Builder analyticsMetadata(AnalyticsMetadataType var1);

        default public Builder analyticsMetadata(Consumer<AnalyticsMetadataType.Builder> analyticsMetadata) {
            return this.analyticsMetadata((AnalyticsMetadataType)((AnalyticsMetadataType.Builder)AnalyticsMetadataType.builder().applyMutation(analyticsMetadata)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

