/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The password policy type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PasswordPolicyType implements SdkPojo, Serializable,
        ToCopyableBuilder<PasswordPolicyType.Builder, PasswordPolicyType> {
    private static final SdkField<Integer> MINIMUM_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PasswordPolicyType::minimumLength)).setter(setter(Builder::minimumLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumLength").build()).build();

    private static final SdkField<Boolean> REQUIRE_UPPERCASE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PasswordPolicyType::requireUppercase)).setter(setter(Builder::requireUppercase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireUppercase").build()).build();

    private static final SdkField<Boolean> REQUIRE_LOWERCASE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PasswordPolicyType::requireLowercase)).setter(setter(Builder::requireLowercase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireLowercase").build()).build();

    private static final SdkField<Boolean> REQUIRE_NUMBERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PasswordPolicyType::requireNumbers)).setter(setter(Builder::requireNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireNumbers").build()).build();

    private static final SdkField<Boolean> REQUIRE_SYMBOLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PasswordPolicyType::requireSymbols)).setter(setter(Builder::requireSymbols))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireSymbols").build()).build();

    private static final SdkField<Integer> TEMPORARY_PASSWORD_VALIDITY_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PasswordPolicyType::temporaryPasswordValidityDays))
            .setter(setter(Builder::temporaryPasswordValidityDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemporaryPasswordValidityDays")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_LENGTH_FIELD,
            REQUIRE_UPPERCASE_FIELD, REQUIRE_LOWERCASE_FIELD, REQUIRE_NUMBERS_FIELD, REQUIRE_SYMBOLS_FIELD,
            TEMPORARY_PASSWORD_VALIDITY_DAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minimumLength;

    private final Boolean requireUppercase;

    private final Boolean requireLowercase;

    private final Boolean requireNumbers;

    private final Boolean requireSymbols;

    private final Integer temporaryPasswordValidityDays;

    private PasswordPolicyType(BuilderImpl builder) {
        this.minimumLength = builder.minimumLength;
        this.requireUppercase = builder.requireUppercase;
        this.requireLowercase = builder.requireLowercase;
        this.requireNumbers = builder.requireNumbers;
        this.requireSymbols = builder.requireSymbols;
        this.temporaryPasswordValidityDays = builder.temporaryPasswordValidityDays;
    }

    /**
     * <p>
     * The minimum length of the password policy that you have set. Cannot be less than 6.
     * </p>
     * 
     * @return The minimum length of the password policy that you have set. Cannot be less than 6.
     */
    public Integer minimumLength() {
        return minimumLength;
    }

    /**
     * <p>
     * In the password policy that you have set, refers to whether you have required users to use at least one uppercase
     * letter in their password.
     * </p>
     * 
     * @return In the password policy that you have set, refers to whether you have required users to use at least one
     *         uppercase letter in their password.
     */
    public Boolean requireUppercase() {
        return requireUppercase;
    }

    /**
     * <p>
     * In the password policy that you have set, refers to whether you have required users to use at least one lowercase
     * letter in their password.
     * </p>
     * 
     * @return In the password policy that you have set, refers to whether you have required users to use at least one
     *         lowercase letter in their password.
     */
    public Boolean requireLowercase() {
        return requireLowercase;
    }

    /**
     * <p>
     * In the password policy that you have set, refers to whether you have required users to use at least one number in
     * their password.
     * </p>
     * 
     * @return In the password policy that you have set, refers to whether you have required users to use at least one
     *         number in their password.
     */
    public Boolean requireNumbers() {
        return requireNumbers;
    }

    /**
     * <p>
     * In the password policy that you have set, refers to whether you have required users to use at least one symbol in
     * their password.
     * </p>
     * 
     * @return In the password policy that you have set, refers to whether you have required users to use at least one
     *         symbol in their password.
     */
    public Boolean requireSymbols() {
        return requireSymbols;
    }

    /**
     * Returns the value of the TemporaryPasswordValidityDays property for this object.
     * 
     * @return The value of the TemporaryPasswordValidityDays property for this object.
     */
    public Integer temporaryPasswordValidityDays() {
        return temporaryPasswordValidityDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumLength());
        hashCode = 31 * hashCode + Objects.hashCode(requireUppercase());
        hashCode = 31 * hashCode + Objects.hashCode(requireLowercase());
        hashCode = 31 * hashCode + Objects.hashCode(requireNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(requireSymbols());
        hashCode = 31 * hashCode + Objects.hashCode(temporaryPasswordValidityDays());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordPolicyType)) {
            return false;
        }
        PasswordPolicyType other = (PasswordPolicyType) obj;
        return Objects.equals(minimumLength(), other.minimumLength())
                && Objects.equals(requireUppercase(), other.requireUppercase())
                && Objects.equals(requireLowercase(), other.requireLowercase())
                && Objects.equals(requireNumbers(), other.requireNumbers())
                && Objects.equals(requireSymbols(), other.requireSymbols())
                && Objects.equals(temporaryPasswordValidityDays(), other.temporaryPasswordValidityDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PasswordPolicyType").add("MinimumLength", minimumLength())
                .add("RequireUppercase", requireUppercase()).add("RequireLowercase", requireLowercase())
                .add("RequireNumbers", requireNumbers()).add("RequireSymbols", requireSymbols())
                .add("TemporaryPasswordValidityDays", temporaryPasswordValidityDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumLength":
            return Optional.ofNullable(clazz.cast(minimumLength()));
        case "RequireUppercase":
            return Optional.ofNullable(clazz.cast(requireUppercase()));
        case "RequireLowercase":
            return Optional.ofNullable(clazz.cast(requireLowercase()));
        case "RequireNumbers":
            return Optional.ofNullable(clazz.cast(requireNumbers()));
        case "RequireSymbols":
            return Optional.ofNullable(clazz.cast(requireSymbols()));
        case "TemporaryPasswordValidityDays":
            return Optional.ofNullable(clazz.cast(temporaryPasswordValidityDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PasswordPolicyType, T> g) {
        return obj -> g.apply((PasswordPolicyType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PasswordPolicyType> {
        /**
         * <p>
         * The minimum length of the password policy that you have set. Cannot be less than 6.
         * </p>
         * 
         * @param minimumLength
         *        The minimum length of the password policy that you have set. Cannot be less than 6.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLength(Integer minimumLength);

        /**
         * <p>
         * In the password policy that you have set, refers to whether you have required users to use at least one
         * uppercase letter in their password.
         * </p>
         * 
         * @param requireUppercase
         *        In the password policy that you have set, refers to whether you have required users to use at least
         *        one uppercase letter in their password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireUppercase(Boolean requireUppercase);

        /**
         * <p>
         * In the password policy that you have set, refers to whether you have required users to use at least one
         * lowercase letter in their password.
         * </p>
         * 
         * @param requireLowercase
         *        In the password policy that you have set, refers to whether you have required users to use at least
         *        one lowercase letter in their password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireLowercase(Boolean requireLowercase);

        /**
         * <p>
         * In the password policy that you have set, refers to whether you have required users to use at least one
         * number in their password.
         * </p>
         * 
         * @param requireNumbers
         *        In the password policy that you have set, refers to whether you have required users to use at least
         *        one number in their password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireNumbers(Boolean requireNumbers);

        /**
         * <p>
         * In the password policy that you have set, refers to whether you have required users to use at least one
         * symbol in their password.
         * </p>
         * 
         * @param requireSymbols
         *        In the password policy that you have set, refers to whether you have required users to use at least
         *        one symbol in their password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireSymbols(Boolean requireSymbols);

        /**
         * Sets the value of the TemporaryPasswordValidityDays property for this object.
         *
         * @param temporaryPasswordValidityDays
         *        The new value for the TemporaryPasswordValidityDays property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temporaryPasswordValidityDays(Integer temporaryPasswordValidityDays);
    }

    static final class BuilderImpl implements Builder {
        private Integer minimumLength;

        private Boolean requireUppercase;

        private Boolean requireLowercase;

        private Boolean requireNumbers;

        private Boolean requireSymbols;

        private Integer temporaryPasswordValidityDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PasswordPolicyType model) {
            minimumLength(model.minimumLength);
            requireUppercase(model.requireUppercase);
            requireLowercase(model.requireLowercase);
            requireNumbers(model.requireNumbers);
            requireSymbols(model.requireSymbols);
            temporaryPasswordValidityDays(model.temporaryPasswordValidityDays);
        }

        public final Integer getMinimumLength() {
            return minimumLength;
        }

        @Override
        public final Builder minimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public final void setMinimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
        }

        public final Boolean getRequireUppercase() {
            return requireUppercase;
        }

        @Override
        public final Builder requireUppercase(Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
            return this;
        }

        public final void setRequireUppercase(Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
        }

        public final Boolean getRequireLowercase() {
            return requireLowercase;
        }

        @Override
        public final Builder requireLowercase(Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
            return this;
        }

        public final void setRequireLowercase(Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
        }

        public final Boolean getRequireNumbers() {
            return requireNumbers;
        }

        @Override
        public final Builder requireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
            return this;
        }

        public final void setRequireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
        }

        public final Boolean getRequireSymbols() {
            return requireSymbols;
        }

        @Override
        public final Builder requireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        public final void setRequireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
        }

        public final Integer getTemporaryPasswordValidityDays() {
            return temporaryPasswordValidityDays;
        }

        @Override
        public final Builder temporaryPasswordValidityDays(Integer temporaryPasswordValidityDays) {
            this.temporaryPasswordValidityDays = temporaryPasswordValidityDays;
            return this;
        }

        public final void setTemporaryPasswordValidityDays(Integer temporaryPasswordValidityDays) {
            this.temporaryPasswordValidityDays = temporaryPasswordValidityDays;
        }

        @Override
        public PasswordPolicyType build() {
            return new PasswordPolicyType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
