/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for creating a new user profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminCreateUserConfigType implements SdkPojo, Serializable,
        ToCopyableBuilder<AdminCreateUserConfigType.Builder, AdminCreateUserConfigType> {
    private static final SdkField<Boolean> ALLOW_ADMIN_CREATE_USER_ONLY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(AdminCreateUserConfigType::allowAdminCreateUserOnly))
            .setter(setter(Builder::allowAdminCreateUserOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowAdminCreateUserOnly").build())
            .build();

    private static final SdkField<Integer> UNUSED_ACCOUNT_VALIDITY_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(AdminCreateUserConfigType::unusedAccountValidityDays))
            .setter(setter(Builder::unusedAccountValidityDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnusedAccountValidityDays").build())
            .build();

    private static final SdkField<MessageTemplateType> INVITE_MESSAGE_TEMPLATE_FIELD = SdkField
            .<MessageTemplateType> builder(MarshallingType.SDK_POJO)
            .getter(getter(AdminCreateUserConfigType::inviteMessageTemplate)).setter(setter(Builder::inviteMessageTemplate))
            .constructor(MessageTemplateType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InviteMessageTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOW_ADMIN_CREATE_USER_ONLY_FIELD, UNUSED_ACCOUNT_VALIDITY_DAYS_FIELD, INVITE_MESSAGE_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowAdminCreateUserOnly;

    private final Integer unusedAccountValidityDays;

    private final MessageTemplateType inviteMessageTemplate;

    private AdminCreateUserConfigType(BuilderImpl builder) {
        this.allowAdminCreateUserOnly = builder.allowAdminCreateUserOnly;
        this.unusedAccountValidityDays = builder.unusedAccountValidityDays;
        this.inviteMessageTemplate = builder.inviteMessageTemplate;
    }

    /**
     * <p>
     * Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to <code>False</code>
     * if users can sign themselves up via an app.
     * </p>
     * 
     * @return Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to
     *         <code>False</code> if users can sign themselves up via an app.
     */
    public Boolean allowAdminCreateUserOnly() {
        return allowAdminCreateUserOnly;
    }

    /**
     * <p>
     * The user account expiration limit, in days, after which the account is no longer usable. To reset the account
     * after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the
     * <code>MessageAction</code> parameter. The default value for this parameter is 7.
     * </p>
     * <note>
     * <p>
     * If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code>, that value will
     * be used and <code>UnusedAccountValidityDays</code> will be deprecated for that user pool.
     * </p>
     * </note>
     * 
     * @return The user account expiration limit, in days, after which the account is no longer usable. To reset the
     *         account after that time limit, you must call <code>AdminCreateUser</code> again, specifying
     *         <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter
     *         is 7. </p> <note>
     *         <p>
     *         If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code>, that
     *         value will be used and <code>UnusedAccountValidityDays</code> will be deprecated for that user pool.
     *         </p>
     */
    public Integer unusedAccountValidityDays() {
        return unusedAccountValidityDays;
    }

    /**
     * <p>
     * The message template to be used for the welcome message to new users.
     * </p>
     * <p>
     * See also <a href=
     * "http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization"
     * >Customizing User Invitation Messages</a>.
     * </p>
     * 
     * @return The message template to be used for the welcome message to new users.</p>
     *         <p>
     *         See also <a href=
     *         "http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization"
     *         >Customizing User Invitation Messages</a>.
     */
    public MessageTemplateType inviteMessageTemplate() {
        return inviteMessageTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowAdminCreateUserOnly());
        hashCode = 31 * hashCode + Objects.hashCode(unusedAccountValidityDays());
        hashCode = 31 * hashCode + Objects.hashCode(inviteMessageTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminCreateUserConfigType)) {
            return false;
        }
        AdminCreateUserConfigType other = (AdminCreateUserConfigType) obj;
        return Objects.equals(allowAdminCreateUserOnly(), other.allowAdminCreateUserOnly())
                && Objects.equals(unusedAccountValidityDays(), other.unusedAccountValidityDays())
                && Objects.equals(inviteMessageTemplate(), other.inviteMessageTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AdminCreateUserConfigType").add("AllowAdminCreateUserOnly", allowAdminCreateUserOnly())
                .add("UnusedAccountValidityDays", unusedAccountValidityDays())
                .add("InviteMessageTemplate", inviteMessageTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowAdminCreateUserOnly":
            return Optional.ofNullable(clazz.cast(allowAdminCreateUserOnly()));
        case "UnusedAccountValidityDays":
            return Optional.ofNullable(clazz.cast(unusedAccountValidityDays()));
        case "InviteMessageTemplate":
            return Optional.ofNullable(clazz.cast(inviteMessageTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminCreateUserConfigType, T> g) {
        return obj -> g.apply((AdminCreateUserConfigType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdminCreateUserConfigType> {
        /**
         * <p>
         * Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to
         * <code>False</code> if users can sign themselves up via an app.
         * </p>
         * 
         * @param allowAdminCreateUserOnly
         *        Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to
         *        <code>False</code> if users can sign themselves up via an app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAdminCreateUserOnly(Boolean allowAdminCreateUserOnly);

        /**
         * <p>
         * The user account expiration limit, in days, after which the account is no longer usable. To reset the account
         * after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for
         * the <code>MessageAction</code> parameter. The default value for this parameter is 7.
         * </p>
         * <note>
         * <p>
         * If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code>, that value
         * will be used and <code>UnusedAccountValidityDays</code> will be deprecated for that user pool.
         * </p>
         * </note>
         * 
         * @param unusedAccountValidityDays
         *        The user account expiration limit, in days, after which the account is no longer usable. To reset the
         *        account after that time limit, you must call <code>AdminCreateUser</code> again, specifying
         *        <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this
         *        parameter is 7. </p> <note>
         *        <p>
         *        If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code>, that
         *        value will be used and <code>UnusedAccountValidityDays</code> will be deprecated for that user pool.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedAccountValidityDays(Integer unusedAccountValidityDays);

        /**
         * <p>
         * The message template to be used for the welcome message to new users.
         * </p>
         * <p>
         * See also <a href=
         * "http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization"
         * >Customizing User Invitation Messages</a>.
         * </p>
         * 
         * @param inviteMessageTemplate
         *        The message template to be used for the welcome message to new users.</p>
         *        <p>
         *        See also <a href=
         *        "http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization"
         *        >Customizing User Invitation Messages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inviteMessageTemplate(MessageTemplateType inviteMessageTemplate);

        /**
         * <p>
         * The message template to be used for the welcome message to new users.
         * </p>
         * <p>
         * See also <a href=
         * "http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization"
         * >Customizing User Invitation Messages</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link MessageTemplateType.Builder} avoiding the need
         * to create one manually via {@link MessageTemplateType#builder()}.
         *
         * When the {@link Consumer} completes, {@link MessageTemplateType.Builder#build()} is called immediately and
         * its result is passed to {@link #inviteMessageTemplate(MessageTemplateType)}.
         * 
         * @param inviteMessageTemplate
         *        a consumer that will call methods on {@link MessageTemplateType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inviteMessageTemplate(MessageTemplateType)
         */
        default Builder inviteMessageTemplate(Consumer<MessageTemplateType.Builder> inviteMessageTemplate) {
            return inviteMessageTemplate(MessageTemplateType.builder().applyMutation(inviteMessageTemplate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowAdminCreateUserOnly;

        private Integer unusedAccountValidityDays;

        private MessageTemplateType inviteMessageTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminCreateUserConfigType model) {
            allowAdminCreateUserOnly(model.allowAdminCreateUserOnly);
            unusedAccountValidityDays(model.unusedAccountValidityDays);
            inviteMessageTemplate(model.inviteMessageTemplate);
        }

        public final Boolean getAllowAdminCreateUserOnly() {
            return allowAdminCreateUserOnly;
        }

        @Override
        public final Builder allowAdminCreateUserOnly(Boolean allowAdminCreateUserOnly) {
            this.allowAdminCreateUserOnly = allowAdminCreateUserOnly;
            return this;
        }

        public final void setAllowAdminCreateUserOnly(Boolean allowAdminCreateUserOnly) {
            this.allowAdminCreateUserOnly = allowAdminCreateUserOnly;
        }

        public final Integer getUnusedAccountValidityDays() {
            return unusedAccountValidityDays;
        }

        @Override
        public final Builder unusedAccountValidityDays(Integer unusedAccountValidityDays) {
            this.unusedAccountValidityDays = unusedAccountValidityDays;
            return this;
        }

        public final void setUnusedAccountValidityDays(Integer unusedAccountValidityDays) {
            this.unusedAccountValidityDays = unusedAccountValidityDays;
        }

        public final MessageTemplateType.Builder getInviteMessageTemplate() {
            return inviteMessageTemplate != null ? inviteMessageTemplate.toBuilder() : null;
        }

        @Override
        public final Builder inviteMessageTemplate(MessageTemplateType inviteMessageTemplate) {
            this.inviteMessageTemplate = inviteMessageTemplate;
            return this;
        }

        public final void setInviteMessageTemplate(MessageTemplateType.BuilderImpl inviteMessageTemplate) {
            this.inviteMessageTemplate = inviteMessageTemplate != null ? inviteMessageTemplate.build() : null;
        }

        @Override
        public AdminCreateUserConfigType build() {
            return new AdminCreateUserConfigType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
