/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to list users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUsersRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<ListUsersRequest.Builder, ListUsersRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUsersRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListUsersRequest::attributesToGet))
            .setter(setter(Builder::attributesToGet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListUsersRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUsersRequest::paginationToken)).setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUsersRequest::filter)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            ATTRIBUTES_TO_GET_FIELD, LIMIT_FIELD, PAGINATION_TOKEN_FIELD, FILTER_FIELD));

    private final String userPoolId;

    private final List<String> attributesToGet;

    private final Integer limit;

    private final String paginationToken;

    private final String filter;

    private ListUsersRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.paginationToken = builder.paginationToken;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The user pool ID for the user pool on which the search should be performed.
     * </p>
     * 
     * @return The user pool ID for the user pool on which the search should be performed.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * An array of strings, where each string is the name of a user attribute to be returned for each user in the search
     * results. If the array is null, all attributes are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of strings, where each string is the name of a user attribute to be returned for each user in
     *         the search results. If the array is null, all attributes are returned.
     */
    public List<String> attributesToGet() {
        return attributesToGet;
    }

    /**
     * <p>
     * Maximum number of users to be returned.
     * </p>
     * 
     * @return Maximum number of users to be returned.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String paginationToken() {
        return paginationToken;
    }

    /**
     * <p>
     * A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation marks
     * within the filter string must be escaped using the backslash (\) character. For example, "
     * <code>family_name</code> = \"Reddy\"".
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \"Jon\"". For a prefix
     * ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \"Jon\"".
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>AttributeValue</i>: The attribute value that must be matched for each user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.
     * </p>
     * <p>
     * You can only search for the following standard attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>username</code> (case-sensitive)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>email</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>phone_number</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>given_name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>family_name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>preferred_username</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sub</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Custom attributes are not searchable.
     * </p>
     * <p>
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api"
     * >Searching for Users Using the ListUsers API</a> and <a href=
     * "http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples"
     * >Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * 
     * @return A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation
     *         marks within the filter string must be escaped using the backslash (\) character. For example, "
     *         <code>family_name</code> = \"Reddy\"".</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a
     *         time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \"Jon\"". For a
     *         prefix ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \"Jon\"".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>AttributeValue</i>: The attribute value that must be matched for each user.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.
     *         </p>
     *         <p>
     *         You can only search for the following standard attributes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>username</code> (case-sensitive)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>email</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>phone_number</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>given_name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>family_name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>preferred_username</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sub</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Custom attributes are not searchable.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api"
     *         >Searching for Users Using the ListUsers API</a> and <a href=
     *         "http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples"
     *         >Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.
     */
    public String filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(attributesToGet());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersRequest)) {
            return false;
        }
        ListUsersRequest other = (ListUsersRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(attributesToGet(), other.attributesToGet())
                && Objects.equals(limit(), other.limit()) && Objects.equals(paginationToken(), other.paginationToken())
                && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListUsersRequest").add("UserPoolId", userPoolId()).add("AttributesToGet", attributesToGet())
                .add("Limit", limit()).add("PaginationToken", paginationToken()).add("Filter", filter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "AttributesToGet":
            return Optional.ofNullable(clazz.cast(attributesToGet()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUsersRequest, T> g) {
        return obj -> g.apply((ListUsersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListUsersRequest> {
        /**
         * <p>
         * The user pool ID for the user pool on which the search should be performed.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool on which the search should be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * An array of strings, where each string is the name of a user attribute to be returned for each user in the
         * search results. If the array is null, all attributes are returned.
         * </p>
         * 
         * @param attributesToGet
         *        An array of strings, where each string is the name of a user attribute to be returned for each user in
         *        the search results. If the array is null, all attributes are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(Collection<String> attributesToGet);

        /**
         * <p>
         * An array of strings, where each string is the name of a user attribute to be returned for each user in the
         * search results. If the array is null, all attributes are returned.
         * </p>
         * 
         * @param attributesToGet
         *        An array of strings, where each string is the name of a user attribute to be returned for each user in
         *        the search results. If the array is null, all attributes are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(String... attributesToGet);

        /**
         * <p>
         * Maximum number of users to be returned.
         * </p>
         * 
         * @param limit
         *        Maximum number of users to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param paginationToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);

        /**
         * <p>
         * A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation
         * marks within the filter string must be escaped using the backslash (\) character. For example, "
         * <code>family_name</code> = \"Reddy\"".
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a
         * time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \"Jon\"". For a prefix
         * ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \"Jon\"".
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>AttributeValue</i>: The attribute value that must be matched for each user.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.
         * </p>
         * <p>
         * You can only search for the following standard attributes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>username</code> (case-sensitive)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>email</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>phone_number</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>given_name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>family_name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>preferred_username</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sub</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Custom attributes are not searchable.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api"
         * >Searching for Users Using the ListUsers API</a> and <a href=
         * "http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples"
         * >Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.
         * </p>
         * 
         * @param filter
         *        A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"".
         *        Quotation marks within the filter string must be escaped using the backslash (\) character. For
         *        example, "<code>family_name</code> = \"Reddy\"".</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute
         *        at a time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \"Jon\"". For a
         *        prefix ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \"Jon\"".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>AttributeValue</i>: The attribute value that must be matched for each user.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.
         *        </p>
         *        <p>
         *        You can only search for the following standard attributes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>username</code> (case-sensitive)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>email</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>phone_number</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>given_name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>family_name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>preferred_username</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sub</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Custom attributes are not searchable.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api"
         *        >Searching for Users Using the ListUsers API</a> and <a href=
         *        "http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples"
         *        >Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(String filter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String paginationToken;

        private String filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            attributesToGet(model.attributesToGet);
            limit(model.limit);
            paginationToken(model.paginationToken);
            filter(model.filter);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final Collection<String> getAttributesToGet() {
            return attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = SearchedAttributeNamesListTypeCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String... attributesToGet) {
            attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = SearchedAttributeNamesListTypeCopier.copy(attributesToGet);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        public final String getFilter() {
            return filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListUsersRequest build() {
            return new ListUsersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
