/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceRememberedStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDeviceStatusRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, UpdateDeviceStatusRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDeviceStatusRequest.getter(UpdateDeviceStatusRequest::accessToken)).setter(UpdateDeviceStatusRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final SdkField<String> DEVICE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDeviceStatusRequest.getter(UpdateDeviceStatusRequest::deviceKey)).setter(UpdateDeviceStatusRequest.setter(Builder::deviceKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceKey").build()}).build();
    private static final SdkField<String> DEVICE_REMEMBERED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDeviceStatusRequest.getter(UpdateDeviceStatusRequest::deviceRememberedStatusAsString)).setter(UpdateDeviceStatusRequest.setter(Builder::deviceRememberedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceRememberedStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, DEVICE_KEY_FIELD, DEVICE_REMEMBERED_STATUS_FIELD));
    private final String accessToken;
    private final String deviceKey;
    private final String deviceRememberedStatus;

    private UpdateDeviceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.deviceKey = builder.deviceKey;
        this.deviceRememberedStatus = builder.deviceRememberedStatus;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public String deviceKey() {
        return this.deviceKey;
    }

    public DeviceRememberedStatusType deviceRememberedStatus() {
        return DeviceRememberedStatusType.fromValue(this.deviceRememberedStatus);
    }

    public String deviceRememberedStatusAsString() {
        return this.deviceRememberedStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceRememberedStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceStatusRequest)) {
            return false;
        }
        UpdateDeviceStatusRequest other = (UpdateDeviceStatusRequest)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.deviceKey(), other.deviceKey()) && Objects.equals(this.deviceRememberedStatusAsString(), other.deviceRememberedStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDeviceStatusRequest").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("DeviceKey", (Object)this.deviceKey()).add("DeviceRememberedStatus", (Object)this.deviceRememberedStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "DeviceKey": {
                return Optional.ofNullable(clazz.cast(this.deviceKey()));
            }
            case "DeviceRememberedStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceRememberedStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceStatusRequest, T> g) {
        return obj -> g.apply((UpdateDeviceStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String accessToken;
        private String deviceKey;
        private String deviceRememberedStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceStatusRequest model) {
            super(model);
            this.accessToken(model.accessToken);
            this.deviceKey(model.deviceKey);
            this.deviceRememberedStatus(model.deviceRememberedStatus);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getDeviceKey() {
            return this.deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final String getDeviceRememberedStatusAsString() {
            return this.deviceRememberedStatus;
        }

        @Override
        public final Builder deviceRememberedStatus(String deviceRememberedStatus) {
            this.deviceRememberedStatus = deviceRememberedStatus;
            return this;
        }

        @Override
        public final Builder deviceRememberedStatus(DeviceRememberedStatusType deviceRememberedStatus) {
            this.deviceRememberedStatus(deviceRememberedStatus.toString());
            return this;
        }

        public final void setDeviceRememberedStatus(String deviceRememberedStatus) {
            this.deviceRememberedStatus = deviceRememberedStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeviceStatusRequest build() {
            return new UpdateDeviceStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDeviceStatusRequest> {
        public Builder accessToken(String var1);

        public Builder deviceKey(String var1);

        public Builder deviceRememberedStatus(String var1);

        public Builder deviceRememberedStatus(DeviceRememberedStatusType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

