/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for information about the user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPoolType implements SdkPojo, Serializable, ToCopyableBuilder<UserPoolType.Builder, UserPoolType> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<UserPoolPolicyType> POLICIES_FIELD = SdkField
            .<UserPoolPolicyType> builder(MarshallingType.SDK_POJO).getter(getter(UserPoolType::policies))
            .setter(setter(Builder::policies)).constructor(UserPoolPolicyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()).build();

    private static final SdkField<LambdaConfigType> LAMBDA_CONFIG_FIELD = SdkField
            .<LambdaConfigType> builder(MarshallingType.SDK_POJO).getter(getter(UserPoolType::lambdaConfig))
            .setter(setter(Builder::lambdaConfig)).constructor(LambdaConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaConfig").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UserPoolType::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UserPoolType::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<List<SchemaAttributeType>> SCHEMA_ATTRIBUTES_FIELD = SdkField
            .<List<SchemaAttributeType>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolType::schemaAttributes))
            .setter(setter(Builder::schemaAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaAttributeType> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaAttributeType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTO_VERIFIED_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolType::autoVerifiedAttributesAsStrings))
            .setter(setter(Builder::autoVerifiedAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoVerifiedAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALIAS_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolType::aliasAttributesAsStrings))
            .setter(setter(Builder::aliasAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USERNAME_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UserPoolType::usernameAttributesAsStrings))
            .setter(setter(Builder::usernameAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SMS_VERIFICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::smsVerificationMessage)).setter(setter(Builder::smsVerificationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsVerificationMessage").build())
            .build();

    private static final SdkField<String> EMAIL_VERIFICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::emailVerificationMessage)).setter(setter(Builder::emailVerificationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationMessage").build())
            .build();

    private static final SdkField<String> EMAIL_VERIFICATION_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::emailVerificationSubject)).setter(setter(Builder::emailVerificationSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationSubject").build())
            .build();

    private static final SdkField<VerificationMessageTemplateType> VERIFICATION_MESSAGE_TEMPLATE_FIELD = SdkField
            .<VerificationMessageTemplateType> builder(MarshallingType.SDK_POJO)
            .getter(getter(UserPoolType::verificationMessageTemplate))
            .setter(setter(Builder::verificationMessageTemplate))
            .constructor(VerificationMessageTemplateType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationMessageTemplate")
                    .build()).build();

    private static final SdkField<String> SMS_AUTHENTICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::smsAuthenticationMessage)).setter(setter(Builder::smsAuthenticationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsAuthenticationMessage").build())
            .build();

    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::mfaConfigurationAsString)).setter(setter(Builder::mfaConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()).build();

    private static final SdkField<DeviceConfigurationType> DEVICE_CONFIGURATION_FIELD = SdkField
            .<DeviceConfigurationType> builder(MarshallingType.SDK_POJO).getter(getter(UserPoolType::deviceConfiguration))
            .setter(setter(Builder::deviceConfiguration)).constructor(DeviceConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConfiguration").build())
            .build();

    private static final SdkField<Integer> ESTIMATED_NUMBER_OF_USERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UserPoolType::estimatedNumberOfUsers)).setter(setter(Builder::estimatedNumberOfUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedNumberOfUsers").build())
            .build();

    private static final SdkField<EmailConfigurationType> EMAIL_CONFIGURATION_FIELD = SdkField
            .<EmailConfigurationType> builder(MarshallingType.SDK_POJO).getter(getter(UserPoolType::emailConfiguration))
            .setter(setter(Builder::emailConfiguration)).constructor(EmailConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailConfiguration").build())
            .build();

    private static final SdkField<SmsConfigurationType> SMS_CONFIGURATION_FIELD = SdkField
            .<SmsConfigurationType> builder(MarshallingType.SDK_POJO).getter(getter(UserPoolType::smsConfiguration))
            .setter(setter(Builder::smsConfiguration)).constructor(SmsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsConfiguration").build()).build();

    private static final SdkField<Map<String, String>> USER_POOL_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(UserPoolType::userPoolTags))
            .setter(setter(Builder::userPoolTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SMS_CONFIGURATION_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::smsConfigurationFailure)).setter(setter(Builder::smsConfigurationFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsConfigurationFailure").build())
            .build();

    private static final SdkField<String> EMAIL_CONFIGURATION_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::emailConfigurationFailure)).setter(setter(Builder::emailConfigurationFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailConfigurationFailure").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::customDomain)).setter(setter(Builder::customDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomain").build()).build();

    private static final SdkField<AdminCreateUserConfigType> ADMIN_CREATE_USER_CONFIG_FIELD = SdkField
            .<AdminCreateUserConfigType> builder(MarshallingType.SDK_POJO).getter(getter(UserPoolType::adminCreateUserConfig))
            .setter(setter(Builder::adminCreateUserConfig)).constructor(AdminCreateUserConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminCreateUserConfig").build())
            .build();

    private static final SdkField<UserPoolAddOnsType> USER_POOL_ADD_ONS_FIELD = SdkField
            .<UserPoolAddOnsType> builder(MarshallingType.SDK_POJO).getter(getter(UserPoolType::userPoolAddOns))
            .setter(setter(Builder::userPoolAddOns)).constructor(UserPoolAddOnsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolAddOns").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserPoolType::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            POLICIES_FIELD, LAMBDA_CONFIG_FIELD, STATUS_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD,
            SCHEMA_ATTRIBUTES_FIELD, AUTO_VERIFIED_ATTRIBUTES_FIELD, ALIAS_ATTRIBUTES_FIELD, USERNAME_ATTRIBUTES_FIELD,
            SMS_VERIFICATION_MESSAGE_FIELD, EMAIL_VERIFICATION_MESSAGE_FIELD, EMAIL_VERIFICATION_SUBJECT_FIELD,
            VERIFICATION_MESSAGE_TEMPLATE_FIELD, SMS_AUTHENTICATION_MESSAGE_FIELD, MFA_CONFIGURATION_FIELD,
            DEVICE_CONFIGURATION_FIELD, ESTIMATED_NUMBER_OF_USERS_FIELD, EMAIL_CONFIGURATION_FIELD, SMS_CONFIGURATION_FIELD,
            USER_POOL_TAGS_FIELD, SMS_CONFIGURATION_FAILURE_FIELD, EMAIL_CONFIGURATION_FAILURE_FIELD, DOMAIN_FIELD,
            CUSTOM_DOMAIN_FIELD, ADMIN_CREATE_USER_CONFIG_FIELD, USER_POOL_ADD_ONS_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final UserPoolPolicyType policies;

    private final LambdaConfigType lambdaConfig;

    private final String status;

    private final Instant lastModifiedDate;

    private final Instant creationDate;

    private final List<SchemaAttributeType> schemaAttributes;

    private final List<String> autoVerifiedAttributes;

    private final List<String> aliasAttributes;

    private final List<String> usernameAttributes;

    private final String smsVerificationMessage;

    private final String emailVerificationMessage;

    private final String emailVerificationSubject;

    private final VerificationMessageTemplateType verificationMessageTemplate;

    private final String smsAuthenticationMessage;

    private final String mfaConfiguration;

    private final DeviceConfigurationType deviceConfiguration;

    private final Integer estimatedNumberOfUsers;

    private final EmailConfigurationType emailConfiguration;

    private final SmsConfigurationType smsConfiguration;

    private final Map<String, String> userPoolTags;

    private final String smsConfigurationFailure;

    private final String emailConfigurationFailure;

    private final String domain;

    private final String customDomain;

    private final AdminCreateUserConfigType adminCreateUserConfig;

    private final UserPoolAddOnsType userPoolAddOns;

    private final String arn;

    private UserPoolType(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.policies = builder.policies;
        this.lambdaConfig = builder.lambdaConfig;
        this.status = builder.status;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
        this.schemaAttributes = builder.schemaAttributes;
        this.autoVerifiedAttributes = builder.autoVerifiedAttributes;
        this.aliasAttributes = builder.aliasAttributes;
        this.usernameAttributes = builder.usernameAttributes;
        this.smsVerificationMessage = builder.smsVerificationMessage;
        this.emailVerificationMessage = builder.emailVerificationMessage;
        this.emailVerificationSubject = builder.emailVerificationSubject;
        this.verificationMessageTemplate = builder.verificationMessageTemplate;
        this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
        this.mfaConfiguration = builder.mfaConfiguration;
        this.deviceConfiguration = builder.deviceConfiguration;
        this.estimatedNumberOfUsers = builder.estimatedNumberOfUsers;
        this.emailConfiguration = builder.emailConfiguration;
        this.smsConfiguration = builder.smsConfiguration;
        this.userPoolTags = builder.userPoolTags;
        this.smsConfigurationFailure = builder.smsConfigurationFailure;
        this.emailConfigurationFailure = builder.emailConfigurationFailure;
        this.domain = builder.domain;
        this.customDomain = builder.customDomain;
        this.adminCreateUserConfig = builder.adminCreateUserConfig;
        this.userPoolAddOns = builder.userPoolAddOns;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ID of the user pool.
     * </p>
     * 
     * @return The ID of the user pool.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the user pool.
     * </p>
     * 
     * @return The name of the user pool.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The policies associated with the user pool.
     * </p>
     * 
     * @return The policies associated with the user pool.
     */
    public UserPoolPolicyType policies() {
        return policies;
    }

    /**
     * <p>
     * The AWS Lambda triggers associated with the user pool.
     * </p>
     * 
     * @return The AWS Lambda triggers associated with the user pool.
     */
    public LambdaConfigType lambdaConfig() {
        return lambdaConfig;
    }

    /**
     * <p>
     * The status of a user pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a user pool.
     * @see StatusType
     */
    public StatusType status() {
        return StatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of a user pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a user pool.
     * @see StatusType
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date the user pool was last modified.
     * </p>
     * 
     * @return The date the user pool was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The date the user pool was created.
     * </p>
     * 
     * @return The date the user pool was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * A container with the schema attributes of a user pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A container with the schema attributes of a user pool.
     */
    public List<SchemaAttributeType> schemaAttributes() {
        return schemaAttributes;
    }

    /**
     * <p>
     * Specifies the attributes that are auto-verified in a user pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the attributes that are auto-verified in a user pool.
     */
    public List<VerifiedAttributeType> autoVerifiedAttributes() {
        return VerifiedAttributesListTypeCopier.copyStringToEnum(autoVerifiedAttributes);
    }

    /**
     * <p>
     * Specifies the attributes that are auto-verified in a user pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the attributes that are auto-verified in a user pool.
     */
    public List<String> autoVerifiedAttributesAsStrings() {
        return autoVerifiedAttributes;
    }

    /**
     * <p>
     * Specifies the attributes that are aliased in a user pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the attributes that are aliased in a user pool.
     */
    public List<AliasAttributeType> aliasAttributes() {
        return AliasAttributesListTypeCopier.copyStringToEnum(aliasAttributes);
    }

    /**
     * <p>
     * Specifies the attributes that are aliased in a user pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the attributes that are aliased in a user pool.
     */
    public List<String> aliasAttributesAsStrings() {
        return aliasAttributes;
    }

    /**
     * <p>
     * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
     */
    public List<UsernameAttributeType> usernameAttributes() {
        return UsernameAttributesListTypeCopier.copyStringToEnum(usernameAttributes);
    }

    /**
     * <p>
     * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
     */
    public List<String> usernameAttributesAsStrings() {
        return usernameAttributes;
    }

    /**
     * <p>
     * The contents of the SMS verification message.
     * </p>
     * 
     * @return The contents of the SMS verification message.
     */
    public String smsVerificationMessage() {
        return smsVerificationMessage;
    }

    /**
     * <p>
     * The contents of the email verification message.
     * </p>
     * 
     * @return The contents of the email verification message.
     */
    public String emailVerificationMessage() {
        return emailVerificationMessage;
    }

    /**
     * <p>
     * The subject of the email verification message.
     * </p>
     * 
     * @return The subject of the email verification message.
     */
    public String emailVerificationSubject() {
        return emailVerificationSubject;
    }

    /**
     * <p>
     * The template for verification messages.
     * </p>
     * 
     * @return The template for verification messages.
     */
    public VerificationMessageTemplateType verificationMessageTemplate() {
        return verificationMessageTemplate;
    }

    /**
     * <p>
     * The contents of the SMS authentication message.
     * </p>
     * 
     * @return The contents of the SMS authentication message.
     */
    public String smsAuthenticationMessage() {
        return smsAuthenticationMessage;
    }

    /**
     * <p>
     * Can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you are
     * initially creating a user pool.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return Can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when
     *         you are initially creating a user pool.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
     *         </p>
     *         </li>
     * @see UserPoolMfaType
     */
    public UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(mfaConfiguration);
    }

    /**
     * <p>
     * Can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you are
     * initially creating a user pool.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return Can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when
     *         you are initially creating a user pool.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
     *         </p>
     *         </li>
     * @see UserPoolMfaType
     */
    public String mfaConfigurationAsString() {
        return mfaConfiguration;
    }

    /**
     * <p>
     * The device configuration.
     * </p>
     * 
     * @return The device configuration.
     */
    public DeviceConfigurationType deviceConfiguration() {
        return deviceConfiguration;
    }

    /**
     * <p>
     * A number estimating the size of the user pool.
     * </p>
     * 
     * @return A number estimating the size of the user pool.
     */
    public Integer estimatedNumberOfUsers() {
        return estimatedNumberOfUsers;
    }

    /**
     * <p>
     * The email configuration.
     * </p>
     * 
     * @return The email configuration.
     */
    public EmailConfigurationType emailConfiguration() {
        return emailConfiguration;
    }

    /**
     * <p>
     * The SMS configuration.
     * </p>
     * 
     * @return The SMS configuration.
     */
    public SmsConfigurationType smsConfiguration() {
        return smsConfiguration;
    }

    /**
     * <p>
     * The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize and
     * manage them in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to
     *         categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     */
    public Map<String, String> userPoolTags() {
        return userPoolTags;
    }

    /**
     * <p>
     * The reason why the SMS configuration cannot send the messages to your users.
     * </p>
     * 
     * @return The reason why the SMS configuration cannot send the messages to your users.
     */
    public String smsConfigurationFailure() {
        return smsConfigurationFailure;
    }

    /**
     * <p>
     * The reason why the email configuration cannot send the messages to your users.
     * </p>
     * 
     * @return The reason why the email configuration cannot send the messages to your users.
     */
    public String emailConfigurationFailure() {
        return emailConfigurationFailure;
    }

    /**
     * <p>
     * Holds the domain prefix if the user pool has a domain associated with it.
     * </p>
     * 
     * @return Holds the domain prefix if the user pool has a domain associated with it.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain
     * to host the sign-up and sign-in pages for your application. For example: <code>auth.example.com</code>.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using
     * Your Own Domain for the Hosted UI</a>.
     * </p>
     * 
     * @return A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom
     *         domain to host the sign-up and sign-in pages for your application. For example:
     *         <code>auth.example.com</code>.</p>
     *         <p>
     *         For more information about adding a custom domain to your user pool, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html"
     *         >Using Your Own Domain for the Hosted UI</a>.
     */
    public String customDomain() {
        return customDomain;
    }

    /**
     * <p>
     * The configuration for <code>AdminCreateUser</code> requests.
     * </p>
     * 
     * @return The configuration for <code>AdminCreateUser</code> requests.
     */
    public AdminCreateUserConfigType adminCreateUserConfig() {
        return adminCreateUserConfig;
    }

    /**
     * <p>
     * The user pool add-ons.
     * </p>
     * 
     * @return The user pool add-ons.
     */
    public UserPoolAddOnsType userPoolAddOns() {
        return userPoolAddOns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the user pool.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the user pool.
     */
    public String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(schemaAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(autoVerifiedAttributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(aliasAttributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(usernameAttributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(smsVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailVerificationSubject());
        hashCode = 31 * hashCode + Objects.hashCode(verificationMessageTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(smsAuthenticationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(mfaConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedNumberOfUsers());
        hashCode = 31 * hashCode + Objects.hashCode(emailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(smsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolTags());
        hashCode = 31 * hashCode + Objects.hashCode(smsConfigurationFailure());
        hashCode = 31 * hashCode + Objects.hashCode(emailConfigurationFailure());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(customDomain());
        hashCode = 31 * hashCode + Objects.hashCode(adminCreateUserConfig());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolAddOns());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolType)) {
            return false;
        }
        UserPoolType other = (UserPoolType) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(policies(), other.policies()) && Objects.equals(lambdaConfig(), other.lambdaConfig())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(schemaAttributes(), other.schemaAttributes())
                && Objects.equals(autoVerifiedAttributesAsStrings(), other.autoVerifiedAttributesAsStrings())
                && Objects.equals(aliasAttributesAsStrings(), other.aliasAttributesAsStrings())
                && Objects.equals(usernameAttributesAsStrings(), other.usernameAttributesAsStrings())
                && Objects.equals(smsVerificationMessage(), other.smsVerificationMessage())
                && Objects.equals(emailVerificationMessage(), other.emailVerificationMessage())
                && Objects.equals(emailVerificationSubject(), other.emailVerificationSubject())
                && Objects.equals(verificationMessageTemplate(), other.verificationMessageTemplate())
                && Objects.equals(smsAuthenticationMessage(), other.smsAuthenticationMessage())
                && Objects.equals(mfaConfigurationAsString(), other.mfaConfigurationAsString())
                && Objects.equals(deviceConfiguration(), other.deviceConfiguration())
                && Objects.equals(estimatedNumberOfUsers(), other.estimatedNumberOfUsers())
                && Objects.equals(emailConfiguration(), other.emailConfiguration())
                && Objects.equals(smsConfiguration(), other.smsConfiguration())
                && Objects.equals(userPoolTags(), other.userPoolTags())
                && Objects.equals(smsConfigurationFailure(), other.smsConfigurationFailure())
                && Objects.equals(emailConfigurationFailure(), other.emailConfigurationFailure())
                && Objects.equals(domain(), other.domain()) && Objects.equals(customDomain(), other.customDomain())
                && Objects.equals(adminCreateUserConfig(), other.adminCreateUserConfig())
                && Objects.equals(userPoolAddOns(), other.userPoolAddOns()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UserPoolType").add("Id", id()).add("Name", name()).add("Policies", policies())
                .add("LambdaConfig", lambdaConfig()).add("Status", statusAsString()).add("LastModifiedDate", lastModifiedDate())
                .add("CreationDate", creationDate()).add("SchemaAttributes", schemaAttributes())
                .add("AutoVerifiedAttributes", autoVerifiedAttributesAsStrings())
                .add("AliasAttributes", aliasAttributesAsStrings()).add("UsernameAttributes", usernameAttributesAsStrings())
                .add("SmsVerificationMessage", smsVerificationMessage())
                .add("EmailVerificationMessage", emailVerificationMessage())
                .add("EmailVerificationSubject", emailVerificationSubject())
                .add("VerificationMessageTemplate", verificationMessageTemplate())
                .add("SmsAuthenticationMessage", smsAuthenticationMessage()).add("MfaConfiguration", mfaConfigurationAsString())
                .add("DeviceConfiguration", deviceConfiguration()).add("EstimatedNumberOfUsers", estimatedNumberOfUsers())
                .add("EmailConfiguration", emailConfiguration()).add("SmsConfiguration", smsConfiguration())
                .add("UserPoolTags", userPoolTags()).add("SmsConfigurationFailure", smsConfigurationFailure())
                .add("EmailConfigurationFailure", emailConfigurationFailure()).add("Domain", domain())
                .add("CustomDomain", customDomain()).add("AdminCreateUserConfig", adminCreateUserConfig())
                .add("UserPoolAddOns", userPoolAddOns()).add("Arn", arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "LambdaConfig":
            return Optional.ofNullable(clazz.cast(lambdaConfig()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "SchemaAttributes":
            return Optional.ofNullable(clazz.cast(schemaAttributes()));
        case "AutoVerifiedAttributes":
            return Optional.ofNullable(clazz.cast(autoVerifiedAttributesAsStrings()));
        case "AliasAttributes":
            return Optional.ofNullable(clazz.cast(aliasAttributesAsStrings()));
        case "UsernameAttributes":
            return Optional.ofNullable(clazz.cast(usernameAttributesAsStrings()));
        case "SmsVerificationMessage":
            return Optional.ofNullable(clazz.cast(smsVerificationMessage()));
        case "EmailVerificationMessage":
            return Optional.ofNullable(clazz.cast(emailVerificationMessage()));
        case "EmailVerificationSubject":
            return Optional.ofNullable(clazz.cast(emailVerificationSubject()));
        case "VerificationMessageTemplate":
            return Optional.ofNullable(clazz.cast(verificationMessageTemplate()));
        case "SmsAuthenticationMessage":
            return Optional.ofNullable(clazz.cast(smsAuthenticationMessage()));
        case "MfaConfiguration":
            return Optional.ofNullable(clazz.cast(mfaConfigurationAsString()));
        case "DeviceConfiguration":
            return Optional.ofNullable(clazz.cast(deviceConfiguration()));
        case "EstimatedNumberOfUsers":
            return Optional.ofNullable(clazz.cast(estimatedNumberOfUsers()));
        case "EmailConfiguration":
            return Optional.ofNullable(clazz.cast(emailConfiguration()));
        case "SmsConfiguration":
            return Optional.ofNullable(clazz.cast(smsConfiguration()));
        case "UserPoolTags":
            return Optional.ofNullable(clazz.cast(userPoolTags()));
        case "SmsConfigurationFailure":
            return Optional.ofNullable(clazz.cast(smsConfigurationFailure()));
        case "EmailConfigurationFailure":
            return Optional.ofNullable(clazz.cast(emailConfigurationFailure()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "CustomDomain":
            return Optional.ofNullable(clazz.cast(customDomain()));
        case "AdminCreateUserConfig":
            return Optional.ofNullable(clazz.cast(adminCreateUserConfig()));
        case "UserPoolAddOns":
            return Optional.ofNullable(clazz.cast(userPoolAddOns()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPoolType, T> g) {
        return obj -> g.apply((UserPoolType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPoolType> {
        /**
         * <p>
         * The ID of the user pool.
         * </p>
         * 
         * @param id
         *        The ID of the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the user pool.
         * </p>
         * 
         * @param name
         *        The name of the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The policies associated with the user pool.
         * </p>
         * 
         * @param policies
         *        The policies associated with the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(UserPoolPolicyType policies);

        /**
         * <p>
         * The policies associated with the user pool.
         * </p>
         * This is a convenience that creates an instance of the {@link UserPoolPolicyType.Builder} avoiding the need to
         * create one manually via {@link UserPoolPolicyType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPoolPolicyType.Builder#build()} is called immediately and its
         * result is passed to {@link #policies(UserPoolPolicyType)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link UserPoolPolicyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(UserPoolPolicyType)
         */
        default Builder policies(Consumer<UserPoolPolicyType.Builder> policies) {
            return policies(UserPoolPolicyType.builder().applyMutation(policies).build());
        }

        /**
         * <p>
         * The AWS Lambda triggers associated with the user pool.
         * </p>
         * 
         * @param lambdaConfig
         *        The AWS Lambda triggers associated with the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaConfig(LambdaConfigType lambdaConfig);

        /**
         * <p>
         * The AWS Lambda triggers associated with the user pool.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaConfigType.Builder} avoiding the need to
         * create one manually via {@link LambdaConfigType#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaConfigType.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaConfig(LambdaConfigType)}.
         * 
         * @param lambdaConfig
         *        a consumer that will call methods on {@link LambdaConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaConfig(LambdaConfigType)
         */
        default Builder lambdaConfig(Consumer<LambdaConfigType.Builder> lambdaConfig) {
            return lambdaConfig(LambdaConfigType.builder().applyMutation(lambdaConfig).build());
        }

        /**
         * <p>
         * The status of a user pool.
         * </p>
         * 
         * @param status
         *        The status of a user pool.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a user pool.
         * </p>
         * 
         * @param status
         *        The status of a user pool.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(StatusType status);

        /**
         * <p>
         * The date the user pool was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the user pool was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The date the user pool was created.
         * </p>
         * 
         * @param creationDate
         *        The date the user pool was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * A container with the schema attributes of a user pool.
         * </p>
         * 
         * @param schemaAttributes
         *        A container with the schema attributes of a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaAttributes(Collection<SchemaAttributeType> schemaAttributes);

        /**
         * <p>
         * A container with the schema attributes of a user pool.
         * </p>
         * 
         * @param schemaAttributes
         *        A container with the schema attributes of a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaAttributes(SchemaAttributeType... schemaAttributes);

        /**
         * <p>
         * A container with the schema attributes of a user pool.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SchemaAttributeType>.Builder} avoiding the
         * need to create one manually via {@link List<SchemaAttributeType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SchemaAttributeType>.Builder#build()} is called immediately
         * and its result is passed to {@link #schemaAttributes(List<SchemaAttributeType>)}.
         * 
         * @param schemaAttributes
         *        a consumer that will call methods on {@link List<SchemaAttributeType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaAttributes(List<SchemaAttributeType>)
         */
        Builder schemaAttributes(Consumer<SchemaAttributeType.Builder>... schemaAttributes);

        /**
         * <p>
         * Specifies the attributes that are auto-verified in a user pool.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        Specifies the attributes that are auto-verified in a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes);

        /**
         * <p>
         * Specifies the attributes that are auto-verified in a user pool.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        Specifies the attributes that are auto-verified in a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributesWithStrings(String... autoVerifiedAttributes);

        /**
         * <p>
         * Specifies the attributes that are auto-verified in a user pool.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        Specifies the attributes that are auto-verified in a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes);

        /**
         * <p>
         * Specifies the attributes that are auto-verified in a user pool.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        Specifies the attributes that are auto-verified in a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributes(VerifiedAttributeType... autoVerifiedAttributes);

        /**
         * <p>
         * Specifies the attributes that are aliased in a user pool.
         * </p>
         * 
         * @param aliasAttributes
         *        Specifies the attributes that are aliased in a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributesWithStrings(Collection<String> aliasAttributes);

        /**
         * <p>
         * Specifies the attributes that are aliased in a user pool.
         * </p>
         * 
         * @param aliasAttributes
         *        Specifies the attributes that are aliased in a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributesWithStrings(String... aliasAttributes);

        /**
         * <p>
         * Specifies the attributes that are aliased in a user pool.
         * </p>
         * 
         * @param aliasAttributes
         *        Specifies the attributes that are aliased in a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributes(Collection<AliasAttributeType> aliasAttributes);

        /**
         * <p>
         * Specifies the attributes that are aliased in a user pool.
         * </p>
         * 
         * @param aliasAttributes
         *        Specifies the attributes that are aliased in a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributes(AliasAttributeType... aliasAttributes);

        /**
         * <p>
         * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributesWithStrings(Collection<String> usernameAttributes);

        /**
         * <p>
         * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributesWithStrings(String... usernameAttributes);

        /**
         * <p>
         * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributes(Collection<UsernameAttributeType> usernameAttributes);

        /**
         * <p>
         * Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributes(UsernameAttributeType... usernameAttributes);

        /**
         * <p>
         * The contents of the SMS verification message.
         * </p>
         * 
         * @param smsVerificationMessage
         *        The contents of the SMS verification message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsVerificationMessage(String smsVerificationMessage);

        /**
         * <p>
         * The contents of the email verification message.
         * </p>
         * 
         * @param emailVerificationMessage
         *        The contents of the email verification message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailVerificationMessage(String emailVerificationMessage);

        /**
         * <p>
         * The subject of the email verification message.
         * </p>
         * 
         * @param emailVerificationSubject
         *        The subject of the email verification message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailVerificationSubject(String emailVerificationSubject);

        /**
         * <p>
         * The template for verification messages.
         * </p>
         * 
         * @param verificationMessageTemplate
         *        The template for verification messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate);

        /**
         * <p>
         * The template for verification messages.
         * </p>
         * This is a convenience that creates an instance of the {@link VerificationMessageTemplateType.Builder}
         * avoiding the need to create one manually via {@link VerificationMessageTemplateType#builder()}.
         *
         * When the {@link Consumer} completes, {@link VerificationMessageTemplateType.Builder#build()} is called
         * immediately and its result is passed to {@link #verificationMessageTemplate(VerificationMessageTemplateType)}
         * .
         * 
         * @param verificationMessageTemplate
         *        a consumer that will call methods on {@link VerificationMessageTemplateType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationMessageTemplate(VerificationMessageTemplateType)
         */
        default Builder verificationMessageTemplate(Consumer<VerificationMessageTemplateType.Builder> verificationMessageTemplate) {
            return verificationMessageTemplate(VerificationMessageTemplateType.builder()
                    .applyMutation(verificationMessageTemplate).build());
        }

        /**
         * <p>
         * The contents of the SMS authentication message.
         * </p>
         * 
         * @param smsAuthenticationMessage
         *        The contents of the SMS authentication message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsAuthenticationMessage(String smsAuthenticationMessage);

        /**
         * <p>
         * Can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you
         * are initially creating a user pool.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mfaConfiguration
         *        Can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required
         *        when you are initially creating a user pool.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
         *        </p>
         *        </li>
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(String mfaConfiguration);

        /**
         * <p>
         * Can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you
         * are initially creating a user pool.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mfaConfiguration
         *        Can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required
         *        when you are initially creating a user pool.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
         *        </p>
         *        </li>
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(UserPoolMfaType mfaConfiguration);

        /**
         * <p>
         * The device configuration.
         * </p>
         * 
         * @param deviceConfiguration
         *        The device configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration);

        /**
         * <p>
         * The device configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceConfigurationType.Builder} avoiding the
         * need to create one manually via {@link DeviceConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #deviceConfiguration(DeviceConfigurationType)}.
         * 
         * @param deviceConfiguration
         *        a consumer that will call methods on {@link DeviceConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceConfiguration(DeviceConfigurationType)
         */
        default Builder deviceConfiguration(Consumer<DeviceConfigurationType.Builder> deviceConfiguration) {
            return deviceConfiguration(DeviceConfigurationType.builder().applyMutation(deviceConfiguration).build());
        }

        /**
         * <p>
         * A number estimating the size of the user pool.
         * </p>
         * 
         * @param estimatedNumberOfUsers
         *        A number estimating the size of the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedNumberOfUsers(Integer estimatedNumberOfUsers);

        /**
         * <p>
         * The email configuration.
         * </p>
         * 
         * @param emailConfiguration
         *        The email configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailConfiguration(EmailConfigurationType emailConfiguration);

        /**
         * <p>
         * The email configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link EmailConfigurationType.Builder} avoiding the
         * need to create one manually via {@link EmailConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmailConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #emailConfiguration(EmailConfigurationType)}.
         * 
         * @param emailConfiguration
         *        a consumer that will call methods on {@link EmailConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailConfiguration(EmailConfigurationType)
         */
        default Builder emailConfiguration(Consumer<EmailConfigurationType.Builder> emailConfiguration) {
            return emailConfiguration(EmailConfigurationType.builder().applyMutation(emailConfiguration).build());
        }

        /**
         * <p>
         * The SMS configuration.
         * </p>
         * 
         * @param smsConfiguration
         *        The SMS configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsConfiguration(SmsConfigurationType smsConfiguration);

        /**
         * <p>
         * The SMS configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SmsConfigurationType.Builder} avoiding the need
         * to create one manually via {@link SmsConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SmsConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #smsConfiguration(SmsConfigurationType)}.
         * 
         * @param smsConfiguration
         *        a consumer that will call methods on {@link SmsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsConfiguration(SmsConfigurationType)
         */
        default Builder smsConfiguration(Consumer<SmsConfigurationType.Builder> smsConfiguration) {
            return smsConfiguration(SmsConfigurationType.builder().applyMutation(smsConfiguration).build());
        }

        /**
         * <p>
         * The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize
         * and manage them in different ways, such as by purpose, owner, environment, or other criteria.
         * </p>
         * 
         * @param userPoolTags
         *        The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to
         *        categorize and manage them in different ways, such as by purpose, owner, environment, or other
         *        criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolTags(Map<String, String> userPoolTags);

        /**
         * <p>
         * The reason why the SMS configuration cannot send the messages to your users.
         * </p>
         * 
         * @param smsConfigurationFailure
         *        The reason why the SMS configuration cannot send the messages to your users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsConfigurationFailure(String smsConfigurationFailure);

        /**
         * <p>
         * The reason why the email configuration cannot send the messages to your users.
         * </p>
         * 
         * @param emailConfigurationFailure
         *        The reason why the email configuration cannot send the messages to your users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailConfigurationFailure(String emailConfigurationFailure);

        /**
         * <p>
         * Holds the domain prefix if the user pool has a domain associated with it.
         * </p>
         * 
         * @param domain
         *        Holds the domain prefix if the user pool has a domain associated with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom
         * domain to host the sign-up and sign-in pages for your application. For example: <code>auth.example.com</code>
         * .
         * </p>
         * <p>
         * For more information about adding a custom domain to your user pool, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html"
         * >Using Your Own Domain for the Hosted UI</a>.
         * </p>
         * 
         * @param customDomain
         *        A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a
         *        custom domain to host the sign-up and sign-in pages for your application. For example:
         *        <code>auth.example.com</code>.</p>
         *        <p>
         *        For more information about adding a custom domain to your user pool, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html"
         *        >Using Your Own Domain for the Hosted UI</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomain(String customDomain);

        /**
         * <p>
         * The configuration for <code>AdminCreateUser</code> requests.
         * </p>
         * 
         * @param adminCreateUserConfig
         *        The configuration for <code>AdminCreateUser</code> requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig);

        /**
         * <p>
         * The configuration for <code>AdminCreateUser</code> requests.
         * </p>
         * This is a convenience that creates an instance of the {@link AdminCreateUserConfigType.Builder} avoiding the
         * need to create one manually via {@link AdminCreateUserConfigType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AdminCreateUserConfigType.Builder#build()} is called immediately
         * and its result is passed to {@link #adminCreateUserConfig(AdminCreateUserConfigType)}.
         * 
         * @param adminCreateUserConfig
         *        a consumer that will call methods on {@link AdminCreateUserConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminCreateUserConfig(AdminCreateUserConfigType)
         */
        default Builder adminCreateUserConfig(Consumer<AdminCreateUserConfigType.Builder> adminCreateUserConfig) {
            return adminCreateUserConfig(AdminCreateUserConfigType.builder().applyMutation(adminCreateUserConfig).build());
        }

        /**
         * <p>
         * The user pool add-ons.
         * </p>
         * 
         * @param userPoolAddOns
         *        The user pool add-ons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolAddOns(UserPoolAddOnsType userPoolAddOns);

        /**
         * <p>
         * The user pool add-ons.
         * </p>
         * This is a convenience that creates an instance of the {@link UserPoolAddOnsType.Builder} avoiding the need to
         * create one manually via {@link UserPoolAddOnsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPoolAddOnsType.Builder#build()} is called immediately and its
         * result is passed to {@link #userPoolAddOns(UserPoolAddOnsType)}.
         * 
         * @param userPoolAddOns
         *        a consumer that will call methods on {@link UserPoolAddOnsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolAddOns(UserPoolAddOnsType)
         */
        default Builder userPoolAddOns(Consumer<UserPoolAddOnsType.Builder> userPoolAddOns) {
            return userPoolAddOns(UserPoolAddOnsType.builder().applyMutation(userPoolAddOns).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the user pool.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private UserPoolPolicyType policies;

        private LambdaConfigType lambdaConfig;

        private String status;

        private Instant lastModifiedDate;

        private Instant creationDate;

        private List<SchemaAttributeType> schemaAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> autoVerifiedAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> aliasAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> usernameAttributes = DefaultSdkAutoConstructList.getInstance();

        private String smsVerificationMessage;

        private String emailVerificationMessage;

        private String emailVerificationSubject;

        private VerificationMessageTemplateType verificationMessageTemplate;

        private String smsAuthenticationMessage;

        private String mfaConfiguration;

        private DeviceConfigurationType deviceConfiguration;

        private Integer estimatedNumberOfUsers;

        private EmailConfigurationType emailConfiguration;

        private SmsConfigurationType smsConfiguration;

        private Map<String, String> userPoolTags = DefaultSdkAutoConstructMap.getInstance();

        private String smsConfigurationFailure;

        private String emailConfigurationFailure;

        private String domain;

        private String customDomain;

        private AdminCreateUserConfigType adminCreateUserConfig;

        private UserPoolAddOnsType userPoolAddOns;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolType model) {
            id(model.id);
            name(model.name);
            policies(model.policies);
            lambdaConfig(model.lambdaConfig);
            status(model.status);
            lastModifiedDate(model.lastModifiedDate);
            creationDate(model.creationDate);
            schemaAttributes(model.schemaAttributes);
            autoVerifiedAttributesWithStrings(model.autoVerifiedAttributes);
            aliasAttributesWithStrings(model.aliasAttributes);
            usernameAttributesWithStrings(model.usernameAttributes);
            smsVerificationMessage(model.smsVerificationMessage);
            emailVerificationMessage(model.emailVerificationMessage);
            emailVerificationSubject(model.emailVerificationSubject);
            verificationMessageTemplate(model.verificationMessageTemplate);
            smsAuthenticationMessage(model.smsAuthenticationMessage);
            mfaConfiguration(model.mfaConfiguration);
            deviceConfiguration(model.deviceConfiguration);
            estimatedNumberOfUsers(model.estimatedNumberOfUsers);
            emailConfiguration(model.emailConfiguration);
            smsConfiguration(model.smsConfiguration);
            userPoolTags(model.userPoolTags);
            smsConfigurationFailure(model.smsConfigurationFailure);
            emailConfigurationFailure(model.emailConfigurationFailure);
            domain(model.domain);
            customDomain(model.customDomain);
            adminCreateUserConfig(model.adminCreateUserConfig);
            userPoolAddOns(model.userPoolAddOns);
            arn(model.arn);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final UserPoolPolicyType.Builder getPolicies() {
            return policies != null ? policies.toBuilder() : null;
        }

        @Override
        public final Builder policies(UserPoolPolicyType policies) {
            this.policies = policies;
            return this;
        }

        public final void setPolicies(UserPoolPolicyType.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        public final LambdaConfigType.Builder getLambdaConfig() {
            return lambdaConfig != null ? lambdaConfig.toBuilder() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaConfigType lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final void setLambdaConfig(LambdaConfigType.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Collection<SchemaAttributeType.Builder> getSchemaAttributes() {
            return schemaAttributes != null ? schemaAttributes.stream().map(SchemaAttributeType::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemaAttributes(Collection<SchemaAttributeType> schemaAttributes) {
            this.schemaAttributes = SchemaAttributesListTypeCopier.copy(schemaAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaAttributes(SchemaAttributeType... schemaAttributes) {
            schemaAttributes(Arrays.asList(schemaAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaAttributes(Consumer<SchemaAttributeType.Builder>... schemaAttributes) {
            schemaAttributes(Stream.of(schemaAttributes).map(c -> SchemaAttributeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSchemaAttributes(Collection<SchemaAttributeType.BuilderImpl> schemaAttributes) {
            this.schemaAttributes = SchemaAttributesListTypeCopier.copyFromBuilder(schemaAttributes);
        }

        public final Collection<String> getAutoVerifiedAttributesAsStrings() {
            return autoVerifiedAttributes;
        }

        @Override
        public final Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoVerifiedAttributesWithStrings(String... autoVerifiedAttributes) {
            autoVerifiedAttributesWithStrings(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        @Override
        public final Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copyEnumToString(autoVerifiedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoVerifiedAttributes(VerifiedAttributeType... autoVerifiedAttributes) {
            autoVerifiedAttributes(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        public final void setAutoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
        }

        public final Collection<String> getAliasAttributesAsStrings() {
            return aliasAttributes;
        }

        @Override
        public final Builder aliasAttributesWithStrings(Collection<String> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copy(aliasAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasAttributesWithStrings(String... aliasAttributes) {
            aliasAttributesWithStrings(Arrays.asList(aliasAttributes));
            return this;
        }

        @Override
        public final Builder aliasAttributes(Collection<AliasAttributeType> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copyEnumToString(aliasAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasAttributes(AliasAttributeType... aliasAttributes) {
            aliasAttributes(Arrays.asList(aliasAttributes));
            return this;
        }

        public final void setAliasAttributesWithStrings(Collection<String> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copy(aliasAttributes);
        }

        public final Collection<String> getUsernameAttributesAsStrings() {
            return usernameAttributes;
        }

        @Override
        public final Builder usernameAttributesWithStrings(Collection<String> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copy(usernameAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usernameAttributesWithStrings(String... usernameAttributes) {
            usernameAttributesWithStrings(Arrays.asList(usernameAttributes));
            return this;
        }

        @Override
        public final Builder usernameAttributes(Collection<UsernameAttributeType> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copyEnumToString(usernameAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usernameAttributes(UsernameAttributeType... usernameAttributes) {
            usernameAttributes(Arrays.asList(usernameAttributes));
            return this;
        }

        public final void setUsernameAttributesWithStrings(Collection<String> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copy(usernameAttributes);
        }

        public final String getSmsVerificationMessage() {
            return smsVerificationMessage;
        }

        @Override
        public final Builder smsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
            return this;
        }

        public final void setSmsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
        }

        public final String getEmailVerificationMessage() {
            return emailVerificationMessage;
        }

        @Override
        public final Builder emailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
            return this;
        }

        public final void setEmailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
        }

        public final String getEmailVerificationSubject() {
            return emailVerificationSubject;
        }

        @Override
        public final Builder emailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
            return this;
        }

        public final void setEmailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
        }

        public final VerificationMessageTemplateType.Builder getVerificationMessageTemplate() {
            return verificationMessageTemplate != null ? verificationMessageTemplate.toBuilder() : null;
        }

        @Override
        public final Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        public final void setVerificationMessageTemplate(VerificationMessageTemplateType.BuilderImpl verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate != null ? verificationMessageTemplate.build() : null;
        }

        public final String getSmsAuthenticationMessage() {
            return smsAuthenticationMessage;
        }

        @Override
        public final Builder smsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        public final void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
        }

        public final String getMfaConfigurationAsString() {
            return mfaConfiguration;
        }

        @Override
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration.toString());
            return this;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        public final DeviceConfigurationType.Builder getDeviceConfiguration() {
            return deviceConfiguration != null ? deviceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        public final void setDeviceConfiguration(DeviceConfigurationType.BuilderImpl deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration != null ? deviceConfiguration.build() : null;
        }

        public final Integer getEstimatedNumberOfUsers() {
            return estimatedNumberOfUsers;
        }

        @Override
        public final Builder estimatedNumberOfUsers(Integer estimatedNumberOfUsers) {
            this.estimatedNumberOfUsers = estimatedNumberOfUsers;
            return this;
        }

        public final void setEstimatedNumberOfUsers(Integer estimatedNumberOfUsers) {
            this.estimatedNumberOfUsers = estimatedNumberOfUsers;
        }

        public final EmailConfigurationType.Builder getEmailConfiguration() {
            return emailConfiguration != null ? emailConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder emailConfiguration(EmailConfigurationType emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        public final void setEmailConfiguration(EmailConfigurationType.BuilderImpl emailConfiguration) {
            this.emailConfiguration = emailConfiguration != null ? emailConfiguration.build() : null;
        }

        public final SmsConfigurationType.Builder getSmsConfiguration() {
            return smsConfiguration != null ? smsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder smsConfiguration(SmsConfigurationType smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public final void setSmsConfiguration(SmsConfigurationType.BuilderImpl smsConfiguration) {
            this.smsConfiguration = smsConfiguration != null ? smsConfiguration.build() : null;
        }

        public final Map<String, String> getUserPoolTags() {
            return userPoolTags;
        }

        @Override
        public final Builder userPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
            return this;
        }

        public final void setUserPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
        }

        public final String getSmsConfigurationFailure() {
            return smsConfigurationFailure;
        }

        @Override
        public final Builder smsConfigurationFailure(String smsConfigurationFailure) {
            this.smsConfigurationFailure = smsConfigurationFailure;
            return this;
        }

        public final void setSmsConfigurationFailure(String smsConfigurationFailure) {
            this.smsConfigurationFailure = smsConfigurationFailure;
        }

        public final String getEmailConfigurationFailure() {
            return emailConfigurationFailure;
        }

        @Override
        public final Builder emailConfigurationFailure(String emailConfigurationFailure) {
            this.emailConfigurationFailure = emailConfigurationFailure;
            return this;
        }

        public final void setEmailConfigurationFailure(String emailConfigurationFailure) {
            this.emailConfigurationFailure = emailConfigurationFailure;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getCustomDomain() {
            return customDomain;
        }

        @Override
        public final Builder customDomain(String customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        public final void setCustomDomain(String customDomain) {
            this.customDomain = customDomain;
        }

        public final AdminCreateUserConfigType.Builder getAdminCreateUserConfig() {
            return adminCreateUserConfig != null ? adminCreateUserConfig.toBuilder() : null;
        }

        @Override
        public final Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        public final void setAdminCreateUserConfig(AdminCreateUserConfigType.BuilderImpl adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig != null ? adminCreateUserConfig.build() : null;
        }

        public final UserPoolAddOnsType.Builder getUserPoolAddOns() {
            return userPoolAddOns != null ? userPoolAddOns.toBuilder() : null;
        }

        @Override
        public final Builder userPoolAddOns(UserPoolAddOnsType userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns;
            return this;
        }

        public final void setUserPoolAddOns(UserPoolAddOnsType.BuilderImpl userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns != null ? userPoolAddOns.build() : null;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public UserPoolType build() {
            return new UserPoolType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
