/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventRiskType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventRiskType> {
    private static final SdkField<String> RISK_DECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EventRiskType.getter(EventRiskType::riskDecisionAsString)).setter(EventRiskType.setter(Builder::riskDecision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskDecision").build()}).build();
    private static final SdkField<String> RISK_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EventRiskType.getter(EventRiskType::riskLevelAsString)).setter(EventRiskType.setter(Builder::riskLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RISK_DECISION_FIELD, RISK_LEVEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String riskDecision;
    private final String riskLevel;

    private EventRiskType(BuilderImpl builder) {
        this.riskDecision = builder.riskDecision;
        this.riskLevel = builder.riskLevel;
    }

    public RiskDecisionType riskDecision() {
        return RiskDecisionType.fromValue(this.riskDecision);
    }

    public String riskDecisionAsString() {
        return this.riskDecision;
    }

    public RiskLevelType riskLevel() {
        return RiskLevelType.fromValue(this.riskLevel);
    }

    public String riskLevelAsString() {
        return this.riskLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.riskDecisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.riskLevelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventRiskType)) {
            return false;
        }
        EventRiskType other = (EventRiskType)obj;
        return Objects.equals(this.riskDecisionAsString(), other.riskDecisionAsString()) && Objects.equals(this.riskLevelAsString(), other.riskLevelAsString());
    }

    public String toString() {
        return ToString.builder((String)"EventRiskType").add("RiskDecision", (Object)this.riskDecisionAsString()).add("RiskLevel", (Object)this.riskLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RiskDecision": {
                return Optional.ofNullable(clazz.cast(this.riskDecisionAsString()));
            }
            case "RiskLevel": {
                return Optional.ofNullable(clazz.cast(this.riskLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventRiskType, T> g) {
        return obj -> g.apply((EventRiskType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String riskDecision;
        private String riskLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(EventRiskType model) {
            this.riskDecision(model.riskDecision);
            this.riskLevel(model.riskLevel);
        }

        public final String getRiskDecisionAsString() {
            return this.riskDecision;
        }

        @Override
        public final Builder riskDecision(String riskDecision) {
            this.riskDecision = riskDecision;
            return this;
        }

        @Override
        public final Builder riskDecision(RiskDecisionType riskDecision) {
            this.riskDecision(riskDecision.toString());
            return this;
        }

        public final void setRiskDecision(String riskDecision) {
            this.riskDecision = riskDecision;
        }

        public final String getRiskLevelAsString() {
            return this.riskLevel;
        }

        @Override
        public final Builder riskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
            return this;
        }

        @Override
        public final Builder riskLevel(RiskLevelType riskLevel) {
            this.riskLevel(riskLevel.toString());
            return this;
        }

        public final void setRiskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
        }

        public EventRiskType build() {
            return new EventRiskType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventRiskType> {
        public Builder riskDecision(String var1);

        public Builder riskDecision(RiskDecisionType var1);

        public Builder riskLevel(String var1);

        public Builder riskLevel(RiskLevelType var1);
    }
}

