/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An update operation for a record.
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordPatch implements SdkPojo, Serializable, ToCopyableBuilder<RecordPatch.Builder, RecordPatch> {
    private static final SdkField<String> OP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Op")
            .getter(getter(RecordPatch::opAsString)).setter(setter(Builder::op))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Op").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(RecordPatch::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(RecordPatch::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Long> SYNC_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("SyncCount")
            .getter(getter(RecordPatch::syncCount)).setter(setter(Builder::syncCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncCount").build()).build();

    private static final SdkField<Instant> DEVICE_LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeviceLastModifiedDate").getter(getter(RecordPatch::deviceLastModifiedDate))
            .setter(setter(Builder::deviceLastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceLastModifiedDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OP_FIELD, KEY_FIELD,
            VALUE_FIELD, SYNC_COUNT_FIELD, DEVICE_LAST_MODIFIED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String op;

    private final String key;

    private final String value;

    private final Long syncCount;

    private final Instant deviceLastModifiedDate;

    private RecordPatch(BuilderImpl builder) {
        this.op = builder.op;
        this.key = builder.key;
        this.value = builder.value;
        this.syncCount = builder.syncCount;
        this.deviceLastModifiedDate = builder.deviceLastModifiedDate;
    }

    /**
     * An operation, either replace or remove.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #op} will return
     * {@link Operation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #opAsString}.
     * </p>
     * 
     * @return An operation, either replace or remove.
     * @see Operation
     */
    public final Operation op() {
        return Operation.fromValue(op);
    }

    /**
     * An operation, either replace or remove.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #op} will return
     * {@link Operation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #opAsString}.
     * </p>
     * 
     * @return An operation, either replace or remove.
     * @see Operation
     */
    public final String opAsString() {
        return op;
    }

    /**
     * The key associated with the record patch.
     * 
     * @return The key associated with the record patch.
     */
    public final String key() {
        return key;
    }

    /**
     * The value associated with the record patch.
     * 
     * @return The value associated with the record patch.
     */
    public final String value() {
        return value;
    }

    /**
     * Last known server sync count for this record. Set to 0 if unknown.
     * 
     * @return Last known server sync count for this record. Set to 0 if unknown.
     */
    public final Long syncCount() {
        return syncCount;
    }

    /**
     * The last modified date of the client device.
     * 
     * @return The last modified date of the client device.
     */
    public final Instant deviceLastModifiedDate() {
        return deviceLastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opAsString());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(syncCount());
        hashCode = 31 * hashCode + Objects.hashCode(deviceLastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordPatch)) {
            return false;
        }
        RecordPatch other = (RecordPatch) obj;
        return Objects.equals(opAsString(), other.opAsString()) && Objects.equals(key(), other.key())
                && Objects.equals(value(), other.value()) && Objects.equals(syncCount(), other.syncCount())
                && Objects.equals(deviceLastModifiedDate(), other.deviceLastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordPatch").add("Op", opAsString()).add("Key", key()).add("Value", value())
                .add("SyncCount", syncCount()).add("DeviceLastModifiedDate", deviceLastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Op":
            return Optional.ofNullable(clazz.cast(opAsString()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "SyncCount":
            return Optional.ofNullable(clazz.cast(syncCount()));
        case "DeviceLastModifiedDate":
            return Optional.ofNullable(clazz.cast(deviceLastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordPatch, T> g) {
        return obj -> g.apply((RecordPatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordPatch> {
        /**
         * An operation, either replace or remove.
         * 
         * @param op
         *        An operation, either replace or remove.
         * @see Operation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operation
         */
        Builder op(String op);

        /**
         * An operation, either replace or remove.
         * 
         * @param op
         *        An operation, either replace or remove.
         * @see Operation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operation
         */
        Builder op(Operation op);

        /**
         * The key associated with the record patch.
         * 
         * @param key
         *        The key associated with the record patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * The value associated with the record patch.
         * 
         * @param value
         *        The value associated with the record patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * Last known server sync count for this record. Set to 0 if unknown.
         * 
         * @param syncCount
         *        Last known server sync count for this record. Set to 0 if unknown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncCount(Long syncCount);

        /**
         * The last modified date of the client device.
         * 
         * @param deviceLastModifiedDate
         *        The last modified date of the client device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceLastModifiedDate(Instant deviceLastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String op;

        private String key;

        private String value;

        private Long syncCount;

        private Instant deviceLastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordPatch model) {
            op(model.op);
            key(model.key);
            value(model.value);
            syncCount(model.syncCount);
            deviceLastModifiedDate(model.deviceLastModifiedDate);
        }

        public final String getOp() {
            return op;
        }

        @Override
        public final Builder op(String op) {
            this.op = op;
            return this;
        }

        @Override
        public final Builder op(Operation op) {
            this.op(op == null ? null : op.toString());
            return this;
        }

        public final void setOp(String op) {
            this.op = op;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Long getSyncCount() {
            return syncCount;
        }

        @Override
        public final Builder syncCount(Long syncCount) {
            this.syncCount = syncCount;
            return this;
        }

        public final void setSyncCount(Long syncCount) {
            this.syncCount = syncCount;
        }

        public final Instant getDeviceLastModifiedDate() {
            return deviceLastModifiedDate;
        }

        @Override
        public final Builder deviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
            return this;
        }

        public final void setDeviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
        }

        @Override
        public RecordPatch build() {
            return new RecordPatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
