/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response to a successful DescribeIdentityPoolUsage request.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIdentityPoolUsageResponse extends CognitoSyncResponse implements
        ToCopyableBuilder<DescribeIdentityPoolUsageResponse.Builder, DescribeIdentityPoolUsageResponse> {
    private static final SdkField<IdentityPoolUsage> IDENTITY_POOL_USAGE_FIELD = SdkField
            .<IdentityPoolUsage> builder(MarshallingType.SDK_POJO).memberName("IdentityPoolUsage")
            .getter(getter(DescribeIdentityPoolUsageResponse::identityPoolUsage)).setter(setter(Builder::identityPoolUsage))
            .constructor(IdentityPoolUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolUsage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_USAGE_FIELD));

    private final IdentityPoolUsage identityPoolUsage;

    private DescribeIdentityPoolUsageResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolUsage = builder.identityPoolUsage;
    }

    /**
     * Information about the usage of the identity pool.
     * 
     * @return Information about the usage of the identity pool.
     */
    public final IdentityPoolUsage identityPoolUsage() {
        return identityPoolUsage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolUsage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityPoolUsageResponse)) {
            return false;
        }
        DescribeIdentityPoolUsageResponse other = (DescribeIdentityPoolUsageResponse) obj;
        return Objects.equals(identityPoolUsage(), other.identityPoolUsage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIdentityPoolUsageResponse").add("IdentityPoolUsage", identityPoolUsage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolUsage":
            return Optional.ofNullable(clazz.cast(identityPoolUsage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityPoolUsageResponse, T> g) {
        return obj -> g.apply((DescribeIdentityPoolUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeIdentityPoolUsageResponse> {
        /**
         * Information about the usage of the identity pool.
         * 
         * @param identityPoolUsage
         *        Information about the usage of the identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolUsage(IdentityPoolUsage identityPoolUsage);

        /**
         * Information about the usage of the identity pool. This is a convenience method that creates an instance of
         * the {@link IdentityPoolUsage.Builder} avoiding the need to create one manually via
         * {@link IdentityPoolUsage#builder()}.
         *
         * When the {@link Consumer} completes, {@link IdentityPoolUsage.Builder#build()} is called immediately and its
         * result is passed to {@link #identityPoolUsage(IdentityPoolUsage)}.
         * 
         * @param identityPoolUsage
         *        a consumer that will call methods on {@link IdentityPoolUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityPoolUsage(IdentityPoolUsage)
         */
        default Builder identityPoolUsage(Consumer<IdentityPoolUsage.Builder> identityPoolUsage) {
            return identityPoolUsage(IdentityPoolUsage.builder().applyMutation(identityPoolUsage).build());
        }
    }

    static final class BuilderImpl extends CognitoSyncResponse.BuilderImpl implements Builder {
        private IdentityPoolUsage identityPoolUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityPoolUsageResponse model) {
            super(model);
            identityPoolUsage(model.identityPoolUsage);
        }

        public final IdentityPoolUsage.Builder getIdentityPoolUsage() {
            return identityPoolUsage != null ? identityPoolUsage.toBuilder() : null;
        }

        public final void setIdentityPoolUsage(IdentityPoolUsage.BuilderImpl identityPoolUsage) {
            this.identityPoolUsage = identityPoolUsage != null ? identityPoolUsage.build() : null;
        }

        @Override
        public final Builder identityPoolUsage(IdentityPoolUsage identityPoolUsage) {
            this.identityPoolUsage = identityPoolUsage;
            return this;
        }

        @Override
        public DescribeIdentityPoolUsageResponse build() {
            return new DescribeIdentityPoolUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
