/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishResponse;
import software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsRequest;
import software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse;
import software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest;
import software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsResponse;
import software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse;
import software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest;
import software.amazon.awssdk.services.cognitosync.model.ListDatasetsResponse;
import software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsResponse;
import software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest;
import software.amazon.awssdk.services.cognitosync.model.RegisterDeviceResponse;
import software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest;
import software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsResponse;
import software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationResponse;
import software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest;
import software.amazon.awssdk.services.cognitosync.model.UpdateRecordsResponse;

/**
 * Service client for accessing Amazon Cognito Sync asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <fullname>Amazon Cognito Sync</fullname>
 * <p>
 * Amazon Cognito Sync provides an AWS service and client library that enable cross-device syncing of
 * application-related user data. High-level client libraries are available for both iOS and Android. You can use these
 * libraries to persist data locally so that it's available even if the device is offline. Developer credentials don't
 * need to be stored on the mobile device to access the service. You can use Amazon Cognito to obtain a normalized user
 * ID and credentials. User data is persisted in a dataset that can store up to 1 MB of key-value pairs, and you can
 * have up to 20 datasets per user identity.
 * </p>
 * <p>
 * With Amazon Cognito Sync, the data stored for each identity is accessible only to credentials assigned to that
 * identity. In order to use the Cognito Sync service, you need to make API calls using credentials retrieved with <a
 * href="http://docs.aws.amazon.com/cognitoidentity/latest/APIReference/Welcome.html">Amazon Cognito Identity
 * service</a>.
 * </p>
 * <p>
 * If you want to use Cognito Sync in an Android or iOS application, you will probably want to make API calls via the
 * AWS Mobile SDK. To learn more, see the <a
 * href="http://docs.aws.amazon.com/mobile/sdkforandroid/developerguide/cognito-sync.html">Developer Guide for
 * Android</a> and the <a href="http://docs.aws.amazon.com/mobile/sdkforios/developerguide/cognito-sync.html">Developer
 * Guide for iOS</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CognitoSyncAsyncClient extends AwsClient {
    String SERVICE_NAME = "cognito-sync";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cognito-sync";

    /**
     * <p>
     * Initiates a bulk publish of all existing datasets for an Identity Pool to the configured stream. Customers are
     * limited to one successful bulk publish per 24 hours. Bulk publish is an asynchronous request, customers can see
     * the status of the request via the GetBulkPublishDetails operation.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     *
     * @param bulkPublishRequest
     *        The input for the BulkPublish operation.
     * @return A Java Future containing the result of the BulkPublish operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>DuplicateRequestException An exception thrown when there is an IN_PROGRESS bulk publish operation for
     *         the given identity pool.</li>
     *         <li>AlreadyStreamedException An exception thrown when a bulk publish operation is requested less than 24
     *         hours after a previous bulk publish operation completed successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.BulkPublish
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/BulkPublish" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BulkPublishResponse> bulkPublish(BulkPublishRequest bulkPublishRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a bulk publish of all existing datasets for an Identity Pool to the configured stream. Customers are
     * limited to one successful bulk publish per 24 hours. Bulk publish is an asynchronous request, customers can see
     * the status of the request via the GetBulkPublishDetails operation.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BulkPublishRequest.Builder} avoiding the need to
     * create one manually via {@link BulkPublishRequest#builder()}
     * </p>
     *
     * @param bulkPublishRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest.Builder} to create a request.
     *        The input for the BulkPublish operation.
     * @return A Java Future containing the result of the BulkPublish operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>DuplicateRequestException An exception thrown when there is an IN_PROGRESS bulk publish operation for
     *         the given identity pool.</li>
     *         <li>AlreadyStreamedException An exception thrown when a bulk publish operation is requested less than 24
     *         hours after a previous bulk publish operation completed successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.BulkPublish
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/BulkPublish" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BulkPublishResponse> bulkPublish(Consumer<BulkPublishRequest.Builder> bulkPublishRequest) {
        return bulkPublish(BulkPublishRequest.builder().applyMutation(bulkPublishRequest).build());
    }

    /**
     * <p>
     * Deletes the specific dataset. The dataset will be deleted permanently, and the action can't be undone. Datasets
     * that this dataset was merged with will no longer report the merge. Any subsequent operation on this dataset will
     * result in a ResourceNotFoundException.
     * </p>
     * <p>
     * This API can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials.
     * </p>
     *
     * @param deleteDatasetRequest
     *        A request to delete the specific dataset.
     * @return A Java Future containing the result of the DeleteDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>ResourceConflictException Thrown if an update can't be applied because the resource was changed by
     *         another call and this would result in a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DeleteDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specific dataset. The dataset will be deleted permanently, and the action can't be undone. Datasets
     * that this dataset was merged with will no longer report the merge. Any subsequent operation on this dataset will
     * result in a ResourceNotFoundException.
     * </p>
     * <p>
     * This API can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest.Builder} to create a
     *        request. A request to delete the specific dataset.
     * @return A Java Future containing the result of the DeleteDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>ResourceConflictException Thrown if an update can't be applied because the resource was changed by
     *         another call and this would result in a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DeleteDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDatasetResponse> deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest) {
        return deleteDataset(DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest).build());
    }

    /**
     * <p>
     * Gets meta data about a dataset by identity and dataset name. With Amazon Cognito Sync, each identity has access
     * only to its own data. Thus, the credentials used to make this API call need to have access to the identity data.
     * </p>
     * <p>
     * This API can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials. You should use Cognito Identity credentials to make this API call.
     * </p>
     *
     * @param describeDatasetRequest
     *        A request for meta data about a dataset (creation date, number of records, size) by owner and dataset
     *        name.
     * @return A Java Future containing the result of the DescribeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDatasetResponse> describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets meta data about a dataset by identity and dataset name. With Amazon Cognito Sync, each identity has access
     * only to its own data. Thus, the credentials used to make this API call need to have access to the identity data.
     * </p>
     * <p>
     * This API can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials. You should use Cognito Identity credentials to make this API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatasetRequest#builder()}
     * </p>
     *
     * @param describeDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.DescribeDatasetRequest.Builder} to create a
     *        request. A request for meta data about a dataset (creation date, number of records, size) by owner and
     *        dataset name.
     * @return A Java Future containing the result of the DescribeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDatasetResponse> describeDataset(
            Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest) {
        return describeDataset(DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest).build());
    }

    /**
     * <p>
     * Gets usage details (for example, data storage) about a particular identity pool.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     *
     * @param describeIdentityPoolUsageRequest
     *        A request for usage information about the identity pool.
     * @return A Java Future containing the result of the DescribeIdentityPoolUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.DescribeIdentityPoolUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeIdentityPoolUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityPoolUsageResponse> describeIdentityPoolUsage(
            DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets usage details (for example, data storage) about a particular identity pool.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIdentityPoolUsageRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeIdentityPoolUsageRequest#builder()}
     * </p>
     *
     * @param describeIdentityPoolUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest.Builder} to
     *        create a request. A request for usage information about the identity pool.
     * @return A Java Future containing the result of the DescribeIdentityPoolUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.DescribeIdentityPoolUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeIdentityPoolUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityPoolUsageResponse> describeIdentityPoolUsage(
            Consumer<DescribeIdentityPoolUsageRequest.Builder> describeIdentityPoolUsageRequest) {
        return describeIdentityPoolUsage(DescribeIdentityPoolUsageRequest.builder()
                .applyMutation(describeIdentityPoolUsageRequest).build());
    }

    /**
     * <p>
     * Gets usage information for an identity, including number of datasets and data usage.
     * </p>
     * <p>
     * This API can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials.
     * </p>
     *
     * @param describeIdentityUsageRequest
     *        A request for information about the usage of an identity pool.
     * @return A Java Future containing the result of the DescribeIdentityUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.DescribeIdentityUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeIdentityUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityUsageResponse> describeIdentityUsage(
            DescribeIdentityUsageRequest describeIdentityUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets usage information for an identity, including number of datasets and data usage.
     * </p>
     * <p>
     * This API can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIdentityUsageRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeIdentityUsageRequest#builder()}
     * </p>
     *
     * @param describeIdentityUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest.Builder} to create a
     *        request. A request for information about the usage of an identity pool.
     * @return A Java Future containing the result of the DescribeIdentityUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.DescribeIdentityUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeIdentityUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityUsageResponse> describeIdentityUsage(
            Consumer<DescribeIdentityUsageRequest.Builder> describeIdentityUsageRequest) {
        return describeIdentityUsage(DescribeIdentityUsageRequest.builder().applyMutation(describeIdentityUsageRequest).build());
    }

    /**
     * <p>
     * Get the status of the last BulkPublish operation for an identity pool.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     *
     * @param getBulkPublishDetailsRequest
     *        The input for the GetBulkPublishDetails operation.
     * @return A Java Future containing the result of the GetBulkPublishDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.GetBulkPublishDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetBulkPublishDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBulkPublishDetailsResponse> getBulkPublishDetails(
            GetBulkPublishDetailsRequest getBulkPublishDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the status of the last BulkPublish operation for an identity pool.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBulkPublishDetailsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBulkPublishDetailsRequest#builder()}
     * </p>
     *
     * @param getBulkPublishDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsRequest.Builder} to create a
     *        request. The input for the GetBulkPublishDetails operation.
     * @return A Java Future containing the result of the GetBulkPublishDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.GetBulkPublishDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetBulkPublishDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBulkPublishDetailsResponse> getBulkPublishDetails(
            Consumer<GetBulkPublishDetailsRequest.Builder> getBulkPublishDetailsRequest) {
        return getBulkPublishDetails(GetBulkPublishDetailsRequest.builder().applyMutation(getBulkPublishDetailsRequest).build());
    }

    /**
     * <p>
     * Gets the events and the corresponding Lambda functions associated with an identity pool.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     *
     * @param getCognitoEventsRequest
     *        A request for a list of the configured Cognito Events
     * @return A Java Future containing the result of the GetCognitoEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.GetCognitoEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetCognitoEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCognitoEventsResponse> getCognitoEvents(GetCognitoEventsRequest getCognitoEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the events and the corresponding Lambda functions associated with an identity pool.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCognitoEventsRequest.Builder} avoiding the need
     * to create one manually via {@link GetCognitoEventsRequest#builder()}
     * </p>
     *
     * @param getCognitoEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest.Builder} to create a
     *        request. A request for a list of the configured Cognito Events
     * @return A Java Future containing the result of the GetCognitoEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.GetCognitoEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetCognitoEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCognitoEventsResponse> getCognitoEvents(
            Consumer<GetCognitoEventsRequest.Builder> getCognitoEventsRequest) {
        return getCognitoEvents(GetCognitoEventsRequest.builder().applyMutation(getCognitoEventsRequest).build());
    }

    /**
     * <p>
     * Gets the configuration settings of an identity pool.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     *
     * @param getIdentityPoolConfigurationRequest
     *        The input for the GetIdentityPoolConfiguration operation.
     * @return A Java Future containing the result of the GetIdentityPoolConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.GetIdentityPoolConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetIdentityPoolConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityPoolConfigurationResponse> getIdentityPoolConfiguration(
            GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the configuration settings of an identity pool.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityPoolConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetIdentityPoolConfigurationRequest#builder()}
     * </p>
     *
     * @param getIdentityPoolConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest.Builder} to
     *        create a request. The input for the GetIdentityPoolConfiguration operation.
     * @return A Java Future containing the result of the GetIdentityPoolConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.GetIdentityPoolConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetIdentityPoolConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityPoolConfigurationResponse> getIdentityPoolConfiguration(
            Consumer<GetIdentityPoolConfigurationRequest.Builder> getIdentityPoolConfigurationRequest) {
        return getIdentityPoolConfiguration(GetIdentityPoolConfigurationRequest.builder()
                .applyMutation(getIdentityPoolConfigurationRequest).build());
    }

    /**
     * <p>
     * Lists datasets for an identity. With Amazon Cognito Sync, each identity has access only to its own data. Thus,
     * the credentials used to make this API call need to have access to the identity data.
     * </p>
     * <p>
     * ListDatasets can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials. You should use the Cognito Identity credentials to make this API call.
     * </p>
     *
     * @param listDatasetsRequest
     *        Request for a list of datasets for an identity.
     * @return A Java Future containing the result of the ListDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDatasetsResponse> listDatasets(ListDatasetsRequest listDatasetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists datasets for an identity. With Amazon Cognito Sync, each identity has access only to its own data. Thus,
     * the credentials used to make this API call need to have access to the identity data.
     * </p>
     * <p>
     * ListDatasets can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials. You should use the Cognito Identity credentials to make this API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest.Builder} to create a request.
     *        Request for a list of datasets for an identity.
     * @return A Java Future containing the result of the ListDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDatasetsResponse> listDatasets(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest) {
        return listDatasets(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Gets a list of identity pools registered with Cognito.
     * </p>
     * <p>
     * ListIdentityPoolUsage can only be called with developer credentials. You cannot make this API call with the
     * temporary user credentials provided by Cognito Identity.
     * </p>
     *
     * @param listIdentityPoolUsageRequest
     *        A request for usage information on an identity pool.
     * @return A Java Future containing the result of the ListIdentityPoolUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.ListIdentityPoolUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListIdentityPoolUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityPoolUsageResponse> listIdentityPoolUsage(
            ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of identity pools registered with Cognito.
     * </p>
     * <p>
     * ListIdentityPoolUsage can only be called with developer credentials. You cannot make this API call with the
     * temporary user credentials provided by Cognito Identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityPoolUsageRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityPoolUsageRequest#builder()}
     * </p>
     *
     * @param listIdentityPoolUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest.Builder} to create a
     *        request. A request for usage information on an identity pool.
     * @return A Java Future containing the result of the ListIdentityPoolUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.ListIdentityPoolUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListIdentityPoolUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityPoolUsageResponse> listIdentityPoolUsage(
            Consumer<ListIdentityPoolUsageRequest.Builder> listIdentityPoolUsageRequest) {
        return listIdentityPoolUsage(ListIdentityPoolUsageRequest.builder().applyMutation(listIdentityPoolUsageRequest).build());
    }

    /**
     * <p>
     * Gets a list of identity pools registered with Cognito.
     * </p>
     * <p>
     * ListIdentityPoolUsage can only be called with developer credentials. You cannot make this API call with the
     * temporary user credentials provided by Cognito Identity.
     * </p>
     *
     * @return A Java Future containing the result of the ListIdentityPoolUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.ListIdentityPoolUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListIdentityPoolUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityPoolUsageResponse> listIdentityPoolUsage() {
        return listIdentityPoolUsage(ListIdentityPoolUsageRequest.builder().build());
    }

    /**
     * <p>
     * Gets paginated records, optionally changed after a particular sync count for a dataset and identity. With Amazon
     * Cognito Sync, each identity has access only to its own data. Thus, the credentials used to make this API call
     * need to have access to the identity data.
     * </p>
     * <p>
     * ListRecords can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials. You should use Cognito Identity credentials to make this API call.
     * </p>
     *
     * @param listRecordsRequest
     *        A request for a list of records.
     * @return A Java Future containing the result of the ListRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.ListRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListRecords" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRecordsResponse> listRecords(ListRecordsRequest listRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets paginated records, optionally changed after a particular sync count for a dataset and identity. With Amazon
     * Cognito Sync, each identity has access only to its own data. Thus, the credentials used to make this API call
     * need to have access to the identity data.
     * </p>
     * <p>
     * ListRecords can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials. You should use Cognito Identity credentials to make this API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecordsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRecordsRequest#builder()}
     * </p>
     *
     * @param listRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest.Builder} to create a request.
     *        A request for a list of records.
     * @return A Java Future containing the result of the ListRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.ListRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListRecords" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRecordsResponse> listRecords(Consumer<ListRecordsRequest.Builder> listRecordsRequest) {
        return listRecords(ListRecordsRequest.builder().applyMutation(listRecordsRequest).build());
    }

    /**
     * <p>
     * Registers a device to receive push sync notifications.
     * </p>
     * <p>
     * This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API
     * with developer credentials.
     * </p>
     *
     * @param registerDeviceRequest
     *        A request to RegisterDevice.
     * @return A Java Future containing the result of the RegisterDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidConfigurationException</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.RegisterDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/RegisterDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterDeviceResponse> registerDevice(RegisterDeviceRequest registerDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a device to receive push sync notifications.
     * </p>
     * <p>
     * This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API
     * with developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterDeviceRequest#builder()}
     * </p>
     *
     * @param registerDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest.Builder} to create a
     *        request. A request to RegisterDevice.
     * @return A Java Future containing the result of the RegisterDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidConfigurationException</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.RegisterDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/RegisterDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterDeviceResponse> registerDevice(Consumer<RegisterDeviceRequest.Builder> registerDeviceRequest) {
        return registerDevice(RegisterDeviceRequest.builder().applyMutation(registerDeviceRequest).build());
    }

    /**
     * <p>
     * Sets the AWS Lambda function for a given event type for an identity pool. This request only updates the key/value
     * pair specified. Other key/values pairs are not updated. To remove a key value pair, pass a empty value for the
     * particular key.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     *
     * @param setCognitoEventsRequest
     *        A request to configure Cognito Events"
     * @return A Java Future containing the result of the SetCognitoEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.SetCognitoEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SetCognitoEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetCognitoEventsResponse> setCognitoEvents(SetCognitoEventsRequest setCognitoEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the AWS Lambda function for a given event type for an identity pool. This request only updates the key/value
     * pair specified. Other key/values pairs are not updated. To remove a key value pair, pass a empty value for the
     * particular key.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetCognitoEventsRequest.Builder} avoiding the need
     * to create one manually via {@link SetCognitoEventsRequest#builder()}
     * </p>
     *
     * @param setCognitoEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest.Builder} to create a
     *        request. A request to configure Cognito Events"
     * @return A Java Future containing the result of the SetCognitoEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.SetCognitoEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SetCognitoEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetCognitoEventsResponse> setCognitoEvents(
            Consumer<SetCognitoEventsRequest.Builder> setCognitoEventsRequest) {
        return setCognitoEvents(SetCognitoEventsRequest.builder().applyMutation(setCognitoEventsRequest).build());
    }

    /**
     * <p>
     * Sets the necessary configuration for push sync.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     *
     * @param setIdentityPoolConfigurationRequest
     *        The input for the SetIdentityPoolConfiguration operation.
     * @return A Java Future containing the result of the SetIdentityPoolConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>ConcurrentModificationException Thrown if there are parallel requests to modify a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.SetIdentityPoolConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SetIdentityPoolConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityPoolConfigurationResponse> setIdentityPoolConfiguration(
            SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the necessary configuration for push sync.
     * </p>
     * <p>
     * This API can only be called with developer credentials. You cannot call this API with the temporary user
     * credentials provided by Cognito Identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIdentityPoolConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link SetIdentityPoolConfigurationRequest#builder()}
     * </p>
     *
     * @param setIdentityPoolConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest.Builder} to
     *        create a request. The input for the SetIdentityPoolConfiguration operation.
     * @return A Java Future containing the result of the SetIdentityPoolConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>ConcurrentModificationException Thrown if there are parallel requests to modify a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.SetIdentityPoolConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SetIdentityPoolConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityPoolConfigurationResponse> setIdentityPoolConfiguration(
            Consumer<SetIdentityPoolConfigurationRequest.Builder> setIdentityPoolConfigurationRequest) {
        return setIdentityPoolConfiguration(SetIdentityPoolConfigurationRequest.builder()
                .applyMutation(setIdentityPoolConfigurationRequest).build());
    }

    /**
     * <p>
     * Subscribes to receive notifications when a dataset is modified by another device.
     * </p>
     * <p>
     * This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API
     * with developer credentials.
     * </p>
     *
     * @param subscribeToDatasetRequest
     *        A request to SubscribeToDatasetRequest.
     * @return A Java Future containing the result of the SubscribeToDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidConfigurationException</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.SubscribeToDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SubscribeToDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubscribeToDatasetResponse> subscribeToDataset(SubscribeToDatasetRequest subscribeToDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Subscribes to receive notifications when a dataset is modified by another device.
     * </p>
     * <p>
     * This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API
     * with developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubscribeToDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link SubscribeToDatasetRequest#builder()}
     * </p>
     *
     * @param subscribeToDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest.Builder} to create a
     *        request. A request to SubscribeToDatasetRequest.
     * @return A Java Future containing the result of the SubscribeToDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidConfigurationException</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.SubscribeToDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SubscribeToDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubscribeToDatasetResponse> subscribeToDataset(
            Consumer<SubscribeToDatasetRequest.Builder> subscribeToDatasetRequest) {
        return subscribeToDataset(SubscribeToDatasetRequest.builder().applyMutation(subscribeToDatasetRequest).build());
    }

    /**
     * <p>
     * Unsubscribes from receiving notifications when a dataset is modified by another device.
     * </p>
     * <p>
     * This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API
     * with developer credentials.
     * </p>
     *
     * @param unsubscribeFromDatasetRequest
     *        A request to UnsubscribeFromDataset.
     * @return A Java Future containing the result of the UnsubscribeFromDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidConfigurationException</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.UnsubscribeFromDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UnsubscribeFromDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnsubscribeFromDatasetResponse> unsubscribeFromDataset(
            UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unsubscribes from receiving notifications when a dataset is modified by another device.
     * </p>
     * <p>
     * This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API
     * with developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnsubscribeFromDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link UnsubscribeFromDatasetRequest#builder()}
     * </p>
     *
     * @param unsubscribeFromDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetRequest.Builder} to create
     *        a request. A request to UnsubscribeFromDataset.
     * @return A Java Future containing the result of the UnsubscribeFromDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidConfigurationException</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.UnsubscribeFromDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UnsubscribeFromDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnsubscribeFromDatasetResponse> unsubscribeFromDataset(
            Consumer<UnsubscribeFromDatasetRequest.Builder> unsubscribeFromDatasetRequest) {
        return unsubscribeFromDataset(UnsubscribeFromDatasetRequest.builder().applyMutation(unsubscribeFromDatasetRequest)
                .build());
    }

    /**
     * <p>
     * Posts updates to records and adds and deletes records for a dataset and user.
     * </p>
     * <p>
     * The sync count in the record patch is your last known sync count for that record. The server will reject an
     * UpdateRecords request with a ResourceConflictException if you try to patch a record with a new value but a stale
     * sync count.
     * </p>
     * <p>
     * For example, if the sync count on the server is 5 for a key called highScore and you try and submit a new
     * highScore with sync count of 4, the request will be rejected. To obtain the current sync count for a record, call
     * ListRecords. On a successful update of the record, the response returns the new sync count for that record. You
     * should present that sync count the next time you try to update that same record. When the record does not exist,
     * specify the sync count as 0.
     * </p>
     * <p>
     * This API can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials.
     * </p>
     *
     * @param updateRecordsRequest
     *        A request to post updates to records or add and delete records for a dataset and user.
     * @return A Java Future containing the result of the UpdateRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>LimitExceededException Thrown when the limit on the number of objects or operations has been
     *         exceeded.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>ResourceConflictException Thrown if an update can't be applied because the resource was changed by
     *         another call and this would result in a conflict.</li>
     *         <li>InvalidLambdaFunctionOutputException The AWS Lambda function returned invalid output or an exception.
     *         </li>
     *         <li>LambdaThrottledException AWS Lambda throttled your account, please contact AWS Support</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.UpdateRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UpdateRecords" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRecordsResponse> updateRecords(UpdateRecordsRequest updateRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Posts updates to records and adds and deletes records for a dataset and user.
     * </p>
     * <p>
     * The sync count in the record patch is your last known sync count for that record. The server will reject an
     * UpdateRecords request with a ResourceConflictException if you try to patch a record with a new value but a stale
     * sync count.
     * </p>
     * <p>
     * For example, if the sync count on the server is 5 for a key called highScore and you try and submit a new
     * highScore with sync count of 4, the request will be rejected. To obtain the current sync count for a record, call
     * ListRecords. On a successful update of the record, the response returns the new sync count for that record. You
     * should present that sync count the next time you try to update that same record. When the record does not exist,
     * specify the sync count as 0.
     * </p>
     * <p>
     * This API can be called with temporary user credentials provided by Cognito Identity or with developer
     * credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecordsRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRecordsRequest#builder()}
     * </p>
     *
     * @param updateRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest.Builder} to create a
     *        request. A request to post updates to records or add and delete records for a dataset and user.
     * @return A Java Future containing the result of the UpdateRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown when a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>LimitExceededException Thrown when the limit on the number of objects or operations has been
     *         exceeded.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceNotFoundException Thrown if the resource doesn't exist.</li>
     *         <li>ResourceConflictException Thrown if an update can't be applied because the resource was changed by
     *         another call and this would result in a conflict.</li>
     *         <li>InvalidLambdaFunctionOutputException The AWS Lambda function returned invalid output or an exception.
     *         </li>
     *         <li>LambdaThrottledException AWS Lambda throttled your account, please contact AWS Support</li>
     *         <li>TooManyRequestsException Thrown if the request is throttled.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CognitoSyncAsyncClient.UpdateRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UpdateRecords" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRecordsResponse> updateRecords(Consumer<UpdateRecordsRequest.Builder> updateRecordsRequest) {
        return updateRecords(UpdateRecordsRequest.builder().applyMutation(updateRecordsRequest).build());
    }

    @Override
    default CognitoSyncServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CognitoSyncAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CognitoSyncAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CognitoSyncAsyncClient}.
     */
    static CognitoSyncAsyncClientBuilder builder() {
        return new DefaultCognitoSyncAsyncClientBuilder();
    }
}
