/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the GetIdentityPoolConfiguration operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityPoolConfigurationResponse extends CognitoSyncResponse implements
        ToCopyableBuilder<GetIdentityPoolConfigurationResponse.Builder, GetIdentityPoolConfigurationResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(GetIdentityPoolConfigurationResponse::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<PushSync> PUSH_SYNC_FIELD = SdkField.<PushSync> builder(MarshallingType.SDK_POJO)
            .memberName("PushSync").getter(getter(GetIdentityPoolConfigurationResponse::pushSync))
            .setter(setter(Builder::pushSync)).constructor(PushSync::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushSync").build()).build();

    private static final SdkField<CognitoStreams> COGNITO_STREAMS_FIELD = SdkField
            .<CognitoStreams> builder(MarshallingType.SDK_POJO).memberName("CognitoStreams")
            .getter(getter(GetIdentityPoolConfigurationResponse::cognitoStreams)).setter(setter(Builder::cognitoStreams))
            .constructor(CognitoStreams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoStreams").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            PUSH_SYNC_FIELD, COGNITO_STREAMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identityPoolId;

    private final PushSync pushSync;

    private final CognitoStreams cognitoStreams;

    private GetIdentityPoolConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.pushSync = builder.pushSync;
        this.cognitoStreams = builder.cognitoStreams;
    }

    /**
     * <p>
     * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.
     * </p>
     * 
     * @return A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
     *         Cognito.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * Options to apply to this identity pool for push synchronization.
     * </p>
     * 
     * @return Options to apply to this identity pool for push synchronization.
     */
    public final PushSync pushSync() {
        return pushSync;
    }

    /**
     * Options to apply to this identity pool for Amazon Cognito streams.
     * 
     * @return Options to apply to this identity pool for Amazon Cognito streams.
     */
    public final CognitoStreams cognitoStreams() {
        return cognitoStreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(pushSync());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoStreams());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoolConfigurationResponse)) {
            return false;
        }
        GetIdentityPoolConfigurationResponse other = (GetIdentityPoolConfigurationResponse) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && Objects.equals(pushSync(), other.pushSync())
                && Objects.equals(cognitoStreams(), other.cognitoStreams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdentityPoolConfigurationResponse").add("IdentityPoolId", identityPoolId())
                .add("PushSync", pushSync()).add("CognitoStreams", cognitoStreams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "PushSync":
            return Optional.ofNullable(clazz.cast(pushSync()));
        case "CognitoStreams":
            return Optional.ofNullable(clazz.cast(cognitoStreams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("PushSync", PUSH_SYNC_FIELD);
        map.put("CognitoStreams", COGNITO_STREAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityPoolConfigurationResponse, T> g) {
        return obj -> g.apply((GetIdentityPoolConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdentityPoolConfigurationResponse> {
        /**
         * <p>
         * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.
         * </p>
         * 
         * @param identityPoolId
         *        A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
         *        Cognito.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * Options to apply to this identity pool for push synchronization.
         * </p>
         * 
         * @param pushSync
         *        Options to apply to this identity pool for push synchronization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pushSync(PushSync pushSync);

        /**
         * <p>
         * Options to apply to this identity pool for push synchronization.
         * </p>
         * This is a convenience method that creates an instance of the {@link PushSync.Builder} avoiding the need to
         * create one manually via {@link PushSync#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PushSync.Builder#build()} is called immediately and its result is
         * passed to {@link #pushSync(PushSync)}.
         * 
         * @param pushSync
         *        a consumer that will call methods on {@link PushSync.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pushSync(PushSync)
         */
        default Builder pushSync(Consumer<PushSync.Builder> pushSync) {
            return pushSync(PushSync.builder().applyMutation(pushSync).build());
        }

        /**
         * Options to apply to this identity pool for Amazon Cognito streams.
         * 
         * @param cognitoStreams
         *        Options to apply to this identity pool for Amazon Cognito streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoStreams(CognitoStreams cognitoStreams);

        /**
         * Options to apply to this identity pool for Amazon Cognito streams. This is a convenience method that creates
         * an instance of the {@link CognitoStreams.Builder} avoiding the need to create one manually via
         * {@link CognitoStreams#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CognitoStreams.Builder#build()} is called immediately and its
         * result is passed to {@link #cognitoStreams(CognitoStreams)}.
         * 
         * @param cognitoStreams
         *        a consumer that will call methods on {@link CognitoStreams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoStreams(CognitoStreams)
         */
        default Builder cognitoStreams(Consumer<CognitoStreams.Builder> cognitoStreams) {
            return cognitoStreams(CognitoStreams.builder().applyMutation(cognitoStreams).build());
        }
    }

    static final class BuilderImpl extends CognitoSyncResponse.BuilderImpl implements Builder {
        private String identityPoolId;

        private PushSync pushSync;

        private CognitoStreams cognitoStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoolConfigurationResponse model) {
            super(model);
            identityPoolId(model.identityPoolId);
            pushSync(model.pushSync);
            cognitoStreams(model.cognitoStreams);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final PushSync.Builder getPushSync() {
            return pushSync != null ? pushSync.toBuilder() : null;
        }

        public final void setPushSync(PushSync.BuilderImpl pushSync) {
            this.pushSync = pushSync != null ? pushSync.build() : null;
        }

        @Override
        public final Builder pushSync(PushSync pushSync) {
            this.pushSync = pushSync;
            return this;
        }

        public final CognitoStreams.Builder getCognitoStreams() {
            return cognitoStreams != null ? cognitoStreams.toBuilder() : null;
        }

        public final void setCognitoStreams(CognitoStreams.BuilderImpl cognitoStreams) {
            this.cognitoStreams = cognitoStreams != null ? cognitoStreams.build() : null;
        }

        @Override
        public final Builder cognitoStreams(CognitoStreams cognitoStreams) {
            this.cognitoStreams = cognitoStreams;
            return this;
        }

        @Override
        public GetIdentityPoolConfigurationResponse build() {
            return new GetIdentityPoolConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
