/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitosync.model.ApplicationArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PushSync
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PushSync> {
    private static final SdkField<List<String>> APPLICATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationArns").getter(PushSync.getter(PushSync::applicationArns)).setter(PushSync.setter(Builder::applicationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(PushSync.getter(PushSync::roleArn)).setter(PushSync.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARNS_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PushSync.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> applicationArns;
    private final String roleArn;

    private PushSync(BuilderImpl builder) {
        this.applicationArns = builder.applicationArns;
        this.roleArn = builder.roleArn;
    }

    public final boolean hasApplicationArns() {
        return this.applicationArns != null && !(this.applicationArns instanceof SdkAutoConstructList);
    }

    public final List<String> applicationArns() {
        return this.applicationArns;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationArns() ? this.applicationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushSync)) {
            return false;
        }
        PushSync other = (PushSync)obj;
        return this.hasApplicationArns() == other.hasApplicationArns() && Objects.equals(this.applicationArns(), other.applicationArns()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"PushSync").add("ApplicationArns", this.hasApplicationArns() ? this.applicationArns() : null).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArns": {
                return Optional.ofNullable(clazz.cast(this.applicationArns()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationArns", APPLICATION_ARNS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PushSync, T> g) {
        return obj -> g.apply((PushSync)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> applicationArns = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PushSync model) {
            this.applicationArns(model.applicationArns);
            this.roleArn(model.roleArn);
        }

        public final Collection<String> getApplicationArns() {
            if (this.applicationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationArns;
        }

        public final void setApplicationArns(Collection<String> applicationArns) {
            this.applicationArns = ApplicationArnListCopier.copy(applicationArns);
        }

        @Override
        public final Builder applicationArns(Collection<String> applicationArns) {
            this.applicationArns = ApplicationArnListCopier.copy(applicationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationArns(String ... applicationArns) {
            this.applicationArns(Arrays.asList(applicationArns));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public PushSync build() {
            return new PushSync(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PushSync> {
        public Builder applicationArns(Collection<String> var1);

        public Builder applicationArns(String ... var1);

        public Builder roleArn(String var1);
    }
}

