/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The output for the GetBulkPublishDetails operation.
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBulkPublishDetailsResponse extends CognitoSyncResponse implements
        ToCopyableBuilder<GetBulkPublishDetailsResponse.Builder, GetBulkPublishDetailsResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(GetBulkPublishDetailsResponse::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<Instant> BULK_PUBLISH_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BulkPublishStartTime").getter(getter(GetBulkPublishDetailsResponse::bulkPublishStartTime))
            .setter(setter(Builder::bulkPublishStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkPublishStartTime").build())
            .build();

    private static final SdkField<Instant> BULK_PUBLISH_COMPLETE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BulkPublishCompleteTime").getter(getter(GetBulkPublishDetailsResponse::bulkPublishCompleteTime))
            .setter(setter(Builder::bulkPublishCompleteTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkPublishCompleteTime").build())
            .build();

    private static final SdkField<String> BULK_PUBLISH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BulkPublishStatus").getter(getter(GetBulkPublishDetailsResponse::bulkPublishStatusAsString))
            .setter(setter(Builder::bulkPublishStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkPublishStatus").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(GetBulkPublishDetailsResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            BULK_PUBLISH_START_TIME_FIELD, BULK_PUBLISH_COMPLETE_TIME_FIELD, BULK_PUBLISH_STATUS_FIELD, FAILURE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identityPoolId;

    private final Instant bulkPublishStartTime;

    private final Instant bulkPublishCompleteTime;

    private final String bulkPublishStatus;

    private final String failureMessage;

    private GetBulkPublishDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.bulkPublishStartTime = builder.bulkPublishStartTime;
        this.bulkPublishCompleteTime = builder.bulkPublishCompleteTime;
        this.bulkPublishStatus = builder.bulkPublishStatus;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
     * generation is unique within a region.
     * 
     * @return A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
     *         Cognito. GUID generation is unique within a region.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * The date/time at which the last bulk publish was initiated.
     * 
     * @return The date/time at which the last bulk publish was initiated.
     */
    public final Instant bulkPublishStartTime() {
        return bulkPublishStartTime;
    }

    /**
     * If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation completed.
     * 
     * @return If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation completed.
     */
    public final Instant bulkPublishCompleteTime() {
        return bulkPublishCompleteTime;
    }

    /**
     * Status of the last bulk publish operation, valid values are:
     * <p>
     * NOT_STARTED - No bulk publish has been requested for this identity pool
     * </p>
     * <p>
     * IN_PROGRESS - Data is being published to the configured stream
     * </p>
     * <p>
     * SUCCEEDED - All data for the identity pool has been published to the configured stream
     * </p>
     * <p>
     * FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bulkPublishStatus}
     * will return {@link BulkPublishStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bulkPublishStatusAsString}.
     * </p>
     * 
     * @return Status of the last bulk publish operation, valid values are:
     *         <p>
     *         NOT_STARTED - No bulk publish has been requested for this identity pool
     *         </p>
     *         <p>
     *         IN_PROGRESS - Data is being published to the configured stream
     *         </p>
     *         <p>
     *         SUCCEEDED - All data for the identity pool has been published to the configured stream
     *         </p>
     *         <p>
     *         FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.
     *         </p>
     * @see BulkPublishStatus
     */
    public final BulkPublishStatus bulkPublishStatus() {
        return BulkPublishStatus.fromValue(bulkPublishStatus);
    }

    /**
     * Status of the last bulk publish operation, valid values are:
     * <p>
     * NOT_STARTED - No bulk publish has been requested for this identity pool
     * </p>
     * <p>
     * IN_PROGRESS - Data is being published to the configured stream
     * </p>
     * <p>
     * SUCCEEDED - All data for the identity pool has been published to the configured stream
     * </p>
     * <p>
     * FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bulkPublishStatus}
     * will return {@link BulkPublishStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bulkPublishStatusAsString}.
     * </p>
     * 
     * @return Status of the last bulk publish operation, valid values are:
     *         <p>
     *         NOT_STARTED - No bulk publish has been requested for this identity pool
     *         </p>
     *         <p>
     *         IN_PROGRESS - Data is being published to the configured stream
     *         </p>
     *         <p>
     *         SUCCEEDED - All data for the identity pool has been published to the configured stream
     *         </p>
     *         <p>
     *         FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.
     *         </p>
     * @see BulkPublishStatus
     */
    public final String bulkPublishStatusAsString() {
        return bulkPublishStatus;
    }

    /**
     * If BulkPublishStatus is FAILED this field will contain the error message that caused the bulk publish to fail.
     * 
     * @return If BulkPublishStatus is FAILED this field will contain the error message that caused the bulk publish to
     *         fail.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(bulkPublishStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(bulkPublishCompleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(bulkPublishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBulkPublishDetailsResponse)) {
            return false;
        }
        GetBulkPublishDetailsResponse other = (GetBulkPublishDetailsResponse) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(bulkPublishStartTime(), other.bulkPublishStartTime())
                && Objects.equals(bulkPublishCompleteTime(), other.bulkPublishCompleteTime())
                && Objects.equals(bulkPublishStatusAsString(), other.bulkPublishStatusAsString())
                && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBulkPublishDetailsResponse").add("IdentityPoolId", identityPoolId())
                .add("BulkPublishStartTime", bulkPublishStartTime()).add("BulkPublishCompleteTime", bulkPublishCompleteTime())
                .add("BulkPublishStatus", bulkPublishStatusAsString()).add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "BulkPublishStartTime":
            return Optional.ofNullable(clazz.cast(bulkPublishStartTime()));
        case "BulkPublishCompleteTime":
            return Optional.ofNullable(clazz.cast(bulkPublishCompleteTime()));
        case "BulkPublishStatus":
            return Optional.ofNullable(clazz.cast(bulkPublishStatusAsString()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("BulkPublishStartTime", BULK_PUBLISH_START_TIME_FIELD);
        map.put("BulkPublishCompleteTime", BULK_PUBLISH_COMPLETE_TIME_FIELD);
        map.put("BulkPublishStatus", BULK_PUBLISH_STATUS_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBulkPublishDetailsResponse, T> g) {
        return obj -> g.apply((GetBulkPublishDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBulkPublishDetailsResponse> {
        /**
         * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.
         * GUID generation is unique within a region.
         * 
         * @param identityPoolId
         *        A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
         *        Cognito. GUID generation is unique within a region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * The date/time at which the last bulk publish was initiated.
         * 
         * @param bulkPublishStartTime
         *        The date/time at which the last bulk publish was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkPublishStartTime(Instant bulkPublishStartTime);

        /**
         * If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation completed.
         * 
         * @param bulkPublishCompleteTime
         *        If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkPublishCompleteTime(Instant bulkPublishCompleteTime);

        /**
         * Status of the last bulk publish operation, valid values are:
         * <p>
         * NOT_STARTED - No bulk publish has been requested for this identity pool
         * </p>
         * <p>
         * IN_PROGRESS - Data is being published to the configured stream
         * </p>
         * <p>
         * SUCCEEDED - All data for the identity pool has been published to the configured stream
         * </p>
         * <p>
         * FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.
         * </p>
         * 
         * @param bulkPublishStatus
         *        Status of the last bulk publish operation, valid values are:
         *        <p>
         *        NOT_STARTED - No bulk publish has been requested for this identity pool
         *        </p>
         *        <p>
         *        IN_PROGRESS - Data is being published to the configured stream
         *        </p>
         *        <p>
         *        SUCCEEDED - All data for the identity pool has been published to the configured stream
         *        </p>
         *        <p>
         *        FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.
         *        </p>
         * @see BulkPublishStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BulkPublishStatus
         */
        Builder bulkPublishStatus(String bulkPublishStatus);

        /**
         * Status of the last bulk publish operation, valid values are:
         * <p>
         * NOT_STARTED - No bulk publish has been requested for this identity pool
         * </p>
         * <p>
         * IN_PROGRESS - Data is being published to the configured stream
         * </p>
         * <p>
         * SUCCEEDED - All data for the identity pool has been published to the configured stream
         * </p>
         * <p>
         * FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.
         * </p>
         * 
         * @param bulkPublishStatus
         *        Status of the last bulk publish operation, valid values are:
         *        <p>
         *        NOT_STARTED - No bulk publish has been requested for this identity pool
         *        </p>
         *        <p>
         *        IN_PROGRESS - Data is being published to the configured stream
         *        </p>
         *        <p>
         *        SUCCEEDED - All data for the identity pool has been published to the configured stream
         *        </p>
         *        <p>
         *        FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.
         *        </p>
         * @see BulkPublishStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BulkPublishStatus
         */
        Builder bulkPublishStatus(BulkPublishStatus bulkPublishStatus);

        /**
         * If BulkPublishStatus is FAILED this field will contain the error message that caused the bulk publish to
         * fail.
         * 
         * @param failureMessage
         *        If BulkPublishStatus is FAILED this field will contain the error message that caused the bulk publish
         *        to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl extends CognitoSyncResponse.BuilderImpl implements Builder {
        private String identityPoolId;

        private Instant bulkPublishStartTime;

        private Instant bulkPublishCompleteTime;

        private String bulkPublishStatus;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBulkPublishDetailsResponse model) {
            super(model);
            identityPoolId(model.identityPoolId);
            bulkPublishStartTime(model.bulkPublishStartTime);
            bulkPublishCompleteTime(model.bulkPublishCompleteTime);
            bulkPublishStatus(model.bulkPublishStatus);
            failureMessage(model.failureMessage);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final Instant getBulkPublishStartTime() {
            return bulkPublishStartTime;
        }

        public final void setBulkPublishStartTime(Instant bulkPublishStartTime) {
            this.bulkPublishStartTime = bulkPublishStartTime;
        }

        @Override
        public final Builder bulkPublishStartTime(Instant bulkPublishStartTime) {
            this.bulkPublishStartTime = bulkPublishStartTime;
            return this;
        }

        public final Instant getBulkPublishCompleteTime() {
            return bulkPublishCompleteTime;
        }

        public final void setBulkPublishCompleteTime(Instant bulkPublishCompleteTime) {
            this.bulkPublishCompleteTime = bulkPublishCompleteTime;
        }

        @Override
        public final Builder bulkPublishCompleteTime(Instant bulkPublishCompleteTime) {
            this.bulkPublishCompleteTime = bulkPublishCompleteTime;
            return this;
        }

        public final String getBulkPublishStatus() {
            return bulkPublishStatus;
        }

        public final void setBulkPublishStatus(String bulkPublishStatus) {
            this.bulkPublishStatus = bulkPublishStatus;
        }

        @Override
        public final Builder bulkPublishStatus(String bulkPublishStatus) {
            this.bulkPublishStatus = bulkPublishStatus;
            return this;
        }

        @Override
        public final Builder bulkPublishStatus(BulkPublishStatus bulkPublishStatus) {
            this.bulkPublishStatus(bulkPublishStatus == null ? null : bulkPublishStatus.toString());
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public GetBulkPublishDetailsResponse build() {
            return new GetBulkPublishDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
