/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response to a successful DeleteDataset request.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDatasetResponse extends CognitoSyncResponse implements
        ToCopyableBuilder<DeleteDatasetResponse.Builder, DeleteDatasetResponse> {
    private static final SdkField<Dataset> DATASET_FIELD = SdkField.<Dataset> builder(MarshallingType.SDK_POJO)
            .memberName("Dataset").getter(getter(DeleteDatasetResponse::dataset)).setter(setter(Builder::dataset))
            .constructor(Dataset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dataset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Dataset dataset;

    private DeleteDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.dataset = builder.dataset;
    }

    /**
     * A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per identity
     * and can be general or associated with a particular entity in an application (like a saved game). Datasets are
     * automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of
     * key-value pairs.
     * 
     * @return A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per
     *         identity and can be general or associated with a particular entity in an application (like a saved game).
     *         Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold
     *         up to 1MB of key-value pairs.
     */
    public final Dataset dataset() {
        return dataset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDatasetResponse)) {
            return false;
        }
        DeleteDatasetResponse other = (DeleteDatasetResponse) obj;
        return Objects.equals(dataset(), other.dataset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDatasetResponse").add("Dataset", dataset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dataset":
            return Optional.ofNullable(clazz.cast(dataset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dataset", DATASET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDatasetResponse, T> g) {
        return obj -> g.apply((DeleteDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDatasetResponse> {
        /**
         * A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per
         * identity and can be general or associated with a particular entity in an application (like a saved game).
         * Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up
         * to 1MB of key-value pairs.
         * 
         * @param dataset
         *        A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is
         *        per identity and can be general or associated with a particular entity in an application (like a saved
         *        game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a
         *        dataset can hold up to 1MB of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataset(Dataset dataset);

        /**
         * A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per
         * identity and can be general or associated with a particular entity in an application (like a saved game).
         * Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up
         * to 1MB of key-value pairs. This is a convenience method that creates an instance of the
         * {@link Dataset.Builder} avoiding the need to create one manually via {@link Dataset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Dataset.Builder#build()} is called immediately and its result is
         * passed to {@link #dataset(Dataset)}.
         * 
         * @param dataset
         *        a consumer that will call methods on {@link Dataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataset(Dataset)
         */
        default Builder dataset(Consumer<Dataset.Builder> dataset) {
            return dataset(Dataset.builder().applyMutation(dataset).build());
        }
    }

    static final class BuilderImpl extends CognitoSyncResponse.BuilderImpl implements Builder {
        private Dataset dataset;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDatasetResponse model) {
            super(model);
            dataset(model.dataset);
        }

        public final Dataset.Builder getDataset() {
            return dataset != null ? dataset.toBuilder() : null;
        }

        public final void setDataset(Dataset.BuilderImpl dataset) {
            this.dataset = dataset != null ? dataset.build() : null;
        }

        @Override
        public final Builder dataset(Dataset dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public DeleteDatasetResponse build() {
            return new DeleteDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
