/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDocumentClassificationJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeDocumentClassificationJobResponse.Builder, DescribeDocumentClassificationJobResponse> {
    private static final SdkField<DocumentClassificationJobProperties> DOCUMENT_CLASSIFICATION_JOB_PROPERTIES_FIELD = SdkField
            .<DocumentClassificationJobProperties> builder(MarshallingType.SDK_POJO)
            .memberName("DocumentClassificationJobProperties")
            .getter(getter(DescribeDocumentClassificationJobResponse::documentClassificationJobProperties))
            .setter(setter(Builder::documentClassificationJobProperties))
            .constructor(DocumentClassificationJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DocumentClassificationJobProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DOCUMENT_CLASSIFICATION_JOB_PROPERTIES_FIELD));

    private final DocumentClassificationJobProperties documentClassificationJobProperties;

    private DescribeDocumentClassificationJobResponse(BuilderImpl builder) {
        super(builder);
        this.documentClassificationJobProperties = builder.documentClassificationJobProperties;
    }

    /**
     * <p>
     * An object that describes the properties associated with the document classification job.
     * </p>
     * 
     * @return An object that describes the properties associated with the document classification job.
     */
    public final DocumentClassificationJobProperties documentClassificationJobProperties() {
        return documentClassificationJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentClassificationJobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentClassificationJobResponse)) {
            return false;
        }
        DescribeDocumentClassificationJobResponse other = (DescribeDocumentClassificationJobResponse) obj;
        return Objects.equals(documentClassificationJobProperties(), other.documentClassificationJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDocumentClassificationJobResponse")
                .add("DocumentClassificationJobProperties", documentClassificationJobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentClassificationJobProperties":
            return Optional.ofNullable(clazz.cast(documentClassificationJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDocumentClassificationJobResponse, T> g) {
        return obj -> g.apply((DescribeDocumentClassificationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDocumentClassificationJobResponse> {
        /**
         * <p>
         * An object that describes the properties associated with the document classification job.
         * </p>
         * 
         * @param documentClassificationJobProperties
         *        An object that describes the properties associated with the document classification job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassificationJobProperties(DocumentClassificationJobProperties documentClassificationJobProperties);

        /**
         * <p>
         * An object that describes the properties associated with the document classification job.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentClassificationJobProperties.Builder}
         * avoiding the need to create one manually via {@link DocumentClassificationJobProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentClassificationJobProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #documentClassificationJobProperties(DocumentClassificationJobProperties)}.
         * 
         * @param documentClassificationJobProperties
         *        a consumer that will call methods on {@link DocumentClassificationJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentClassificationJobProperties(DocumentClassificationJobProperties)
         */
        default Builder documentClassificationJobProperties(
                Consumer<DocumentClassificationJobProperties.Builder> documentClassificationJobProperties) {
            return documentClassificationJobProperties(DocumentClassificationJobProperties.builder()
                    .applyMutation(documentClassificationJobProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private DocumentClassificationJobProperties documentClassificationJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentClassificationJobResponse model) {
            super(model);
            documentClassificationJobProperties(model.documentClassificationJobProperties);
        }

        public final DocumentClassificationJobProperties.Builder getDocumentClassificationJobProperties() {
            return documentClassificationJobProperties != null ? documentClassificationJobProperties.toBuilder() : null;
        }

        @Override
        public final Builder documentClassificationJobProperties(
                DocumentClassificationJobProperties documentClassificationJobProperties) {
            this.documentClassificationJobProperties = documentClassificationJobProperties;
            return this;
        }

        public final void setDocumentClassificationJobProperties(
                DocumentClassificationJobProperties.BuilderImpl documentClassificationJobProperties) {
            this.documentClassificationJobProperties = documentClassificationJobProperties != null ? documentClassificationJobProperties
                    .build() : null;
        }

        @Override
        public DescribeDocumentClassificationJobResponse build() {
            return new DescribeDocumentClassificationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
