/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.BatchSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse;
import software.amazon.awssdk.services.comprehend.model.ComprehendException;
import software.amazon.awssdk.services.comprehend.model.ConcurrentModificationException;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.InternalServerException;
import software.amazon.awssdk.services.comprehend.model.InvalidFilterException;
import software.amazon.awssdk.services.comprehend.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehend.model.JobNotFoundException;
import software.amazon.awssdk.services.comprehend.model.KmsKeyValidationException;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ResourceInUseException;
import software.amazon.awssdk.services.comprehend.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehend.model.ResourceUnavailableException;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.TagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.TagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagKeysException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagsException;
import software.amazon.awssdk.services.comprehend.model.UnsupportedLanguageException;
import software.amazon.awssdk.services.comprehend.model.UntagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.UntagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable;

/**
 * Service client for accessing Amazon Comprehend. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Comprehend is an AWS service for gaining insight into the content of documents. Use these actions to determine
 * the topics contained in your documents, the topics they discuss, the predominant sentiment expressed in them, the
 * predominant language used, and more.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ComprehendClient extends SdkClient {
    String SERVICE_NAME = "comprehend";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "comprehend";

    /**
     * Create a {@link ComprehendClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ComprehendClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ComprehendClient}.
     */
    static ComprehendClientBuilder builder() {
        return new DefaultComprehendClientBuilder();
    }

    /**
     * <p>
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon
     * Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon
     * Comprehend Supported Languages</a>.
     * </p>
     *
     * @param batchDetectDominantLanguageRequest
     * @return Result of the BatchDetectDominantLanguage operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectDominantLanguageResponse batchDetectDominantLanguage(
            BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon
     * Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon
     * Comprehend Supported Languages</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectDominantLanguageRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDetectDominantLanguageRequest#builder()}
     * </p>
     *
     * @param batchDetectDominantLanguageRequest
     *        A {@link Consumer} that will call methods on {@link BatchDetectDominantLanguageRequest.Builder} to create
     *        a request.
     * @return Result of the BatchDetectDominantLanguage operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectDominantLanguageResponse batchDetectDominantLanguage(
            Consumer<BatchDetectDominantLanguageRequest.Builder> batchDetectDominantLanguageRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, BatchSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return batchDetectDominantLanguage(BatchDetectDominantLanguageRequest.builder()
                .applyMutation(batchDetectDominantLanguageRequest).build());
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for named entities and returns information about them. For more
     * information about named entities, see <a>how-entities</a>
     * </p>
     *
     * @param batchDetectEntitiesRequest
     * @return Result of the BatchDetectEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectEntitiesResponse batchDetectEntities(BatchDetectEntitiesRequest batchDetectEntitiesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for named entities and returns information about them. For more
     * information about named entities, see <a>how-entities</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDetectEntitiesRequest#builder()}
     * </p>
     *
     * @param batchDetectEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link BatchDetectEntitiesRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDetectEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectEntitiesResponse batchDetectEntities(
            Consumer<BatchDetectEntitiesRequest.Builder> batchDetectEntitiesRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return batchDetectEntities(BatchDetectEntitiesRequest.builder().applyMutation(batchDetectEntitiesRequest).build());
    }

    /**
     * <p>
     * Detects the key noun phrases found in a batch of documents.
     * </p>
     *
     * @param batchDetectKeyPhrasesRequest
     * @return Result of the BatchDetectKeyPhrases operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectKeyPhrasesResponse batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects the key noun phrases found in a batch of documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectKeyPhrasesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDetectKeyPhrasesRequest#builder()}
     * </p>
     *
     * @param batchDetectKeyPhrasesRequest
     *        A {@link Consumer} that will call methods on {@link BatchDetectKeyPhrasesRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDetectKeyPhrases operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectKeyPhrasesResponse batchDetectKeyPhrases(
            Consumer<BatchDetectKeyPhrasesRequest.Builder> batchDetectKeyPhrasesRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest.builder().applyMutation(batchDetectKeyPhrasesRequest).build());
    }

    /**
     * <p>
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, <code>POSITIVE</code>,
     * <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>, in each one.
     * </p>
     *
     * @param batchDetectSentimentRequest
     * @return Result of the BatchDetectSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectSentimentResponse batchDetectSentiment(BatchDetectSentimentRequest batchDetectSentimentRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, <code>POSITIVE</code>,
     * <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>, in each one.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectSentimentRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDetectSentimentRequest#builder()}
     * </p>
     *
     * @param batchDetectSentimentRequest
     *        A {@link Consumer} that will call methods on {@link BatchDetectSentimentRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDetectSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDetectSentimentResponse batchDetectSentiment(
            Consumer<BatchDetectSentimentRequest.Builder> batchDetectSentimentRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return batchDetectSentiment(BatchDetectSentimentRequest.builder().applyMutation(batchDetectSentimentRequest).build());
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and
     * returns information about them. For more information, see <a>how-syntax</a>.
     * </p>
     *
     * @param batchDetectSyntaxRequest
     * @return Result of the BatchDetectSyntax operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDetectSyntaxResponse batchDetectSyntax(BatchDetectSyntaxRequest batchDetectSyntaxRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and
     * returns information about them. For more information, see <a>how-syntax</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectSyntaxRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDetectSyntaxRequest#builder()}
     * </p>
     *
     * @param batchDetectSyntaxRequest
     *        A {@link Consumer} that will call methods on {@link BatchDetectSyntaxRequest.Builder} to create a request.
     * @return Result of the BatchDetectSyntax operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws BatchSizeLimitExceededException
     *         The number of documents in the request exceeds the limit of 25. Try your request again with fewer
     *         documents.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.BatchDetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDetectSyntaxResponse batchDetectSyntax(Consumer<BatchDetectSyntaxRequest.Builder> batchDetectSyntaxRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return batchDetectSyntax(BatchDetectSyntaxRequest.builder().applyMutation(batchDetectSyntaxRequest).build());
    }

    /**
     * <p>
     * Creates a new document classification request to analyze a single document in real-time, using a previously
     * created and trained custom model and an endpoint.
     * </p>
     *
     * @param classifyDocumentRequest
     * @return Result of the ClassifyDocument operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ClassifyDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default ClassifyDocumentResponse classifyDocument(ClassifyDocumentRequest classifyDocumentRequest)
            throws InvalidRequestException, ResourceUnavailableException, TextSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new document classification request to analyze a single document in real-time, using a previously
     * created and trained custom model and an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClassifyDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link ClassifyDocumentRequest#builder()}
     * </p>
     *
     * @param classifyDocumentRequest
     *        A {@link Consumer} that will call methods on {@link ClassifyDocumentRequest.Builder} to create a request.
     * @return Result of the ClassifyDocument operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ClassifyDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default ClassifyDocumentResponse classifyDocument(Consumer<ClassifyDocumentRequest.Builder> classifyDocumentRequest)
            throws InvalidRequestException, ResourceUnavailableException, TextSizeLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return classifyDocument(ClassifyDocumentRequest.builder().applyMutation(classifyDocumentRequest).build());
    }

    /**
     * <p>
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of
     * identified PII entity types such as name, address, bank account number, or phone number.
     * </p>
     *
     * @param containsPiiEntitiesRequest
     * @return Result of the ContainsPiiEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ContainsPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ContainsPiiEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default ContainsPiiEntitiesResponse containsPiiEntities(ContainsPiiEntitiesRequest containsPiiEntitiesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of
     * identified PII entity types such as name, address, bank account number, or phone number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ContainsPiiEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ContainsPiiEntitiesRequest#builder()}
     * </p>
     *
     * @param containsPiiEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ContainsPiiEntitiesRequest.Builder} to create a
     *        request.
     * @return Result of the ContainsPiiEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ContainsPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ContainsPiiEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default ContainsPiiEntitiesResponse containsPiiEntities(
            Consumer<ContainsPiiEntitiesRequest.Builder> containsPiiEntitiesRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return containsPiiEntities(ContainsPiiEntitiesRequest.builder().applyMutation(containsPiiEntitiesRequest).build());
    }

    /**
     * <p>
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a
     * set of training documents that labeled with the categories that you want to use. After the classifier is trained
     * you can use it to categorize a set of labeled documents into the categories. For more information, see
     * <a>how-document-classification</a>.
     * </p>
     *
     * @param createDocumentClassifierRequest
     * @return Result of the CreateDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDocumentClassifierResponse createDocumentClassifier(
            CreateDocumentClassifierRequest createDocumentClassifierRequest) throws InvalidRequestException,
            ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException,
            UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a
     * set of training documents that labeled with the categories that you want to use. After the classifier is trained
     * you can use it to categorize a set of labeled documents into the categories. For more information, see
     * <a>how-document-classification</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDocumentClassifierRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param createDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on {@link CreateDocumentClassifierRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDocumentClassifierResponse createDocumentClassifier(
            Consumer<CreateDocumentClassifierRequest.Builder> createDocumentClassifierRequest) throws InvalidRequestException,
            ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException,
            UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return createDocumentClassifier(CreateDocumentClassifierRequest.builder().applyMutation(createDocumentClassifierRequest)
                .build());
    }

    /**
     * <p>
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model
     * </p>
     *
     * @param createEndpointRequest
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest) throws InvalidRequestException,
            ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, ResourceUnavailableException,
            TooManyRequestsException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEndpointRequest#builder()}
     * </p>
     *
     * @param createEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateEndpointRequest.Builder} to create a request.
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest)
            throws InvalidRequestException, ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException,
            ResourceUnavailableException, TooManyRequestsException, TooManyTagsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return createEndpoint(CreateEndpointRequest.builder().applyMutation(createEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an entity recognizer using submitted files. After your <code>CreateEntityRecognizer</code> request is
     * submitted, you can check job status using the API.
     * </p>
     *
     * @param createEntityRecognizerRequest
     * @return Result of the CreateEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEntityRecognizerResponse createEntityRecognizer(CreateEntityRecognizerRequest createEntityRecognizerRequest)
            throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException,
            ResourceLimitExceededException, UnsupportedLanguageException, KmsKeyValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an entity recognizer using submitted files. After your <code>CreateEntityRecognizer</code> request is
     * submitted, you can check job status using the API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEntityRecognizerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param createEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on {@link CreateEntityRecognizerRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.CreateEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEntityRecognizerResponse createEntityRecognizer(
            Consumer<CreateEntityRecognizerRequest.Builder> createEntityRecognizerRequest) throws InvalidRequestException,
            ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException,
            UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return createEntityRecognizer(CreateEntityRecognizerRequest.builder().applyMutation(createEntityRecognizerRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a previously created document classifier
     * </p>
     * <p>
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a
     * background job. Once removed, the classifier disappears from your account and is no longer available for use.
     * </p>
     *
     * @param deleteDocumentClassifierRequest
     * @return Result of the DeleteDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDocumentClassifierResponse deleteDocumentClassifier(
            DeleteDocumentClassifierRequest deleteDocumentClassifierRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously created document classifier
     * </p>
     * <p>
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a
     * background job. Once removed, the classifier disappears from your account and is no longer available for use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentClassifierRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param deleteDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDocumentClassifierRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDocumentClassifierResponse deleteDocumentClassifier(
            Consumer<DeleteDocumentClassifierRequest.Builder> deleteDocumentClassifierRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return deleteDocumentClassifier(DeleteDocumentClassifierRequest.builder().applyMutation(deleteDocumentClassifierRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order
     * for the model to be deleted.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws InvalidRequestException,
            ResourceInUseException, ResourceNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order
     * for the model to be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointRequest.Builder} to create a request.
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest)
            throws InvalidRequestException, ResourceInUseException, ResourceNotFoundException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an entity recognizer.
     * </p>
     * <p>
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a
     * background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     * </p>
     *
     * @param deleteEntityRecognizerRequest
     * @return Result of the DeleteEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEntityRecognizerResponse deleteEntityRecognizer(DeleteEntityRecognizerRequest deleteEntityRecognizerRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException,
            ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an entity recognizer.
     * </p>
     * <p>
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a
     * background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEntityRecognizerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param deleteEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEntityRecognizerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DeleteEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEntityRecognizerResponse deleteEntityRecognizer(
            Consumer<DeleteEntityRecognizerRequest.Builder> deleteEntityRecognizerRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return deleteEntityRecognizer(DeleteEntityRecognizerRequest.builder().applyMutation(deleteEntityRecognizerRequest)
                .build());
    }

    /**
     * <p>
     * Gets the properties associated with a document classification job. Use this operation to get the status of a
     * classification job.
     * </p>
     *
     * @param describeDocumentClassificationJobRequest
     * @return Result of the DescribeDocumentClassificationJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentClassificationJobResponse describeDocumentClassificationJob(
            DescribeDocumentClassificationJobRequest describeDocumentClassificationJobRequest) throws InvalidRequestException,
            TooManyRequestsException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a document classification job. Use this operation to get the status of a
     * classification job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentClassificationJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDocumentClassificationJobRequest#builder()}
     * </p>
     *
     * @param describeDocumentClassificationJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDocumentClassificationJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeDocumentClassificationJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentClassificationJobResponse describeDocumentClassificationJob(
            Consumer<DescribeDocumentClassificationJobRequest.Builder> describeDocumentClassificationJobRequest)
            throws InvalidRequestException, TooManyRequestsException, JobNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest.builder()
                .applyMutation(describeDocumentClassificationJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a document classifier.
     * </p>
     *
     * @param describeDocumentClassifierRequest
     * @return Result of the DescribeDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentClassifierResponse describeDocumentClassifier(
            DescribeDocumentClassifierRequest describeDocumentClassifierRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a document classifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentClassifierRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param describeDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDocumentClassifierRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentClassifierResponse describeDocumentClassifier(
            Consumer<DescribeDocumentClassifierRequest.Builder> describeDocumentClassifierRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeDocumentClassifier(DescribeDocumentClassifierRequest.builder()
                .applyMutation(describeDocumentClassifierRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeDominantLanguageDetectionJobRequest
     * @return Result of the DescribeDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDominantLanguageDetectionJobResponse describeDominantLanguageDetectionJob(
            DescribeDominantLanguageDetectionJobRequest describeDominantLanguageDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeDominantLanguageDetectionJobRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeDominantLanguageDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeDominantLanguageDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDominantLanguageDetectionJobRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDominantLanguageDetectionJobResponse describeDominantLanguageDetectionJob(
            Consumer<DescribeDominantLanguageDetectionJobRequest.Builder> describeDominantLanguageDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest.builder()
                .applyMutation(describeDominantLanguageDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint.
     * </p>
     *
     * @param describeEndpointRequest
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointResponse describeEndpoint(DescribeEndpointRequest describeEndpointRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointRequest#builder()}
     * </p>
     *
     * @param describeEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointRequest.Builder} to create a request.
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointResponse describeEndpoint(Consumer<DescribeEndpointRequest.Builder> describeEndpointRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeEndpoint(DescribeEndpointRequest.builder().applyMutation(describeEndpointRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeEntitiesDetectionJobRequest
     * @return Result of the DescribeEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntitiesDetectionJobResponse describeEntitiesDetectionJob(
            DescribeEntitiesDetectionJobRequest describeEntitiesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEntitiesDetectionJobRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntitiesDetectionJobResponse describeEntitiesDetectionJob(
            Consumer<DescribeEntitiesDetectionJobRequest.Builder> describeEntitiesDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest.builder()
                .applyMutation(describeEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer
     * metadata, metrics, and so on.
     * </p>
     *
     * @param describeEntityRecognizerRequest
     * @return Result of the DescribeEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntityRecognizerResponse describeEntityRecognizer(
            DescribeEntityRecognizerRequest describeEntityRecognizerRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer
     * metadata, metrics, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntityRecognizerRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param describeEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEntityRecognizerRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntityRecognizerResponse describeEntityRecognizer(
            Consumer<DescribeEntityRecognizerRequest.Builder> describeEntityRecognizerRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return describeEntityRecognizer(DescribeEntityRecognizerRequest.builder().applyMutation(describeEntityRecognizerRequest)
                .build());
    }

    /**
     * <p>
     * Gets the status and details of an events detection job.
     * </p>
     *
     * @param describeEventsDetectionJobRequest
     * @return Result of the DescribeEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsDetectionJobResponse describeEventsDetectionJob(
            DescribeEventsDetectionJobRequest describeEventsDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status and details of an events detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventsDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeEventsDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsDetectionJobResponse describeEventsDetectionJob(
            Consumer<DescribeEventsDetectionJobRequest.Builder> describeEventsDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeEventsDetectionJob(DescribeEventsDetectionJobRequest.builder()
                .applyMutation(describeEventsDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeKeyPhrasesDetectionJobRequest
     * @return Result of the DescribeKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeyPhrasesDetectionJobResponse describeKeyPhrasesDetectionJob(
            DescribeKeyPhrasesDetectionJobRequest describeKeyPhrasesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeKeyPhrasesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeKeyPhrasesDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeKeyPhrasesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeKeyPhrasesDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeyPhrasesDetectionJobResponse describeKeyPhrasesDetectionJob(
            Consumer<DescribeKeyPhrasesDetectionJobRequest.Builder> describeKeyPhrasesDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest.builder()
                .applyMutation(describeKeyPhrasesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get
     * the job status.
     * </p>
     *
     * @param describePiiEntitiesDetectionJobRequest
     * @return Result of the DescribePiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribePiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePiiEntitiesDetectionJobResponse describePiiEntitiesDetectionJob(
            DescribePiiEntitiesDetectionJobRequest describePiiEntitiesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get
     * the job status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePiiEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePiiEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param describePiiEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribePiiEntitiesDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribePiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribePiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePiiEntitiesDetectionJobResponse describePiiEntitiesDetectionJob(
            Consumer<DescribePiiEntitiesDetectionJobRequest.Builder> describePiiEntitiesDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describePiiEntitiesDetectionJob(DescribePiiEntitiesDetectionJobRequest.builder()
                .applyMutation(describePiiEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeSentimentDetectionJobRequest
     * @return Result of the DescribeSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSentimentDetectionJobResponse describeSentimentDetectionJob(
            DescribeSentimentDetectionJobRequest describeSentimentDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSentimentDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSentimentDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSentimentDetectionJobResponse describeSentimentDetectionJob(
            Consumer<DescribeSentimentDetectionJobRequest.Builder> describeSentimentDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest.builder()
                .applyMutation(describeSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection
     * job.
     * </p>
     *
     * @param describeTopicsDetectionJobRequest
     * @return Result of the DescribeTopicsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTopicsDetectionJobResponse describeTopicsDetectionJob(
            DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection
     * job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTopicsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTopicsDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeTopicsDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTopicsDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTopicsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DescribeTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTopicsDetectionJobResponse describeTopicsDetectionJob(
            Consumer<DescribeTopicsDetectionJobRequest.Builder> describeTopicsDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest.builder()
                .applyMutation(describeTopicsDetectionJobRequest).build());
    }

    /**
     * <p>
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect,
     * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported
     * Languages</a>.
     * </p>
     *
     * @param detectDominantLanguageRequest
     * @return Result of the DetectDominantLanguage operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectDominantLanguageResponse detectDominantLanguage(DetectDominantLanguageRequest detectDominantLanguageRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect,
     * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported
     * Languages</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectDominantLanguageRequest.Builder} avoiding the
     * need to create one manually via {@link DetectDominantLanguageRequest#builder()}
     * </p>
     *
     * @param detectDominantLanguageRequest
     *        A {@link Consumer} that will call methods on {@link DetectDominantLanguageRequest.Builder} to create a
     *        request.
     * @return Result of the DetectDominantLanguage operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectDominantLanguageResponse detectDominantLanguage(
            Consumer<DetectDominantLanguageRequest.Builder> detectDominantLanguageRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectDominantLanguage(DetectDominantLanguageRequest.builder().applyMutation(detectDominantLanguageRequest)
                .build());
    }

    /**
     * <p>
     * Inspects text for named entities, and returns information about them. For more information, about named entities,
     * see <a>how-entities</a>.
     * </p>
     *
     * @param detectEntitiesRequest
     * @return Result of the DetectEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default DetectEntitiesResponse detectEntities(DetectEntitiesRequest detectEntitiesRequest) throws InvalidRequestException,
            ResourceUnavailableException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects text for named entities, and returns information about them. For more information, about named entities,
     * see <a>how-entities</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link DetectEntitiesRequest#builder()}
     * </p>
     *
     * @param detectEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link DetectEntitiesRequest.Builder} to create a request.
     * @return Result of the DetectEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default DetectEntitiesResponse detectEntities(Consumer<DetectEntitiesRequest.Builder> detectEntitiesRequest)
            throws InvalidRequestException, ResourceUnavailableException, TextSizeLimitExceededException,
            UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectEntities(DetectEntitiesRequest.builder().applyMutation(detectEntitiesRequest).build());
    }

    /**
     * <p>
     * Detects the key noun phrases found in the text.
     * </p>
     *
     * @param detectKeyPhrasesRequest
     * @return Result of the DetectKeyPhrases operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectKeyPhrasesResponse detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects the key noun phrases found in the text.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectKeyPhrasesRequest.Builder} avoiding the need
     * to create one manually via {@link DetectKeyPhrasesRequest#builder()}
     * </p>
     *
     * @param detectKeyPhrasesRequest
     *        A {@link Consumer} that will call methods on {@link DetectKeyPhrasesRequest.Builder} to create a request.
     * @return Result of the DetectKeyPhrases operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectKeyPhrasesResponse detectKeyPhrases(Consumer<DetectKeyPhrasesRequest.Builder> detectKeyPhrasesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectKeyPhrases(DetectKeyPhrasesRequest.builder().applyMutation(detectKeyPhrasesRequest).build());
    }

    /**
     * <p>
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns
     * information about them.
     * </p>
     *
     * @param detectPiiEntitiesRequest
     * @return Result of the DetectPiiEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectPiiEntitiesResponse detectPiiEntities(DetectPiiEntitiesRequest detectPiiEntitiesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns
     * information about them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectPiiEntitiesRequest.Builder} avoiding the need
     * to create one manually via {@link DetectPiiEntitiesRequest#builder()}
     * </p>
     *
     * @param detectPiiEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link DetectPiiEntitiesRequest.Builder} to create a request.
     * @return Result of the DetectPiiEntities operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectPiiEntitiesResponse detectPiiEntities(Consumer<DetectPiiEntitiesRequest.Builder> detectPiiEntitiesRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectPiiEntities(DetectPiiEntitiesRequest.builder().applyMutation(detectPiiEntitiesRequest).build());
    }

    /**
     * <p>
     * Inspects text and returns an inference of the prevailing sentiment (<code>POSITIVE</code>, <code>NEUTRAL</code>,
     * <code>MIXED</code>, or <code>NEGATIVE</code>).
     * </p>
     *
     * @param detectSentimentRequest
     * @return Result of the DetectSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectSentimentResponse detectSentiment(DetectSentimentRequest detectSentimentRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects text and returns an inference of the prevailing sentiment (<code>POSITIVE</code>, <code>NEUTRAL</code>,
     * <code>MIXED</code>, or <code>NEGATIVE</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectSentimentRequest.Builder} avoiding the need
     * to create one manually via {@link DetectSentimentRequest#builder()}
     * </p>
     *
     * @param detectSentimentRequest
     *        A {@link Consumer} that will call methods on {@link DetectSentimentRequest.Builder} to create a request.
     * @return Result of the DetectSentiment operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectSentimentResponse detectSentiment(Consumer<DetectSentimentRequest.Builder> detectSentimentRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectSentiment(DetectSentimentRequest.builder().applyMutation(detectSentimentRequest).build());
    }

    /**
     * <p>
     * Inspects text for syntax and the part of speech of words in the document. For more information,
     * <a>how-syntax</a>.
     * </p>
     *
     * @param detectSyntaxRequest
     * @return Result of the DetectSyntax operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax" target="_top">AWS API
     *      Documentation</a>
     */
    default DetectSyntaxResponse detectSyntax(DetectSyntaxRequest detectSyntaxRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects text for syntax and the part of speech of words in the document. For more information,
     * <a>how-syntax</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectSyntaxRequest.Builder} avoiding the need to
     * create one manually via {@link DetectSyntaxRequest#builder()}
     * </p>
     *
     * @param detectSyntaxRequest
     *        A {@link Consumer} that will call methods on {@link DetectSyntaxRequest.Builder} to create a request.
     * @return Result of the DetectSyntax operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TextSizeLimitExceededException
     *         The size of the input text exceeds the limit. Use a smaller document.
     * @throws UnsupportedLanguageException
     *         Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only
     *         English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages,
     *         see <a>supported-languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.DetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax" target="_top">AWS API
     *      Documentation</a>
     */
    default DetectSyntaxResponse detectSyntax(Consumer<DetectSyntaxRequest.Builder> detectSyntaxRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return detectSyntax(DetectSyntaxRequest.builder().applyMutation(detectSyntaxRequest).build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListDocumentClassificationJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see #listDocumentClassificationJobs(ListDocumentClassificationJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsResponse listDocumentClassificationJobs() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDocumentClassificationJobs(ListDocumentClassificationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     * @return Result of the ListDocumentClassificationJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsResponse listDocumentClassificationJobs(
            ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassificationJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentClassificationJobsRequest#builder()}
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentClassificationJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDocumentClassificationJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsResponse listDocumentClassificationJobs(
            Consumer<ListDocumentClassificationJobsRequest.Builder> listDocumentClassificationJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listDocumentClassificationJobs(ListDocumentClassificationJobsRequest.builder()
                .applyMutation(listDocumentClassificationJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client
     *             .listDocumentClassificationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see #listDocumentClassificationJobsPaginator(ListDocumentClassificationJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsIterable listDocumentClassificationJobsPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDocumentClassificationJobsPaginator(ListDocumentClassificationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client
     *             .listDocumentClassificationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsIterable listDocumentClassificationJobsPaginator(
            ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client
     *             .listDocumentClassificationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable responses = client.listDocumentClassificationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassificationJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentClassificationJobsRequest#builder()}
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentClassificationJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsIterable listDocumentClassificationJobsPaginator(
            Consumer<ListDocumentClassificationJobsRequest.Builder> listDocumentClassificationJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listDocumentClassificationJobsPaginator(ListDocumentClassificationJobsRequest.builder()
                .applyMutation(listDocumentClassificationJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     *
     * @return Result of the ListDocumentClassifiers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see #listDocumentClassifiers(ListDocumentClassifiersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersResponse listDocumentClassifiers() throws InvalidRequestException, TooManyRequestsException,
            InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listDocumentClassifiers(ListDocumentClassifiersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     *
     * @param listDocumentClassifiersRequest
     * @return Result of the ListDocumentClassifiers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersResponse listDocumentClassifiers(ListDocumentClassifiersRequest listDocumentClassifiersRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassifiersRequest.Builder} avoiding
     * the need to create one manually via {@link ListDocumentClassifiersRequest#builder()}
     * </p>
     *
     * @param listDocumentClassifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentClassifiersRequest.Builder} to create a
     *        request.
     * @return Result of the ListDocumentClassifiers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersResponse listDocumentClassifiers(
            Consumer<ListDocumentClassifiersRequest.Builder> listDocumentClassifiersRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDocumentClassifiers(ListDocumentClassifiersRequest.builder().applyMutation(listDocumentClassifiersRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client
     *             .listDocumentClassifiersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see #listDocumentClassifiersPaginator(ListDocumentClassifiersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersIterable listDocumentClassifiersPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDocumentClassifiersPaginator(ListDocumentClassifiersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client
     *             .listDocumentClassifiersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentClassifiersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersIterable listDocumentClassifiersPaginator(
            ListDocumentClassifiersRequest listDocumentClassifiersRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client
     *             .listDocumentClassifiersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable responses = client.listDocumentClassifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassifiersRequest.Builder} avoiding
     * the need to create one manually via {@link ListDocumentClassifiersRequest#builder()}
     * </p>
     *
     * @param listDocumentClassifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentClassifiersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersIterable listDocumentClassifiersPaginator(
            Consumer<ListDocumentClassifiersRequest.Builder> listDocumentClassifiersRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDocumentClassifiersPaginator(ListDocumentClassifiersRequest.builder()
                .applyMutation(listDocumentClassifiersRequest).build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListDominantLanguageDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see #listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobs() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     * @return Result of the ListDominantLanguageDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobs(
            ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDominantLanguageDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDominantLanguageDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDominantLanguageDetectionJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDominantLanguageDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobs(
            Consumer<ListDominantLanguageDetectionJobsRequest.Builder> listDominantLanguageDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest.builder()
                .applyMutation(listDominantLanguageDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client
     *             .listDominantLanguageDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see #listDominantLanguageDetectionJobsPaginator(ListDominantLanguageDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsIterable listDominantLanguageDetectionJobsPaginator()
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listDominantLanguageDetectionJobsPaginator(ListDominantLanguageDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client
     *             .listDominantLanguageDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsIterable listDominantLanguageDetectionJobsPaginator(
            ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client
     *             .listDominantLanguageDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable responses = client.listDominantLanguageDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDominantLanguageDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDominantLanguageDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDominantLanguageDetectionJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsIterable listDominantLanguageDetectionJobsPaginator(
            Consumer<ListDominantLanguageDetectionJobsRequest.Builder> listDominantLanguageDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listDominantLanguageDetectionJobsPaginator(ListDominantLanguageDetectionJobsRequest.builder()
                .applyMutation(listDominantLanguageDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of all existing endpoints that you've created.
     * </p>
     *
     * @param listEndpointsRequest
     * @return Result of the ListEndpoints operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsResponse listEndpoints(ListEndpointsRequest listEndpointsRequest) throws InvalidRequestException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all existing endpoints that you've created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEndpointsRequest#builder()}
     * </p>
     *
     * @param listEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointsRequest.Builder} to create a request.
     * @return Result of the ListEndpoints operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsResponse listEndpoints(Consumer<ListEndpointsRequest.Builder> listEndpointsRequest)
            throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return listEndpoints(ListEndpointsRequest.builder().applyMutation(listEndpointsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListEntitiesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see #listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsResponse listEntitiesDetectionJobs() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     * @return Result of the ListEntitiesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsResponse listEntitiesDetectionJobs(
            ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEntitiesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesDetectionJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEntitiesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsResponse listEntitiesDetectionJobs(
            Consumer<ListEntitiesDetectionJobsRequest.Builder> listEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest.builder()
                .applyMutation(listEntitiesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client
     *             .listEntitiesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see #listEntitiesDetectionJobsPaginator(ListEntitiesDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsIterable listEntitiesDetectionJobsPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntitiesDetectionJobsPaginator(ListEntitiesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client
     *             .listEntitiesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsIterable listEntitiesDetectionJobsPaginator(
            ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client
     *             .listEntitiesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable responses = client.listEntitiesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEntitiesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsIterable listEntitiesDetectionJobsPaginator(
            Consumer<ListEntitiesDetectionJobsRequest.Builder> listEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntitiesDetectionJobsPaginator(ListEntitiesDetectionJobsRequest.builder()
                .applyMutation(listEntitiesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     *
     * @return Result of the ListEntityRecognizers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see #listEntityRecognizers(ListEntityRecognizersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersResponse listEntityRecognizers() throws InvalidRequestException, TooManyRequestsException,
            InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listEntityRecognizers(ListEntityRecognizersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     *
     * @param listEntityRecognizersRequest
     * @return Result of the ListEntityRecognizers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersResponse listEntityRecognizers(ListEntityRecognizersRequest listEntityRecognizersRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityRecognizersRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntityRecognizersRequest#builder()}
     * </p>
     *
     * @param listEntityRecognizersRequest
     *        A {@link Consumer} that will call methods on {@link ListEntityRecognizersRequest.Builder} to create a
     *        request.
     * @return Result of the ListEntityRecognizers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersResponse listEntityRecognizers(
            Consumer<ListEntityRecognizersRequest.Builder> listEntityRecognizersRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntityRecognizers(ListEntityRecognizersRequest.builder().applyMutation(listEntityRecognizersRequest).build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client
     *             .listEntityRecognizersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see #listEntityRecognizersPaginator(ListEntityRecognizersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersIterable listEntityRecognizersPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntityRecognizersPaginator(ListEntityRecognizersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client
     *             .listEntityRecognizersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntityRecognizersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersIterable listEntityRecognizersPaginator(ListEntityRecognizersRequest listEntityRecognizersRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client
     *             .listEntityRecognizersPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable responses = client.listEntityRecognizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityRecognizersRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntityRecognizersRequest#builder()}
     * </p>
     *
     * @param listEntityRecognizersRequest
     *        A {@link Consumer} that will call methods on {@link ListEntityRecognizersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersIterable listEntityRecognizersPaginator(
            Consumer<ListEntityRecognizersRequest.Builder> listEntityRecognizersRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEntityRecognizersPaginator(ListEntityRecognizersRequest.builder().applyMutation(listEntityRecognizersRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     * @return Result of the ListEventsDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventsDetectionJobsResponse listEventsDetectionJobs(ListEventsDetectionJobsRequest listEventsDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventsDetectionJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEventsDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventsDetectionJobsResponse listEventsDetectionJobs(
            Consumer<ListEventsDetectionJobsRequest.Builder> listEventsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEventsDetectionJobs(ListEventsDetectionJobsRequest.builder().applyMutation(listEventsDetectionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client.listEventsDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client
     *             .listEventsDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client.listEventsDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventsDetectionJobsIterable listEventsDetectionJobsPaginator(
            ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client.listEventsDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client
     *             .listEventsDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable responses = client.listEventsDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventsDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventsDetectionJobsIterable listEventsDetectionJobsPaginator(
            Consumer<ListEventsDetectionJobsRequest.Builder> listEventsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listEventsDetectionJobsPaginator(ListEventsDetectionJobsRequest.builder()
                .applyMutation(listEventsDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListKeyPhrasesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see #listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobs() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     * @return Result of the ListKeyPhrasesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobs(
            ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeyPhrasesDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListKeyPhrasesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListKeyPhrasesDetectionJobsRequest.Builder} to create
     *        a request.
     * @return Result of the ListKeyPhrasesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobs(
            Consumer<ListKeyPhrasesDetectionJobsRequest.Builder> listKeyPhrasesDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest.builder()
                .applyMutation(listKeyPhrasesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client
     *             .listKeyPhrasesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see #listKeyPhrasesDetectionJobsPaginator(ListKeyPhrasesDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsIterable listKeyPhrasesDetectionJobsPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listKeyPhrasesDetectionJobsPaginator(ListKeyPhrasesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client
     *             .listKeyPhrasesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsIterable listKeyPhrasesDetectionJobsPaginator(
            ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client
     *             .listKeyPhrasesDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable responses = client.listKeyPhrasesDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeyPhrasesDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListKeyPhrasesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListKeyPhrasesDetectionJobsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsIterable listKeyPhrasesDetectionJobsPaginator(
            Consumer<ListKeyPhrasesDetectionJobsRequest.Builder> listKeyPhrasesDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listKeyPhrasesDetectionJobsPaginator(ListKeyPhrasesDetectionJobsRequest.builder()
                .applyMutation(listKeyPhrasesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the PII entity detection jobs that you have submitted.
     * </p>
     *
     * @param listPiiEntitiesDetectionJobsRequest
     * @return Result of the ListPiiEntitiesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListPiiEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPiiEntitiesDetectionJobsResponse listPiiEntitiesDetectionJobs(
            ListPiiEntitiesDetectionJobsRequest listPiiEntitiesDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the PII entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPiiEntitiesDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPiiEntitiesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listPiiEntitiesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListPiiEntitiesDetectionJobsRequest.Builder} to create
     *        a request.
     * @return Result of the ListPiiEntitiesDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListPiiEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPiiEntitiesDetectionJobsResponse listPiiEntitiesDetectionJobs(
            Consumer<ListPiiEntitiesDetectionJobsRequest.Builder> listPiiEntitiesDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsRequest.builder()
                .applyMutation(listPiiEntitiesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListSentimentDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see #listSentimentDetectionJobs(ListSentimentDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsResponse listSentimentDetectionJobs() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listSentimentDetectionJobs(ListSentimentDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     * @return Result of the ListSentimentDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsResponse listSentimentDetectionJobs(
            ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSentimentDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSentimentDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSentimentDetectionJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSentimentDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsResponse listSentimentDetectionJobs(
            Consumer<ListSentimentDetectionJobsRequest.Builder> listSentimentDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listSentimentDetectionJobs(ListSentimentDetectionJobsRequest.builder()
                .applyMutation(listSentimentDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client
     *             .listSentimentDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see #listSentimentDetectionJobsPaginator(ListSentimentDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsIterable listSentimentDetectionJobsPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listSentimentDetectionJobsPaginator(ListSentimentDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client
     *             .listSentimentDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsIterable listSentimentDetectionJobsPaginator(
            ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client
     *             .listSentimentDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable responses = client.listSentimentDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSentimentDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSentimentDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSentimentDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsIterable listSentimentDetectionJobsPaginator(
            Consumer<ListSentimentDetectionJobsRequest.Builder> listSentimentDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return listSentimentDetectionJobsPaginator(ListSentimentDetectionJobsRequest.builder()
                .applyMutation(listSentimentDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Comprehend resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Comprehend resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     *
     * @return Result of the ListTopicsDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see #listTopicsDetectionJobs(ListTopicsDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsResponse listTopicsDetectionJobs() throws InvalidRequestException, TooManyRequestsException,
            InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return listTopicsDetectionJobs(ListTopicsDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     * @return Result of the ListTopicsDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsResponse listTopicsDetectionJobs(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTopicsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTopicsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTopicsDetectionJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTopicsDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsResponse listTopicsDetectionJobs(
            Consumer<ListTopicsDetectionJobsRequest.Builder> listTopicsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listTopicsDetectionJobs(ListTopicsDetectionJobsRequest.builder().applyMutation(listTopicsDetectionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client
     *             .listTopicsDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see #listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsIterable listTopicsDetectionJobsPaginator() throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client
     *             .listTopicsDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsIterable listTopicsDetectionJobsPaginator(
            ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client
     *             .listTopicsDetectionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable responses = client.listTopicsDetectionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTopicsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTopicsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTopicsDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws InvalidFilterException
     *         The filter specified for the operation is invalid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsIterable listTopicsDetectionJobsPaginator(
            Consumer<ListTopicsDetectionJobsRequest.Builder> listTopicsDetectionJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendException {
        return listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest.builder()
                .applyMutation(listTopicsDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous document classification job. Use the operation to track the progress of the job.
     * </p>
     *
     * @param startDocumentClassificationJobRequest
     * @return Result of the StartDocumentClassificationJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDocumentClassificationJobResponse startDocumentClassificationJob(
            StartDocumentClassificationJobRequest startDocumentClassificationJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous document classification job. Use the operation to track the progress of the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDocumentClassificationJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartDocumentClassificationJobRequest#builder()}
     * </p>
     *
     * @param startDocumentClassificationJobRequest
     *        A {@link Consumer} that will call methods on {@link StartDocumentClassificationJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartDocumentClassificationJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDocumentClassificationJobResponse startDocumentClassificationJob(
            Consumer<StartDocumentClassificationJobRequest.Builder> startDocumentClassificationJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException,
            KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return startDocumentClassificationJob(StartDocumentClassificationJobRequest.builder()
                .applyMutation(startDocumentClassificationJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track
     * the status of a job.
     * </p>
     *
     * @param startDominantLanguageDetectionJobRequest
     * @return Result of the StartDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDominantLanguageDetectionJobResponse startDominantLanguageDetectionJob(
            StartDominantLanguageDetectionJobRequest startDominantLanguageDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track
     * the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDominantLanguageDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartDominantLanguageDetectionJobRequest#builder()}
     * </p>
     *
     * @param startDominantLanguageDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartDominantLanguageDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDominantLanguageDetectionJobResponse startDominantLanguageDetectionJob(
            Consumer<StartDominantLanguageDetectionJobRequest.Builder> startDominantLanguageDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest.builder()
                .applyMutation(startDominantLanguageDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status
     * of a job.
     * </p>
     * <p>
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for
     * custom entity recognition, the optional <code>EntityRecognizerArn</code> must be used in order to provide access
     * to the recognizer being used to detect the custom entity.
     * </p>
     *
     * @param startEntitiesDetectionJobRequest
     * @return Result of the StartEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEntitiesDetectionJobResponse startEntitiesDetectionJob(
            StartEntitiesDetectionJobRequest startEntitiesDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status
     * of a job.
     * </p>
     * <p>
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for
     * custom entity recognition, the optional <code>EntityRecognizerArn</code> must be used in order to provide access
     * to the recognizer being used to detect the custom entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEntitiesDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param startEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartEntitiesDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEntitiesDetectionJobResponse startEntitiesDetectionJob(
            Consumer<StartEntitiesDetectionJobRequest.Builder> startEntitiesDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return startEntitiesDetectionJob(StartEntitiesDetectionJobRequest.builder()
                .applyMutation(startEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous event detection job for a collection of documents.
     * </p>
     *
     * @param startEventsDetectionJobRequest
     * @return Result of the StartEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEventsDetectionJobResponse startEventsDetectionJob(StartEventsDetectionJobRequest startEventsDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous event detection job for a collection of documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEventsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartEventsDetectionJobRequest#builder()}
     * </p>
     *
     * @param startEventsDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartEventsDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEventsDetectionJobResponse startEventsDetectionJob(
            Consumer<StartEventsDetectionJobRequest.Builder> startEventsDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return startEventsDetectionJob(StartEventsDetectionJobRequest.builder().applyMutation(startEventsDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     *
     * @param startKeyPhrasesDetectionJobRequest
     * @return Result of the StartKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartKeyPhrasesDetectionJobResponse startKeyPhrasesDetectionJob(
            StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartKeyPhrasesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartKeyPhrasesDetectionJobRequest#builder()}
     * </p>
     *
     * @param startKeyPhrasesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartKeyPhrasesDetectionJobRequest.Builder} to create
     *        a request.
     * @return Result of the StartKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartKeyPhrasesDetectionJobResponse startKeyPhrasesDetectionJob(
            Consumer<StartKeyPhrasesDetectionJobRequest.Builder> startKeyPhrasesDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest.builder()
                .applyMutation(startKeyPhrasesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous PII entity detection job for a collection of documents.
     * </p>
     *
     * @param startPiiEntitiesDetectionJobRequest
     * @return Result of the StartPiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartPiiEntitiesDetectionJobResponse startPiiEntitiesDetectionJob(
            StartPiiEntitiesDetectionJobRequest startPiiEntitiesDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous PII entity detection job for a collection of documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPiiEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartPiiEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param startPiiEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartPiiEntitiesDetectionJobRequest.Builder} to create
     *        a request.
     * @return Result of the StartPiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartPiiEntitiesDetectionJobResponse startPiiEntitiesDetectionJob(
            Consumer<StartPiiEntitiesDetectionJobRequest.Builder> startPiiEntitiesDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return startPiiEntitiesDetectionJob(StartPiiEntitiesDetectionJobRequest.builder()
                .applyMutation(startPiiEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous sentiment detection job for a collection of documents. use the operation to track the
     * status of a job.
     * </p>
     *
     * @param startSentimentDetectionJobRequest
     * @return Result of the StartSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSentimentDetectionJobResponse startSentimentDetectionJob(
            StartSentimentDetectionJobRequest startSentimentDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous sentiment detection job for a collection of documents. use the operation to track the
     * status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSentimentDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param startSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartSentimentDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSentimentDetectionJobResponse startSentimentDetectionJob(
            Consumer<StartSentimentDetectionJobRequest.Builder> startSentimentDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return startSentimentDetectionJob(StartSentimentDetectionJobRequest.builder()
                .applyMutation(startSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous topic detection job. Use the <code>DescribeTopicDetectionJob</code> operation to track the
     * status of a job.
     * </p>
     *
     * @param startTopicsDetectionJobRequest
     * @return Result of the StartTopicsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTopicsDetectionJobResponse startTopicsDetectionJob(StartTopicsDetectionJobRequest startTopicsDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous topic detection job. Use the <code>DescribeTopicDetectionJob</code> operation to track the
     * status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTopicsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartTopicsDetectionJobRequest#builder()}
     * </p>
     *
     * @param startTopicsDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartTopicsDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartTopicsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws KmsKeyValidationException
     *         The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StartTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTopicsDetectionJobResponse startTopicsDetectionJob(
            Consumer<StartTopicsDetectionJobRequest.Builder> startTopicsDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, KmsKeyValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return startTopicsDetectionJob(StartTopicsDetectionJobRequest.builder().applyMutation(startTopicsDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops a dominant language detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopDominantLanguageDetectionJobRequest
     * @return Result of the StopDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopDominantLanguageDetectionJobResponse stopDominantLanguageDetectionJob(
            StopDominantLanguageDetectionJobRequest stopDominantLanguageDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a dominant language detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDominantLanguageDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StopDominantLanguageDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopDominantLanguageDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopDominantLanguageDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StopDominantLanguageDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopDominantLanguageDetectionJobResponse stopDominantLanguageDetectionJob(
            Consumer<StopDominantLanguageDetectionJobRequest.Builder> stopDominantLanguageDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest.builder()
                .applyMutation(stopDominantLanguageDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops an entities detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopEntitiesDetectionJobRequest
     * @return Result of the StopEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopEntitiesDetectionJobResponse stopEntitiesDetectionJob(
            StopEntitiesDetectionJobRequest stopEntitiesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an entities detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEntitiesDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopEntitiesDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StopEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopEntitiesDetectionJobResponse stopEntitiesDetectionJob(
            Consumer<StopEntitiesDetectionJobRequest.Builder> stopEntitiesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest.builder().applyMutation(stopEntitiesDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops an events detection job in progress.
     * </p>
     *
     * @param stopEventsDetectionJobRequest
     * @return Result of the StopEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopEventsDetectionJobResponse stopEventsDetectionJob(StopEventsDetectionJobRequest stopEventsDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an events detection job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEventsDetectionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopEventsDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopEventsDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopEventsDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StopEventsDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopEventsDetectionJobResponse stopEventsDetectionJob(
            Consumer<StopEventsDetectionJobRequest.Builder> stopEventsDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return stopEventsDetectionJob(StopEventsDetectionJobRequest.builder().applyMutation(stopEventsDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops a key phrases detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopKeyPhrasesDetectionJobRequest
     * @return Result of the StopKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopKeyPhrasesDetectionJobResponse stopKeyPhrasesDetectionJob(
            StopKeyPhrasesDetectionJobRequest stopKeyPhrasesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a key phrases detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopKeyPhrasesDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopKeyPhrasesDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopKeyPhrasesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopKeyPhrasesDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StopKeyPhrasesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopKeyPhrasesDetectionJobResponse stopKeyPhrasesDetectionJob(
            Consumer<StopKeyPhrasesDetectionJobRequest.Builder> stopKeyPhrasesDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest.builder()
                .applyMutation(stopKeyPhrasesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a PII entities detection job in progress.
     * </p>
     *
     * @param stopPiiEntitiesDetectionJobRequest
     * @return Result of the StopPiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopPiiEntitiesDetectionJobResponse stopPiiEntitiesDetectionJob(
            StopPiiEntitiesDetectionJobRequest stopPiiEntitiesDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a PII entities detection job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopPiiEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StopPiiEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopPiiEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopPiiEntitiesDetectionJobRequest.Builder} to create
     *        a request.
     * @return Result of the StopPiiEntitiesDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopPiiEntitiesDetectionJobResponse stopPiiEntitiesDetectionJob(
            Consumer<StopPiiEntitiesDetectionJobRequest.Builder> stopPiiEntitiesDetectionJobRequest)
            throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return stopPiiEntitiesDetectionJob(StopPiiEntitiesDetectionJobRequest.builder()
                .applyMutation(stopPiiEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopSentimentDetectionJobRequest
     * @return Result of the StopSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopSentimentDetectionJobResponse stopSentimentDetectionJob(
            StopSentimentDetectionJobRequest stopSentimentDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSentimentDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopSentimentDetectionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StopSentimentDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws JobNotFoundException
     *         The specified job was not found. Check the job ID and try again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopSentimentDetectionJobResponse stopSentimentDetectionJob(
            Consumer<StopSentimentDetectionJobRequest.Builder> stopSentimentDetectionJobRequest) throws InvalidRequestException,
            JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return stopSentimentDetectionJob(StopSentimentDetectionJobRequest.builder()
                .applyMutation(stopSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a document classifier training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and put into the <code>STOPPED</code> state and the
     * service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param stopTrainingDocumentClassifierRequest
     * @return Result of the StopTrainingDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopTrainingDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTrainingDocumentClassifierResponse stopTrainingDocumentClassifier(
            StopTrainingDocumentClassifierRequest stopTrainingDocumentClassifierRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a document classifier training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and put into the <code>STOPPED</code> state and the
     * service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTrainingDocumentClassifierRequest.Builder}
     * avoiding the need to create one manually via {@link StopTrainingDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param stopTrainingDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on {@link StopTrainingDocumentClassifierRequest.Builder} to
     *        create a request.
     * @return Result of the StopTrainingDocumentClassifier operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopTrainingDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTrainingDocumentClassifierResponse stopTrainingDocumentClassifier(
            Consumer<StopTrainingDocumentClassifierRequest.Builder> stopTrainingDocumentClassifierRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest.builder()
                .applyMutation(stopTrainingDocumentClassifierRequest).build());
    }

    /**
     * <p>
     * Stops an entity recognizer training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and putted into the <code>STOPPED</code> state and
     * the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param stopTrainingEntityRecognizerRequest
     * @return Result of the StopTrainingEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopTrainingEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTrainingEntityRecognizerResponse stopTrainingEntityRecognizer(
            StopTrainingEntityRecognizerRequest stopTrainingEntityRecognizerRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an entity recognizer training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and putted into the <code>STOPPED</code> state and
     * the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTrainingEntityRecognizerRequest.Builder}
     * avoiding the need to create one manually via {@link StopTrainingEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param stopTrainingEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on {@link StopTrainingEntityRecognizerRequest.Builder} to create
     *        a request.
     * @return Result of the StopTrainingEntityRecognizer operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.StopTrainingEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTrainingEntityRecognizerResponse stopTrainingEntityRecognizer(
            Consumer<StopTrainingEntityRecognizerRequest.Builder> stopTrainingEntityRecognizerRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        return stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest.builder()
                .applyMutation(stopTrainingEntityRecognizerRequest).build());
    }

    /**
     * <p>
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata
     * to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource
     * to indicate its use by the sales department.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ConcurrentModificationException
     *         Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            ConcurrentModificationException, ResourceNotFoundException, TooManyTagsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata
     * to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource
     * to indicate its use by the sales department.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ConcurrentModificationException
     *         Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws TooManyTagsException
     *         The request contains more tags than can be associated with a resource (50 tags per resource). The maximum
     *         number of tags includes both existing tags and those included in your current request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException, TooManyTagsException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Comprehend resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws TooManyTagKeysException
     *         The request contains more tag keys than can be associated with a resource (50 tag keys per resource).
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ConcurrentModificationException
     *         Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws TooManyTagKeysException,
            InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Comprehend resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws TooManyTagKeysException
     *         The request contains more tag keys than can be associated with a resource (50 tag keys per resource).
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ConcurrentModificationException
     *         Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws TooManyTagKeysException, InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates information about the specified endpoint.
     * </p>
     *
     * @param updateEndpointRequest
     * @return Result of the UpdateEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest updateEndpointRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException,
            ResourceUnavailableException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about the specified endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateEndpointRequest#builder()}
     * </p>
     *
     * @param updateEndpointRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointRequest.Builder} to create a request.
     * @return Result of the UpdateEndpoint operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit. Resubmit your request later.
     * @throws ResourceInUseException
     *         The specified resource name is already in use. Use a different name and try your request again.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources per account has been exceeded. Review the resources, and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The specified resource ARN was not found. Check the ARN and try your request again.
     * @throws ResourceUnavailableException
     *         The specified resource is not available. Check the resource and try your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEndpointResponse updateEndpoint(Consumer<UpdateEndpointRequest.Builder> updateEndpointRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceInUseException, ResourceLimitExceededException,
            ResourceNotFoundException, ResourceUnavailableException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendException {
        return updateEndpoint(UpdateEndpointRequest.builder().applyMutation(updateEndpointRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
