/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of calling the operation. The operation returns one object for each document that is successfully
 * processed by the operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDetectDominantLanguageItemResult implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDetectDominantLanguageItemResult.Builder, BatchDetectDominantLanguageItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Index")
            .getter(getter(BatchDetectDominantLanguageItemResult::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final SdkField<List<DominantLanguage>> LANGUAGES_FIELD = SdkField
            .<List<DominantLanguage>> builder(MarshallingType.LIST)
            .memberName("Languages")
            .getter(getter(BatchDetectDominantLanguageItemResult::languages))
            .setter(setter(Builder::languages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Languages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DominantLanguage> builder(MarshallingType.SDK_POJO)
                                            .constructor(DominantLanguage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, LANGUAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer index;

    private final List<DominantLanguage> languages;

    private BatchDetectDominantLanguageItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.languages = builder.languages;
    }

    /**
     * <p>
     * The zero-based index of the document in the input list.
     * </p>
     * 
     * @return The zero-based index of the document in the input list.
     */
    public final Integer index() {
        return index;
    }

    /**
     * Returns true if the Languages property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLanguages() {
        return languages != null && !(languages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more <a>DominantLanguage</a> objects describing the dominant languages in the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLanguages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more <a>DominantLanguage</a> objects describing the dominant languages in the document.
     */
    public final List<DominantLanguage> languages() {
        return languages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(hasLanguages() ? languages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectDominantLanguageItemResult)) {
            return false;
        }
        BatchDetectDominantLanguageItemResult other = (BatchDetectDominantLanguageItemResult) obj;
        return Objects.equals(index(), other.index()) && hasLanguages() == other.hasLanguages()
                && Objects.equals(languages(), other.languages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDetectDominantLanguageItemResult").add("Index", index())
                .add("Languages", hasLanguages() ? languages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Index":
            return Optional.ofNullable(clazz.cast(index()));
        case "Languages":
            return Optional.ofNullable(clazz.cast(languages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectDominantLanguageItemResult, T> g) {
        return obj -> g.apply((BatchDetectDominantLanguageItemResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDetectDominantLanguageItemResult> {
        /**
         * <p>
         * The zero-based index of the document in the input list.
         * </p>
         * 
         * @param index
         *        The zero-based index of the document in the input list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);

        /**
         * <p>
         * One or more <a>DominantLanguage</a> objects describing the dominant languages in the document.
         * </p>
         * 
         * @param languages
         *        One or more <a>DominantLanguage</a> objects describing the dominant languages in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(Collection<DominantLanguage> languages);

        /**
         * <p>
         * One or more <a>DominantLanguage</a> objects describing the dominant languages in the document.
         * </p>
         * 
         * @param languages
         *        One or more <a>DominantLanguage</a> objects describing the dominant languages in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(DominantLanguage... languages);

        /**
         * <p>
         * One or more <a>DominantLanguage</a> objects describing the dominant languages in the document.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DominantLanguage>.Builder} avoiding the
         * need to create one manually via {@link List<DominantLanguage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DominantLanguage>.Builder#build()} is called immediately and
         * its result is passed to {@link #languages(List<DominantLanguage>)}.
         * 
         * @param languages
         *        a consumer that will call methods on {@link List<DominantLanguage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #languages(List<DominantLanguage>)
         */
        Builder languages(Consumer<DominantLanguage.Builder>... languages);
    }

    static final class BuilderImpl implements Builder {
        private Integer index;

        private List<DominantLanguage> languages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectDominantLanguageItemResult model) {
            index(model.index);
            languages(model.languages);
        }

        public final Integer getIndex() {
            return index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        public final List<DominantLanguage.Builder> getLanguages() {
            List<DominantLanguage.Builder> result = ListOfDominantLanguagesCopier.copyToBuilder(this.languages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder languages(Collection<DominantLanguage> languages) {
            this.languages = ListOfDominantLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(DominantLanguage... languages) {
            languages(Arrays.asList(languages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Consumer<DominantLanguage.Builder>... languages) {
            languages(Stream.of(languages).map(c -> DominantLanguage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLanguages(Collection<DominantLanguage.BuilderImpl> languages) {
            this.languages = ListOfDominantLanguagesCopier.copyFromBuilder(languages);
        }

        @Override
        public BatchDetectDominantLanguageItemResult build() {
            return new BatchDetectDominantLanguageItemResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
