/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies information about the specified endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointProperties.Builder, EndpointProperties> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(EndpointProperties::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EndpointProperties::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(EndpointProperties::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(EndpointProperties::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<Integer> DESIRED_INFERENCE_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredInferenceUnits").getter(getter(EndpointProperties::desiredInferenceUnits))
            .setter(setter(Builder::desiredInferenceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInferenceUnits").build())
            .build();

    private static final SdkField<Integer> CURRENT_INFERENCE_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CurrentInferenceUnits").getter(getter(EndpointProperties::currentInferenceUnits))
            .setter(setter(Builder::currentInferenceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInferenceUnits").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(EndpointProperties::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(EndpointProperties::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(EndpointProperties::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD,
            STATUS_FIELD, MESSAGE_FIELD, MODEL_ARN_FIELD, DESIRED_INFERENCE_UNITS_FIELD, CURRENT_INFERENCE_UNITS_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, DATA_ACCESS_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointArn;

    private final String status;

    private final String message;

    private final String modelArn;

    private final Integer desiredInferenceUnits;

    private final Integer currentInferenceUnits;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String dataAccessRoleArn;

    private EndpointProperties(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
        this.status = builder.status;
        this.message = builder.message;
        this.modelArn = builder.modelArn;
        this.desiredInferenceUnits = builder.desiredInferenceUnits;
        this.currentInferenceUnits = builder.currentInferenceUnits;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the endpoint.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so customers
     * will need to wait for the endpoint to be <code>Ready</code> status before making inference requests.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so
     *         customers will need to wait for the endpoint to be <code>Ready</code> status before making inference
     *         requests.
     * @see EndpointStatus
     */
    public final EndpointStatus status() {
        return EndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so customers
     * will need to wait for the endpoint to be <code>Ready</code> status before making inference requests.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so
     *         customers will need to wait for the endpoint to be <code>Ready</code> status before making inference
     *         requests.
     * @see EndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies a reason for failure in cases of <code>Failed</code> status.
     * </p>
     * 
     * @return Specifies a reason for failure in cases of <code>Failed</code> status.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The desired number of inference units to be used by the model using this endpoint. Each inference unit represents
     * of a throughput of 100 characters per second.
     * </p>
     * 
     * @return The desired number of inference units to be used by the model using this endpoint. Each inference unit
     *         represents of a throughput of 100 characters per second.
     */
    public final Integer desiredInferenceUnits() {
        return desiredInferenceUnits;
    }

    /**
     * <p>
     * The number of inference units currently used by the model using this endpoint.
     * </p>
     * 
     * @return The number of inference units currently used by the model using this endpoint.
     */
    public final Integer currentInferenceUnits() {
        return currentInferenceUnits;
    }

    /**
     * <p>
     * The creation date and time of the endpoint.
     * </p>
     * 
     * @return The creation date and time of the endpoint.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the endpoint was last modified.
     * </p>
     * 
     * @return The date and time that the endpoint was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon Comprehend
     * read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon
     *         Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(desiredInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(currentInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointProperties)) {
            return false;
        }
        EndpointProperties other = (EndpointProperties) obj;
        return Objects.equals(endpointArn(), other.endpointArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(message(), other.message()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(desiredInferenceUnits(), other.desiredInferenceUnits())
                && Objects.equals(currentInferenceUnits(), other.currentInferenceUnits())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointProperties").add("EndpointArn", endpointArn()).add("Status", statusAsString())
                .add("Message", message()).add("ModelArn", modelArn()).add("DesiredInferenceUnits", desiredInferenceUnits())
                .add("CurrentInferenceUnits", currentInferenceUnits()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("DataAccessRoleArn", dataAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "DesiredInferenceUnits":
            return Optional.ofNullable(clazz.cast(desiredInferenceUnits()));
        case "CurrentInferenceUnits":
            return Optional.ofNullable(clazz.cast(currentInferenceUnits()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointProperties, T> g) {
        return obj -> g.apply((EndpointProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointProperties> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the endpoint.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Number (ARN) of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so
         * customers will need to wait for the endpoint to be <code>Ready</code> status before making inference
         * requests.
         * </p>
         * 
         * @param status
         *        Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so
         *        customers will need to wait for the endpoint to be <code>Ready</code> status before making inference
         *        requests.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so
         * customers will need to wait for the endpoint to be <code>Ready</code> status before making inference
         * requests.
         * </p>
         * 
         * @param status
         *        Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so
         *        customers will need to wait for the endpoint to be <code>Ready</code> status before making inference
         *        requests.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder status(EndpointStatus status);

        /**
         * <p>
         * Specifies a reason for failure in cases of <code>Failed</code> status.
         * </p>
         * 
         * @param message
         *        Specifies a reason for failure in cases of <code>Failed</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The desired number of inference units to be used by the model using this endpoint. Each inference unit
         * represents of a throughput of 100 characters per second.
         * </p>
         * 
         * @param desiredInferenceUnits
         *        The desired number of inference units to be used by the model using this endpoint. Each inference unit
         *        represents of a throughput of 100 characters per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredInferenceUnits(Integer desiredInferenceUnits);

        /**
         * <p>
         * The number of inference units currently used by the model using this endpoint.
         * </p>
         * 
         * @param currentInferenceUnits
         *        The number of inference units currently used by the model using this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentInferenceUnits(Integer currentInferenceUnits);

        /**
         * <p>
         * The creation date and time of the endpoint.
         * </p>
         * 
         * @param creationTime
         *        The creation date and time of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the endpoint was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the endpoint was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon
         * Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon
         *        Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String endpointArn;

        private String status;

        private String message;

        private String modelArn;

        private Integer desiredInferenceUnits;

        private Integer currentInferenceUnits;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointProperties model) {
            endpointArn(model.endpointArn);
            status(model.status);
            message(model.message);
            modelArn(model.modelArn);
            desiredInferenceUnits(model.desiredInferenceUnits);
            currentInferenceUnits(model.currentInferenceUnits);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getModelArn() {
            return modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        public final Integer getDesiredInferenceUnits() {
            return desiredInferenceUnits;
        }

        @Override
        public final Builder desiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
            return this;
        }

        public final void setDesiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
        }

        public final Integer getCurrentInferenceUnits() {
            return currentInferenceUnits;
        }

        @Override
        public final Builder currentInferenceUnits(Integer currentInferenceUnits) {
            this.currentInferenceUnits = currentInferenceUnits;
            return this;
        }

        public final void setCurrentInferenceUnits(Integer currentInferenceUnits) {
            this.currentInferenceUnits = currentInferenceUnits;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public EndpointProperties build() {
            return new EndpointProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
