/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.TagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.TagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.UntagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.UntagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher;

/**
 * Service client for accessing Amazon Comprehend asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Comprehend is an AWS service for gaining insight into the content of documents. Use these actions to determine
 * the topics contained in your documents, the topics they discuss, the predominant sentiment expressed in them, the
 * predominant language used, and more.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ComprehendAsyncClient extends SdkClient {
    String SERVICE_NAME = "comprehend";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "comprehend";

    /**
     * Create a {@link ComprehendAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ComprehendAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ComprehendAsyncClient}.
     */
    static ComprehendAsyncClientBuilder builder() {
        return new DefaultComprehendAsyncClientBuilder();
    }

    /**
     * <p>
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon
     * Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon
     * Comprehend Supported Languages</a>.
     * </p>
     *
     * @param batchDetectDominantLanguageRequest
     * @return A Java Future containing the result of the BatchDetectDominantLanguage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDetectDominantLanguageResponse> batchDetectDominantLanguage(
            BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon
     * Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon
     * Comprehend Supported Languages</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectDominantLanguageRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDetectDominantLanguageRequest#builder()}
     * </p>
     *
     * @param batchDetectDominantLanguageRequest
     *        A {@link Consumer} that will call methods on {@link BatchDetectDominantLanguageRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the BatchDetectDominantLanguage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDetectDominantLanguageResponse> batchDetectDominantLanguage(
            Consumer<BatchDetectDominantLanguageRequest.Builder> batchDetectDominantLanguageRequest) {
        return batchDetectDominantLanguage(BatchDetectDominantLanguageRequest.builder()
                .applyMutation(batchDetectDominantLanguageRequest).build());
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for named entities and returns information about them. For more
     * information about named entities, see <a>how-entities</a>
     * </p>
     *
     * @param batchDetectEntitiesRequest
     * @return A Java Future containing the result of the BatchDetectEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDetectEntitiesResponse> batchDetectEntities(
            BatchDetectEntitiesRequest batchDetectEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for named entities and returns information about them. For more
     * information about named entities, see <a>how-entities</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDetectEntitiesRequest#builder()}
     * </p>
     *
     * @param batchDetectEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link BatchDetectEntitiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDetectEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDetectEntitiesResponse> batchDetectEntities(
            Consumer<BatchDetectEntitiesRequest.Builder> batchDetectEntitiesRequest) {
        return batchDetectEntities(BatchDetectEntitiesRequest.builder().applyMutation(batchDetectEntitiesRequest).build());
    }

    /**
     * <p>
     * Detects the key noun phrases found in a batch of documents.
     * </p>
     *
     * @param batchDetectKeyPhrasesRequest
     * @return A Java Future containing the result of the BatchDetectKeyPhrases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDetectKeyPhrasesResponse> batchDetectKeyPhrases(
            BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects the key noun phrases found in a batch of documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectKeyPhrasesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDetectKeyPhrasesRequest#builder()}
     * </p>
     *
     * @param batchDetectKeyPhrasesRequest
     *        A {@link Consumer} that will call methods on {@link BatchDetectKeyPhrasesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDetectKeyPhrases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDetectKeyPhrasesResponse> batchDetectKeyPhrases(
            Consumer<BatchDetectKeyPhrasesRequest.Builder> batchDetectKeyPhrasesRequest) {
        return batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest.builder().applyMutation(batchDetectKeyPhrasesRequest).build());
    }

    /**
     * <p>
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, <code>POSITIVE</code>,
     * <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>, in each one.
     * </p>
     *
     * @param batchDetectSentimentRequest
     * @return A Java Future containing the result of the BatchDetectSentiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDetectSentimentResponse> batchDetectSentiment(
            BatchDetectSentimentRequest batchDetectSentimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, <code>POSITIVE</code>,
     * <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>, in each one.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectSentimentRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDetectSentimentRequest#builder()}
     * </p>
     *
     * @param batchDetectSentimentRequest
     *        A {@link Consumer} that will call methods on {@link BatchDetectSentimentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDetectSentiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDetectSentimentResponse> batchDetectSentiment(
            Consumer<BatchDetectSentimentRequest.Builder> batchDetectSentimentRequest) {
        return batchDetectSentiment(BatchDetectSentimentRequest.builder().applyMutation(batchDetectSentimentRequest).build());
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and
     * returns information about them. For more information, see <a>how-syntax</a>.
     * </p>
     *
     * @param batchDetectSyntaxRequest
     * @return A Java Future containing the result of the BatchDetectSyntax operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDetectSyntaxResponse> batchDetectSyntax(BatchDetectSyntaxRequest batchDetectSyntaxRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and
     * returns information about them. For more information, see <a>how-syntax</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDetectSyntaxRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDetectSyntaxRequest#builder()}
     * </p>
     *
     * @param batchDetectSyntaxRequest
     *        A {@link Consumer} that will call methods on {@link BatchDetectSyntaxRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchDetectSyntax operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDetectSyntaxResponse> batchDetectSyntax(
            Consumer<BatchDetectSyntaxRequest.Builder> batchDetectSyntaxRequest) {
        return batchDetectSyntax(BatchDetectSyntaxRequest.builder().applyMutation(batchDetectSyntaxRequest).build());
    }

    /**
     * <p>
     * Creates a new document classification request to analyze a single document in real-time, using a previously
     * created and trained custom model and an endpoint.
     * </p>
     *
     * @param classifyDocumentRequest
     * @return A Java Future containing the result of the ClassifyDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ClassifyDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ClassifyDocumentResponse> classifyDocument(ClassifyDocumentRequest classifyDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new document classification request to analyze a single document in real-time, using a previously
     * created and trained custom model and an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClassifyDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link ClassifyDocumentRequest#builder()}
     * </p>
     *
     * @param classifyDocumentRequest
     *        A {@link Consumer} that will call methods on {@link ClassifyDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ClassifyDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ClassifyDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ClassifyDocumentResponse> classifyDocument(
            Consumer<ClassifyDocumentRequest.Builder> classifyDocumentRequest) {
        return classifyDocument(ClassifyDocumentRequest.builder().applyMutation(classifyDocumentRequest).build());
    }

    /**
     * <p>
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of
     * identified PII entity types such as name, address, bank account number, or phone number.
     * </p>
     *
     * @param containsPiiEntitiesRequest
     * @return A Java Future containing the result of the ContainsPiiEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ContainsPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ContainsPiiEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ContainsPiiEntitiesResponse> containsPiiEntities(
            ContainsPiiEntitiesRequest containsPiiEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of
     * identified PII entity types such as name, address, bank account number, or phone number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ContainsPiiEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ContainsPiiEntitiesRequest#builder()}
     * </p>
     *
     * @param containsPiiEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ContainsPiiEntitiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ContainsPiiEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ContainsPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ContainsPiiEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ContainsPiiEntitiesResponse> containsPiiEntities(
            Consumer<ContainsPiiEntitiesRequest.Builder> containsPiiEntitiesRequest) {
        return containsPiiEntities(ContainsPiiEntitiesRequest.builder().applyMutation(containsPiiEntitiesRequest).build());
    }

    /**
     * <p>
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a
     * set of training documents that labeled with the categories that you want to use. After the classifier is trained
     * you can use it to categorize a set of labeled documents into the categories. For more information, see
     * <a>how-document-classification</a>.
     * </p>
     *
     * @param createDocumentClassifierRequest
     * @return A Java Future containing the result of the CreateDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDocumentClassifierResponse> createDocumentClassifier(
            CreateDocumentClassifierRequest createDocumentClassifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a
     * set of training documents that labeled with the categories that you want to use. After the classifier is trained
     * you can use it to categorize a set of labeled documents into the categories. For more information, see
     * <a>how-document-classification</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDocumentClassifierRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param createDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on {@link CreateDocumentClassifierRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDocumentClassifierResponse> createDocumentClassifier(
            Consumer<CreateDocumentClassifierRequest.Builder> createDocumentClassifierRequest) {
        return createDocumentClassifier(CreateDocumentClassifierRequest.builder().applyMutation(createDocumentClassifierRequest)
                .build());
    }

    /**
     * <p>
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model
     * </p>
     *
     * @param createEndpointRequest
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEndpointRequest#builder()}
     * </p>
     *
     * @param createEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEndpointResponse> createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest) {
        return createEndpoint(CreateEndpointRequest.builder().applyMutation(createEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an entity recognizer using submitted files. After your <code>CreateEntityRecognizer</code> request is
     * submitted, you can check job status using the API.
     * </p>
     *
     * @param createEntityRecognizerRequest
     * @return A Java Future containing the result of the CreateEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEntityRecognizerResponse> createEntityRecognizer(
            CreateEntityRecognizerRequest createEntityRecognizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an entity recognizer using submitted files. After your <code>CreateEntityRecognizer</code> request is
     * submitted, you can check job status using the API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEntityRecognizerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param createEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on {@link CreateEntityRecognizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEntityRecognizerResponse> createEntityRecognizer(
            Consumer<CreateEntityRecognizerRequest.Builder> createEntityRecognizerRequest) {
        return createEntityRecognizer(CreateEntityRecognizerRequest.builder().applyMutation(createEntityRecognizerRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a previously created document classifier
     * </p>
     * <p>
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a
     * background job. Once removed, the classifier disappears from your account and is no longer available for use.
     * </p>
     *
     * @param deleteDocumentClassifierRequest
     * @return A Java Future containing the result of the DeleteDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDocumentClassifierResponse> deleteDocumentClassifier(
            DeleteDocumentClassifierRequest deleteDocumentClassifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously created document classifier
     * </p>
     * <p>
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a
     * background job. Once removed, the classifier disappears from your account and is no longer available for use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentClassifierRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param deleteDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDocumentClassifierRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDocumentClassifierResponse> deleteDocumentClassifier(
            Consumer<DeleteDocumentClassifierRequest.Builder> deleteDocumentClassifierRequest) {
        return deleteDocumentClassifier(DeleteDocumentClassifierRequest.builder().applyMutation(deleteDocumentClassifierRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order
     * for the model to be deleted.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order
     * for the model to be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest) {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an entity recognizer.
     * </p>
     * <p>
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a
     * background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     * </p>
     *
     * @param deleteEntityRecognizerRequest
     * @return A Java Future containing the result of the DeleteEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEntityRecognizerResponse> deleteEntityRecognizer(
            DeleteEntityRecognizerRequest deleteEntityRecognizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an entity recognizer.
     * </p>
     * <p>
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a
     * background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEntityRecognizerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param deleteEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEntityRecognizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEntityRecognizerResponse> deleteEntityRecognizer(
            Consumer<DeleteEntityRecognizerRequest.Builder> deleteEntityRecognizerRequest) {
        return deleteEntityRecognizer(DeleteEntityRecognizerRequest.builder().applyMutation(deleteEntityRecognizerRequest)
                .build());
    }

    /**
     * <p>
     * Gets the properties associated with a document classification job. Use this operation to get the status of a
     * classification job.
     * </p>
     *
     * @param describeDocumentClassificationJobRequest
     * @return A Java Future containing the result of the DescribeDocumentClassificationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDocumentClassificationJobResponse> describeDocumentClassificationJob(
            DescribeDocumentClassificationJobRequest describeDocumentClassificationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a document classification job. Use this operation to get the status of a
     * classification job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentClassificationJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDocumentClassificationJobRequest#builder()}
     * </p>
     *
     * @param describeDocumentClassificationJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDocumentClassificationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDocumentClassificationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDocumentClassificationJobResponse> describeDocumentClassificationJob(
            Consumer<DescribeDocumentClassificationJobRequest.Builder> describeDocumentClassificationJobRequest) {
        return describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest.builder()
                .applyMutation(describeDocumentClassificationJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a document classifier.
     * </p>
     *
     * @param describeDocumentClassifierRequest
     * @return A Java Future containing the result of the DescribeDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDocumentClassifierResponse> describeDocumentClassifier(
            DescribeDocumentClassifierRequest describeDocumentClassifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a document classifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentClassifierRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param describeDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDocumentClassifierRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDocumentClassifierResponse> describeDocumentClassifier(
            Consumer<DescribeDocumentClassifierRequest.Builder> describeDocumentClassifierRequest) {
        return describeDocumentClassifier(DescribeDocumentClassifierRequest.builder()
                .applyMutation(describeDocumentClassifierRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeDominantLanguageDetectionJobRequest
     * @return A Java Future containing the result of the DescribeDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDominantLanguageDetectionJobResponse> describeDominantLanguageDetectionJob(
            DescribeDominantLanguageDetectionJobRequest describeDominantLanguageDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeDominantLanguageDetectionJobRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeDominantLanguageDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeDominantLanguageDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDominantLanguageDetectionJobRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDominantLanguageDetectionJobResponse> describeDominantLanguageDetectionJob(
            Consumer<DescribeDominantLanguageDetectionJobRequest.Builder> describeDominantLanguageDetectionJobRequest) {
        return describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest.builder()
                .applyMutation(describeDominantLanguageDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint.
     * </p>
     *
     * @param describeEndpointRequest
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointRequest#builder()}
     * </p>
     *
     * @param describeEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointResponse> describeEndpoint(
            Consumer<DescribeEndpointRequest.Builder> describeEndpointRequest) {
        return describeEndpoint(DescribeEndpointRequest.builder().applyMutation(describeEndpointRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the DescribeEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEntitiesDetectionJobResponse> describeEntitiesDetectionJob(
            DescribeEntitiesDetectionJobRequest describeEntitiesDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEntitiesDetectionJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEntitiesDetectionJobResponse> describeEntitiesDetectionJob(
            Consumer<DescribeEntitiesDetectionJobRequest.Builder> describeEntitiesDetectionJobRequest) {
        return describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest.builder()
                .applyMutation(describeEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer
     * metadata, metrics, and so on.
     * </p>
     *
     * @param describeEntityRecognizerRequest
     * @return A Java Future containing the result of the DescribeEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEntityRecognizerResponse> describeEntityRecognizer(
            DescribeEntityRecognizerRequest describeEntityRecognizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer
     * metadata, metrics, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntityRecognizerRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param describeEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEntityRecognizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEntityRecognizerResponse> describeEntityRecognizer(
            Consumer<DescribeEntityRecognizerRequest.Builder> describeEntityRecognizerRequest) {
        return describeEntityRecognizer(DescribeEntityRecognizerRequest.builder().applyMutation(describeEntityRecognizerRequest)
                .build());
    }

    /**
     * <p>
     * Gets the status and details of an events detection job.
     * </p>
     *
     * @param describeEventsDetectionJobRequest
     * @return A Java Future containing the result of the DescribeEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventsDetectionJobResponse> describeEventsDetectionJob(
            DescribeEventsDetectionJobRequest describeEventsDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status and details of an events detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventsDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeEventsDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventsDetectionJobResponse> describeEventsDetectionJob(
            Consumer<DescribeEventsDetectionJobRequest.Builder> describeEventsDetectionJobRequest) {
        return describeEventsDetectionJob(DescribeEventsDetectionJobRequest.builder()
                .applyMutation(describeEventsDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeKeyPhrasesDetectionJobRequest
     * @return A Java Future containing the result of the DescribeKeyPhrasesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeKeyPhrasesDetectionJobResponse> describeKeyPhrasesDetectionJob(
            DescribeKeyPhrasesDetectionJobRequest describeKeyPhrasesDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeKeyPhrasesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeKeyPhrasesDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeKeyPhrasesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeKeyPhrasesDetectionJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeKeyPhrasesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeKeyPhrasesDetectionJobResponse> describeKeyPhrasesDetectionJob(
            Consumer<DescribeKeyPhrasesDetectionJobRequest.Builder> describeKeyPhrasesDetectionJobRequest) {
        return describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest.builder()
                .applyMutation(describeKeyPhrasesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get
     * the job status.
     * </p>
     *
     * @param describePiiEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the DescribePiiEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribePiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePiiEntitiesDetectionJobResponse> describePiiEntitiesDetectionJob(
            DescribePiiEntitiesDetectionJobRequest describePiiEntitiesDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get
     * the job status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePiiEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePiiEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param describePiiEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribePiiEntitiesDetectionJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePiiEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribePiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePiiEntitiesDetectionJobResponse> describePiiEntitiesDetectionJob(
            Consumer<DescribePiiEntitiesDetectionJobRequest.Builder> describePiiEntitiesDetectionJobRequest) {
        return describePiiEntitiesDetectionJob(DescribePiiEntitiesDetectionJobRequest.builder()
                .applyMutation(describePiiEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeSentimentDetectionJobRequest
     * @return A Java Future containing the result of the DescribeSentimentDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSentimentDetectionJobResponse> describeSentimentDetectionJob(
            DescribeSentimentDetectionJobRequest describeSentimentDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSentimentDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSentimentDetectionJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSentimentDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSentimentDetectionJobResponse> describeSentimentDetectionJob(
            Consumer<DescribeSentimentDetectionJobRequest.Builder> describeSentimentDetectionJobRequest) {
        return describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest.builder()
                .applyMutation(describeSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection
     * job.
     * </p>
     *
     * @param describeTopicsDetectionJobRequest
     * @return A Java Future containing the result of the DescribeTopicsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTopicsDetectionJobResponse> describeTopicsDetectionJob(
            DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection
     * job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTopicsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTopicsDetectionJobRequest#builder()}
     * </p>
     *
     * @param describeTopicsDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTopicsDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTopicsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTopicsDetectionJobResponse> describeTopicsDetectionJob(
            Consumer<DescribeTopicsDetectionJobRequest.Builder> describeTopicsDetectionJobRequest) {
        return describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest.builder()
                .applyMutation(describeTopicsDetectionJobRequest).build());
    }

    /**
     * <p>
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect,
     * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported
     * Languages</a>.
     * </p>
     *
     * @param detectDominantLanguageRequest
     * @return A Java Future containing the result of the DetectDominantLanguage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectDominantLanguageResponse> detectDominantLanguage(
            DetectDominantLanguageRequest detectDominantLanguageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect,
     * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported
     * Languages</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectDominantLanguageRequest.Builder} avoiding the
     * need to create one manually via {@link DetectDominantLanguageRequest#builder()}
     * </p>
     *
     * @param detectDominantLanguageRequest
     *        A {@link Consumer} that will call methods on {@link DetectDominantLanguageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetectDominantLanguage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectDominantLanguageResponse> detectDominantLanguage(
            Consumer<DetectDominantLanguageRequest.Builder> detectDominantLanguageRequest) {
        return detectDominantLanguage(DetectDominantLanguageRequest.builder().applyMutation(detectDominantLanguageRequest)
                .build());
    }

    /**
     * <p>
     * Inspects text for named entities, and returns information about them. For more information, about named entities,
     * see <a>how-entities</a>.
     * </p>
     *
     * @param detectEntitiesRequest
     * @return A Java Future containing the result of the DetectEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetectEntitiesResponse> detectEntities(DetectEntitiesRequest detectEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects text for named entities, and returns information about them. For more information, about named entities,
     * see <a>how-entities</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link DetectEntitiesRequest#builder()}
     * </p>
     *
     * @param detectEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link DetectEntitiesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetectEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetectEntitiesResponse> detectEntities(Consumer<DetectEntitiesRequest.Builder> detectEntitiesRequest) {
        return detectEntities(DetectEntitiesRequest.builder().applyMutation(detectEntitiesRequest).build());
    }

    /**
     * <p>
     * Detects the key noun phrases found in the text.
     * </p>
     *
     * @param detectKeyPhrasesRequest
     * @return A Java Future containing the result of the DetectKeyPhrases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetectKeyPhrasesResponse> detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects the key noun phrases found in the text.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectKeyPhrasesRequest.Builder} avoiding the need
     * to create one manually via {@link DetectKeyPhrasesRequest#builder()}
     * </p>
     *
     * @param detectKeyPhrasesRequest
     *        A {@link Consumer} that will call methods on {@link DetectKeyPhrasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetectKeyPhrases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetectKeyPhrasesResponse> detectKeyPhrases(
            Consumer<DetectKeyPhrasesRequest.Builder> detectKeyPhrasesRequest) {
        return detectKeyPhrases(DetectKeyPhrasesRequest.builder().applyMutation(detectKeyPhrasesRequest).build());
    }

    /**
     * <p>
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns
     * information about them.
     * </p>
     *
     * @param detectPiiEntitiesRequest
     * @return A Java Future containing the result of the DetectPiiEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetectPiiEntitiesResponse> detectPiiEntities(DetectPiiEntitiesRequest detectPiiEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns
     * information about them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectPiiEntitiesRequest.Builder} avoiding the need
     * to create one manually via {@link DetectPiiEntitiesRequest#builder()}
     * </p>
     *
     * @param detectPiiEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link DetectPiiEntitiesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetectPiiEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetectPiiEntitiesResponse> detectPiiEntities(
            Consumer<DetectPiiEntitiesRequest.Builder> detectPiiEntitiesRequest) {
        return detectPiiEntities(DetectPiiEntitiesRequest.builder().applyMutation(detectPiiEntitiesRequest).build());
    }

    /**
     * <p>
     * Inspects text and returns an inference of the prevailing sentiment (<code>POSITIVE</code>, <code>NEUTRAL</code>,
     * <code>MIXED</code>, or <code>NEGATIVE</code>).
     * </p>
     *
     * @param detectSentimentRequest
     * @return A Java Future containing the result of the DetectSentiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetectSentimentResponse> detectSentiment(DetectSentimentRequest detectSentimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects text and returns an inference of the prevailing sentiment (<code>POSITIVE</code>, <code>NEUTRAL</code>,
     * <code>MIXED</code>, or <code>NEGATIVE</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectSentimentRequest.Builder} avoiding the need
     * to create one manually via {@link DetectSentimentRequest#builder()}
     * </p>
     *
     * @param detectSentimentRequest
     *        A {@link Consumer} that will call methods on {@link DetectSentimentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetectSentiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetectSentimentResponse> detectSentiment(
            Consumer<DetectSentimentRequest.Builder> detectSentimentRequest) {
        return detectSentiment(DetectSentimentRequest.builder().applyMutation(detectSentimentRequest).build());
    }

    /**
     * <p>
     * Inspects text for syntax and the part of speech of words in the document. For more information,
     * <a>how-syntax</a>.
     * </p>
     *
     * @param detectSyntaxRequest
     * @return A Java Future containing the result of the DetectSyntax operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetectSyntaxResponse> detectSyntax(DetectSyntaxRequest detectSyntaxRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects text for syntax and the part of speech of words in the document. For more information,
     * <a>how-syntax</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectSyntaxRequest.Builder} avoiding the need to
     * create one manually via {@link DetectSyntaxRequest#builder()}
     * </p>
     *
     * @param detectSyntaxRequest
     *        A {@link Consumer} that will call methods on {@link DetectSyntaxRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetectSyntax operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For
     *         custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are
     *         accepted. For a list of supported languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetectSyntaxResponse> detectSyntax(Consumer<DetectSyntaxRequest.Builder> detectSyntaxRequest) {
        return detectSyntax(DetectSyntaxRequest.builder().applyMutation(detectSyntaxRequest).build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     * @return A Java Future containing the result of the ListDocumentClassificationJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDocumentClassificationJobsResponse> listDocumentClassificationJobs(
            ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassificationJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentClassificationJobsRequest#builder()}
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentClassificationJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDocumentClassificationJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDocumentClassificationJobsResponse> listDocumentClassificationJobs(
            Consumer<ListDocumentClassificationJobsRequest.Builder> listDocumentClassificationJobsRequest) {
        return listDocumentClassificationJobs(ListDocumentClassificationJobsRequest.builder()
                .applyMutation(listDocumentClassificationJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     *
     * @return A Java Future containing the result of the ListDocumentClassificationJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDocumentClassificationJobsResponse> listDocumentClassificationJobs() {
        return listDocumentClassificationJobs(ListDocumentClassificationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsPublisher publisher = client.listDocumentClassificationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsPublisher publisher = client.listDocumentClassificationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsPublisher listDocumentClassificationJobsPaginator() {
        return listDocumentClassificationJobsPaginator(ListDocumentClassificationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsPublisher publisher = client.listDocumentClassificationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsPublisher publisher = client.listDocumentClassificationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsPublisher listDocumentClassificationJobsPaginator(
            ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsPublisher publisher = client.listDocumentClassificationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsPublisher publisher = client.listDocumentClassificationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassificationJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentClassificationJobsRequest#builder()}
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentClassificationJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassificationJobsPublisher listDocumentClassificationJobsPaginator(
            Consumer<ListDocumentClassificationJobsRequest.Builder> listDocumentClassificationJobsRequest) {
        return listDocumentClassificationJobsPaginator(ListDocumentClassificationJobsRequest.builder()
                .applyMutation(listDocumentClassificationJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of summaries of the document classifiers that you have created
     * </p>
     *
     * @param listDocumentClassifierSummariesRequest
     * @return A Java Future containing the result of the ListDocumentClassifierSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifierSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDocumentClassifierSummariesResponse> listDocumentClassifierSummaries(
            ListDocumentClassifierSummariesRequest listDocumentClassifierSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of summaries of the document classifiers that you have created
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassifierSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentClassifierSummariesRequest#builder()}
     * </p>
     *
     * @param listDocumentClassifierSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentClassifierSummariesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDocumentClassifierSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifierSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDocumentClassifierSummariesResponse> listDocumentClassifierSummaries(
            Consumer<ListDocumentClassifierSummariesRequest.Builder> listDocumentClassifierSummariesRequest) {
        return listDocumentClassifierSummaries(ListDocumentClassifierSummariesRequest.builder()
                .applyMutation(listDocumentClassifierSummariesRequest).build());
    }

    /**
     * <p>
     * Gets a list of summaries of the document classifiers that you have created
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifierSummaries(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesPublisher publisher = client.listDocumentClassifierSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesPublisher publisher = client.listDocumentClassifierSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifierSummaries(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentClassifierSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifierSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifierSummariesPublisher listDocumentClassifierSummariesPaginator(
            ListDocumentClassifierSummariesRequest listDocumentClassifierSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of summaries of the document classifiers that you have created
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifierSummaries(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesPublisher publisher = client.listDocumentClassifierSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesPublisher publisher = client.listDocumentClassifierSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifierSummaries(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassifierSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentClassifierSummariesRequest#builder()}
     * </p>
     *
     * @param listDocumentClassifierSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentClassifierSummariesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifierSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifierSummariesPublisher listDocumentClassifierSummariesPaginator(
            Consumer<ListDocumentClassifierSummariesRequest.Builder> listDocumentClassifierSummariesRequest) {
        return listDocumentClassifierSummariesPaginator(ListDocumentClassifierSummariesRequest.builder()
                .applyMutation(listDocumentClassifierSummariesRequest).build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     *
     * @param listDocumentClassifiersRequest
     * @return A Java Future containing the result of the ListDocumentClassifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDocumentClassifiersResponse> listDocumentClassifiers(
            ListDocumentClassifiersRequest listDocumentClassifiersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassifiersRequest.Builder} avoiding
     * the need to create one manually via {@link ListDocumentClassifiersRequest#builder()}
     * </p>
     *
     * @param listDocumentClassifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentClassifiersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDocumentClassifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDocumentClassifiersResponse> listDocumentClassifiers(
            Consumer<ListDocumentClassifiersRequest.Builder> listDocumentClassifiersRequest) {
        return listDocumentClassifiers(ListDocumentClassifiersRequest.builder().applyMutation(listDocumentClassifiersRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     *
     * @return A Java Future containing the result of the ListDocumentClassifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDocumentClassifiersResponse> listDocumentClassifiers() {
        return listDocumentClassifiers(ListDocumentClassifiersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersPublisher publisher = client.listDocumentClassifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersPublisher publisher = client.listDocumentClassifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersPublisher listDocumentClassifiersPaginator() {
        return listDocumentClassifiersPaginator(ListDocumentClassifiersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersPublisher publisher = client.listDocumentClassifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersPublisher publisher = client.listDocumentClassifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentClassifiersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersPublisher listDocumentClassifiersPaginator(
            ListDocumentClassifiersRequest listDocumentClassifiersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersPublisher publisher = client.listDocumentClassifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersPublisher publisher = client.listDocumentClassifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentClassifiersRequest.Builder} avoiding
     * the need to create one manually via {@link ListDocumentClassifiersRequest#builder()}
     * </p>
     *
     * @param listDocumentClassifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentClassifiersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentClassifiersPublisher listDocumentClassifiersPaginator(
            Consumer<ListDocumentClassifiersRequest.Builder> listDocumentClassifiersRequest) {
        return listDocumentClassifiersPaginator(ListDocumentClassifiersRequest.builder()
                .applyMutation(listDocumentClassifiersRequest).build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     * @return A Java Future containing the result of the ListDominantLanguageDetectionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDominantLanguageDetectionJobsResponse> listDominantLanguageDetectionJobs(
            ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDominantLanguageDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDominantLanguageDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDominantLanguageDetectionJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDominantLanguageDetectionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDominantLanguageDetectionJobsResponse> listDominantLanguageDetectionJobs(
            Consumer<ListDominantLanguageDetectionJobsRequest.Builder> listDominantLanguageDetectionJobsRequest) {
        return listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest.builder()
                .applyMutation(listDominantLanguageDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     *
     * @return A Java Future containing the result of the ListDominantLanguageDetectionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDominantLanguageDetectionJobsResponse> listDominantLanguageDetectionJobs() {
        return listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsPublisher publisher = client.listDominantLanguageDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsPublisher publisher = client.listDominantLanguageDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsPublisher listDominantLanguageDetectionJobsPaginator() {
        return listDominantLanguageDetectionJobsPaginator(ListDominantLanguageDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsPublisher publisher = client.listDominantLanguageDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsPublisher publisher = client.listDominantLanguageDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsPublisher listDominantLanguageDetectionJobsPaginator(
            ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsPublisher publisher = client.listDominantLanguageDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsPublisher publisher = client.listDominantLanguageDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDominantLanguageDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDominantLanguageDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDominantLanguageDetectionJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDominantLanguageDetectionJobsPublisher listDominantLanguageDetectionJobsPaginator(
            Consumer<ListDominantLanguageDetectionJobsRequest.Builder> listDominantLanguageDetectionJobsRequest) {
        return listDominantLanguageDetectionJobsPaginator(ListDominantLanguageDetectionJobsRequest.builder()
                .applyMutation(listDominantLanguageDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of all existing endpoints that you've created.
     * </p>
     *
     * @param listEndpointsRequest
     * @return A Java Future containing the result of the ListEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEndpointsResponse> listEndpoints(ListEndpointsRequest listEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all existing endpoints that you've created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEndpointsRequest#builder()}
     * </p>
     *
     * @param listEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEndpointsResponse> listEndpoints(Consumer<ListEndpointsRequest.Builder> listEndpointsRequest) {
        return listEndpoints(ListEndpointsRequest.builder().applyMutation(listEndpointsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     * @return A Java Future containing the result of the ListEntitiesDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntitiesDetectionJobsResponse> listEntitiesDetectionJobs(
            ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEntitiesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEntitiesDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntitiesDetectionJobsResponse> listEntitiesDetectionJobs(
            Consumer<ListEntitiesDetectionJobsRequest.Builder> listEntitiesDetectionJobsRequest) {
        return listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest.builder()
                .applyMutation(listEntitiesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     *
     * @return A Java Future containing the result of the ListEntitiesDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntitiesDetectionJobsResponse> listEntitiesDetectionJobs() {
        return listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsPublisher publisher = client.listEntitiesDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsPublisher publisher = client.listEntitiesDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsPublisher listEntitiesDetectionJobsPaginator() {
        return listEntitiesDetectionJobsPaginator(ListEntitiesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsPublisher publisher = client.listEntitiesDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsPublisher publisher = client.listEntitiesDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsPublisher listEntitiesDetectionJobsPaginator(
            ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsPublisher publisher = client.listEntitiesDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsPublisher publisher = client.listEntitiesDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEntitiesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitiesDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionJobsPublisher listEntitiesDetectionJobsPaginator(
            Consumer<ListEntitiesDetectionJobsRequest.Builder> listEntitiesDetectionJobsRequest) {
        return listEntitiesDetectionJobsPaginator(ListEntitiesDetectionJobsRequest.builder()
                .applyMutation(listEntitiesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of summaries for the entity recognizers that you have created.
     * </p>
     *
     * @param listEntityRecognizerSummariesRequest
     * @return A Java Future containing the result of the ListEntityRecognizerSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizerSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntityRecognizerSummariesResponse> listEntityRecognizerSummaries(
            ListEntityRecognizerSummariesRequest listEntityRecognizerSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of summaries for the entity recognizers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityRecognizerSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListEntityRecognizerSummariesRequest#builder()}
     * </p>
     *
     * @param listEntityRecognizerSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListEntityRecognizerSummariesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEntityRecognizerSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizerSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntityRecognizerSummariesResponse> listEntityRecognizerSummaries(
            Consumer<ListEntityRecognizerSummariesRequest.Builder> listEntityRecognizerSummariesRequest) {
        return listEntityRecognizerSummaries(ListEntityRecognizerSummariesRequest.builder()
                .applyMutation(listEntityRecognizerSummariesRequest).build());
    }

    /**
     * <p>
     * Gets a list of summaries for the entity recognizers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizerSummaries(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesPublisher publisher = client.listEntityRecognizerSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesPublisher publisher = client.listEntityRecognizerSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizerSummaries(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntityRecognizerSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizerSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizerSummariesPublisher listEntityRecognizerSummariesPaginator(
            ListEntityRecognizerSummariesRequest listEntityRecognizerSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of summaries for the entity recognizers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizerSummaries(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesPublisher publisher = client.listEntityRecognizerSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesPublisher publisher = client.listEntityRecognizerSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizerSummaries(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityRecognizerSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListEntityRecognizerSummariesRequest#builder()}
     * </p>
     *
     * @param listEntityRecognizerSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListEntityRecognizerSummariesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizerSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizerSummariesPublisher listEntityRecognizerSummariesPaginator(
            Consumer<ListEntityRecognizerSummariesRequest.Builder> listEntityRecognizerSummariesRequest) {
        return listEntityRecognizerSummariesPaginator(ListEntityRecognizerSummariesRequest.builder()
                .applyMutation(listEntityRecognizerSummariesRequest).build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     *
     * @param listEntityRecognizersRequest
     * @return A Java Future containing the result of the ListEntityRecognizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntityRecognizersResponse> listEntityRecognizers(
            ListEntityRecognizersRequest listEntityRecognizersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityRecognizersRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntityRecognizersRequest#builder()}
     * </p>
     *
     * @param listEntityRecognizersRequest
     *        A {@link Consumer} that will call methods on {@link ListEntityRecognizersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEntityRecognizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntityRecognizersResponse> listEntityRecognizers(
            Consumer<ListEntityRecognizersRequest.Builder> listEntityRecognizersRequest) {
        return listEntityRecognizers(ListEntityRecognizersRequest.builder().applyMutation(listEntityRecognizersRequest).build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     *
     * @return A Java Future containing the result of the ListEntityRecognizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntityRecognizersResponse> listEntityRecognizers() {
        return listEntityRecognizers(ListEntityRecognizersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersPublisher publisher = client.listEntityRecognizersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersPublisher publisher = client.listEntityRecognizersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersPublisher listEntityRecognizersPaginator() {
        return listEntityRecognizersPaginator(ListEntityRecognizersRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersPublisher publisher = client.listEntityRecognizersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersPublisher publisher = client.listEntityRecognizersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntityRecognizersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersPublisher listEntityRecognizersPaginator(
            ListEntityRecognizersRequest listEntityRecognizersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersPublisher publisher = client.listEntityRecognizersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersPublisher publisher = client.listEntityRecognizersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityRecognizersRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntityRecognizersRequest#builder()}
     * </p>
     *
     * @param listEntityRecognizersRequest
     *        A {@link Consumer} that will call methods on {@link ListEntityRecognizersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntityRecognizersPublisher listEntityRecognizersPaginator(
            Consumer<ListEntityRecognizersRequest.Builder> listEntityRecognizersRequest) {
        return listEntityRecognizersPaginator(ListEntityRecognizersRequest.builder().applyMutation(listEntityRecognizersRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     * @return A Java Future containing the result of the ListEventsDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventsDetectionJobsResponse> listEventsDetectionJobs(
            ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventsDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventsDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventsDetectionJobsResponse> listEventsDetectionJobs(
            Consumer<ListEventsDetectionJobsRequest.Builder> listEventsDetectionJobsRequest) {
        return listEventsDetectionJobs(ListEventsDetectionJobsRequest.builder().applyMutation(listEventsDetectionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsPublisher publisher = client.listEventsDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsPublisher publisher = client.listEventsDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventsDetectionJobsPublisher listEventsDetectionJobsPaginator(
            ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsPublisher publisher = client.listEventsDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsPublisher publisher = client.listEventsDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventsDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventsDetectionJobsPublisher listEventsDetectionJobsPaginator(
            Consumer<ListEventsDetectionJobsRequest.Builder> listEventsDetectionJobsRequest) {
        return listEventsDetectionJobsPaginator(ListEventsDetectionJobsRequest.builder()
                .applyMutation(listEventsDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     * @return A Java Future containing the result of the ListKeyPhrasesDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListKeyPhrasesDetectionJobsResponse> listKeyPhrasesDetectionJobs(
            ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeyPhrasesDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListKeyPhrasesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListKeyPhrasesDetectionJobsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListKeyPhrasesDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListKeyPhrasesDetectionJobsResponse> listKeyPhrasesDetectionJobs(
            Consumer<ListKeyPhrasesDetectionJobsRequest.Builder> listKeyPhrasesDetectionJobsRequest) {
        return listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest.builder()
                .applyMutation(listKeyPhrasesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     *
     * @return A Java Future containing the result of the ListKeyPhrasesDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListKeyPhrasesDetectionJobsResponse> listKeyPhrasesDetectionJobs() {
        return listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsPublisher publisher = client.listKeyPhrasesDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsPublisher publisher = client.listKeyPhrasesDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsPublisher listKeyPhrasesDetectionJobsPaginator() {
        return listKeyPhrasesDetectionJobsPaginator(ListKeyPhrasesDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsPublisher publisher = client.listKeyPhrasesDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsPublisher publisher = client.listKeyPhrasesDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsPublisher listKeyPhrasesDetectionJobsPaginator(
            ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsPublisher publisher = client.listKeyPhrasesDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsPublisher publisher = client.listKeyPhrasesDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeyPhrasesDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListKeyPhrasesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListKeyPhrasesDetectionJobsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeyPhrasesDetectionJobsPublisher listKeyPhrasesDetectionJobsPaginator(
            Consumer<ListKeyPhrasesDetectionJobsRequest.Builder> listKeyPhrasesDetectionJobsRequest) {
        return listKeyPhrasesDetectionJobsPaginator(ListKeyPhrasesDetectionJobsRequest.builder()
                .applyMutation(listKeyPhrasesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the PII entity detection jobs that you have submitted.
     * </p>
     *
     * @param listPiiEntitiesDetectionJobsRequest
     * @return A Java Future containing the result of the ListPiiEntitiesDetectionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListPiiEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPiiEntitiesDetectionJobsResponse> listPiiEntitiesDetectionJobs(
            ListPiiEntitiesDetectionJobsRequest listPiiEntitiesDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the PII entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPiiEntitiesDetectionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPiiEntitiesDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listPiiEntitiesDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListPiiEntitiesDetectionJobsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListPiiEntitiesDetectionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListPiiEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPiiEntitiesDetectionJobsResponse> listPiiEntitiesDetectionJobs(
            Consumer<ListPiiEntitiesDetectionJobsRequest.Builder> listPiiEntitiesDetectionJobsRequest) {
        return listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsRequest.builder()
                .applyMutation(listPiiEntitiesDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     * @return A Java Future containing the result of the ListSentimentDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSentimentDetectionJobsResponse> listSentimentDetectionJobs(
            ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSentimentDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSentimentDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSentimentDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSentimentDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSentimentDetectionJobsResponse> listSentimentDetectionJobs(
            Consumer<ListSentimentDetectionJobsRequest.Builder> listSentimentDetectionJobsRequest) {
        return listSentimentDetectionJobs(ListSentimentDetectionJobsRequest.builder()
                .applyMutation(listSentimentDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     *
     * @return A Java Future containing the result of the ListSentimentDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSentimentDetectionJobsResponse> listSentimentDetectionJobs() {
        return listSentimentDetectionJobs(ListSentimentDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsPublisher publisher = client.listSentimentDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsPublisher publisher = client.listSentimentDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsPublisher listSentimentDetectionJobsPaginator() {
        return listSentimentDetectionJobsPaginator(ListSentimentDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsPublisher publisher = client.listSentimentDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsPublisher publisher = client.listSentimentDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsPublisher listSentimentDetectionJobsPaginator(
            ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsPublisher publisher = client.listSentimentDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsPublisher publisher = client.listSentimentDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSentimentDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSentimentDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSentimentDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSentimentDetectionJobsPublisher listSentimentDetectionJobsPaginator(
            Consumer<ListSentimentDetectionJobsRequest.Builder> listSentimentDetectionJobsRequest) {
        return listSentimentDetectionJobsPaginator(ListSentimentDetectionJobsRequest.builder()
                .applyMutation(listSentimentDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Comprehend resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Comprehend resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     * @return A Java Future containing the result of the ListTopicsDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTopicsDetectionJobsResponse> listTopicsDetectionJobs(
            ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTopicsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTopicsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTopicsDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTopicsDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTopicsDetectionJobsResponse> listTopicsDetectionJobs(
            Consumer<ListTopicsDetectionJobsRequest.Builder> listTopicsDetectionJobsRequest) {
        return listTopicsDetectionJobs(ListTopicsDetectionJobsRequest.builder().applyMutation(listTopicsDetectionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     *
     * @return A Java Future containing the result of the ListTopicsDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTopicsDetectionJobsResponse> listTopicsDetectionJobs() {
        return listTopicsDetectionJobs(ListTopicsDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher publisher = client.listTopicsDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher publisher = client.listTopicsDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsPublisher listTopicsDetectionJobsPaginator() {
        return listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher publisher = client.listTopicsDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher publisher = client.listTopicsDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsPublisher listTopicsDetectionJobsPaginator(
            ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher publisher = client.listTopicsDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher publisher = client.listTopicsDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTopicsDetectionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTopicsDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTopicsDetectionJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTopicsDetectionJobsPublisher listTopicsDetectionJobsPaginator(
            Consumer<ListTopicsDetectionJobsRequest.Builder> listTopicsDetectionJobsRequest) {
        return listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest.builder()
                .applyMutation(listTopicsDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous document classification job. Use the operation to track the progress of the job.
     * </p>
     *
     * @param startDocumentClassificationJobRequest
     * @return A Java Future containing the result of the StartDocumentClassificationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDocumentClassificationJobResponse> startDocumentClassificationJob(
            StartDocumentClassificationJobRequest startDocumentClassificationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous document classification job. Use the operation to track the progress of the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDocumentClassificationJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartDocumentClassificationJobRequest#builder()}
     * </p>
     *
     * @param startDocumentClassificationJobRequest
     *        A {@link Consumer} that will call methods on {@link StartDocumentClassificationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartDocumentClassificationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDocumentClassificationJobResponse> startDocumentClassificationJob(
            Consumer<StartDocumentClassificationJobRequest.Builder> startDocumentClassificationJobRequest) {
        return startDocumentClassificationJob(StartDocumentClassificationJobRequest.builder()
                .applyMutation(startDocumentClassificationJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track
     * the status of a job.
     * </p>
     *
     * @param startDominantLanguageDetectionJobRequest
     * @return A Java Future containing the result of the StartDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDominantLanguageDetectionJobResponse> startDominantLanguageDetectionJob(
            StartDominantLanguageDetectionJobRequest startDominantLanguageDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track
     * the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDominantLanguageDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartDominantLanguageDetectionJobRequest#builder()}
     * </p>
     *
     * @param startDominantLanguageDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartDominantLanguageDetectionJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDominantLanguageDetectionJobResponse> startDominantLanguageDetectionJob(
            Consumer<StartDominantLanguageDetectionJobRequest.Builder> startDominantLanguageDetectionJobRequest) {
        return startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest.builder()
                .applyMutation(startDominantLanguageDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status
     * of a job.
     * </p>
     * <p>
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for
     * custom entity recognition, the optional <code>EntityRecognizerArn</code> must be used in order to provide access
     * to the recognizer being used to detect the custom entity.
     * </p>
     *
     * @param startEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StartEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartEntitiesDetectionJobResponse> startEntitiesDetectionJob(
            StartEntitiesDetectionJobRequest startEntitiesDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status
     * of a job.
     * </p>
     * <p>
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for
     * custom entity recognition, the optional <code>EntityRecognizerArn</code> must be used in order to provide access
     * to the recognizer being used to detect the custom entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEntitiesDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param startEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartEntitiesDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartEntitiesDetectionJobResponse> startEntitiesDetectionJob(
            Consumer<StartEntitiesDetectionJobRequest.Builder> startEntitiesDetectionJobRequest) {
        return startEntitiesDetectionJob(StartEntitiesDetectionJobRequest.builder()
                .applyMutation(startEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous event detection job for a collection of documents.
     * </p>
     *
     * @param startEventsDetectionJobRequest
     * @return A Java Future containing the result of the StartEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartEventsDetectionJobResponse> startEventsDetectionJob(
            StartEventsDetectionJobRequest startEventsDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous event detection job for a collection of documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEventsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartEventsDetectionJobRequest#builder()}
     * </p>
     *
     * @param startEventsDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartEventsDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartEventsDetectionJobResponse> startEventsDetectionJob(
            Consumer<StartEventsDetectionJobRequest.Builder> startEventsDetectionJobRequest) {
        return startEventsDetectionJob(StartEventsDetectionJobRequest.builder().applyMutation(startEventsDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     *
     * @param startKeyPhrasesDetectionJobRequest
     * @return A Java Future containing the result of the StartKeyPhrasesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartKeyPhrasesDetectionJobResponse> startKeyPhrasesDetectionJob(
            StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartKeyPhrasesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartKeyPhrasesDetectionJobRequest#builder()}
     * </p>
     *
     * @param startKeyPhrasesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartKeyPhrasesDetectionJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartKeyPhrasesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartKeyPhrasesDetectionJobResponse> startKeyPhrasesDetectionJob(
            Consumer<StartKeyPhrasesDetectionJobRequest.Builder> startKeyPhrasesDetectionJobRequest) {
        return startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest.builder()
                .applyMutation(startKeyPhrasesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous PII entity detection job for a collection of documents.
     * </p>
     *
     * @param startPiiEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StartPiiEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPiiEntitiesDetectionJobResponse> startPiiEntitiesDetectionJob(
            StartPiiEntitiesDetectionJobRequest startPiiEntitiesDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous PII entity detection job for a collection of documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPiiEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartPiiEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param startPiiEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartPiiEntitiesDetectionJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartPiiEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPiiEntitiesDetectionJobResponse> startPiiEntitiesDetectionJob(
            Consumer<StartPiiEntitiesDetectionJobRequest.Builder> startPiiEntitiesDetectionJobRequest) {
        return startPiiEntitiesDetectionJob(StartPiiEntitiesDetectionJobRequest.builder()
                .applyMutation(startPiiEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous sentiment detection job for a collection of documents. use the operation to track the
     * status of a job.
     * </p>
     *
     * @param startSentimentDetectionJobRequest
     * @return A Java Future containing the result of the StartSentimentDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSentimentDetectionJobResponse> startSentimentDetectionJob(
            StartSentimentDetectionJobRequest startSentimentDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous sentiment detection job for a collection of documents. use the operation to track the
     * status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSentimentDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param startSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartSentimentDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartSentimentDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSentimentDetectionJobResponse> startSentimentDetectionJob(
            Consumer<StartSentimentDetectionJobRequest.Builder> startSentimentDetectionJobRequest) {
        return startSentimentDetectionJob(StartSentimentDetectionJobRequest.builder()
                .applyMutation(startSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous topic detection job. Use the <code>DescribeTopicDetectionJob</code> operation to track the
     * status of a job.
     * </p>
     *
     * @param startTopicsDetectionJobRequest
     * @return A Java Future containing the result of the StartTopicsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTopicsDetectionJobResponse> startTopicsDetectionJob(
            StartTopicsDetectionJobRequest startTopicsDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous topic detection job. Use the <code>DescribeTopicDetectionJob</code> operation to track the
     * status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTopicsDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartTopicsDetectionJobRequest#builder()}
     * </p>
     *
     * @param startTopicsDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartTopicsDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartTopicsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTopicsDetectionJobResponse> startTopicsDetectionJob(
            Consumer<StartTopicsDetectionJobRequest.Builder> startTopicsDetectionJobRequest) {
        return startTopicsDetectionJob(StartTopicsDetectionJobRequest.builder().applyMutation(startTopicsDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops a dominant language detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopDominantLanguageDetectionJobRequest
     * @return A Java Future containing the result of the StopDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopDominantLanguageDetectionJobResponse> stopDominantLanguageDetectionJob(
            StopDominantLanguageDetectionJobRequest stopDominantLanguageDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a dominant language detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDominantLanguageDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StopDominantLanguageDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopDominantLanguageDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopDominantLanguageDetectionJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StopDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopDominantLanguageDetectionJobResponse> stopDominantLanguageDetectionJob(
            Consumer<StopDominantLanguageDetectionJobRequest.Builder> stopDominantLanguageDetectionJobRequest) {
        return stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest.builder()
                .applyMutation(stopDominantLanguageDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops an entities detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StopEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopEntitiesDetectionJobResponse> stopEntitiesDetectionJob(
            StopEntitiesDetectionJobRequest stopEntitiesDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an entities detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEntitiesDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopEntitiesDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopEntitiesDetectionJobResponse> stopEntitiesDetectionJob(
            Consumer<StopEntitiesDetectionJobRequest.Builder> stopEntitiesDetectionJobRequest) {
        return stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest.builder().applyMutation(stopEntitiesDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops an events detection job in progress.
     * </p>
     *
     * @param stopEventsDetectionJobRequest
     * @return A Java Future containing the result of the StopEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopEventsDetectionJobResponse> stopEventsDetectionJob(
            StopEventsDetectionJobRequest stopEventsDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an events detection job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEventsDetectionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopEventsDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopEventsDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopEventsDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopEventsDetectionJobResponse> stopEventsDetectionJob(
            Consumer<StopEventsDetectionJobRequest.Builder> stopEventsDetectionJobRequest) {
        return stopEventsDetectionJob(StopEventsDetectionJobRequest.builder().applyMutation(stopEventsDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops a key phrases detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopKeyPhrasesDetectionJobRequest
     * @return A Java Future containing the result of the StopKeyPhrasesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopKeyPhrasesDetectionJobResponse> stopKeyPhrasesDetectionJob(
            StopKeyPhrasesDetectionJobRequest stopKeyPhrasesDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a key phrases detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopKeyPhrasesDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopKeyPhrasesDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopKeyPhrasesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopKeyPhrasesDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopKeyPhrasesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopKeyPhrasesDetectionJobResponse> stopKeyPhrasesDetectionJob(
            Consumer<StopKeyPhrasesDetectionJobRequest.Builder> stopKeyPhrasesDetectionJobRequest) {
        return stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest.builder()
                .applyMutation(stopKeyPhrasesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a PII entities detection job in progress.
     * </p>
     *
     * @param stopPiiEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StopPiiEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopPiiEntitiesDetectionJobResponse> stopPiiEntitiesDetectionJob(
            StopPiiEntitiesDetectionJobRequest stopPiiEntitiesDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a PII entities detection job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopPiiEntitiesDetectionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StopPiiEntitiesDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopPiiEntitiesDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopPiiEntitiesDetectionJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StopPiiEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopPiiEntitiesDetectionJobResponse> stopPiiEntitiesDetectionJob(
            Consumer<StopPiiEntitiesDetectionJobRequest.Builder> stopPiiEntitiesDetectionJobRequest) {
        return stopPiiEntitiesDetectionJob(StopPiiEntitiesDetectionJobRequest.builder()
                .applyMutation(stopPiiEntitiesDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopSentimentDetectionJobRequest
     * @return A Java Future containing the result of the StopSentimentDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopSentimentDetectionJobResponse> stopSentimentDetectionJob(
            StopSentimentDetectionJobRequest stopSentimentDetectionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSentimentDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopSentimentDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopSentimentDetectionJobRequest
     *        A {@link Consumer} that will call methods on {@link StopSentimentDetectionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopSentimentDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopSentimentDetectionJobResponse> stopSentimentDetectionJob(
            Consumer<StopSentimentDetectionJobRequest.Builder> stopSentimentDetectionJobRequest) {
        return stopSentimentDetectionJob(StopSentimentDetectionJobRequest.builder()
                .applyMutation(stopSentimentDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops a document classifier training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and put into the <code>STOPPED</code> state and the
     * service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param stopTrainingDocumentClassifierRequest
     * @return A Java Future containing the result of the StopTrainingDocumentClassifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopTrainingDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopTrainingDocumentClassifierResponse> stopTrainingDocumentClassifier(
            StopTrainingDocumentClassifierRequest stopTrainingDocumentClassifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a document classifier training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and put into the <code>STOPPED</code> state and the
     * service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTrainingDocumentClassifierRequest.Builder}
     * avoiding the need to create one manually via {@link StopTrainingDocumentClassifierRequest#builder()}
     * </p>
     *
     * @param stopTrainingDocumentClassifierRequest
     *        A {@link Consumer} that will call methods on {@link StopTrainingDocumentClassifierRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StopTrainingDocumentClassifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopTrainingDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopTrainingDocumentClassifierResponse> stopTrainingDocumentClassifier(
            Consumer<StopTrainingDocumentClassifierRequest.Builder> stopTrainingDocumentClassifierRequest) {
        return stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest.builder()
                .applyMutation(stopTrainingDocumentClassifierRequest).build());
    }

    /**
     * <p>
     * Stops an entity recognizer training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and putted into the <code>STOPPED</code> state and
     * the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param stopTrainingEntityRecognizerRequest
     * @return A Java Future containing the result of the StopTrainingEntityRecognizer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopTrainingEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopTrainingEntityRecognizerResponse> stopTrainingEntityRecognizer(
            StopTrainingEntityRecognizerRequest stopTrainingEntityRecognizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an entity recognizer training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and putted into the <code>STOPPED</code> state and
     * the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTrainingEntityRecognizerRequest.Builder}
     * avoiding the need to create one manually via {@link StopTrainingEntityRecognizerRequest#builder()}
     * </p>
     *
     * @param stopTrainingEntityRecognizerRequest
     *        A {@link Consumer} that will call methods on {@link StopTrainingEntityRecognizerRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StopTrainingEntityRecognizer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopTrainingEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopTrainingEntityRecognizerResponse> stopTrainingEntityRecognizer(
            Consumer<StopTrainingEntityRecognizerRequest.Builder> stopTrainingEntityRecognizerRequest) {
        return stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest.builder()
                .applyMutation(stopTrainingEntityRecognizerRequest).build());
    }

    /**
     * <p>
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata
     * to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource
     * to indicate its use by the sales department.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ConcurrentModificationException Concurrent modification of the tags associated with an Amazon
     *         Comprehend resource is not supported.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata
     * to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource
     * to indicate its use by the sales department.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ConcurrentModificationException Concurrent modification of the tags associated with an Amazon
     *         Comprehend resource is not supported.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Comprehend resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyTagKeysException The request contains more tag keys than can be associated with a resource (50
     *         tag keys per resource).</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ConcurrentModificationException Concurrent modification of the tags associated with an Amazon
     *         Comprehend resource is not supported.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Comprehend resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyTagKeysException The request contains more tag keys than can be associated with a resource (50
     *         tag keys per resource).</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ConcurrentModificationException Concurrent modification of the tags associated with an Amazon
     *         Comprehend resource is not supported.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates information about the specified endpoint.
     * </p>
     *
     * @param updateEndpointRequest
     * @return A Java Future containing the result of the UpdateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about the specified endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateEndpointRequest#builder()}
     * </p>
     *
     * @param updateEndpointRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEndpointResponse> updateEndpoint(Consumer<UpdateEndpointRequest.Builder> updateEndpointRequest) {
        return updateEndpoint(UpdateEndpointRequest.builder().applyMutation(updateEndpointRequest).build());
    }
}
