/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes information about an entity recognizer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityRecognizerProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityRecognizerProperties.Builder, EntityRecognizerProperties> {
    private static final SdkField<String> ENTITY_RECOGNIZER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityRecognizerArn").getter(getter(EntityRecognizerProperties::entityRecognizerArn))
            .setter(setter(Builder::entityRecognizerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerArn").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(EntityRecognizerProperties::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EntityRecognizerProperties::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(EntityRecognizerProperties::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTime").getter(getter(EntityRecognizerProperties::submitTime)).setter(setter(Builder::submitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(EntityRecognizerProperties::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> TRAINING_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingStartTime").getter(getter(EntityRecognizerProperties::trainingStartTime))
            .setter(setter(Builder::trainingStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingStartTime").build()).build();

    private static final SdkField<Instant> TRAINING_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingEndTime").getter(getter(EntityRecognizerProperties::trainingEndTime))
            .setter(setter(Builder::trainingEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTime").build()).build();

    private static final SdkField<EntityRecognizerInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<EntityRecognizerInputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(EntityRecognizerProperties::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(EntityRecognizerInputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<EntityRecognizerMetadata> RECOGNIZER_METADATA_FIELD = SdkField
            .<EntityRecognizerMetadata> builder(MarshallingType.SDK_POJO).memberName("RecognizerMetadata")
            .getter(getter(EntityRecognizerProperties::recognizerMetadata)).setter(setter(Builder::recognizerMetadata))
            .constructor(EntityRecognizerMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecognizerMetadata").build())
            .build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(EntityRecognizerProperties::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeKmsKeyId").getter(getter(EntityRecognizerProperties::volumeKmsKeyId))
            .setter(setter(Builder::volumeKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(EntityRecognizerProperties::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<String> MODEL_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelKmsKeyId").getter(getter(EntityRecognizerProperties::modelKmsKeyId))
            .setter(setter(Builder::modelKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelKmsKeyId").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionName").getter(getter(EntityRecognizerProperties::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_RECOGNIZER_ARN_FIELD,
            LANGUAGE_CODE_FIELD, STATUS_FIELD, MESSAGE_FIELD, SUBMIT_TIME_FIELD, END_TIME_FIELD, TRAINING_START_TIME_FIELD,
            TRAINING_END_TIME_FIELD, INPUT_DATA_CONFIG_FIELD, RECOGNIZER_METADATA_FIELD, DATA_ACCESS_ROLE_ARN_FIELD,
            VOLUME_KMS_KEY_ID_FIELD, VPC_CONFIG_FIELD, MODEL_KMS_KEY_ID_FIELD, VERSION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entityRecognizerArn;

    private final String languageCode;

    private final String status;

    private final String message;

    private final Instant submitTime;

    private final Instant endTime;

    private final Instant trainingStartTime;

    private final Instant trainingEndTime;

    private final EntityRecognizerInputDataConfig inputDataConfig;

    private final EntityRecognizerMetadata recognizerMetadata;

    private final String dataAccessRoleArn;

    private final String volumeKmsKeyId;

    private final VpcConfig vpcConfig;

    private final String modelKmsKeyId;

    private final String versionName;

    private EntityRecognizerProperties(BuilderImpl builder) {
        this.entityRecognizerArn = builder.entityRecognizerArn;
        this.languageCode = builder.languageCode;
        this.status = builder.status;
        this.message = builder.message;
        this.submitTime = builder.submitTime;
        this.endTime = builder.endTime;
        this.trainingStartTime = builder.trainingStartTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.recognizerMetadata = builder.recognizerMetadata;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.vpcConfig = builder.vpcConfig;
        this.modelKmsKeyId = builder.modelKmsKeyId;
        this.versionName = builder.versionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the entity recognizer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the entity recognizer.
     */
    public final String entityRecognizerArn() {
        return entityRecognizerArn;
    }

    /**
     * <p>
     * The language of the input documents. All documents must be in the same language. Only English ("en") is currently
     * supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. All documents must be in the same language. Only English ("en") is
     *         currently supported.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language of the input documents. All documents must be in the same language. Only English ("en") is currently
     * supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. All documents must be in the same language. Only English ("en") is
     *         currently supported.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Provides the status of the entity recognizer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Provides the status of the entity recognizer.
     * @see ModelStatus
     */
    public final ModelStatus status() {
        return ModelStatus.fromValue(status);
    }

    /**
     * <p>
     * Provides the status of the entity recognizer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Provides the status of the entity recognizer.
     * @see ModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the status of the recognizer.
     * </p>
     * 
     * @return A description of the status of the recognizer.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The time that the recognizer was submitted for processing.
     * </p>
     * 
     * @return The time that the recognizer was submitted for processing.
     */
    public final Instant submitTime() {
        return submitTime;
    }

    /**
     * <p>
     * The time that the recognizer creation completed.
     * </p>
     * 
     * @return The time that the recognizer creation completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The time that training of the entity recognizer started.
     * </p>
     * 
     * @return The time that training of the entity recognizer started.
     */
    public final Instant trainingStartTime() {
        return trainingStartTime;
    }

    /**
     * <p>
     * The time that training of the entity recognizer was completed.
     * </p>
     * 
     * @return The time that training of the entity recognizer was completed.
     */
    public final Instant trainingEndTime() {
        return trainingEndTime;
    }

    /**
     * <p>
     * The input data properties of an entity recognizer.
     * </p>
     * 
     * @return The input data properties of an entity recognizer.
     */
    public final EntityRecognizerInputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Provides information about an entity recognizer.
     * </p>
     * 
     * @return Provides information about an entity recognizer.
     */
    public final EntityRecognizerMetadata recognizerMetadata() {
        return recognizerMetadata;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read
     * access to your input data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon
     *         Comprehend read access to your input data.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume
     * attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the
     * following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Resource Name (ARN) of a KMS Key:
     * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the
     *         storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId
     *         can be either of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Resource Name (ARN) of a KMS Key:
     *         <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     */
    public final String volumeKmsKeyId() {
        return volumeKmsKeyId;
    }

    /**
     * <p>
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for
     * your custom entity recognizer. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
     * </p>
     * 
     * @return Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using
     *         for your custom entity recognizer. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The
     * ModelKmsKeyId can be either of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Resource Name (ARN) of a KMS Key:
     * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom
     *         models. The ModelKmsKeyId can be either of the following formats: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Resource Name (ARN) of a KMS Key:
     *         <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     */
    public final String modelKmsKeyId() {
        return modelKmsKeyId;
    }

    /**
     * <p>
     * The version name you assigned to the entity recognizer.
     * </p>
     * 
     * @return The version name you assigned to the entity recognizer.
     */
    public final String versionName() {
        return versionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityRecognizerArn());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(recognizerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerProperties)) {
            return false;
        }
        EntityRecognizerProperties other = (EntityRecognizerProperties) obj;
        return Objects.equals(entityRecognizerArn(), other.entityRecognizerArn())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(submitTime(), other.submitTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(trainingStartTime(), other.trainingStartTime())
                && Objects.equals(trainingEndTime(), other.trainingEndTime())
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(recognizerMetadata(), other.recognizerMetadata())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(modelKmsKeyId(), other.modelKmsKeyId()) && Objects.equals(versionName(), other.versionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityRecognizerProperties").add("EntityRecognizerArn", entityRecognizerArn())
                .add("LanguageCode", languageCodeAsString()).add("Status", statusAsString()).add("Message", message())
                .add("SubmitTime", submitTime()).add("EndTime", endTime()).add("TrainingStartTime", trainingStartTime())
                .add("TrainingEndTime", trainingEndTime()).add("InputDataConfig", inputDataConfig())
                .add("RecognizerMetadata", recognizerMetadata() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("VolumeKmsKeyId", volumeKmsKeyId())
                .add("VpcConfig", vpcConfig()).add("ModelKmsKeyId", modelKmsKeyId()).add("VersionName", versionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityRecognizerArn":
            return Optional.ofNullable(clazz.cast(entityRecognizerArn()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "SubmitTime":
            return Optional.ofNullable(clazz.cast(submitTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "TrainingStartTime":
            return Optional.ofNullable(clazz.cast(trainingStartTime()));
        case "TrainingEndTime":
            return Optional.ofNullable(clazz.cast(trainingEndTime()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "RecognizerMetadata":
            return Optional.ofNullable(clazz.cast(recognizerMetadata()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "VolumeKmsKeyId":
            return Optional.ofNullable(clazz.cast(volumeKmsKeyId()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "ModelKmsKeyId":
            return Optional.ofNullable(clazz.cast(modelKmsKeyId()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerProperties, T> g) {
        return obj -> g.apply((EntityRecognizerProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityRecognizerProperties> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the entity recognizer.
         * </p>
         * 
         * @param entityRecognizerArn
         *        The Amazon Resource Name (ARN) that identifies the entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRecognizerArn(String entityRecognizerArn);

        /**
         * <p>
         * The language of the input documents. All documents must be in the same language. Only English ("en") is
         * currently supported.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. All documents must be in the same language. Only English ("en")
         *        is currently supported.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language of the input documents. All documents must be in the same language. Only English ("en") is
         * currently supported.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. All documents must be in the same language. Only English ("en")
         *        is currently supported.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * Provides the status of the entity recognizer.
         * </p>
         * 
         * @param status
         *        Provides the status of the entity recognizer.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Provides the status of the entity recognizer.
         * </p>
         * 
         * @param status
         *        Provides the status of the entity recognizer.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(ModelStatus status);

        /**
         * <p>
         * A description of the status of the recognizer.
         * </p>
         * 
         * @param message
         *        A description of the status of the recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The time that the recognizer was submitted for processing.
         * </p>
         * 
         * @param submitTime
         *        The time that the recognizer was submitted for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTime(Instant submitTime);

        /**
         * <p>
         * The time that the recognizer creation completed.
         * </p>
         * 
         * @param endTime
         *        The time that the recognizer creation completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The time that training of the entity recognizer started.
         * </p>
         * 
         * @param trainingStartTime
         *        The time that training of the entity recognizer started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingStartTime(Instant trainingStartTime);

        /**
         * <p>
         * The time that training of the entity recognizer was completed.
         * </p>
         * 
         * @param trainingEndTime
         *        The time that training of the entity recognizer was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingEndTime(Instant trainingEndTime);

        /**
         * <p>
         * The input data properties of an entity recognizer.
         * </p>
         * 
         * @param inputDataConfig
         *        The input data properties of an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(EntityRecognizerInputDataConfig inputDataConfig);

        /**
         * <p>
         * The input data properties of an entity recognizer.
         * </p>
         * This is a convenience that creates an instance of the {@link EntityRecognizerInputDataConfig.Builder}
         * avoiding the need to create one manually via {@link EntityRecognizerInputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityRecognizerInputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDataConfig(EntityRecognizerInputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link EntityRecognizerInputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(EntityRecognizerInputDataConfig)
         */
        default Builder inputDataConfig(Consumer<EntityRecognizerInputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(EntityRecognizerInputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * Provides information about an entity recognizer.
         * </p>
         * 
         * @param recognizerMetadata
         *        Provides information about an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recognizerMetadata(EntityRecognizerMetadata recognizerMetadata);

        /**
         * <p>
         * Provides information about an entity recognizer.
         * </p>
         * This is a convenience that creates an instance of the {@link EntityRecognizerMetadata.Builder} avoiding the
         * need to create one manually via {@link EntityRecognizerMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityRecognizerMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #recognizerMetadata(EntityRecognizerMetadata)}.
         * 
         * @param recognizerMetadata
         *        a consumer that will call methods on {@link EntityRecognizerMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recognizerMetadata(EntityRecognizerMetadata)
         */
        default Builder recognizerMetadata(Consumer<EntityRecognizerMetadata.Builder> recognizerMetadata) {
            return recognizerMetadata(EntityRecognizerMetadata.builder().applyMutation(recognizerMetadata).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend
         * read access to your input data.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon
         *        Comprehend read access to your input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage
         * volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either
         * of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Resource Name (ARN) of a KMS Key:
         * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeKmsKeyId
         *        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the
         *        storage volume attached to the ML compute instance(s) that process the analysis job. The
         *        VolumeKmsKeyId can be either of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Resource Name (ARN) of a KMS Key:
         *        <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeKmsKeyId(String volumeKmsKeyId);

        /**
         * <p>
         * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for
         * your custom entity recognizer. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * </p>
         * 
         * @param vpcConfig
         *        Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are
         *        using for your custom entity recognizer. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for
         * your custom entity recognizer. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models.
         * The ModelKmsKeyId can be either of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Resource Name (ARN) of a KMS Key:
         * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelKmsKeyId
         *        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom
         *        models. The ModelKmsKeyId can be either of the following formats: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Resource Name (ARN) of a KMS Key:
         *        <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelKmsKeyId(String modelKmsKeyId);

        /**
         * <p>
         * The version name you assigned to the entity recognizer.
         * </p>
         * 
         * @param versionName
         *        The version name you assigned to the entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);
    }

    static final class BuilderImpl implements Builder {
        private String entityRecognizerArn;

        private String languageCode;

        private String status;

        private String message;

        private Instant submitTime;

        private Instant endTime;

        private Instant trainingStartTime;

        private Instant trainingEndTime;

        private EntityRecognizerInputDataConfig inputDataConfig;

        private EntityRecognizerMetadata recognizerMetadata;

        private String dataAccessRoleArn;

        private String volumeKmsKeyId;

        private VpcConfig vpcConfig;

        private String modelKmsKeyId;

        private String versionName;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerProperties model) {
            entityRecognizerArn(model.entityRecognizerArn);
            languageCode(model.languageCode);
            status(model.status);
            message(model.message);
            submitTime(model.submitTime);
            endTime(model.endTime);
            trainingStartTime(model.trainingStartTime);
            trainingEndTime(model.trainingEndTime);
            inputDataConfig(model.inputDataConfig);
            recognizerMetadata(model.recognizerMetadata);
            dataAccessRoleArn(model.dataAccessRoleArn);
            volumeKmsKeyId(model.volumeKmsKeyId);
            vpcConfig(model.vpcConfig);
            modelKmsKeyId(model.modelKmsKeyId);
            versionName(model.versionName);
        }

        public final String getEntityRecognizerArn() {
            return entityRecognizerArn;
        }

        public final void setEntityRecognizerArn(String entityRecognizerArn) {
            this.entityRecognizerArn = entityRecognizerArn;
        }

        @Override
        @Transient
        public final Builder entityRecognizerArn(String entityRecognizerArn) {
            this.entityRecognizerArn = entityRecognizerArn;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getSubmitTime() {
            return submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        @Transient
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getTrainingStartTime() {
            return trainingStartTime;
        }

        public final void setTrainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
        }

        @Override
        @Transient
        public final Builder trainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
            return this;
        }

        public final Instant getTrainingEndTime() {
            return trainingEndTime;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        @Override
        @Transient
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final EntityRecognizerInputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(EntityRecognizerInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder inputDataConfig(EntityRecognizerInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final EntityRecognizerMetadata.Builder getRecognizerMetadata() {
            return recognizerMetadata != null ? recognizerMetadata.toBuilder() : null;
        }

        public final void setRecognizerMetadata(EntityRecognizerMetadata.BuilderImpl recognizerMetadata) {
            this.recognizerMetadata = recognizerMetadata != null ? recognizerMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder recognizerMetadata(EntityRecognizerMetadata recognizerMetadata) {
            this.recognizerMetadata = recognizerMetadata;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getVolumeKmsKeyId() {
            return volumeKmsKeyId;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        @Override
        @Transient
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getModelKmsKeyId() {
            return modelKmsKeyId;
        }

        public final void setModelKmsKeyId(String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
        }

        @Override
        @Transient
        public final Builder modelKmsKeyId(String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        @Transient
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        @Override
        public EntityRecognizerProperties build() {
            return new EntityRecognizerProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
