/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of calling the operation. The operation returns one object for each document that is successfully
 * processed by the operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDetectKeyPhrasesItemResult implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDetectKeyPhrasesItemResult.Builder, BatchDetectKeyPhrasesItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Index")
            .getter(getter(BatchDetectKeyPhrasesItemResult::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final SdkField<List<KeyPhrase>> KEY_PHRASES_FIELD = SdkField
            .<List<KeyPhrase>> builder(MarshallingType.LIST)
            .memberName("KeyPhrases")
            .getter(getter(BatchDetectKeyPhrasesItemResult::keyPhrases))
            .setter(setter(Builder::keyPhrases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPhrases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyPhrase> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyPhrase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INDEX_FIELD, KEY_PHRASES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer index;

    private final List<KeyPhrase> keyPhrases;

    private BatchDetectKeyPhrasesItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.keyPhrases = builder.keyPhrases;
    }

    /**
     * <p>
     * The zero-based index of the document in the input list.
     * </p>
     * 
     * @return The zero-based index of the document in the input list.
     */
    public final Integer index() {
        return index;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyPhrases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeyPhrases() {
        return keyPhrases != null && !(keyPhrases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyPhrases} method.
     * </p>
     * 
     * @return One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
     */
    public final List<KeyPhrase> keyPhrases() {
        return keyPhrases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyPhrases() ? keyPhrases() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectKeyPhrasesItemResult)) {
            return false;
        }
        BatchDetectKeyPhrasesItemResult other = (BatchDetectKeyPhrasesItemResult) obj;
        return Objects.equals(index(), other.index()) && hasKeyPhrases() == other.hasKeyPhrases()
                && Objects.equals(keyPhrases(), other.keyPhrases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDetectKeyPhrasesItemResult").add("Index", index())
                .add("KeyPhrases", hasKeyPhrases() ? keyPhrases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Index":
            return Optional.ofNullable(clazz.cast(index()));
        case "KeyPhrases":
            return Optional.ofNullable(clazz.cast(keyPhrases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectKeyPhrasesItemResult, T> g) {
        return obj -> g.apply((BatchDetectKeyPhrasesItemResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDetectKeyPhrasesItemResult> {
        /**
         * <p>
         * The zero-based index of the document in the input list.
         * </p>
         * 
         * @param index
         *        The zero-based index of the document in the input list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);

        /**
         * <p>
         * One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
         * </p>
         * 
         * @param keyPhrases
         *        One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPhrases(Collection<KeyPhrase> keyPhrases);

        /**
         * <p>
         * One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
         * </p>
         * 
         * @param keyPhrases
         *        One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPhrases(KeyPhrase... keyPhrases);

        /**
         * <p>
         * One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<KeyPhrase>.Builder} avoiding the
         * need to create one manually via {@link List<KeyPhrase>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeyPhrase>.Builder#build()} is called immediately and its
         * result is passed to {@link #keyPhrases(List<KeyPhrase>)}.
         * 
         * @param keyPhrases
         *        a consumer that will call methods on {@link List<KeyPhrase>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPhrases(List<KeyPhrase>)
         */
        Builder keyPhrases(Consumer<KeyPhrase.Builder>... keyPhrases);
    }

    static final class BuilderImpl implements Builder {
        private Integer index;

        private List<KeyPhrase> keyPhrases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectKeyPhrasesItemResult model) {
            index(model.index);
            keyPhrases(model.keyPhrases);
        }

        public final Integer getIndex() {
            return index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final List<KeyPhrase.Builder> getKeyPhrases() {
            List<KeyPhrase.Builder> result = ListOfKeyPhrasesCopier.copyToBuilder(this.keyPhrases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyPhrases(Collection<KeyPhrase.BuilderImpl> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copyFromBuilder(keyPhrases);
        }

        @Override
        public final Builder keyPhrases(Collection<KeyPhrase> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copy(keyPhrases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(KeyPhrase... keyPhrases) {
            keyPhrases(Arrays.asList(keyPhrases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(Consumer<KeyPhrase.Builder>... keyPhrases) {
            keyPhrases(Stream.of(keyPhrases).map(c -> KeyPhrase.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDetectKeyPhrasesItemResult build() {
            return new BatchDetectKeyPhrasesItemResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
