/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDocumentClassifierResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeDocumentClassifierResponse.Builder, DescribeDocumentClassifierResponse> {
    private static final SdkField<DocumentClassifierProperties> DOCUMENT_CLASSIFIER_PROPERTIES_FIELD = SdkField
            .<DocumentClassifierProperties> builder(MarshallingType.SDK_POJO)
            .memberName("DocumentClassifierProperties")
            .getter(getter(DescribeDocumentClassifierResponse::documentClassifierProperties))
            .setter(setter(Builder::documentClassifierProperties))
            .constructor(DocumentClassifierProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DOCUMENT_CLASSIFIER_PROPERTIES_FIELD));

    private final DocumentClassifierProperties documentClassifierProperties;

    private DescribeDocumentClassifierResponse(BuilderImpl builder) {
        super(builder);
        this.documentClassifierProperties = builder.documentClassifierProperties;
    }

    /**
     * <p>
     * An object that contains the properties associated with a document classifier.
     * </p>
     * 
     * @return An object that contains the properties associated with a document classifier.
     */
    public final DocumentClassifierProperties documentClassifierProperties() {
        return documentClassifierProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentClassifierProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentClassifierResponse)) {
            return false;
        }
        DescribeDocumentClassifierResponse other = (DescribeDocumentClassifierResponse) obj;
        return Objects.equals(documentClassifierProperties(), other.documentClassifierProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDocumentClassifierResponse")
                .add("DocumentClassifierProperties", documentClassifierProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentClassifierProperties":
            return Optional.ofNullable(clazz.cast(documentClassifierProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDocumentClassifierResponse, T> g) {
        return obj -> g.apply((DescribeDocumentClassifierResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDocumentClassifierResponse> {
        /**
         * <p>
         * An object that contains the properties associated with a document classifier.
         * </p>
         * 
         * @param documentClassifierProperties
         *        An object that contains the properties associated with a document classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassifierProperties(DocumentClassifierProperties documentClassifierProperties);

        /**
         * <p>
         * An object that contains the properties associated with a document classifier.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentClassifierProperties.Builder}
         * avoiding the need to create one manually via {@link DocumentClassifierProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentClassifierProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #documentClassifierProperties(DocumentClassifierProperties)}.
         * 
         * @param documentClassifierProperties
         *        a consumer that will call methods on {@link DocumentClassifierProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentClassifierProperties(DocumentClassifierProperties)
         */
        default Builder documentClassifierProperties(Consumer<DocumentClassifierProperties.Builder> documentClassifierProperties) {
            return documentClassifierProperties(DocumentClassifierProperties.builder()
                    .applyMutation(documentClassifierProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private DocumentClassifierProperties documentClassifierProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentClassifierResponse model) {
            super(model);
            documentClassifierProperties(model.documentClassifierProperties);
        }

        public final DocumentClassifierProperties.Builder getDocumentClassifierProperties() {
            return documentClassifierProperties != null ? documentClassifierProperties.toBuilder() : null;
        }

        public final void setDocumentClassifierProperties(DocumentClassifierProperties.BuilderImpl documentClassifierProperties) {
            this.documentClassifierProperties = documentClassifierProperties != null ? documentClassifierProperties.build()
                    : null;
        }

        @Override
        public final Builder documentClassifierProperties(DocumentClassifierProperties documentClassifierProperties) {
            this.documentClassifierProperties = documentClassifierProperties;
            return this;
        }

        @Override
        public DescribeDocumentClassifierResponse build() {
            return new DescribeDocumentClassifierResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
