/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEntityRecognizerResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeEntityRecognizerResponse.Builder, DescribeEntityRecognizerResponse> {
    private static final SdkField<EntityRecognizerProperties> ENTITY_RECOGNIZER_PROPERTIES_FIELD = SdkField
            .<EntityRecognizerProperties> builder(MarshallingType.SDK_POJO)
            .memberName("EntityRecognizerProperties")
            .getter(getter(DescribeEntityRecognizerResponse::entityRecognizerProperties))
            .setter(setter(Builder::entityRecognizerProperties))
            .constructor(EntityRecognizerProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENTITY_RECOGNIZER_PROPERTIES_FIELD));

    private final EntityRecognizerProperties entityRecognizerProperties;

    private DescribeEntityRecognizerResponse(BuilderImpl builder) {
        super(builder);
        this.entityRecognizerProperties = builder.entityRecognizerProperties;
    }

    /**
     * <p>
     * Describes information associated with an entity recognizer.
     * </p>
     * 
     * @return Describes information associated with an entity recognizer.
     */
    public final EntityRecognizerProperties entityRecognizerProperties() {
        return entityRecognizerProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entityRecognizerProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityRecognizerResponse)) {
            return false;
        }
        DescribeEntityRecognizerResponse other = (DescribeEntityRecognizerResponse) obj;
        return Objects.equals(entityRecognizerProperties(), other.entityRecognizerProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEntityRecognizerResponse")
                .add("EntityRecognizerProperties", entityRecognizerProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityRecognizerProperties":
            return Optional.ofNullable(clazz.cast(entityRecognizerProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityRecognizerResponse, T> g) {
        return obj -> g.apply((DescribeEntityRecognizerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEntityRecognizerResponse> {
        /**
         * <p>
         * Describes information associated with an entity recognizer.
         * </p>
         * 
         * @param entityRecognizerProperties
         *        Describes information associated with an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRecognizerProperties(EntityRecognizerProperties entityRecognizerProperties);

        /**
         * <p>
         * Describes information associated with an entity recognizer.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityRecognizerProperties.Builder}
         * avoiding the need to create one manually via {@link EntityRecognizerProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityRecognizerProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #entityRecognizerProperties(EntityRecognizerProperties)}.
         * 
         * @param entityRecognizerProperties
         *        a consumer that will call methods on {@link EntityRecognizerProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityRecognizerProperties(EntityRecognizerProperties)
         */
        default Builder entityRecognizerProperties(Consumer<EntityRecognizerProperties.Builder> entityRecognizerProperties) {
            return entityRecognizerProperties(EntityRecognizerProperties.builder().applyMutation(entityRecognizerProperties)
                    .build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private EntityRecognizerProperties entityRecognizerProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityRecognizerResponse model) {
            super(model);
            entityRecognizerProperties(model.entityRecognizerProperties);
        }

        public final EntityRecognizerProperties.Builder getEntityRecognizerProperties() {
            return entityRecognizerProperties != null ? entityRecognizerProperties.toBuilder() : null;
        }

        public final void setEntityRecognizerProperties(EntityRecognizerProperties.BuilderImpl entityRecognizerProperties) {
            this.entityRecognizerProperties = entityRecognizerProperties != null ? entityRecognizerProperties.build() : null;
        }

        @Override
        public final Builder entityRecognizerProperties(EntityRecognizerProperties entityRecognizerProperties) {
            this.entityRecognizerProperties = entityRecognizerProperties;
            return this;
        }

        @Override
        public DescribeEntityRecognizerResponse build() {
            return new DescribeEntityRecognizerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
