/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeKeyPhrasesDetectionJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeKeyPhrasesDetectionJobResponse.Builder, DescribeKeyPhrasesDetectionJobResponse> {
    private static final SdkField<KeyPhrasesDetectionJobProperties> KEY_PHRASES_DETECTION_JOB_PROPERTIES_FIELD = SdkField
            .<KeyPhrasesDetectionJobProperties> builder(MarshallingType.SDK_POJO)
            .memberName("KeyPhrasesDetectionJobProperties")
            .getter(getter(DescribeKeyPhrasesDetectionJobResponse::keyPhrasesDetectionJobProperties))
            .setter(setter(Builder::keyPhrasesDetectionJobProperties))
            .constructor(KeyPhrasesDetectionJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPhrasesDetectionJobProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KEY_PHRASES_DETECTION_JOB_PROPERTIES_FIELD));

    private final KeyPhrasesDetectionJobProperties keyPhrasesDetectionJobProperties;

    private DescribeKeyPhrasesDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.keyPhrasesDetectionJobProperties = builder.keyPhrasesDetectionJobProperties;
    }

    /**
     * <p>
     * An object that contains the properties associated with a key phrases detection job.
     * </p>
     * 
     * @return An object that contains the properties associated with a key phrases detection job.
     */
    public final KeyPhrasesDetectionJobProperties keyPhrasesDetectionJobProperties() {
        return keyPhrasesDetectionJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyPhrasesDetectionJobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPhrasesDetectionJobResponse)) {
            return false;
        }
        DescribeKeyPhrasesDetectionJobResponse other = (DescribeKeyPhrasesDetectionJobResponse) obj;
        return Objects.equals(keyPhrasesDetectionJobProperties(), other.keyPhrasesDetectionJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeKeyPhrasesDetectionJobResponse")
                .add("KeyPhrasesDetectionJobProperties", keyPhrasesDetectionJobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyPhrasesDetectionJobProperties":
            return Optional.ofNullable(clazz.cast(keyPhrasesDetectionJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyPhrasesDetectionJobResponse, T> g) {
        return obj -> g.apply((DescribeKeyPhrasesDetectionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeKeyPhrasesDetectionJobResponse> {
        /**
         * <p>
         * An object that contains the properties associated with a key phrases detection job.
         * </p>
         * 
         * @param keyPhrasesDetectionJobProperties
         *        An object that contains the properties associated with a key phrases detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPhrasesDetectionJobProperties(KeyPhrasesDetectionJobProperties keyPhrasesDetectionJobProperties);

        /**
         * <p>
         * An object that contains the properties associated with a key phrases detection job.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyPhrasesDetectionJobProperties.Builder}
         * avoiding the need to create one manually via {@link KeyPhrasesDetectionJobProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link KeyPhrasesDetectionJobProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #keyPhrasesDetectionJobProperties(KeyPhrasesDetectionJobProperties)}.
         * 
         * @param keyPhrasesDetectionJobProperties
         *        a consumer that will call methods on {@link KeyPhrasesDetectionJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPhrasesDetectionJobProperties(KeyPhrasesDetectionJobProperties)
         */
        default Builder keyPhrasesDetectionJobProperties(
                Consumer<KeyPhrasesDetectionJobProperties.Builder> keyPhrasesDetectionJobProperties) {
            return keyPhrasesDetectionJobProperties(KeyPhrasesDetectionJobProperties.builder()
                    .applyMutation(keyPhrasesDetectionJobProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private KeyPhrasesDetectionJobProperties keyPhrasesDetectionJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPhrasesDetectionJobResponse model) {
            super(model);
            keyPhrasesDetectionJobProperties(model.keyPhrasesDetectionJobProperties);
        }

        public final KeyPhrasesDetectionJobProperties.Builder getKeyPhrasesDetectionJobProperties() {
            return keyPhrasesDetectionJobProperties != null ? keyPhrasesDetectionJobProperties.toBuilder() : null;
        }

        public final void setKeyPhrasesDetectionJobProperties(
                KeyPhrasesDetectionJobProperties.BuilderImpl keyPhrasesDetectionJobProperties) {
            this.keyPhrasesDetectionJobProperties = keyPhrasesDetectionJobProperties != null ? keyPhrasesDetectionJobProperties
                    .build() : null;
        }

        @Override
        public final Builder keyPhrasesDetectionJobProperties(KeyPhrasesDetectionJobProperties keyPhrasesDetectionJobProperties) {
            this.keyPhrasesDetectionJobProperties = keyPhrasesDetectionJobProperties;
            return this;
        }

        @Override
        public DescribeKeyPhrasesDetectionJobResponse build() {
            return new DescribeKeyPhrasesDetectionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
