/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectEntitiesResponse extends ComprehendResponse implements
        ToCopyableBuilder<DetectEntitiesResponse.Builder, DetectEntitiesResponse> {
    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField
            .<List<Entity>> builder(MarshallingType.LIST)
            .memberName("Entities")
            .getter(getter(DetectEntitiesResponse::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD));

    private final List<Entity> entities;

    private DetectEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of entities identified in the input text. For each entity, the response provides the entity text,
     * entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend has in the
     * detection.
     * </p>
     * <p>
     * If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model is
     * trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types, see
     * <a>how-entities</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return A collection of entities identified in the input text. For each entity, the response provides the entity
     *         text, entity type, where the entity text begins and ends, and the level of confidence that Amazon
     *         Comprehend has in the detection. </p>
     *         <p>
     *         If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the
     *         model is trained to recognize. Otherwise, it detects the default entity types. For a list of default
     *         entity types, see <a>how-entities</a>.
     */
    public final List<Entity> entities() {
        return entities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesResponse)) {
            return false;
        }
        DetectEntitiesResponse other = (DetectEntitiesResponse) obj;
        return hasEntities() == other.hasEntities() && Objects.equals(entities(), other.entities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectEntitiesResponse").add("Entities", hasEntities() ? entities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entities":
            return Optional.ofNullable(clazz.cast(entities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectEntitiesResponse, T> g) {
        return obj -> g.apply((DetectEntitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectEntitiesResponse> {
        /**
         * <p>
         * A collection of entities identified in the input text. For each entity, the response provides the entity
         * text, entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend
         * has in the detection.
         * </p>
         * <p>
         * If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model
         * is trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types,
         * see <a>how-entities</a>.
         * </p>
         * 
         * @param entities
         *        A collection of entities identified in the input text. For each entity, the response provides the
         *        entity text, entity type, where the entity text begins and ends, and the level of confidence that
         *        Amazon Comprehend has in the detection. </p>
         *        <p>
         *        If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that
         *        the model is trained to recognize. Otherwise, it detects the default entity types. For a list of
         *        default entity types, see <a>how-entities</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<Entity> entities);

        /**
         * <p>
         * A collection of entities identified in the input text. For each entity, the response provides the entity
         * text, entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend
         * has in the detection.
         * </p>
         * <p>
         * If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model
         * is trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types,
         * see <a>how-entities</a>.
         * </p>
         * 
         * @param entities
         *        A collection of entities identified in the input text. For each entity, the response provides the
         *        entity text, entity type, where the entity text begins and ends, and the level of confidence that
         *        Amazon Comprehend has in the detection. </p>
         *        <p>
         *        If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that
         *        the model is trained to recognize. Otherwise, it detects the default entity types. For a list of
         *        default entity types, see <a>how-entities</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Entity... entities);

        /**
         * <p>
         * A collection of entities identified in the input text. For each entity, the response provides the entity
         * text, entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend
         * has in the detection.
         * </p>
         * <p>
         * If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model
         * is trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types,
         * see <a>how-entities</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Entity>.Builder} avoiding the need
         * to create one manually via {@link List<Entity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Entity>.Builder#build()} is called immediately and its
         * result is passed to {@link #entities(List<Entity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link List<Entity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(List<Entity>)
         */
        Builder entities(Consumer<Entity.Builder>... entities);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectEntitiesResponse model) {
            super(model);
            entities(model.entities);
        }

        public final List<Entity.Builder> getEntities() {
            List<Entity.Builder> result = ListOfEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = ListOfEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = ListOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> Entity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectEntitiesResponse build() {
            return new DetectEntitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
