/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an events detection job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventsDetectionJobProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<EventsDetectionJobProperties.Builder, EventsDetectionJobProperties> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(EventsDetectionJobProperties::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobArn")
            .getter(getter(EventsDetectionJobProperties::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(EventsDetectionJobProperties::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(EventsDetectionJobProperties::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(EventsDetectionJobProperties::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTime").getter(getter(EventsDetectionJobProperties::submitTime))
            .setter(setter(Builder::submitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(EventsDetectionJobProperties::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(EventsDetectionJobProperties::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(EventsDetectionJobProperties::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(EventsDetectionJobProperties::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(EventsDetectionJobProperties::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<List<String>> TARGET_EVENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetEventTypes")
            .getter(getter(EventsDetectionJobProperties::targetEventTypes))
            .setter(setter(Builder::targetEventTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEventTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_ARN_FIELD,
            JOB_NAME_FIELD, JOB_STATUS_FIELD, MESSAGE_FIELD, SUBMIT_TIME_FIELD, END_TIME_FIELD, INPUT_DATA_CONFIG_FIELD,
            OUTPUT_DATA_CONFIG_FIELD, LANGUAGE_CODE_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, TARGET_EVENT_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String jobArn;

    private final String jobName;

    private final String jobStatus;

    private final String message;

    private final Instant submitTime;

    private final Instant endTime;

    private final InputDataConfig inputDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final String languageCode;

    private final String dataAccessRoleArn;

    private final List<String> targetEventTypes;

    private EventsDetectionJobProperties(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.message = builder.message;
        this.submitTime = builder.submitTime;
        this.endTime = builder.endTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.languageCode = builder.languageCode;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.targetEventTypes = builder.targetEventTypes;
    }

    /**
     * <p>
     * The identifier assigned to the events detection job.
     * </p>
     * 
     * @return The identifier assigned to the events detection job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully qualified identifier for the
     * job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:events-detection-job/&lt;job-id&gt;</code>
     * </p>
     * <p>
     * The following is an example job ARN:
     * </p>
     * <p>
     * <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully qualified identifier
     *         for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as
     *         follows:</p>
     *         <p>
     *         <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:events-detection-job/&lt;job-id&gt;</code>
     *         </p>
     *         <p>
     *         The following is an example job ARN:
     *         </p>
     *         <p>
     *         <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The name you assigned the events detection job.
     * </p>
     * 
     * @return The name you assigned the events detection job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The current status of the events detection job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the events detection job.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the events detection job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the events detection job.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * A description of the status of the events detection job.
     * </p>
     * 
     * @return A description of the status of the events detection job.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The time that the events detection job was submitted for processing.
     * </p>
     * 
     * @return The time that the events detection job was submitted for processing.
     */
    public final Instant submitTime() {
        return submitTime;
    }

    /**
     * <p>
     * The time that the events detection job completed.
     * </p>
     * 
     * @return The time that the events detection job completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The input data configuration that you supplied when you created the events detection job.
     * </p>
     * 
     * @return The input data configuration that you supplied when you created the events detection job.
     */
    public final InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * The output data configuration that you supplied when you created the events detection job.
     * </p>
     * 
     * @return The output data configuration that you supplied when you created the events detection job.
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The language code of the input documents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the input documents.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code of the input documents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the input documents.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identify and Access Management (IAM) role that grants Amazon Comprehend
     * read access to your input data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identify and Access Management (IAM) role that grants Amazon
     *         Comprehend read access to your input data.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetEventTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetEventTypes() {
        return targetEventTypes != null && !(targetEventTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of events that are detected by the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetEventTypes} method.
     * </p>
     * 
     * @return The types of events that are detected by the job.
     */
    public final List<String> targetEventTypes() {
        return targetEventTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetEventTypes() ? targetEventTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsDetectionJobProperties)) {
            return false;
        }
        EventsDetectionJobProperties other = (EventsDetectionJobProperties) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(message(), other.message()) && Objects.equals(submitTime(), other.submitTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && hasTargetEventTypes() == other.hasTargetEventTypes()
                && Objects.equals(targetEventTypes(), other.targetEventTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventsDetectionJobProperties").add("JobId", jobId()).add("JobArn", jobArn())
                .add("JobName", jobName()).add("JobStatus", jobStatusAsString()).add("Message", message())
                .add("SubmitTime", submitTime()).add("EndTime", endTime()).add("InputDataConfig", inputDataConfig())
                .add("OutputDataConfig", outputDataConfig()).add("LanguageCode", languageCodeAsString())
                .add("DataAccessRoleArn", dataAccessRoleArn())
                .add("TargetEventTypes", hasTargetEventTypes() ? targetEventTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "SubmitTime":
            return Optional.ofNullable(clazz.cast(submitTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "TargetEventTypes":
            return Optional.ofNullable(clazz.cast(targetEventTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventsDetectionJobProperties, T> g) {
        return obj -> g.apply((EventsDetectionJobProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventsDetectionJobProperties> {
        /**
         * <p>
         * The identifier assigned to the events detection job.
         * </p>
         * 
         * @param jobId
         *        The identifier assigned to the events detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully qualified identifier for
         * the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
         * </p>
         * <p>
         * <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:events-detection-job/&lt;job-id&gt;</code>
         * </p>
         * <p>
         * The following is an example job ARN:
         * </p>
         * <p>
         * <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully qualified identifier
         *        for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as
         *        follows:</p>
         *        <p>
         *        <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:events-detection-job/&lt;job-id&gt;</code>
         *        </p>
         *        <p>
         *        The following is an example job ARN:
         *        </p>
         *        <p>
         *        <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The name you assigned the events detection job.
         * </p>
         * 
         * @param jobName
         *        The name you assigned the events detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The current status of the events detection job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the events detection job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the events detection job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the events detection job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * A description of the status of the events detection job.
         * </p>
         * 
         * @param message
         *        A description of the status of the events detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The time that the events detection job was submitted for processing.
         * </p>
         * 
         * @param submitTime
         *        The time that the events detection job was submitted for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTime(Instant submitTime);

        /**
         * <p>
         * The time that the events detection job completed.
         * </p>
         * 
         * @param endTime
         *        The time that the events detection job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The input data configuration that you supplied when you created the events detection job.
         * </p>
         * 
         * @param inputDataConfig
         *        The input data configuration that you supplied when you created the events detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * The input data configuration that you supplied when you created the events detection job.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputDataConfig.Builder} avoiding the
         * need to create one manually via {@link InputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * The output data configuration that you supplied when you created the events detection job.
         * </p>
         * 
         * @param outputDataConfig
         *        The output data configuration that you supplied when you created the events detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * The output data configuration that you supplied when you created the events detection job.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link OutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The language code of the input documents.
         * </p>
         * 
         * @param languageCode
         *        The language code of the input documents.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code of the input documents.
         * </p>
         * 
         * @param languageCode
         *        The language code of the input documents.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identify and Access Management (IAM) role that grants Amazon
         * Comprehend read access to your input data.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the AWS Identify and Access Management (IAM) role that grants Amazon
         *        Comprehend read access to your input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * The types of events that are detected by the job.
         * </p>
         * 
         * @param targetEventTypes
         *        The types of events that are detected by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEventTypes(Collection<String> targetEventTypes);

        /**
         * <p>
         * The types of events that are detected by the job.
         * </p>
         * 
         * @param targetEventTypes
         *        The types of events that are detected by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEventTypes(String... targetEventTypes);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobArn;

        private String jobName;

        private String jobStatus;

        private String message;

        private Instant submitTime;

        private Instant endTime;

        private InputDataConfig inputDataConfig;

        private OutputDataConfig outputDataConfig;

        private String languageCode;

        private String dataAccessRoleArn;

        private List<String> targetEventTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsDetectionJobProperties model) {
            jobId(model.jobId);
            jobArn(model.jobArn);
            jobName(model.jobName);
            jobStatus(model.jobStatus);
            message(model.message);
            submitTime(model.submitTime);
            endTime(model.endTime);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            languageCode(model.languageCode);
            dataAccessRoleArn(model.dataAccessRoleArn);
            targetEventTypes(model.targetEventTypes);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getSubmitTime() {
            return submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final Collection<String> getTargetEventTypes() {
            if (targetEventTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return targetEventTypes;
        }

        public final void setTargetEventTypes(Collection<String> targetEventTypes) {
            this.targetEventTypes = TargetEventTypesCopier.copy(targetEventTypes);
        }

        @Override
        public final Builder targetEventTypes(Collection<String> targetEventTypes) {
            this.targetEventTypes = TargetEventTypesCopier.copy(targetEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetEventTypes(String... targetEventTypes) {
            targetEventTypes(Arrays.asList(targetEventTypes));
            return this;
        }

        @Override
        public EventsDetectionJobProperties build() {
            return new EventsDetectionJobProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
